/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser.util;

import android.app.Activity;
import android.content.Context;
import com.payu.custombrowser.PayUCustomBrowserCallback;
import com.payu.custombrowser.bean.CustomBrowserAsyncTaskData;
import com.payu.custombrowser.bean.CustomBrowserResultData;
import com.payu.custombrowser.cbinterface.CustomBrowserAsyncTaskInterface;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.util.CustomBrowserAsyncTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentOptionHandler
implements CustomBrowserAsyncTaskInterface {
    private PayUCustomBrowserCallback payUCustomBrowserCallback;
    private String merchantKey;
    private String paymentOptionHash;
    private String user_credentials;
    private Activity activity;

    public PaymentOptionHandler(Activity activity, PayUCustomBrowserCallback payUCustomBrowserCallback, String merchantKey, String paymentOptionHash, String user_credentials) {
        this.payUCustomBrowserCallback = payUCustomBrowserCallback;
        this.merchantKey = merchantKey;
        this.paymentOptionHash = paymentOptionHash;
        this.user_credentials = user_credentials;
        this.activity = activity;
        this.checkPayment();
    }

    private void checkPayment() {
        CustomBrowserAsyncTaskData customBrowserAsyncTaskData = new CustomBrowserAsyncTaskData();
        customBrowserAsyncTaskData.setHttpMethod("POST");
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(this.createPostData());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        jsonArray.put((Object)jsonObject);
        customBrowserAsyncTaskData.setPostData(jsonArray.toString());
        customBrowserAsyncTaskData.setUrl("https://info.payu.in/merchant/MobileAnalytics");
        CustomBrowserAsyncTask customBrowserAsyncTask = new CustomBrowserAsyncTask(this);
        customBrowserAsyncTask.execute(new CustomBrowserAsyncTaskData[]{customBrowserAsyncTaskData});
    }

    private String createPostData() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("command");
        stringBuilder.append("=");
        stringBuilder.append("payment_related_details_for_mobile_sdk");
        stringBuilder.append("&");
        stringBuilder.append("imei");
        stringBuilder.append("=");
        stringBuilder.append(CBUtil.getImei((Context)this.activity));
        stringBuilder.append("&");
        stringBuilder.append("udid");
        stringBuilder.append("=");
        stringBuilder.append(CBUtil.getUdid((Context)this.activity));
        stringBuilder.append("&");
        stringBuilder.append("key");
        stringBuilder.append("=");
        stringBuilder.append(this.merchantKey);
        stringBuilder.append("&");
        stringBuilder.append("hash");
        stringBuilder.append("=");
        stringBuilder.append(this.paymentOptionHash);
        stringBuilder.append("&");
        stringBuilder.append("var1");
        stringBuilder.append("=");
        stringBuilder.append(this.user_credentials);
        return stringBuilder.toString();
    }

    @Override
    public void onCustomBrowserAsyncTaskResponse(String cbAsynTaskResponse) {
        CustomBrowserResultData customBrowserResultData = new CustomBrowserResultData();
        customBrowserResultData.setJsonResult(cbAsynTaskResponse);
        this.payUCustomBrowserCallback.isPaymentOptionAvailable(customBrowserResultData);
    }
}

