/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser.upiintent;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.payu.custombrowser.PayUCustomBrowserCallback;
import com.payu.custombrowser.upiintent.Payment;
import com.payu.custombrowser.upiintent.UPIUtil;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.widgets.PayUProgressDialog;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

class PaymentHandler {
    private Activity mActivity;
    private String postData;
    private PayUCustomBrowserCallback payUCustomBrowserCallback;
    private PayUProgressDialog progressDialog;
    private String paymentUrl;
    private String verifyPaymentUrl;
    private String merchantVpa;
    private String merchantName;
    private String referenceId;
    private UPIUtil upiUtil;
    private Payment payment;
    private Timer transactionTimeout;
    private long TRANSACTION_TIMEOUT = 1200000L;

    PaymentHandler(Activity mActivity, String postData, PayUCustomBrowserCallback payUCustomBrowserCallback) {
        this.mActivity = mActivity;
        this.postData = postData;
        this.upiUtil = new UPIUtil();
        this.payUCustomBrowserCallback = payUCustomBrowserCallback;
        this.paymentUrl = "https://secure.payu.in/_payment";
    }

    void initiatePayment() {
        AsyncTask<String, Void, Boolean> asyncTask = new AsyncTask<String, Void, Boolean>(){

            protected void onPreExecute() {
                super.onPreExecute();
                if (PaymentHandler.this.mActivity != null && !PaymentHandler.this.mActivity.isFinishing()) {
                    PaymentHandler.this.progressDialog = new PayUProgressDialog((Context)PaymentHandler.this.mActivity);
                    PaymentHandler.this.progressDialog.show();
                }
            }

            protected Boolean doInBackground(String ... params) {
                block6: {
                    try {
                        int responseCode;
                        CBUtil cbUtil = new CBUtil();
                        PaymentHandler.this.postData = PaymentHandler.this.postData.concat("&txn_s2s_flow=2");
                        HttpURLConnection conn = cbUtil.getHttpsConn(PaymentHandler.this.paymentUrl, PaymentHandler.this.postData);
                        if (conn == null || (responseCode = conn.getResponseCode()) != 200) break block6;
                        try {
                            InputStream responseInputStream = conn.getInputStream();
                            StringBuffer responseStringBuffer = CBUtil.getStringBufferFromInputStream(responseInputStream);
                            if (responseStringBuffer != null) {
                                JSONObject jsonObject = new JSONObject(responseStringBuffer.toString());
                                PaymentHandler.this.merchantName = jsonObject.optString("merchantName");
                                PaymentHandler.this.verifyPaymentUrl = jsonObject.optString("returnUrl");
                                PaymentHandler.this.merchantVpa = jsonObject.optString("merchantVpa");
                                PaymentHandler.this.referenceId = jsonObject.optString("referenceId");
                                if (TextUtils.isEmpty((CharSequence)PaymentHandler.this.merchantName) || TextUtils.isEmpty((CharSequence)PaymentHandler.this.verifyPaymentUrl) || TextUtils.isEmpty((CharSequence)PaymentHandler.this.merchantVpa) || TextUtils.isEmpty((CharSequence)PaymentHandler.this.referenceId)) {
                                    return false;
                                }
                                return true;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return false;
            }

            protected void onPostExecute(Boolean result) {
                super.onPostExecute((Object)result);
                if (null != PaymentHandler.this.progressDialog && PaymentHandler.this.progressDialog.isShowing() && !PaymentHandler.this.mActivity.isFinishing()) {
                    PaymentHandler.this.progressDialog.dismiss();
                }
                if (result.booleanValue()) {
                    PaymentHandler.this.makePayment();
                } else {
                    PaymentHandler.this.payUCustomBrowserCallback.onCBErrorReceived(1002, "MERCHANT_INFO_NOT_PRESENT");
                    PaymentHandler.this.mActivity.finish();
                }
            }
        };
        asyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new String[]{""});
    }

    private void makePayment() {
        this.payment = this.upiUtil.getSupportedPayment(this.postData);
        Intent i = new Intent();
        i.setPackage(this.payment.getPackageName());
        i.setData(Uri.parse((String)this.upiUtil.getUPIIntent(this.merchantVpa, this.merchantName, this.upiUtil.getValuePostData(this.postData, "amount"), this.upiUtil.getValuePostData(this.postData, "transactionId"), this.referenceId)));
        this.mActivity.startActivityForResult(i, 101);
        this.startTimer();
    }

    private void startTimer() {
        if (this.transactionTimeout != null) {
            new CBUtil().cancelTimer(this.transactionTimeout);
        }
        this.transactionTimeout = new Timer();
        this.transactionTimeout.schedule(new TimerTask(){

            @Override
            public void run() {
                if (PaymentHandler.this.mActivity != null && !PaymentHandler.this.mActivity.isFinishing()) {
                    PaymentHandler.this.mActivity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            PaymentHandler.this.verifyPayment("failure", "timeout");
                        }
                    });
                }
            }
        }, this.TRANSACTION_TIMEOUT);
    }

    void verifyPayment(final String transactionStatus, final String errorReason) {
        AsyncTask<String, Void, String> asyncTask = new AsyncTask<String, Void, String>(){

            protected void onPreExecute() {
                super.onPreExecute();
                if (PaymentHandler.this.mActivity != null && !PaymentHandler.this.mActivity.isFinishing()) {
                    PaymentHandler.this.progressDialog = new PayUProgressDialog((Context)PaymentHandler.this.mActivity);
                    PaymentHandler.this.progressDialog.show();
                }
            }

            protected String doInBackground(String ... params) {
                block5: {
                    try {
                        int responseCode;
                        CBUtil cbUtil = new CBUtil();
                        String postData = "txnStatus=" + transactionStatus + "&" + "failureReason" + "=" + errorReason;
                        HttpURLConnection conn = cbUtil.getHttpsConn(PaymentHandler.this.verifyPaymentUrl, postData);
                        if (conn == null || (responseCode = conn.getResponseCode()) != 200) break block5;
                        try {
                            InputStream responseInputStream = conn.getInputStream();
                            StringBuffer responseStringBuffer = CBUtil.getStringBufferFromInputStream(responseInputStream);
                            if (responseStringBuffer != null) {
                                String response = CBUtil.getBase64DecodedString(responseStringBuffer.toString());
                                return response;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }

            protected void onPostExecute(String result) {
                super.onPostExecute((Object)result);
                if (null != PaymentHandler.this.progressDialog && PaymentHandler.this.progressDialog.isShowing() && !PaymentHandler.this.mActivity.isFinishing()) {
                    PaymentHandler.this.progressDialog.dismiss();
                }
                if (!TextUtils.isEmpty((CharSequence)result)) {
                    PaymentHandler.this.payUCustomBrowserCallback.onPaymentSuccess(result, null);
                } else {
                    PaymentHandler.this.payUCustomBrowserCallback.onPaymentFailure(null, null);
                }
                PaymentHandler.this.mActivity.finish();
            }
        };
        asyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new String[]{""});
    }
}

