/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser.analytics;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.payu.custombrowser.util.CBUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CBAnalytics {
    private static final String TEST_URL = "https://mobiletest.payu.in/merchant/MobileAnalytics";
    private static final String PRODUCTION_URL = "https://info.payu.in/merchant/MobileAnalytics";
    private String fileName;
    private static final long TIMER_DELAY = 5000L;
    private static CBAnalytics INSTANCE;
    private final Context mcontext;
    public static final String ANALYTICS_URL = "https://info.payu.in/merchant/MobileAnalytics";
    private volatile boolean mainFileLocked = false;
    private Timer mTimer;
    private CBUtil cbUtil;
    private volatile boolean mBufferLock;
    private String ANALYTICS_BUFFER_KEY = "analytics_buffer_key";

    private CBAnalytics(final Context context, String filename) {
        this.mcontext = context;
        this.fileName = filename;
        this.cbUtil = new CBUtil();
        final Thread.UncaughtExceptionHandler defaultUEH = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler _unCaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                while (CBAnalytics.this.mainFileLocked) {
                }
                CBAnalytics.this.setLock();
                try {
                    FileOutputStream fileOutputStream = CBAnalytics.this.mcontext.openFileOutput(CBAnalytics.this.fileName, 0);
                    int c = CBAnalytics.this.cbUtil.getStringSharedPreference(CBAnalytics.this.mcontext, CBAnalytics.this.ANALYTICS_BUFFER_KEY).length();
                    if (c > 0) {
                        JSONArray jsonArray = new JSONArray();
                        JSONArray bufferJsonArray = new JSONArray(CBAnalytics.this.cbUtil.getStringSharedPreference(CBAnalytics.this.mcontext, CBAnalytics.this.ANALYTICS_BUFFER_KEY).toString());
                        for (int i = 0; i < bufferJsonArray.length(); ++i) {
                            JSONObject jsonObject = bufferJsonArray.getJSONObject(i);
                            jsonArray.put(jsonArray.length(), (Object)jsonObject);
                        }
                        fileOutputStream.write(jsonArray.toString().getBytes());
                        CBAnalytics.this.cbUtil.deleteSharedPrefKey(context, CBAnalytics.this.ANALYTICS_BUFFER_KEY);
                    }
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                CBAnalytics.this.releaseLock();
                defaultUEH.uncaughtException(thread, ex);
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(_unCaughtExceptionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CBAnalytics getInstance(Context context, String fileName) {
        if (INSTANCE != null) return INSTANCE;
        Class<CBAnalytics> clazz = CBAnalytics.class;
        synchronized (CBAnalytics.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new CBAnalytics(context, fileName);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void log(final String msg) {
        if (this.isOnline()) {
            this.resetTimer();
        }
        if (this.mainFileLocked) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (CBAnalytics.this.mBufferLock) {
                        }
                        String str = CBAnalytics.this.cbUtil.getStringSharedPreference(CBAnalytics.this.mcontext, CBAnalytics.this.ANALYTICS_BUFFER_KEY);
                        JSONArray jsonArray = str != null && !str.equalsIgnoreCase("") ? new JSONArray(str) : new JSONArray();
                        JSONObject newAnalyticsEvent = new JSONObject(msg);
                        jsonArray.put((Object)newAnalyticsEvent);
                        CBAnalytics.this.cbUtil.setStringSharedPreference(CBAnalytics.this.mcontext, CBAnalytics.this.ANALYTICS_BUFFER_KEY, jsonArray.toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        } else {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (CBAnalytics.this.mainFileLocked) {
                    }
                    CBAnalytics.this.setLock();
                    try {
                        JSONObject newobject = new JSONObject(msg);
                        String temp = CBAnalytics.this.cbUtil.readFileInputStream(CBAnalytics.this.mcontext, CBAnalytics.this.fileName, 0);
                        JSONArray jsonArray = temp == null || temp.equalsIgnoreCase("") ? new JSONArray() : new JSONArray(temp);
                        FileOutputStream fileOutputStream = CBAnalytics.this.mcontext.openFileOutput(CBAnalytics.this.fileName, 0);
                        jsonArray.put(jsonArray.length(), (Object)newobject);
                        fileOutputStream.write(jsonArray.toString().getBytes());
                        fileOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        CBAnalytics.this.releaseLock();
                    }
                }
            }).start();
        }
    }

    private void resetTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (CBAnalytics.this.mainFileLocked) {
                }
                CBAnalytics.this.setLock();
                if (CBAnalytics.this.isOnline()) {
                    String temp = "";
                    try {
                        temp = CBAnalytics.this.cbUtil.readFileInputStream(CBAnalytics.this.mcontext, CBAnalytics.this.fileName, 0);
                    }
                    finally {
                        try {
                            JSONArray tempJsonArray = temp != null && !temp.equalsIgnoreCase("") ? new JSONArray(temp) : new JSONArray();
                            if (CBAnalytics.this.cbUtil.getStringSharedPreference(CBAnalytics.this.mcontext, CBAnalytics.this.ANALYTICS_BUFFER_KEY).length() > 1) {
                                CBAnalytics.this.mBufferLock = true;
                                JSONArray analyticsBufferArray = new JSONArray(CBAnalytics.this.cbUtil.getStringSharedPreference(CBAnalytics.this.mcontext, CBAnalytics.this.ANALYTICS_BUFFER_KEY));
                                tempJsonArray = CBAnalytics.this.copyBufferToFile(tempJsonArray, analyticsBufferArray);
                            }
                            if (tempJsonArray.length() > 0) {
                                JSONObject jsonObject;
                                StringBuffer responseStringBuffer;
                                int responseCode;
                                String postData = "command=EventAnalytics&data=" + tempJsonArray.toString();
                                HttpURLConnection conn = CBAnalytics.this.cbUtil.getHttpsConn("https://info.payu.in/merchant/MobileAnalytics", postData, 30000);
                                if (conn != null && (responseCode = conn.getResponseCode()) == 200 && conn.getInputStream() != null && (responseStringBuffer = CBUtil.getStringBufferFromInputStream(conn.getInputStream())) != null && (jsonObject = new JSONObject(responseStringBuffer.toString())).has("status")) {
                                    CBAnalytics.this.mcontext.deleteFile(CBAnalytics.this.fileName);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                CBAnalytics.this.releaseLock();
                if (CBAnalytics.this.cbUtil.getStringSharedPreference(CBAnalytics.this.mcontext, CBAnalytics.this.ANALYTICS_BUFFER_KEY).length() > 1) {
                    CBAnalytics.this.resetTimer();
                }
            }
        }, 5000L);
    }

    private synchronized void setLock() {
        while (this.mainFileLocked) {
        }
        this.mainFileLocked = true;
    }

    private void releaseLock() {
        this.mainFileLocked = false;
    }

    private boolean isOnline() {
        ConnectivityManager cm = (ConnectivityManager)this.mcontext.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnectedOrConnecting();
    }

    public Timer getmTimer() {
        return this.mTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray copyBufferToFile(JSONArray fileJsonArray, JSONArray bufferJsonArray) {
        FileOutputStream fileOutputStream = null;
        try {
            JSONArray mergeJsonArray = new JSONArray(fileJsonArray.toString());
            for (int i = 0; i < bufferJsonArray.length(); ++i) {
                JSONObject jsonObject = bufferJsonArray.getJSONObject(i);
                mergeJsonArray.put((Object)jsonObject);
            }
            fileOutputStream = this.mcontext.openFileOutput(this.fileName, 0);
            fileOutputStream.write(mergeJsonArray.toString().getBytes());
            this.cbUtil.deleteSharedPrefKey(this.mcontext, this.ANALYTICS_BUFFER_KEY);
            JSONArray jSONArray = mergeJsonArray;
            return jSONArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            JSONArray jSONArray = fileJsonArray;
            return jSONArray;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.mBufferLock = false;
        }
    }
}

