/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.payu.custombrowser.R;
import com.payu.custombrowser.bean.ReviewOrderData;
import java.util.ArrayList;

public class ReviewOrderFragment
extends Fragment {
    private static final String REVIEW_ORDER_DETAIL_LIST = "review_order_detail_list";
    private static final String LAYOUT_RES = "layout_res";
    private ArrayList<ReviewOrderData> reviewOrderDetailList;
    private int resLayout;
    private OnReviewOrderDetailCloseListener mListener;
    private View view;
    private int reviewHeight;

    public static ReviewOrderFragment newInstance(ArrayList<ReviewOrderData> reviewOrderDetailList, @LayoutRes int resLayout) {
        ReviewOrderFragment fragment = new ReviewOrderFragment();
        Bundle args = new Bundle();
        args.putParcelableArrayList(REVIEW_ORDER_DETAIL_LIST, reviewOrderDetailList);
        args.putInt(LAYOUT_RES, resLayout);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.reviewOrderDetailList = this.getArguments().getParcelableArrayList(REVIEW_ORDER_DETAIL_LIST);
            this.resLayout = this.getArguments().getInt(LAYOUT_RES);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.view = inflater.inflate(R.layout.fragment_review_order, container, false);
        return this.view;
    }

    public void onViewCreated(final View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        LinearLayout layout2 = (LinearLayout)view.findViewById(R.id.payu_review_order_list);
        if (this.resLayout == -1) {
            if (this.reviewOrderDetailList != null) {
                for (ReviewOrderData reviewOrderDetail : this.reviewOrderDetailList) {
                    View orderDetailsRowView = this.getActivity().getLayoutInflater().inflate(R.layout.payu_review_order_list_row, null, false);
                    TextView orderDetailKey = (TextView)orderDetailsRowView.findViewById(R.id.t_review_order_details_key);
                    TextView orderDetailValue = (TextView)orderDetailsRowView.findViewById(R.id.t_review_order_details_value);
                    orderDetailKey.setText((CharSequence)reviewOrderDetail.getKey());
                    orderDetailValue.setText((CharSequence)reviewOrderDetail.getValue());
                    layout2.addView(orderDetailsRowView);
                }
            }
        } else {
            View orderDetailsRowView = this.getActivity().getLayoutInflater().inflate(this.resLayout, null, false);
            RelativeLayout reviewOrderViewLayout = (RelativeLayout)view.findViewById(R.id.r_payu_review_order);
            reviewOrderViewLayout.removeAllViews();
            reviewOrderViewLayout.addView(orderDetailsRowView);
        }
        this.optimiseReviewFragmentHeight(view);
        view.findViewById(R.id.i_payu_close_review).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                v.setEnabled(false);
                v.setClickable(false);
                ReviewOrderFragment.this.mListener.onFragmentInteraction();
                TranslateAnimation animate = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)ReviewOrderFragment.this.reviewHeight);
                animate.setDuration(500L);
                animate.setFillBefore(false);
                animate.setFillEnabled(true);
                animate.setZAdjustment(1);
                view.startAnimation((Animation)animate);
                Handler handlertrans = new Handler();
                handlertrans.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (ReviewOrderFragment.this.getActivity() != null && !ReviewOrderFragment.this.getActivity().isFinishing()) {
                            view.setVisibility(8);
                            FragmentTransaction ft = ReviewOrderFragment.this.getActivity().getSupportFragmentManager().beginTransaction();
                            ft.remove((Fragment)ReviewOrderFragment.this);
                            ft.commit();
                        }
                    }
                }, 450L);
            }
        });
    }

    public void onButtonPressed(Uri uri) {
        if (this.mListener != null) {
            this.mListener.onFragmentInteraction();
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof OnReviewOrderDetailCloseListener)) {
            throw new RuntimeException(context.toString() + " must implement OnReviewOrderDetailCloseListener");
        }
        this.mListener = (OnReviewOrderDetailCloseListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    private void optimiseReviewFragmentHeight(View view) {
        DisplayMetrics metrics = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(metrics);
        int height = metrics.heightPixels;
        view.measure(0, 0);
        this.reviewHeight = (int)((double)height * 0.45);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, this.reviewHeight);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public static interface OnReviewOrderDetailCloseListener {
        public void onFragmentInteraction();
    }
}

