/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser.analytics;

import android.content.Context;
import android.os.AsyncTask;
import com.payu.custombrowser.util.CBUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PayuDeviceAnalytics {
    private long TIMER_DELAY = 0L;
    private final Context context;
    private static final String TEST_URL_DEVICE_ANALYTICS = "http://10.50.23.170:6543/MobileAnalytics";
    private static final String PRODUCTION_URL_DEVICE_ANALYTICS = "https://info.payu.in/merchant/MobileAnalytics";
    private boolean mIsLocked = false;
    private ArrayList<String> mBuffer;
    private Timer mTimer;
    private String file_name = "cb_local_cache_device";
    private CBUtil cbUtil;
    private boolean isTimerCancelled;

    public PayuDeviceAnalytics(Context context, final String fileName) {
        this.context = context;
        this.file_name = fileName;
        this.mBuffer = new ArrayList();
        this.cbUtil = new CBUtil();
        final Thread.UncaughtExceptionHandler defaultUEH = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler _unCaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                while (PayuDeviceAnalytics.this.mIsLocked) {
                }
                PayuDeviceAnalytics.this.setLock();
                try {
                    FileOutputStream fileOutputStream = PayuDeviceAnalytics.this.context.openFileOutput(fileName, 0);
                    int c = PayuDeviceAnalytics.this.mBuffer.size();
                    for (int i = 0; i < c; ++i) {
                        fileOutputStream.write(((String)PayuDeviceAnalytics.this.mBuffer.get(i) + "\r\n").getBytes());
                    }
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                PayuDeviceAnalytics.this.releaseLock();
                defaultUEH.uncaughtException(thread, ex);
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(_unCaughtExceptionHandler);
    }

    public void log(String msg) {
        if (this.mIsLocked) {
            this.mBuffer.add(msg);
        } else {
            this.setLock();
            try {
                int c;
                JSONObject newobject = new JSONObject(msg);
                String temp = "";
                File file = new File(this.context.getFilesDir(), this.file_name);
                if (!file.exists()) {
                    this.context.openFileOutput(this.file_name, 0);
                }
                FileInputStream fileInputStream = this.context.openFileInput(this.file_name);
                while ((c = fileInputStream.read()) != -1) {
                    temp = temp + Character.toString((char)c);
                }
                JSONArray jsonArray = temp.equalsIgnoreCase("") ? new JSONArray() : new JSONArray(temp);
                fileInputStream.close();
                FileOutputStream fileOutputStream = this.context.openFileOutput(this.file_name, 0);
                jsonArray.put(jsonArray.length(), (Object)newobject);
                fileOutputStream.write(jsonArray.toString().getBytes());
                fileOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.mBuffer.add(msg);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.releaseLock();
        }
        this.resetTimer();
    }

    private void resetTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int c;
                while (PayuDeviceAnalytics.this.mIsLocked) {
                }
                PayuDeviceAnalytics.this.TIMER_DELAY = 5000L;
                PayuDeviceAnalytics.this.setLock();
                String temp = "";
                try {
                    File file = new File(PayuDeviceAnalytics.this.context.getFilesDir(), PayuDeviceAnalytics.this.file_name);
                    if (!file.exists()) {
                        PayuDeviceAnalytics.this.context.openFileOutput(PayuDeviceAnalytics.this.file_name, 0);
                    }
                    FileInputStream fileInputStream = PayuDeviceAnalytics.this.context.openFileInput(PayuDeviceAnalytics.this.file_name);
                    while ((c = fileInputStream.read()) != -1) {
                        temp = temp + Character.toString((char)c);
                    }
                    fileInputStream.close();
                    c = PayuDeviceAnalytics.this.mBuffer.size();
                }
                catch (IOException e) {
                    int c22;
                    try {
                        e.printStackTrace();
                        c22 = PayuDeviceAnalytics.this.mBuffer.size();
                    }
                    catch (Throwable throwable) {
                        int c22 = PayuDeviceAnalytics.this.mBuffer.size();
                        while (c22 > 0) {
                            temp = temp + (String)PayuDeviceAnalytics.this.mBuffer.get(--c22) + "\r\n";
                            if (c22 < 0 || PayuDeviceAnalytics.this.mBuffer.size() <= c22) continue;
                            PayuDeviceAnalytics.this.mBuffer.remove(c22);
                        }
                        if ((temp = temp.trim()).length() > 0) {
                            new UploadData(temp).execute(new String[]{temp});
                        } else {
                            PayuDeviceAnalytics.this.mTimer.cancel();
                        }
                        throw throwable;
                    }
                    while (c22 > 0) {
                        temp = temp + (String)PayuDeviceAnalytics.this.mBuffer.get(--c22) + "\r\n";
                        if (c22 < 0 || PayuDeviceAnalytics.this.mBuffer.size() <= c22) continue;
                        PayuDeviceAnalytics.this.mBuffer.remove(c22);
                    }
                    if ((temp = temp.trim()).length() > 0) {
                        new UploadData(temp).execute(new String[]{temp});
                    } else {
                        PayuDeviceAnalytics.this.mTimer.cancel();
                    }
                }
                while (c > 0) {
                    temp = temp + (String)PayuDeviceAnalytics.this.mBuffer.get(--c) + "\r\n";
                    if (c < 0 || PayuDeviceAnalytics.this.mBuffer.size() <= c) continue;
                    PayuDeviceAnalytics.this.mBuffer.remove(c);
                }
                if ((temp = temp.trim()).length() > 0) {
                    new UploadData(temp).execute(new String[]{temp});
                } else {
                    PayuDeviceAnalytics.this.mTimer.cancel();
                }
                if (PayuDeviceAnalytics.this.mBuffer.size() > 0) {
                    PayuDeviceAnalytics.this.resetTimer();
                }
                PayuDeviceAnalytics.this.releaseLock();
            }
        }, this.TIMER_DELAY);
    }

    private synchronized void setLock() {
        this.mIsLocked = true;
    }

    private synchronized void releaseLock() {
        this.mIsLocked = false;
    }

    private JSONArray removeJsonObjectAtJsonArrayIndex(JSONArray source, int index) throws JSONException {
        if (index < 0 || index > source.length() - 1) {
            throw new IndexOutOfBoundsException();
        }
        JSONArray copy = new JSONArray();
        int count = source.length();
        for (int i = 0; i < count; ++i) {
            if (i == index) continue;
            copy.put(source.get(i));
        }
        return copy;
    }

    private void updateFile(String temp) {
        try {
            FileOutputStream fileOutputStream = this.context.openFileOutput(this.file_name, 0);
            fileOutputStream.write(temp.getBytes());
            fileOutputStream.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public Timer getmTimer() {
        this.isTimerCancelled = true;
        return this.mTimer;
    }

    public class UploadData
    extends AsyncTask<String, Void, String> {
        private String temp;

        UploadData(String temp) {
            this.temp = temp;
        }

        protected void onPostExecute(String aVoid) {
            super.onPostExecute((Object)aVoid);
        }

        protected String doInBackground(String ... strarr) {
            block12: {
                try {
                    try {
                        JSONArray jsonArray;
                        if (PayuDeviceAnalytics.this.context == null || PayuDeviceAnalytics.this.isTimerCancelled) break block12;
                        JSONArray editorJsonArray = jsonArray = new JSONArray(strarr[0]);
                        for (int j = 0; j < editorJsonArray.length(); ++j) {
                            if (!PayuDeviceAnalytics.this.cbUtil.getBooleanSharedPreference(((JSONObject)editorJsonArray.get(j)).getString("merchant_key") + "|" + ((JSONObject)editorJsonArray.get(j)).getString("txnid"), PayuDeviceAnalytics.this.context)) continue;
                            jsonArray = PayuDeviceAnalytics.this.removeJsonObjectAtJsonArrayIndex(editorJsonArray, j);
                        }
                        if (jsonArray.length() <= 0) break block12;
                        String postData = "command=DeviceAnalytics&data=" + jsonArray.toString();
                        String analyticsURL = PayuDeviceAnalytics.PRODUCTION_URL_DEVICE_ANALYTICS;
                        HttpURLConnection conn = PayuDeviceAnalytics.this.cbUtil.getHttpsConn(analyticsURL, postData);
                        if (conn != null) {
                            int responseCode = conn.getResponseCode();
                            if (responseCode == 200) {
                                try {
                                    InputStream responseInputStream = conn.getInputStream();
                                    StringBuffer responseStringBuffer = CBUtil.getStringBufferFromInputStream(responseInputStream);
                                    if (responseStringBuffer == null) break block12;
                                    JSONObject jsonObject = new JSONObject(responseStringBuffer.toString());
                                    if (jsonObject.has("status")) {
                                        PayuDeviceAnalytics.this.context.deleteFile(PayuDeviceAnalytics.this.file_name);
                                        for (int j = 0; j < jsonArray.length(); ++j) {
                                            PayuDeviceAnalytics.this.cbUtil.setBooleanSharedPreference(((JSONObject)jsonArray.get(j)).getString("merchant_key") + "|" + ((JSONObject)jsonArray.get(j)).getString("txnid"), true, PayuDeviceAnalytics.this.context);
                                        }
                                        break block12;
                                    }
                                    PayuDeviceAnalytics.this.updateFile(this.temp);
                                }
                                catch (Exception e) {
                                    PayuDeviceAnalytics.this.updateFile(this.temp);
                                }
                                break block12;
                            }
                            PayuDeviceAnalytics.this.updateFile(this.temp);
                            break block12;
                        }
                        PayuDeviceAnalytics.this.context.deleteFile(PayuDeviceAnalytics.this.file_name);
                    }
                    catch (MalformedURLException | ProtocolException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        PayuDeviceAnalytics.this.resetTimer();
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

