/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.app.AlertDialog;
import android.app.NotificationManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.payu.custombrowser.Bank;
import com.payu.custombrowser.R;
import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.magicretry.MagicRetryFragment;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import org.json.JSONObject;

public class CBActivity
extends FragmentActivity
implements MagicRetryFragment.ActivityCallback {
    public static int STATE;
    CustomBrowserConfig customBrowserConfig;
    private Bank payUCustomBrowser;
    private AlertDialog snoozeDialog;
    private android.app.AlertDialog backButtonAlertDialog;
    CBUtil cbUtil;

    protected void onStart() {
        super.onStart();
    }

    protected void onResume() {
        super.onResume();
        STATE = 1;
    }

    protected void onPause() {
        super.onPause();
        STATE = 2;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(null);
        this.setContentView(R.layout.cb_payments);
        this.payUCustomBrowser = new Bank();
        this.cbUtil = new CBUtil();
        this.cbUtil.resetPayuID();
        Bundle bundle = new Bundle();
        this.customBrowserConfig = (CustomBrowserConfig)this.getIntent().getParcelableExtra("cb_config");
        bundle.putParcelable("cb_config", (Parcelable)this.customBrowserConfig);
        this.payUCustomBrowser.setArguments(bundle);
        this.getSupportFragmentManager().beginTransaction().add(R.id.main_frame, (Fragment)this.payUCustomBrowser).commit();
    }

    public void showBackButtonDialog() {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this);
        alertDialog.setCancelable(false);
        alertDialog.setMessage((CharSequence)"Do you really want to cancel the transaction ?");
        alertDialog.setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackApprove();
                }
                CBActivity.this.payUCustomBrowser.addEventAnalytics("user_input", "back_button_ok".toLowerCase());
                CBActivity.this.finish();
            }
        });
        alertDialog.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                CBActivity.this.payUCustomBrowser.addEventAnalytics("user_input", "back_button_cancel".toLowerCase());
                if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackDismiss();
                }
            }
        });
        this.payUCustomBrowser.addEventAnalytics("user_input", "payu_back_button".toLowerCase());
        if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackButton(alertDialog);
        }
        this.backButtonAlertDialog = alertDialog.create();
        alertDialog.show();
    }

    public void onBackPressed() {
        if (this.customBrowserConfig != null && this.customBrowserConfig.getDisableBackButtonDialog() != 1) {
            this.showBackButtonDialog();
        } else {
            this.finish();
        }
    }

    public void showMagicRetry() {
        this.payUCustomBrowser.showMagicRetry();
    }

    public void hideMagicRetry() {
        this.payUCustomBrowser.hideMagicRetry();
    }

    public void onDestroy() {
        if (this.backButtonAlertDialog != null && this.backButtonAlertDialog.isShowing()) {
            this.backButtonAlertDialog.dismiss();
            this.backButtonAlertDialog.cancel();
        }
        if (this.snoozeDialog != null && this.snoozeDialog.isShowing()) {
            this.snoozeDialog.dismiss();
            this.snoozeDialog.cancel();
        }
        STATE = 3;
        if (this.payUCustomBrowser != null && this.payUCustomBrowser.getSnoozeLoaderView() != null) {
            this.payUCustomBrowser.getSnoozeLoaderView().cancelAnimation();
        }
        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentTerminate();
        }
        NotificationManager mNotificationManager = (NotificationManager)this.getSystemService("notification");
        mNotificationManager.cancel(CBConstant.SNOOZE_NOTIFICATION_ID);
        mNotificationManager.cancel(63);
        super.onDestroy();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (null != intent && intent.getStringExtra("sender").contentEquals("snoozeService")) {
            this.payUCustomBrowser.killSnoozeService();
            if (intent.getExtras().getBoolean("verificationMsgReceived")) {
                if (this.payUCustomBrowser != null) {
                    this.payUCustomBrowser.dismissSnoozeWindow();
                }
                this.showTransactionStatusDialog(intent.getExtras().getString("payu_response"), intent);
            } else {
                this.customBrowserConfig = (CustomBrowserConfig)intent.getExtras().getParcelable("cb_config");
                this.payUCustomBrowser.addEventAnalytics("snooze_notification_action", "snooze_transaction_resumed");
                if (intent.getStringExtra("currentUrl") != null) {
                    if (intent.getStringExtra("currentUrl").equalsIgnoreCase(this.customBrowserConfig.getPostURL())) {
                        if (this.customBrowserConfig.getPostURL().contentEquals("https://secure.payu.in/_payment") || this.customBrowserConfig.getPostURL().contentEquals("https://mobiletest.payu.in/_payment")) {
                            this.payUCustomBrowser.markPreviousTxnAsUserCanceled(this.cbUtil.getLogMessage(this.getApplicationContext(), "sure_pay_cancelled", this.customBrowserConfig.getTransactionID(), "", Bank.keyAnalytics, this.customBrowserConfig.getTransactionID(), ""));
                        }
                        this.payUCustomBrowser.reloadWebView(this.customBrowserConfig.getPostURL(), this.customBrowserConfig.getPayuPostData());
                    } else if (Bank.isUrlWhiteListed(intent.getStringExtra("currentUrl"))) {
                        this.payUCustomBrowser.reloadWebView(intent.getStringExtra("currentUrl"));
                    } else {
                        if (this.customBrowserConfig.getPostURL().contentEquals("https://secure.payu.in/_payment") || this.customBrowserConfig.getPostURL().contentEquals("https://mobiletest.payu.in/_payment")) {
                            this.payUCustomBrowser.markPreviousTxnAsUserCanceled(this.cbUtil.getLogMessage(this.getApplicationContext(), "sure_pay_cancelled", this.customBrowserConfig.getTransactionID(), "", Bank.keyAnalytics, this.customBrowserConfig.getTransactionID(), ""));
                        }
                        this.payUCustomBrowser.reloadWebView(this.customBrowserConfig.getPostURL(), this.customBrowserConfig.getPayuPostData());
                    }
                } else {
                    this.payUCustomBrowser.reloadWebView(this.customBrowserConfig.getPostURL(), this.customBrowserConfig.getPayuPostData());
                }
            }
        }
    }

    private void showTransactionStatusDialog(String payuResponse, Intent intent) {
        try {
            this.payUCustomBrowser.setTransactionStatusReceived(true);
            final JSONObject jsonObject = new JSONObject(payuResponse.toString());
            if (jsonObject.has("api_status")) {
                LayoutInflater layoutInflater = this.getLayoutInflater();
                View snoozeLayout = layoutInflater.inflate(R.layout.cb_layout_snooze, null);
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
                builder.setView(snoozeLayout);
                this.snoozeDialog = builder.create();
                int verifyApiStatus = 0;
                if (jsonObject.has(this.getString(R.string.cb_snooze_verify_api_status))) {
                    verifyApiStatus = Integer.parseInt(jsonObject.get(this.getString(R.string.cb_snooze_verify_api_status)).toString());
                }
                if (verifyApiStatus == 1) {
                    this.payUCustomBrowser.addEventAnalytics("snooze_notification_action", "success_screen");
                    if (Bank.isUrlWhiteListed(this.payUCustomBrowser.getCurrentURL()) && 19 != Build.VERSION.SDK_INT) {
                        this.payUCustomBrowser.addEventAnalytics("snooze_transaction_status_update", "data_repost");
                        this.payUCustomBrowser.dismissSnoozeWindow();
                        this.payUCustomBrowser.progressBarVisibilityPayuChrome(8, "");
                        this.payUCustomBrowser.reloadWebView();
                    } else {
                        this.payUCustomBrowser.addEventAnalytics("snooze_transaction_status_update", "post_to_surl");
                        if (jsonObject.has("response")) {
                            this.setCheckFURLSURL(jsonObject.getString("response"), new CBUtil().getDataFromPostData(this.customBrowserConfig.getPayuPostData(), "surl"));
                        }
                        snoozeLayout.findViewById(R.id.snooze_status_icon).setVisibility(0);
                        ((TextView)snoozeLayout.findViewById(R.id.snooze_header_txt)).setText(R.string.cb_transaction_sucess);
                        snoozeLayout.findViewById(R.id.text_view_cancel_snooze_window).setVisibility(8);
                        ((TextView)snoozeLayout.findViewById(R.id.text_view_snooze_message)).setText((CharSequence)this.getString(R.string.cb_transaction_success_msg));
                        snoozeLayout.findViewById(R.id.snooze_loader_view).setVisibility(8);
                        snoozeLayout.findViewById(R.id.button_snooze_transaction).setVisibility(8);
                        snoozeLayout.findViewById(R.id.text_view_retry_message_detail).setVisibility(8);
                        snoozeLayout.findViewById(R.id.button_retry_transaction).setVisibility(8);
                        snoozeLayout.findViewById(R.id.button_cancel_transaction).setVisibility(8);
                        snoozeLayout.findViewById(R.id.t_confirm).setVisibility(8);
                        snoozeLayout.findViewById(R.id.t_nconfirm).setVisibility(8);
                        this.snoozeDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                            public void onDismiss(DialogInterface dialogInterface) {
                                try {
                                    if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                                        CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentSuccess(jsonObject.getString("response"), "");
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                CBActivity.this.snoozeDialog.dismiss();
                                CBActivity.this.snoozeDialog.cancel();
                                CBActivity.this.finish();
                            }
                        });
                        this.snoozeDialog.setCanceledOnTouchOutside(false);
                        this.snoozeDialog.show();
                        new Handler().postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                if (CBActivity.this.snoozeDialog != null && CBActivity.this.snoozeDialog.isShowing()) {
                                    CBActivity.this.snoozeDialog.cancel();
                                    CBActivity.this.snoozeDialog.dismiss();
                                    CBActivity.this.finish();
                                }
                            }
                        }, 5000L);
                    }
                } else {
                    this.payUCustomBrowser.addEventAnalytics("snooze_notification_action", "txn_not_confirmed");
                    snoozeLayout.findViewById(R.id.button_snooze_transaction).setVisibility(0);
                    snoozeLayout.findViewById(R.id.snooze_status_icon).setVisibility(0);
                    snoozeLayout.findViewById(R.id.text_view_cancel_snooze_window).setVisibility(8);
                    snoozeLayout.findViewById(R.id.button_snooze_transaction).setVisibility(8);
                    ((TextView)snoozeLayout.findViewById(R.id.snooze_header_txt)).setText(R.string.cb_transaction_failed_title);
                    ((TextView)snoozeLayout.findViewById(R.id.text_view_snooze_message)).setText(R.string.cb_transaction_failed);
                    snoozeLayout.findViewById(R.id.button_retry_transaction).setVisibility(8);
                    snoozeLayout.findViewById(R.id.button_cancel_transaction).setVisibility(0);
                    snoozeLayout.findViewById(R.id.button_snooze_transaction).setVisibility(8);
                    snoozeLayout.findViewById(R.id.text_view_retry_message_detail).setVisibility(8);
                    snoozeLayout.findViewById(R.id.text_view_transaction_snoozed_message1).setVisibility(8);
                    snoozeLayout.findViewById(R.id.text_view_ac_debited_twice).setVisibility(8);
                    snoozeLayout.findViewById(R.id.button_cancel_transaction).setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            CBActivity.this.payUCustomBrowser.addEventAnalytics("snooze_interaction_time", Bank.getSystemCurrentTime());
                            CBActivity.this.payUCustomBrowser.addEventAnalytics("snooze_window_action", "snooze_cancel_transaction_click");
                            CBActivity.this.snoozeDialog.dismiss();
                            CBActivity.this.snoozeDialog.cancel();
                            CBActivity.this.finish();
                        }
                    });
                    this.snoozeDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                        public void onDismiss(DialogInterface dialogInterface) {
                            CBActivity.this.snoozeDialog.dismiss();
                            CBActivity.this.snoozeDialog.cancel();
                        }
                    });
                    this.snoozeDialog.setCanceledOnTouchOutside(false);
                    this.snoozeDialog.show();
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (CBActivity.this.snoozeDialog != null && CBActivity.this.snoozeDialog.isShowing()) {
                                CBActivity.this.snoozeDialog.cancel();
                                CBActivity.this.snoozeDialog.dismiss();
                                CBActivity.this.finish();
                            }
                        }
                    }, 5000L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCheckFURLSURL(final String postData, final String surl) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String responseStringBuffer = "";
                try {
                    URL url = new URL(URLDecoder.decode(surl, "UTF-8"));
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    String post = postData;
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    conn.setRequestProperty("Content-Length", String.valueOf(post.length()));
                    conn.setDoOutput(true);
                    byte[] postParamsByte = post.getBytes();
                    conn.getOutputStream().write(postParamsByte);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }
}

