package com.payu.custombrowser.analytics;

import android.content.Context;
import android.os.AsyncTask;

import com.payu.custombrowser.Bank;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;


public class PayuDeviceAnalytics {
    private  long TIMER_DELAY = 0;
    private final Context context;
    private static final String TEST_URL_DEVICE_ANALYTICS = "http://10.50.23.170:6543/MobileAnalytics";
    private static final String PRODUCTION_URL_DEVICE_ANALYTICS = "https://info.payu.in/merchant/MobileAnalytics";
    private boolean mIsLocked = false;
    private ArrayList<String> mBuffer;
    private Timer mTimer;
    private String file_name = "cb_local_cache_device";
    private CBUtil cbUtil;
    private boolean isTimerCancelled;

    /**
     * Constructor
     *
     * @param context base activity
     */
    public PayuDeviceAnalytics(Context context, final String fileName) {
        this.context = context;
        this.file_name=fileName;
        mBuffer = new ArrayList<>();
        cbUtil = new CBUtil();
        final Thread.UncaughtExceptionHandler defaultUEH = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler _unCaughtExceptionHandler = new Thread.UncaughtExceptionHandler() {
            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                while (mIsLocked) ;
                setLock();
                try {
                    FileOutputStream fileOutputStream = PayuDeviceAnalytics.this.context.openFileOutput(fileName, Context.MODE_PRIVATE);
                    int c = mBuffer.size();
                    for (int i = 0; i < c; i++) {
                        fileOutputStream.write((mBuffer.get(i) + "\r\n").getBytes());
                    }
                    fileOutputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
                releaseLock();
                defaultUEH.uncaughtException(thread, ex);
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(_unCaughtExceptionHandler);
    }

    /**
     * Adding log information to a local file.
     *
     * @param msg json string
     */
    public void log(final String msg) {

        if (mIsLocked) {
            mBuffer.add(msg);
        } else {
            /*new AsyncTask<Void, Void, Void>() {
                @Override
                protected Void doInBackground(Void... voids) {*/
            setLock();
            try {
                JSONObject newobject = new JSONObject(msg);
                JSONArray jsonArray;
                int c;
                String temp = "";
                File file = new File(context.getFilesDir(), file_name);
                if (!file.exists()) { // create the file if not created yet.
                    context.openFileOutput(file_name, Context.MODE_PRIVATE);
                }
                FileInputStream fileInputStream = context.openFileInput(file_name);
                while ((c = fileInputStream.read()) != -1) {
                    temp = temp + Character.toString((char) c);
                }
                if(temp.equalsIgnoreCase(""))
                    jsonArray = new JSONArray();
                else
                    jsonArray = new JSONArray(temp);
                fileInputStream.close();
                FileOutputStream fileOutputStream = context.openFileOutput(file_name, Context.MODE_PRIVATE);
                jsonArray.put(jsonArray.length(), newobject);
                fileOutputStream.write((jsonArray.toString()).getBytes());
                fileOutputStream.close();
            } catch (IOException e) {
                e.printStackTrace();
                mBuffer.add(msg);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            releaseLock();
            // return null;
        }
        resetTimer();
            /*}.execute(null, null, null);*/
    }

    /**
     * Open file and read the content.
     * Send the contents to payu server
     * command should be sdkWs and var1 should be the actual data.
     */
    private void resetTimer() {
        if (mTimer != null) {
            mTimer.cancel();
        }
        mTimer = new Timer();
        mTimer.schedule(new TimerTask() {
            @Override
            public void run() {
                while (mIsLocked) ;
                TIMER_DELAY = 5000;
                setLock();
                String temp = "";
                int c;
                try {
                    File file = new File(context.getFilesDir(), file_name);
                    if (!file.exists()) { // create the file if not created yet.
                        context.openFileOutput(file_name, Context.MODE_PRIVATE);
                    }
                    FileInputStream fileInputStream = context.openFileInput(file_name);
                    while ((c = fileInputStream.read()) != -1) {
                        temp = temp + Character.toString((char) c);

                    }
                    fileInputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                } finally {
                    c = mBuffer.size();
                    while (c > 0) {
                        c--;
                        temp = temp + mBuffer.get(c) + "\r\n";
                        if (c >= 0 && mBuffer.size() > c)
                            mBuffer.remove(c);
                    }
                    temp = temp.trim();
                    if (temp.length() > 0) {
                        // lets prepare data
                        //put data here
                        new UploadData(temp).execute(temp);

                    }else{
                        mTimer.cancel();
                    }
                }
                if (mBuffer.size() > 0) {
                    resetTimer();
                }
                releaseLock();
            }
        }, TIMER_DELAY);
    }

    private synchronized void setLock() {
        mIsLocked = true;
    }

    private synchronized void releaseLock() {
        mIsLocked = false;
    }


    private  JSONArray removeJsonObjectAtJsonArrayIndex(JSONArray source, int index) throws JSONException {
        if (index < 0 || index > source.length() - 1) {
            throw new IndexOutOfBoundsException();
        }

        final JSONArray copy = new JSONArray();
        for (int i = 0, count = source.length(); i < count; i++) {
            if (i != index) copy.put(source.get(i));
        }
        return copy;
    }
    public class UploadData extends AsyncTask<String,Void,String>{
        /**
         * temporary string
         */
        private String temp;
        UploadData(String temp){
            this.temp=temp;
        }
        @Override
        protected void onPostExecute(String aVoid) {
            super.onPostExecute(aVoid);
        }

        @Override
        protected String doInBackground(String... strarr) {
            try{
                try {
                  if(context!=null && !isTimerCancelled) {
                      JSONArray jsonArray = new JSONArray(strarr[0]);
                      JSONArray editorJsonArray = jsonArray;
                      for (int j = 0; j < editorJsonArray.length(); j++) {
                          if (cbUtil.getBooleanSharedPreference(((JSONObject) editorJsonArray.get(j)).getString(CBAnalyticsConstant.MERCHANT_KEY) + "|" + ((JSONObject) editorJsonArray.get(j)).getString(CBAnalyticsConstant.TRANSACTION_ID), context)) {
                              jsonArray = removeJsonObjectAtJsonArrayIndex(editorJsonArray, j);
                          }
                      }
                      if (jsonArray.length() > 0) {

                          String postData = "command=" + CBConstant.DEVICE_ANALYTICS + "&data=" + jsonArray.toString();
                          String analyticsURL = Bank.DEBUG ? TEST_URL_DEVICE_ANALYTICS : PRODUCTION_URL_DEVICE_ANALYTICS;
                          HttpURLConnection conn = cbUtil.getHttpsConn(analyticsURL, postData);
                          if (conn != null) {
                              int responseCode = conn.getResponseCode();

                              if (responseCode == HttpURLConnection.HTTP_OK) {
                                  try {
                                      InputStream responseInputStream = conn.getInputStream();
                                      StringBuffer responseStringBuffer = CBUtil.getStringBufferFromInputStream(responseInputStream);
                                      if (responseStringBuffer != null) {
                                          JSONObject jsonObject = new JSONObject(responseStringBuffer.toString());
                                          if (jsonObject.has("status")) {
                                              context.deleteFile(file_name);
                                              for (int j = 0; j < jsonArray.length(); j++) {
                                                  cbUtil.setBooleanSharedPreference(((JSONObject) jsonArray.get(j)).getString(CBAnalyticsConstant.MERCHANT_KEY) + "|" + ((JSONObject) jsonArray.get(j)).getString(CBAnalyticsConstant.TRANSACTION_ID), true, context);
                                              }
                                          } else {
                                              updateFile(temp);
                                          }
                                      }
                                  } catch (Exception e) {
                                      // SH: A common helper for file operation??
                                      updateFile(temp);
                                  }
                              } else {
                                  updateFile(temp);
                              }
                          } else {

                              context.deleteFile(file_name);
                          }
                      }
                  }
                } catch (MalformedURLException | ProtocolException e) {
                    e.printStackTrace();
                } catch (IOException e) {
                    resetTimer();
                    e.printStackTrace();
                }
            }catch (Exception e){
                e.printStackTrace();
            }
            return null;
        }
    }

    private void updateFile(String temp){
        try {
            FileOutputStream fileOutputStream = context.openFileOutput(file_name, Context.MODE_PRIVATE);
            fileOutputStream.write(temp.getBytes());
            fileOutputStream.close();
        } catch (IOException e1) {

            e1.printStackTrace();
        }
    }

    public Timer getmTimer(){
        isTimerCancelled=true;
        return mTimer;
    }
}