package com.payu.custombrowser;

import android.Manifest;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.telephony.SmsMessage;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.cbinterface.MagicRetryCallbacks;
import com.payu.custombrowser.custombar.CustomProgressBar;
import com.payu.custombrowser.services.SnoozeService;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.util.L;
import com.payu.custombrowser.util.SharedPreferenceUtil;
import com.payu.custombrowser.util.SnoozeConfigMap;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.FileNotFoundException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;


public abstract class PayUCBLifecycle extends CustomBrowserMain implements MagicRetryCallbacks {

    public static int snoozeImageDownloadTimeout;
    protected static List<String> whiteListedUrls = new ArrayList<>();
    // Flag to check whether the txn is from normal flow or snooze flow
    private static boolean isFromSnoozeService;
    // Intent action for determining WEBVIEW status
    protected String SNOOZE_GET_WEBVIEW_STATUS_INTENT_ACTION = "webview_status_action";
    // Broadcast receiver for WEBVIEW status updates
    protected BroadcastReceiver snoozeBroadCastReceiver;
    // Bind service for snooze notifications
    protected SnoozeService snoozeService;
    // snooze broadcast receiver registered
    protected boolean isSnoozeBroadCastReceiverRegistered = false;
    // snooze service bounded
    protected boolean isSnoozeServiceBounded = false;
    // NO. of times snooze will appear during a txn for forward journey
    protected int snoozeCount = 0;
    // NO. of times snooze will appear during a txn for backward journey
    protected int snoozeCountBackwardJourney = 0;
    // Flag for snooze feature
    protected boolean isSnoozeEnabled = true;
    // Slow user warning waitingOTPTimer
    protected CountDownTimer slowUserCountDownTimer;
    // Slow user warning dialog
    protected AlertDialog slowUserWarningDialog;

    protected int snoozeVisibleCountFwdJourney;
    protected int snoozeVisibleCountBackwdJourney;
//    protected CustomBrowserAsyncTask customBrowserAsyncTask;

    // cb blank overlay should appear on click of snooze try later
    View cbBlankOverlay;

    protected ServiceConnection snoozeServiceConnection = new ServiceConnection() {
        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            SnoozeService.SnoozeBinder snoozeBinder = (SnoozeService.SnoozeBinder) iBinder;
            snoozeService = snoozeBinder.getSnoozeService();
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            snoozeService = null;
        }
    };
    // snoozeUrlLoadingPercentage
    protected int snoozeUrlLoadingPercentage;//20;
    // percentage of page should load with in snoozeUrlLoadingTimeout
    protected int snoozeUrlLoadingTimeout;//5000;
    //Check instance

    // true - when password is selected from CB. Default value is - false
    boolean pin_selected_flag;
    // choose view hieght
    int chooseActionHeight;
    // check for CB visibility for dynamic CB
    boolean showCB = true;
    // OTP received from message
    String mPassword;
    // waitingOTPTimer for OTP wait
    Timer waitingOTPTimer;
    // Approve OTP click
    Boolean approve_flag = false;
    // Loading is visible on screen
    boolean checkLoading;
    // JsonObject string received by javascript
    String enterOtpParams;
    // sms receiving permission granted
    boolean permissionGranted = true;
    // check for sms receiving permission
    boolean checkedPermission = false;
    // check for permission dialog visiblility
    boolean checkPermissionVisibility;
    // page load complete
    boolean mPageReady = false;
    // OTP button clicked
    boolean SMSOTPClicked = false;
    // dot progress dialog utility
    CustomProgressBar customProgressBar;
    int[] snoozeLoadPercentageAndTimeOut;

    SnoozeConfigMap snoozeConfigMap;
    private String SNOOZE_BROAD_CAST_MESSAGE = "snooze_broad_cast_message";

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        activity = getActivity();

        //Default values of CB config
        //auto approve false
        // auto select false
        // store one click none
        // merchant sms permission false
        // magic retry true
        // back button true
        // view port default false

        // reset payuId when transaction is initiated to avoid old payuID
        cbUtil.resetPayuID();

        isSnoozeEnabled = cbUtil.getBooleanSharedPreferenceDefaultTrue(SNOOZE_ENABLED, getActivity().getApplicationContext());
        isFromSnoozeService = false;

        snoozeConfigMap = cbUtil.convertToSnoozeConfigMap(SharedPreferenceUtil.getSharedPrefMap(activity, CBConstant.SNOOZE_SHARED_PREF));

        // Setting default snooze config values.
        snoozeLoadPercentageAndTimeOut = snoozeConfigMap.getPercentageAndTimeout(CBConstant.DEFAULT_PAYMENT_URLS);
        snoozeUrlLoadingPercentage = snoozeLoadPercentageAndTimeOut[0];
        snoozeUrlLoadingTimeout = snoozeLoadPercentageAndTimeOut[1];

        // Setting up magic retry white listed urls.
        whiteListedUrls = CBUtil.processAndAddWhiteListedUrls(SharedPreferenceUtil.getStringFromSharedPreference(activity, CBConstant.SP_RETRY_FILE_NAME, CBConstant.SP_RETRY_WHITELISTED_URLS, ""));

        // setup the snoozeImageDownloadTimeout from shared pref. (this value will be used till we get initialize.js)
        snoozeImageDownloadTimeout = SharedPreferenceUtil.getIntFromSharedPreference(activity.getApplicationContext(), CBUtil.CB_PREFERENCE, CBConstant.SNOOZE_IMAGE_DOWNLOAD_TIME_OUT, 0);
        
        /**
         * Coming from snooze service - lets notify snooze service to kill itself.
         */
        if (null != snoozeService) {
            snoozeService.killSnoozeService();
        }

        // setting the snooze cout.
        if (null != activity.getIntent().getStringExtra(SENDER) && activity.getIntent().getStringExtra(SENDER).contentEquals(SNOOZE_SERVICE)) {
            isFromSnoozeService = true;
        }

        /**
         * Registering snooze broad cast receiver
         */
        snoozeBroadCastReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                // Acknowledge the same message to service
                if (intent.hasExtra("broadcaststatus")) {
                    Intent cbIntent = new Intent(activity, CBActivity.class);
                    //  cbIntent.putExtra(POST_DATA, intent.getExtras().getString(POST_DATA));
                    cbIntent.putExtra(CBConstant.SENDER, CBConstant.SNOOZE_SERVICE);
                    //cbIntent.putExtra(POST_URL, intent.getExtras().getString(POST_URL));
                    cbIntent.putExtra(CBConstant.VERIFICATION_MSG_RECEIVED, true);
                    cbIntent.putExtra(CBConstant.PAYU_RESPONSE, intent.getExtras().getString(CBConstant.PAYU_RESPONSE));
                    cbIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_SINGLE_TOP);
                    startActivity(cbIntent);
                }
                if (intent.hasExtra(SNOOZE_BROAD_CAST_MESSAGE)) {
                    if (snoozeService != null)
                        snoozeService.updateWebviewStatus(intent.getStringExtra(SNOOZE_BROAD_CAST_MESSAGE));
                }

                //Analytics events.
                if(intent.getBooleanExtra(CBAnalyticsConstant.BROAD_CAST_FROM_SNOOZE_SERVICE, false)){
                    addEventAnalytics(intent.getStringExtra(CBAnalyticsConstant.KEY), intent.getStringExtra(CBAnalyticsConstant.VALUE));
                }

                if (intent.hasExtra(CBConstant.SNOOZE_SERVICE_STATUS)) { // Snooze service expired! we need to update snooze dialog with new message!
                    updateSnoozeDialogWithSnoozeServiceStatus();
                }
            }
        };


        if (!activity.getClass().getSimpleName().equalsIgnoreCase("CBActivity")) {
            cbOldFlow = true;
            cbOldOnCreate();
        } else {
            cbOnCreate();
        }

        initAnalytics(Bank.keyAnalytics);
        pin_selected_flag = false;
        if (activity != null) {
            cbUtil.clearCookie();
        }
        if (customBrowserConfig != null) {
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_ENABLE_COUNT, "" + customBrowserConfig.getEnableSurePay());
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_MODE_SET_MERCHANT, customBrowserConfig.getSurePayMode() == CustomBrowserConfig.WARN_MODE ? "WARN" : "FAIL");
        }
    }

    private void updateSnoozeDialogWithSnoozeServiceStatus() {
        if (null != snoozeDialog && snoozeDialog.isShowing()) { // This case we update the ui.
            snoozeDialog.cancel();
            snoozeDialog.dismiss();
        }

        LayoutInflater layoutInflater = activity.getLayoutInflater();
        View snoozeLayout = layoutInflater.inflate(R.layout.cb_layout_snooze, null);

        ((TextView) snoozeLayout.findViewById(R.id.snooze_header_txt)).setText(getString(R.string.cb_snooze_network_error));
        // Top right cancel (x) is not required here.
        snoozeLayout.findViewById(R.id.text_view_cancel_snooze_window).setVisibility(View.GONE);
        ((TextView) snoozeLayout.findViewById(R.id.text_view_snooze_message)).setText(getString(R.string.cb_snooze_network_down_message));
        snoozeLayout.findViewById(R.id.snooze_loader_view).setVisibility(View.GONE);
        snoozeLayout.findViewById(R.id.button_snooze_transaction).setVisibility(View.GONE);
        snoozeLayout.findViewById(R.id.text_view_retry_message_detail).setVisibility(View.GONE);
        snoozeLayout.findViewById(R.id.button_retry_transaction).setVisibility(View.GONE);
        snoozeLayout.findViewById(R.id.button_cancel_transaction).setVisibility(View.GONE);
        snoozeLayout.findViewById(R.id.t_confirm).setVisibility(View.GONE);
        snoozeLayout.findViewById(R.id.t_nconfirm).setVisibility(View.GONE);
        Button goBackButton = (Button) snoozeLayout.findViewById(R.id.button_go_back_snooze);
        goBackButton.setVisibility(View.VISIBLE);
        goBackButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                activity.finish();
            }
        });

        snoozeDialog = new android.support.v7.app.AlertDialog.Builder(activity).create();
        snoozeDialog.setView(snoozeLayout);
//        snoozeDialog.setCancelable(false);
        snoozeDialog.setCanceledOnTouchOutside(false);
        snoozeDialog.setOnCancelListener(new DialogInterface.OnCancelListener() {
            @Override
            public void onCancel(DialogInterface dialogInterface) {
                // Here we launch Do you want cancel dialog.
                activity.finish();
            }
        });
        snoozeDialog.show();
    }

    /**
     * For Backward compability with old CB flow
     */
    public void cbOldOnCreate() {
        bundle = getArguments();
        autoApprove = bundle.getBoolean(AUTO_APPROVE, false);
        autoSelectOtp = bundle.getBoolean(AUTO_SELECT_OTP, false);
        storeOneClickHash = bundle.getInt(STORE_ONE_CLICK_HASH, CustomBrowserConfig.STOREONECLICKHASH_MODE_NONE);
        merchantSMSPermission = bundle.getBoolean(MERCHANT_SMS_PERMISSION, false);

        if (Bank.sdkVersion == null || Bank.sdkVersion.equalsIgnoreCase(""))
            Bank.sdkVersion = (getArguments().getString(Bank.SDK_DETAILS));

        if (Bank.transactionID == null || Bank.transactionID.equalsIgnoreCase(""))
            Bank.transactionID = (getArguments().getString(Bank.TXN_ID));

        if (Bank.keyAnalytics == null || Bank.keyAnalytics.equalsIgnoreCase(""))
            Bank.keyAnalytics = (getArguments().getString(Bank.MERCHANT_KEY));


    }

    public void cbOnCreate() {
        if (getArguments() != null && getArguments().containsKey(CB_CONFIG)) {
            customBrowserConfig = getArguments().getParcelable(CB_CONFIG);

            merchantSMSPermission = (customBrowserConfig != null) && customBrowserConfig.getMerchantSMSPermission() == CB_ENABLE_OPTION;
            autoApprove = (customBrowserConfig != null) && customBrowserConfig.getAutoApprove() == CB_ENABLE_OPTION;
            autoSelectOtp = (customBrowserConfig != null) && customBrowserConfig.getAutoSelectOTP() == CB_ENABLE_OPTION;
            storeOneClickHash = (customBrowserConfig == null) ? 0 : customBrowserConfig.getStoreOneClickHash();
            String url = (customBrowserConfig == null) ? "" : customBrowserConfig.getPostURL();


            if (customBrowserConfig != null) {
                if (Bank.keyAnalytics == null || Bank.keyAnalytics.trim().equals("")) {
                    if (customBrowserConfig.getMerchantKey() != null || !customBrowserConfig.getMerchantKey().trim().equals(""))
                        Bank.keyAnalytics = customBrowserConfig.getMerchantKey();
                    else
                        Bank.keyAnalytics = "";
                }

                if (Bank.transactionID == null || Bank.transactionID.trim().equals("")) {
                    if (customBrowserConfig.getTransactionID() != null && !customBrowserConfig.getTransactionID().trim().equals(""))
                        Bank.transactionID = customBrowserConfig.getTransactionID();
                    else
                        Bank.transactionID = "123";
                }

                if (Bank.sdkVersion == null || Bank.sdkVersion.trim().equals("")) {
                    if (customBrowserConfig.getSdkVersionName() != null && !customBrowserConfig.getSdkVersionName().trim().equals(""))
                        Bank.sdkVersion = customBrowserConfig.getSdkVersionName();
                    else
                        Bank.sdkVersion = "";
                }

            }
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        // setCheckFURLSURL();
        // view which is inflated
        // For old flow it is cbSlideBarView + cbBaseView
        // for new flow it is cbWebView + cbSlideBarView + cbBaseView
        View cbInflatedView;
        // Custom Browser cbMainView which has the cbSlideBarView and the cbBaseView
        View cbMainView;

        // WebView.setWebContentsDebuggingEnabled(true);

        // condition to handle old integration for CB
        if (cbOldFlow) {
            cbInflatedView = inflater.inflate(R.layout.bankold, container, false);
            cbMainView = cbInflatedView;
            cbInflatedView.bringToFront();
            cbOldFlowOnCreateView();
        } else {
            cbInflatedView = inflater.inflate(R.layout.bank, container, false);
            cbTransparentView = cbInflatedView.findViewById(R.id.trans_overlay);
            cbWebView = (WebView) cbInflatedView.findViewById(R.id.webview);
            cbBlankOverlay = cbInflatedView.findViewById(R.id.cb_blank_overlay);

            cbMainView = cbInflatedView.findViewById(R.id.parent);
            cbOnCreateView();
        }

        CBUtil.setVariableReflection(CBConstant.MAGIC_RETRY_PAKAGE, BuildConfig.VERSION_NAME, CBConstant.CB_VERSION);


        // cbBaseView - FrameLayout, different cbInflatedView are added to this framelayout, event depend on js.
        cbBaseView = (FrameLayout) cbInflatedView.findViewById(R.id.help_view);
        cbSlideBarView = cbInflatedView.findViewById(R.id.view);
        cbWebPageProgressBar = (ProgressBar) cbInflatedView.findViewById(R.id.cb_progressbar);
        initCBSettings();


        // download initialize.js file
        getInitializeJS();


        // touch listener to handle minimise and maximise of the CustomBrowser
        cbMainView.setOnTouchListener(new PayUCBLifeCycleTouchListener());
        return cbInflatedView;
    }

    private void initCBSettings() {
        cbWebView.getSettings().setJavaScriptEnabled(true);
        cbWebView.addJavascriptInterface(this, "PayU");
        cbWebView.getSettings().setSupportMultipleWindows(true);
        cbWebView.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {

                // User is interacting, dismiss slow user warning waitingOTPTimer
                dismissSlowUserWarningTimerOnTouch();


                if (cbTransparentView != null)
                    cbTransparentView.setVisibility(View.GONE);
                if (frameState == MAXIMISED) {
                    minimizeWebviewHeight();
                }
                return false;
            }
        });

        // improve webView performance
        cbWebView.getSettings().setDomStorageEnabled(true);
        cbWebView.getSettings().setRenderPriority(WebSettings.RenderPriority.HIGH);
        cbWebView.getSettings().setCacheMode(WebSettings.LOAD_NO_CACHE);
        cbWebView.getSettings().setAppCacheEnabled(false);
        // cbWebView.setLayerType(View.LAYER_TYPE_HARDWARE, null);
        // improve webView performance ends
    }

    public void cbOldFlowOnCreateView() {
        cbWebView = (WebView) activity.findViewById(getArguments().getInt(Bank.WEBVIEW));

        if (Bank.paymentMode != null && Bank.paymentMode.equalsIgnoreCase(NB)) {
            cbWebView.getSettings().setUseWideViewPort(true);
        } else if (customBrowserConfig != null && customBrowserConfig.getViewPortWideEnable() == CB_ENABLE_OPTION) {
            // CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getViewPortWideEnable() is 1 when during integration it is set to true
            cbWebView.getSettings().setUseWideViewPort(true);
        }
        cbWebView.setFocusable(true);
        if (getArguments().getBoolean(BACK_BUTTON, true)) {
            cbWebView.setOnKeyListener(new View.OnKeyListener() {
                @Override
                public boolean onKey(View v, int keyCode, KeyEvent event) {

                    if (event.getAction() == KeyEvent.ACTION_UP && keyCode == KeyEvent.KEYCODE_BACK) {
                        if (getArguments().getBoolean(BACK_BUTTON, true)) {
                            AlertDialog.Builder alertDialog = new AlertDialog.Builder(activity);
                            alertDialog.setCancelable(false);
                            alertDialog.setMessage("Do you really want to cancel the transaction ?");
                            alertDialog.setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_OK_CLICK);
                                    dialog.dismiss();
                                    onBackApproved();

                                    // CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackApprove();
                                    activity.finish();
                                }
                            });
                            alertDialog.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_CANCEL_CLICK);
                                    onBackCancelled();
                                    dialog.dismiss();

                                    //  CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackDismiss();
                                }
                            });
                            // CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackButton(alertDialog);
                            addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.PAYU_BACK_BUTTON_CLICK);
                            onBackPressed(alertDialog);
                            alertDialog.show();

                            return true;
                        } else {
                            addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.MERCHANT_BACK_BUTTON_CLICK);
                            activity.onBackPressed();
                        }
                    }
                    return false;
                }
            });
        }
        if (Bank.paymentMode != null && Bank.paymentMode.equalsIgnoreCase(NB)) {
            cbWebView.getSettings().setUseWideViewPort(true);
        } else if (bundle.getBoolean(VIEWPORTWIDE, false)) {
            cbWebView.getSettings().setUseWideViewPort(true);
        }
    }

    public void cbOnCreateView() {

        if (Bank.paymentMode != null && Bank.paymentMode.equalsIgnoreCase(NB)) {
            cbWebView.getSettings().setUseWideViewPort(true);
        } else if (customBrowserConfig != null && customBrowserConfig.getViewPortWideEnable() == CB_ENABLE_OPTION) {
            cbWebView.getSettings().setUseWideViewPort(true);
        }

        cbWebView.setWebChromeClient(new PayUWebChromeClient((Bank) this));
        if (customBrowserConfig.getEnableSurePay() > 0) {
            // Snooze is enabled use SnoozeWebViewClient
            cbWebView.setWebViewClient(new PayUSurePayWebViewClient((Bank) this, Bank.keyAnalytics));
        } else {
            cbWebView.setWebViewClient(new PayUWebViewClient((Bank) this, Bank.keyAnalytics));
        }

        if (customBrowserConfig != null && customBrowserConfig.getPostURL() != null && customBrowserConfig.getPayuPostData() != null) {
            cbWebView.postUrl(customBrowserConfig.getPostURL(), customBrowserConfig.getPayuPostData().getBytes());
        }

        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().setCBProperties(cbWebView, (Bank) this);
        }


        if (customBrowserConfig != null && customBrowserConfig.getMagicretry() == CB_ENABLE_OPTION) {
            if (customBrowserConfig.getEnableSurePay() == 0) {
                initMagicRetry();
            }
            if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                // TODO Do we need this callback??
                CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().initializeMagicRetry((Bank) this, cbWebView, magicRetryFragment);
            }
        }
    }

    // log the event for destroy of fragment
    // events - custom browser / non custom browser, last url , terminate
    public void logOnTerminate() {
        try {

            addEventAnalytics(CBAnalyticsConstant.LAST_URL, CBUtil.updateLastUrl(cbUtil.getStringSharedPreference(activity.getApplicationContext(), CBAnalyticsConstant.LAST_URL)));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            cbUtil.deleteSharedPrefKey(activity.getApplicationContext(), CBAnalyticsConstant.LAST_URL);
        }

        if (!eventArray.contains(CBAnalyticsConstant.CUSTOM_BROWSER)) {
            eventRecorded = CBAnalyticsConstant.NON_CUSTOM_BROWSER;
            addEventAnalytics(CBAnalyticsConstant.CB_STATUS, eventRecorded);
        }

        eventRecorded = CBAnalyticsConstant.TERMINATE_TRANSACTION;
        addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);

        if (progressDialog != null && !progressDialog.isShowing())
            progressDialog.dismiss();

        if (mBroadcastReceiver != null) {
            unregisterBroadcast(mBroadcastReceiver);
            mBroadcastReceiver = null;
        }

    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        cbUtil.cancelTimer(timerProgress);
        if (snoozeDialog != null && snoozeDialog.isShowing()) {
            snoozeDialog.dismiss();
        }
        if (progressDialog != null) {
            progressDialog.dismiss();
            // checkForInput = 1;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        cbUtil.cancelTimer(timerProgress);
        cbUtil.cancelTimer(waitingOTPTimer);

//        if(customBrowserAsyncTask!=null){
//            customBrowserAsyncTask.cancel(false);
//        }
        // Destroy slowUserCountDownTimer
        if (slowUserCountDownTimer != null) {
            slowUserCountDownTimer.cancel();
        }


        // Snooze Event Analytics
        //  addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_STATUS,snoozeCount>0?CBAnalyticsConstant.SNOOZE_VISIBLE:CBAnalyticsConstant.SNOOZE_NOT_VISIBLE);

        addEventAnalytics(CBAnalyticsConstant.SNOOZE_COUNT,""+(snoozeVisibleCountBackwdJourney + snoozeVisibleCountFwdJourney));

        /**
         * If snooze window available then we might need to send the post data to snooze service.
         * Otherwise we dont need config data, because snooze service already has it.
         * CBActivity's onNewIntent will have the post data and current loading url .
         */

        CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(null);

        if (snoozeDialog != null && snoozeDialog.isShowing()) {
            snoozeDialog.dismiss();
        }


        if (null != snoozeBroadCastReceiver && isSnoozeBroadCastReceiverRegistered && !isFromSnoozeService) {
            LocalBroadcastManager.getInstance(activity.getApplicationContext()).unregisterReceiver(snoozeBroadCastReceiver);
        }

        if (null != snoozeServiceConnection && isSnoozeServiceBounded) {
            activity.unbindService(snoozeServiceConnection);
        }

        if (null != snoozeService && isFromSnoozeService) {
            snoozeService.killSnoozeService();
        }


        if (loadingLayout != null)
            customProgressBar.removeProgressDialog(loadingLayout.findViewById(R.id.progress));
        if (enterOTPView != null)
            customProgressBar.removeProgressDialog(enterOTPView.findViewById(R.id.progress));

        if (payuDeviceAnalytics != null) {
            cbUtil.cancelTimer(payuDeviceAnalytics.getmTimer());
        }


        if (mAnalytics != null)
            cbUtil.cancelTimer(mAnalytics.getmTimer());

        cbUtil.cancelTimer(waitingOTPTimer);

        if (countDownTimer != null)
            countDownTimer.cancel();

        //testing remove
        logOnTerminate();
        Bank.sdkVersion = null;
        Bank.keyAnalytics = null;
        Bank.transactionID = null;
        Bank.paymentMode = null;

        // reset payuid cookie
        cbUtil.resetPayuID();
    }

    @Override
    public void onResume() {
        super.onResume();
    }


    /**
     * Preparing sms listener.
     * Reads the sms and checks whether its a otp message.
     */

    void prepareSmsListener() {
        if (mBroadcastReceiver == null) {
            mBroadcastReceiver = new BroadcastReceiver() {
                @Override
                public void onReceive(Context context, Intent intent) {
                    try {
                        if (mBankJS == null) {
                            return;
                        }
                        Bundle myBundle = intent.getExtras();
                        if (getActivity() != null) {
                            Bundle extras = intent.getExtras();
                            if (extras != null) {

                                // Get received SMS array
                                SmsMessage[] msgs;
                                String msgBody = null;
                                String msgAddress = null;
                                Object[] pdus = (Object[]) extras.get("pdus");
                                if (pdus != null) {
                                    msgs = new SmsMessage[pdus.length];
                                    for (int i = 0; i < msgs.length; i++) {
                                        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                                            String format = myBundle.getString("format");
                                            msgs[i] = SmsMessage.createFromPdu((byte[]) pdus[i], format);
                                        } else {
                                            msgs[i] = SmsMessage.createFromPdu((byte[]) pdus[i]);
                                        }
                                        //  msgs[i] = SmsMessage.createFromPdu((byte[]) pdus[i]);
                                        msgBody += msgs[i].getMessageBody();
                                        msgAddress = msgs[i].getDisplayOriginatingAddress();
                                    }
                                }

                                // We have the message!
                                //filter sms
                                mPassword = CBUtil.filterSMS(mBankJS, msgBody, activity.getApplicationContext());

                                // fill otp
                                if (mPassword != null) {
                                    fillOTP(this);
                                } else {
                                    if (payuPG)
                                        verificationMsgReceived = checkConfirmMessage(msgAddress, msgBody);
                                    if (verificationMsgReceived) {
                                        addEventAnalytics(CBAnalyticsConstant.SNOOZE_BACKWARD_WINDOW_SMS_RECEIVED, CBAnalyticsConstant.RECEIVED);
                                    }
                                }
                            }

                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            // Register the broadcast receiver
            IntentFilter filter = new IntentFilter();
            filter.setPriority(9999999);
            filter.addAction("android.provider.Telephony.SMS_RECEIVED");
            registerBroadcast(mBroadcastReceiver, filter);
        }
    }

    public void registerSMSBroadcast() {
        // Register the broadcast receiver
        if (mBroadcastReceiver == null) {
            prepareSmsListener();
        } else {
            IntentFilter filter = new IntentFilter();
            filter.setPriority(9999999);
            filter.addAction("android.provider.Telephony.SMS_RECEIVED");
            registerBroadcast(mBroadcastReceiver, filter);
        }
    }

    String getValueFromPostData(String key) {
        String[] list = customBrowserConfig.getPayuPostData().split("&");

        for (String item : list) {
            String[] items = item.split("=");
            if (items.length >= 2) {
                String id = items[0];
                if (id.equalsIgnoreCase(key)) {
                    return items[1];
                }
            }
        }
        return null;
    }


    private boolean checkConfirmMessage(String msgAddress, String msgBody) {
        int count = 0;
        msgBody = msgBody.toLowerCase();
        boolean returnValue = false;

        if (msgAddress.contains(bankName)) {
            count++;
        }
        if (msgBody.toLowerCase().contains(getValueFromPostData("amount").replace(",", ""))) {
            count++;
        }

        if (count == 2) {
            returnValue = true;
        }

        if (count == 0) {
            returnValue = false;
        }

     /* 1. Verify the bank name from which SMS was received.
                                2. Verify the amount of transaction.
                                3. Look for the following set of keywords:
                                made+purchase
                                account+debited
                                ac+debited
                                a/c+debited
                                tranx+made
                                transaction+made
                                spent
                                Thank+you+using+card+for
                                Spent
                                charge+initiated*/
        if (count == 0) {
            returnValue = false;
        } else if (msgBody.contains("made") && msgBody.contains("purchase")) {

            returnValue = true;
        } else if (msgBody.contains("account") && msgBody.contains("debited")) {
            returnValue = true;
        } else if (msgBody.contains("ac") && msgBody.contains("debited")) {
            returnValue = true;
        } else if (msgBody.contains("tranx") && msgBody.contains("made")) {
            returnValue = true;
        } else if (msgBody.contains("transaction") && msgBody.contains("made")) {
            returnValue = true;
        } else if (msgBody.contains("spent")) {
            returnValue = true;
        } else if (msgBody.contains("Thank you using card for")) {
            returnValue = true;
        } else if (msgBody.contains("charge") && msgBody.contains("initiated")) {
            returnValue = msgBody.contains("charge") && msgBody.contains("initiated");
        }
        return returnValue;
    }


    public void fillOTP(BroadcastReceiver mReceiver) {
        if (getActivity().findViewById(R.id.otp_sms) != null) {
            final TextView otpSMS = (TextView) getActivity().findViewById(R.id.otp_sms);
            if (showCB && mPassword != null && otpSMS.getVisibility() != View.VISIBLE) {
                cbUtil.cancelTimer(waitingOTPTimer);
                switch (eventRecorded) {
                    case CBAnalyticsConstant.PAYMENT_INITIATED:
                        eventRecorded = CBAnalyticsConstant.RECEIVED_OTP_DIRECT;

                        break;
                    case CBAnalyticsConstant.OTP:
                        eventRecorded = CBAnalyticsConstant.RECEIVED_OTP_SELECTED;

                        break;
                    case CBAnalyticsConstant.REGENERATE:
                        eventRecorded = CBAnalyticsConstant.RECEIVED_OTP_REGENERATE;

                        break;
                    default:
                        eventRecorded = CBAnalyticsConstant.OTP_WEB;
                        break;
                }
                addEventAnalytics(CBAnalyticsConstant.OTP_RECIEVED, eventRecorded);

                otpSMS.setText(mPassword);
                mPassword = null;
                customProgressBar.removeDialog(getActivity().findViewById(R.id.progress));

                Button approveButton = (Button) getActivity().findViewById(R.id.approve);
                approveButton.setClickable(true);
                CBUtil.setAlpha(1, approveButton);
                approveButton.setVisibility(View.VISIBLE);

                activity.findViewById(R.id.timer).setVisibility(View.GONE);
                activity.findViewById(R.id.retry_text).setVisibility(View.GONE);
                activity.findViewById(R.id.regenerate_layout).setVisibility(View.GONE);
                activity.findViewById(R.id.waiting).setVisibility(View.GONE);
                activity.findViewById(R.id.otp_recieved).setVisibility(View.VISIBLE);
                otpSMS.setVisibility(View.VISIBLE);
                if (autoApprove) {
                    approveButton.performClick();
                    eventRecorded = CBAnalyticsConstant.CB_AUTO_APPROVE;
                    addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                }
                approveButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        try {
                            mPassword = null;
                            eventRecorded = CBAnalyticsConstant.APPROVED_OTP;
                            addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                            addEventAnalytics(CBAnalyticsConstant.APPROVE_BTN_CLICK_TIME,getSystemCurrentTime() );

                            prepareSmsListener();
                            checkLoading = false;
                            approve_flag = true;
                            onHelpUnavailable();
                            maximiseWebviewHeight();
                            frameState = MINIMISED;
                            cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_process_otp)) + "(\"" + otpSMS.getText().toString() + "\")");
                            otpSMS.setText("");
                            hideSoftKeyboard();

                        } catch (JSONException e) {
                            e.printStackTrace();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });

                // unregister the broadcast receiver.


                if (mBroadcastReceiver != null) {
                    mReceiver.abortBroadcast();
                    unregisterBroadcast(mBroadcastReceiver);
                    mBroadcastReceiver = null;
                }
            }
        }
    }

    /**
     * Download initialize.js form payu server.
     */
    private void getInitializeJS() {
        // listen for OTP
        prepareSmsListener();
        eventRecorded = CBAnalyticsConstant.PAYMENT_INITIATED;

        addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);


        Runnable initilializeRunnable = new Runnable() {
            @Override
            public void run() {
                String fileName = "initialize";
                String strURL = CB_URL + fileName + ".js";
                HttpURLConnection conn = CBUtil.getHttpsConn(strURL);
                try {
                    if (conn != null && conn.getResponseCode() == HttpURLConnection.HTTP_OK) {
                        cbUtil.writeFileOutputStream(conn.getInputStream(), activity, fileName, Context.MODE_PRIVATE);

                    }
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    try {
                        if (activity != null) {
                            mBankJS = new JSONObject(CBUtil.decodeContents(activity.openFileInput(fileName)));
                            setUrlString();
                            checkVisibilityCB("", true);
                            //snoozeImageDownloadTimeout = Integer.parseInt(mBankJS.getString("snooze_image_download_time"));

                            final String snoozeConfig = mBankJS.has("snooze_config") ? mBankJS.get("snooze_config") + "('" + Bank.keyAnalytics + "')" : "";
                            snoozeImageDownloadTimeout = Integer.parseInt(mBankJS.has("snooze_image_download_time") ? mBankJS.get("snooze_image_download_time").toString() : "0");
                            // Store snoozeImageTimeOut in sharedPref.
                            // Storing it in CBUtil.CB_PREFERENCE because CB_CONSTANTS.SNOOZE_SHARED_PREF will be cleared and filled with new set of config on every initialize.js download.
                            SharedPreferenceUtil.addIntToSharedPreference(activity.getApplicationContext(), CBUtil.CB_PREFERENCE, CBConstant.SNOOZE_IMAGE_DOWNLOAD_TIME_OUT, snoozeImageDownloadTimeout);


                            activity.runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    cbWebView.loadUrl("javascript:" + snoozeConfig);

                                }
                            });


                            if (mPageReady) {
                                if (activity != null) {
                                    activity.runOnUiThread(new Runnable() {
                                        @Override
                                        public void run() {
                                            onPageStarted();
                                        }
                                    });
                                }
                            }
                        }
                    } catch (FileNotFoundException | JSONException e) {
                        communicationError();
                        e.printStackTrace();
                    } catch (Exception e) {
                        communicationError();
                        e.printStackTrace();
                    }
                }

            }
        };
        serialExecutor.execute(initilializeRunnable);
    }


    /**
     * Adjust cbWebView size
     *
     * @param view instance of view of which hieght has to be updated
     */
    public void updateHeight(View view) {

        if (maxWebview == 0) {
            calculateMaximumWebViewHeight();
            maximiseWebviewHeight();
        }
        calculateCBHeight(view);
    }

    /**
     * Calculate and update loader height.
     */
    public void updateLoaderHeight() {
        if (chooseActionHeight == 0) {
            cbWebView.measure(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            int maxWebview = cbWebView.getMeasuredHeight();
            chooseActionHeight = (int) (maxWebview * (0.35));
        }
    }


    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String permissions[], @NonNull int[] grantResults) {// here we get the respose of the above request for receiving sms
        switch (requestCode) {
            case 1: {
                checkPermissionVisibility = false;
                if (SMSOTPClicked) {
                    try {
                        cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_otp)));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                if (ContextCompat.checkSelfPermission(activity, Manifest.permission.RECEIVE_SMS) == PackageManager.PERMISSION_GRANTED) {// this condition checks if the user has given us the permission to read sms
                    permissionGranted = true;
                    mPassword = null;
                    prepareSmsListener();
                    enter_otp(enterOtpParams);
                } else {
                    permissionGranted = false;
                    enter_otp(enterOtpParams);
                }
            }
        }
    }

    /**
     * Display slow user warning dialog
     */
    protected void showSlowUserWarning() {

        if (activity != null && !activity.isFinishing() && !isSnoozeWindowVisible) {

            // ############################################################################################## //
            // TODO ADD SOME Event analytics HERE
            // addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_STATUS, CBAnalyticsConstant.SNOOZE_VISIBLE);
            // ############################################################################################## //

            LayoutInflater layoutInflater = activity.getLayoutInflater();
            // Inflating the Slow User Warning UI
            View slowUserWarningLayout = layoutInflater.inflate(R.layout.cb_layout_snooze_slow_user, null);
            // Find header text
            TextView slowUserWarningDialogHeaderText = (TextView) slowUserWarningLayout.findViewById(R.id.snooze_header_txt);
            // Set header text
            slowUserWarningDialogHeaderText.setText(R.string.cb_snooze_slow_user_warning_header);
            // Find close button
            TextView slowUserWarningDialogCloseBtn = (TextView) slowUserWarningLayout.findViewById(R.id.text_view_cancel_snooze_window);
            // Set Visual Graphics
            ImageView slowUserWarningDialogGraphics = (ImageView) slowUserWarningLayout.findViewById(R.id.snooze_status_icon);
            slowUserWarningDialogGraphics.setVisibility(View.VISIBLE);
            slowUserWarningDialogGraphics.setImageDrawable(cbGetDrawable(activity.getApplicationContext(), R.drawable.hourglass));

            // AlertDialog slowUserWarningDialog = null;
            if (null == slowUserWarningDialog) {
                slowUserWarningDialog = new AlertDialog.Builder(activity).create();
                slowUserWarningDialog.setView(slowUserWarningLayout);
                slowUserWarningDialog.setCanceledOnTouchOutside(true);
                slowUserWarningDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialogInterface) {
                        // TODO Future scope - if something needs to be done on dismiss
                    }
                });
                slowUserWarningDialog.setOnKeyListener(new DialogInterface.OnKeyListener() {
                    @Override
                    public boolean onKey(DialogInterface arg0, int keyCode, KeyEvent event) {

                        if (keyCode == KeyEvent.KEYCODE_BACK && event.getAction() == KeyEvent.ACTION_DOWN) {
                            // NOTE: Doing nothing in case of back button press as of now.
                            // This dialog can be closed only by touching outside OR
                            // cancel button press OR back press
                            slowUserWarningDialog.dismiss();

                            // Toast.makeText(activity.getApplicationContext(), "Back button pressed: IGNORED", Toast.LENGTH_SHORT).show();
                            // showBackButtonDialog();

                        }
                        return true;
                    }
                });
                slowUserWarningDialogCloseBtn.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        // Dismiss warning dialog when close button is clicked
                        slowUserWarningDialog.dismiss();
                    }
                });
            }
            slowUserWarningDialog.show();

            if (((CBActivity) activity).STATE == CBConstant.STATE_RESUMED) {
                // User is in background Show Notification to user as well
                showSlowUserWarningNotification();
            }
        }
    }

    /**
     * Dismiss slow user warning dialog
     */
    protected void dismissSlowUserWarning() {
        if (slowUserWarningDialog != null)
            slowUserWarningDialog.dismiss();
    }

    /**
     * Dismiss slow user warning waitingOTPTimer on touch event fire
     */
    private void dismissSlowUserWarningTimerOnTouch() {
        // Marking first CB interaction after forwardjourney
        // is marked completed
        if (forwardJourneyForChromeLoaderIsComplete) {
            firstTouch = true;
            dismissSlowUserWarningTimer();
        }
    }

    protected void showSlowUserWarningNotification() {
        if (activity != null && !activity.isFinishing()) {
            Intent i = new Intent();
            // TODO After discussion with PM
            // cbUtil.showNotification(activity.getApplicationContext(), i, "title", "txt", R.drawable.snooze11, 63);
        }
    }

    abstract void onPageStarted();

    abstract void enter_otp(String params);

    /**
     * Dismiss slow user warning waitingOTPTimer
     * <p/>
     * WARNING: Don't override this method and let bank.java handle it
     */
    abstract void dismissSlowUserWarningTimer();

    /**
     * Start slow user warning waitingOTPTimer
     * <p/>
     * WARNING: Don't override this method and let bank.java handle it
     */

    abstract void startSlowUserWarningTimer();

    /**
     * Having touch listener
     */
    public class PayUCBLifeCycleTouchListener extends CustomBrowserMain.CBMainViewOnTouchListener {
        @Override
        public boolean onTouch(View v, MotionEvent event) {
            L.v("sTag", "onTouch of PayUCBLifeCycleCalled");

            // User is interacting, dismiss slow user warning waitingOTPTimer
            dismissSlowUserWarningTimerOnTouch();

            return super.onTouch(v, event);
        }
    }


    /**
     * Method to display and hide cb blank overlay.
     * should be visible once the user clicked the trylater of snooze
     * should be gone once the snoozewindo disappear.
     * @param visibility
     */
    protected void showCbBlankOverlay(int visibility){
        if(null != cbBlankOverlay) cbBlankOverlay.setVisibility(visibility);
    }
}

