// The MIT License (MIT)
//
// Copyright (c) 2014-2015 PayU India
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package com.payu.custombrowser;

import android.Manifest;
import android.app.Activity;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.AlertDialog;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.custombar.CustomProgressBar;
import com.payu.custombrowser.services.SnoozeService;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.custombrowser.util.L;
import com.payu.custombrowser.util.MissingParamException;
import com.payu.custombrowser.widgets.SnoozeLoaderView;
import com.payu.custombrowser.widgets.SurePayCancelAsyncTaskHelper;
import com.payu.magicretry.Helpers.Util;
import com.payu.magicretry.MagicRetryFragment;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;


/**
 * Custom browser's Fragment.
 * Keeping it as abstract for providing call back function to implementing Activities.
 * Following functions needs to be overridden.
 * {@link Bank#registerBroadcast(BroadcastReceiver, IntentFilter)}}
 * {@link Bank#unregisterBroadcast(BroadcastReceiver)}
 * {@link Bank#onHelpAvailable()}
 * {@link Bank#onHelpUnavailable()}
 * {@link Bank#onBankError()}
 */

public class Bank extends PayUCBLifecycle {
    //CB version
    public static String Version = BuildConfig.VERSION_NAME;
    // making it public because cbConfig need to access this.
    public static String keyAnalytics;
    static String transactionID;
    static String paymentMode;
    static String sdkVersion;
    private static List<String> whiteListedUrls = new ArrayList<>();

    static {
        Version = BuildConfig.VERSION_NAME;
    }

    // Time at snooze button clicked
    public long snoozeClickedTime;
    // Runnable for wait for OTP waitingOTPTimer
    Runnable enterOtpRunnable;
    // Current loading progress of the webview
    private int currentLoadingProgress;
    // Count down waitingOTPTimer to detect slow connection with the help of LOADING THRESHOLD and TIME INTERVAL
    private CountDownTimer mCountDownTimer = null;
    // Flag keeps track of snooze status.
    private boolean isSnoozeTimerRunning = false;
    // Flag tells page loading is stopped by clicking snooze window.
    private boolean isPageStoppedForcefully = false;
    /*    // Time at snooze window dismissed.
        private long snoozeWindowDismissTime;*/
    // Check for backward journey
    //private boolean backwardJourneyTransactionStarted;
    //snooze laoder(3- bar loader)
    private SnoozeLoaderView snoozeLoaderView;
    private View snoozeLayout;
    // false when onPageFinished  called second time
    private boolean firstFinish = true;
    //check for loading mJS only once
    private boolean mLoadingJS = false;
    //listener on buttons of custom browser
    private ButtonOnclickListener buttonClickListener;
    //check for, should save user ID
    private boolean saveUserIDCheck = true;
    // make sure checkvisibility(dynamic CB) is called only once.
    private boolean visibilitychecked;
    // private boolean isBankFound;
    //check for HDFC bank as enterOTP is called twice
    //private int c_hdfc = 0;
    //Android M handling permission check
    //private String merchantHash;
    // MR integration
    private boolean isMRDataSet = false;

    //check for first time finish call
    //private boolean firstFinish = true;
    // checkBox status for NB(checkbox - (enable or disable) save user ID)
    private boolean showToggleCheck;
    //input bundle
    // private Bundle bundle;
    // Timer to disable PayUChromeLoader after some threshold time has elapsed
    private CountDownTimer payUChromeLoaderDisableTimer;
    // @deprecated Timer to enable PayUChromeLoader after some threshold time has elapsed
    private CountDownTimer payUChromeLoaderEnableTimer;
    private boolean showSnoozeWindow = true;
    // check for first url loaded in webpagestart
    private boolean isFirstURLLoaded;
    // Flag to monitor page started and finished.
    private boolean pageStarted = false;
    private boolean webpageNotFoundError = false;
    // flag to monitor transaction status(success or unknown) received or not.
    // check added unnecessarily showing confirm transaction dialog again
    private boolean isTransactionStatusReceived;
    private boolean stopOnlyOnce;


    public Bank() {
        // SH: lets combine urlSet and postPaymentURL someday
        //  urlSet = new HashSet<>(); //initialize the hashset for url where loader has to be visible
        //  postPaymentURL = new HashSet<>(); //initialize the hashset for url after transaction
        buttonClickListener = new ButtonOnclickListener(); //listener for button click event
        showToggleCheck = false; //checkbox status for netbanking
        customProgressBar = new CustomProgressBar(); //progress bar util
        backwardJourneyUrls = new HashSet<>();
        cbUtil = new CBUtil();
        serialExecutor = Executors.newCachedThreadPool();
        retryUrls = new HashSet<>();

    }

    /**
     * Check if currentUrl is a white listed url
     *
     * @param currentUrl
     * @return TRUE / FALSE
     */
    public static boolean isUrlWhiteListed(String currentUrl) {

        // Check if url contain (mobiltest.payu.in or payu.secure.in ) and response
        // payuresponse url support reposting so addin in whitelisted url
        if ((currentUrl.contains(CBConstant.PAYU_DOMAIN_PROD) || currentUrl.contains(CBConstant.PAYU_DOMAIN_TEST)) && currentUrl.contains(CBConstant.RESPONSE_BACKWARD)) {
            return true;
        }
        // TODO : isWhiteListed check needs to be implemented.
        for (String whiteListedUrl : whiteListedUrls) {
            if (null != currentUrl && currentUrl.contains(whiteListedUrl)) {
                return true;
            }
        }
        return false;
    }

    // set transaction status
    public void setTransactionStatusReceived(boolean transactionStatusReceived) {
        isTransactionStatusReceived = transactionStatusReceived;
    }

    public String getCurrentURL() {
        return cbWebView.getUrl() != null ? cbWebView.getUrl() : "";
    }

    // getter for loader
    public SnoozeLoaderView getSnoozeLoaderView() {
        return snoozeLoaderView;
    }

    public String getPageType() {
        return pageType;
    }

    /**
     * if the currentUrl is not supported to be resumed, post the data to
     *
     * @param url        url to be loaded
     * @param postParams post data
     */
    public void reloadWebView(String url, String postParams) {
        // Reset PayUChromeLoader flags
        forwardJourneyForChromeLoaderIsComplete = false;
        backwardJourneyStarted = false;
        isWebviewReloading = true;

        registerSMSBroadcast();
        backwardJourneyStarted = false;
        if (null != snoozeService) {
            snoozeService.killSnoozeService();
        }
        if (isSnoozeWindowVisible) {
            dismissSnoozeWindow();
        }
        if (progressDialog != null) {
            progressDialog.dismiss();
        }
        progressDialog = null;


        if (Build.VERSION.SDK_INT == Build.VERSION_CODES.JELLY_BEAN || Build.VERSION.SDK_INT == Build.VERSION_CODES.JELLY_BEAN_MR1 || Build.VERSION.SDK_INT == Build.VERSION_CODES.JELLY_BEAN_MR2) {
            cbWebView.loadUrl("about:blank");
        }
        addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, url);
        // reset value of auto select OTP to value set by merchant
        resetAutoSelectOTP();
        cbUtil.resetPayuID();
        cbWebView.postUrl(url, postParams.getBytes());
    }

    public void killSnoozeService() {
        if (null != snoozeService) {
            snoozeService.killSnoozeService();
        }
    }

    /**
     * reload webview
     */
    public void reloadWebView() {
        if (null != snoozeService) {
            snoozeService.killSnoozeService();
        }
        if (isSnoozeWindowVisible) {
            dismissSnoozeWindow();
        }
        registerSMSBroadcast();
        isWebviewReloading = true;
        // webview.reload does not invoke onPageStarted
        // lets initialize snoozecounter again.
        if (isSnoozeEnabled) {
            initializeSnoozeTimer();
        }
        if (cbWebView.getUrl() != null) {
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, cbWebView.getUrl());
            if (19 == Build.VERSION.SDK_INT) { // reload webview using js breaks in KITKAT
                cbWebView.reload();
            } else {
                reloadWVUsingJS();
            }
        }
    }

    /**
     * @param resumeUrl Used only for analytics
     */
    public void reloadWebView(String resumeUrl) {
        if (null != snoozeService) {
            snoozeService.killSnoozeService();
        }
        if (isSnoozeWindowVisible) {
            dismissSnoozeWindow();
        }
        registerSMSBroadcast();
        isWebviewReloading = true;
        // webview.reload does not invoke onPageStarted
        // lets initialize snoozecounter again.
        if (isSnoozeEnabled) {
            initializeSnoozeTimer();
        }

        if (cbWebView.getUrl() != null) {
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, resumeUrl);
            if (19 == Build.VERSION.SDK_INT) { // reload webview using js breaks in KITKAT
                cbWebView.reload();
            } else {
                reloadWVUsingJS();
            }
        } else {// This case comes some times on _payment url. if this happen we post the data again to url.
            reloadWebView(customBrowserConfig.getPostURL(), customBrowserConfig.getPayuPostData());
        }
    }

    /***
     * Return the bank name received from JS
     *
     * @return Bank name recieved from JS
     */
    public String getBankName() {
        if (bankName == null)
            return "";
        return bankName;
    }

    /**
     * This method checks permission to read SMS for androidM and above
     */
    private void checkPermission() {//this method checks permission to read SMS for androidM and above
        //  if (!checkedPermission) { // this is to check if this method was called before.

        if (!checkedPermission && Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && merchantSMSPermission) {
            checkedPermission = true;
            if (ContextCompat.checkSelfPermission(activity, Manifest.permission.RECEIVE_SMS) != PackageManager.PERMISSION_GRANTED) {// this checks if we have permission to receive sms or not,
                requestPermissions(new String[]{Manifest.permission.RECEIVE_SMS}, 1); // if we dont have permission we request permission
                checkPermissionVisibility = true;
            } else {
                permissionGranted = true;
                if (SMSOTPClicked) {
                    try {
                        cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_otp)));
                    } catch (JSONException e) {

                        e.printStackTrace();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            onHelpAvailable();
            permissionGranted = ContextCompat.checkSelfPermission(activity, Manifest.permission.RECEIVE_SMS) == PackageManager.PERMISSION_GRANTED;

            if (SMSOTPClicked) {
                try {
                    cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_otp)));
                } catch (JSONException e) {
                    e.printStackTrace();
                } catch (Exception e) {
                    e.printStackTrace();

                }
            }
        }

    }

    /**
     * Callback from custombrowser tells the bank.java to show or hide the custom browser.
     *
     * @param showCustomBrowser enable or disbale custom browser
     */
    @JavascriptInterface
    public void showCustomBrowser(final boolean showCustomBrowser) {
        showCB = showCustomBrowser;
        if (getActivity() != null) {
            getActivity().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (!showCustomBrowser) {
                        maximiseWebviewHeight();
                        frameState = MINIMISED;
                        try {
                            if (cbSlideBarView != null)
                                cbSlideBarView.setVisibility(View.GONE);
                            onHelpUnavailable();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    @JavascriptInterface
    public void setMRData(String data) {
        if (!isMRDataSet) {
            // TODO MR.setMRData will eventually phase out, only CBUtil.updateRetryData will be used
            // Store the Magic retry setting in shared preference
            MagicRetryFragment.setMRData(data, getActivity().getApplicationContext());
            updateWhitelistedRetryUrls(CBUtil.updateRetryData(data, getActivity().getApplicationContext()));

            isMRDataSet = true;
        }
    }

    /**
     * Dismiss error page
     */
    public void onOverrideURL(String url) {
        if (cbWebPageProgressBar != null)
            cbWebPageProgressBar.setProgress(10);
    }

    private void snoozeOnReceivedError() {
        setIsPageStoppedForcefully(true);
        launchSnoozeWindow(CBConstant.FAIL_MODE);
    }

    /**
     * Custom browser shows the error page.
     *
     * @param errorCode   error code received by dvm for the error
     * @param description description about the error
     */
    public void onReceivedErrorWebClient(int errorCode, String description) {
        webpageNotFoundError = true;
        try {
            if (getActivity() != null && !getActivity().isFinishing()) {

                if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                    /*if(backwardJourneyTransactionStarted && isTxnNBType){
                        launchSnoozeWindow();
                    }*/
                    if (!backwardJourneyStarted) {
                        snoozeOnReceivedError();
                    } else if (backwardJourneyStarted && isTxnNBType && snoozeCountBackwardJourney < customBrowserConfig.getEnableSurePay()) {
                        dismissSnoozeWindow();
                        snoozeOnReceivedError();

                    }
                    onHelpUnavailable();
                    cbBaseView.removeAllViews();
                    if (cbWebPageProgressBar != null) {
                        cbWebPageProgressBar.setVisibility(View.GONE);
                        //    cbWebPageProgressBar.setProgress(0);
                    }
                    // maximize cb webview height, if calculated maximum WebView height is greater than 0
                    if (maxWebview != 0) {
                        maximiseWebviewHeight();
                        frameState = MINIMISED;
                    }
                    hideCB();
                    if (!cbOldFlow)
                        CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onCBErrorReceived(errorCode, description);

                /* old progressBarVisibilityPayuChrome(View.GONE);*/
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    // MR Integration
    private void showMagicRetryCB() {
        try {
            cbWebView.loadUrl("javascript:" + mBankJS.getString("getMagicRetryUrls") + "('" + Bank.keyAnalytics + "')");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * update progress bar according to progress recieved
     *
     * @param progress percentage completion of loading url
     */

    public void onProgressChanged(int progress) {
        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            if (cbWebPageProgressBar != null) {
                cbWebPageProgressBar.setVisibility(View.VISIBLE);
                // progressBar.setProgress(progress);

                if (progress == 100) {
                    if (cbWebPageProgressBar != null) {
                        cbWebPageProgressBar.setProgress(100);
                        Handler handler = new Handler();
                        handler.postDelayed(new Runnable() {
                            @Override
                            public void run() {

                                if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
                                    cbWebPageProgressBar.setVisibility(View.GONE);
                                    //     cbWebPageProgressBar.setProgress(0);
                                    lastProgress = 0;
                                }
                            }
                        }, 100);
                    }
                } else {
                    startAnimation(progress);
                }
            }
        }
    }

    @JavascriptInterface
    public void onMerchantHashReceived(final String result) {

        if (getActivity() != null && !getActivity().isFinishing() && !isRemoving() && isAdded()) {
            getActivity().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    switch (storeOneClickHash) {
                        case CBAnalyticsConstant.STORE_ONE_CLICK_HASH_MOBILE:
                            try {
                                JSONObject hashObject = new JSONObject(result);
                                // store the cvv in shared preferences.
                                cbUtil.storeInSharedPreferences(getActivity().getApplicationContext(), hashObject.getString(CBAnalyticsConstant.CARD_TOKEN), hashObject.getString(CBAnalyticsConstant.MERCHANT_HASH));
                            } catch (JSONException e) {
                                e.printStackTrace();

                            }
                            break;
                        case CBAnalyticsConstant.STORE_ONE_CLICK_HASH_SERVER:
                            //  merchantHash = result;
                            break;
                        case CBAnalyticsConstant.STORE_ONE_CLICK_HASH_NONE:
                            break;
                    }
                }
            });
        }
    }

    /**
     * Initialize snooze waitingOTPTimer,
     */
    private void initializeSnoozeTimer() {
        // if merchant opted for snooze
        if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null && customBrowserConfig != null) {
            if (cbUtil.getBooleanSharedPreferenceDefaultTrue(SNOOZE_ENABLED, activity.getApplicationContext()) && customBrowserConfig.getEnableSurePay() > snoozeCount) {
                // a page has been started, lets start snoozeCountDownTimer and stop snoozer if its running already.
                if (isSnoozeTimerRunning) {
                    stopSnoozeCountDownTimer();
                }
                startSnoozeCountDownTimer();
            }
        }
    }

    public void onPageStartedWebclient(String url) {

        pageStarted = true;
        // page is started setting forcefully stopped to false;
        isPageStoppedForcefully = false;

        // Special case for jelly bean where in case of onReceivedError the flow is onPageStarted->onReceivedError->OnPageStarted
        // here, if webpageNotFoundError = true then it means that it is coming from onReceivedError and hence
        // we can do custom things we needed to do for JELLYBEAN in case of onReceivedError and which get reset in onPageStarted
        if ((Build.VERSION.SDK_INT == Build.VERSION_CODES.JELLY_BEAN ||
                Build.VERSION.SDK_INT == Build.VERSION_CODES.JELLY_BEAN_MR1 ||
                Build.VERSION.SDK_INT == Build.VERSION_CODES.JELLY_BEAN_MR2) && webpageNotFoundError) {
            jellyBeanOnReceivedError();
        }


        // Setting flag, webpage not found error is no more
        webpageNotFoundError = false;

        // Dismiss slow user warning waitingOTPTimer, if any
        dismissSlowUserWarning();

        // check if PayU PG is used for making payment, as Backward journey for snooze will only work if PayU PG is used for making payment
        if (!payuPG && (url != null) &&
                (((DEBUG)?url.equalsIgnoreCase(MOBILE_TEST_PAYMENT_URL) : url.equalsIgnoreCase(PRODUCTION_PAYMENT_URL))
                ||((DEBUG) ? url.equalsIgnoreCase(MOBILE_TEST_PAYMENT_URL_SEAMLESS) : url.equalsIgnoreCase(PRODUCTION_PAYMENT_URL_SEAMLESS)))){
            payuPG = true;
        }

        if (!isFirstURLLoaded) {
            // add post URL and post data to config of custom browser from callback
            if (customBrowserConfig != null && customBrowserConfig.getPayuPostData() == null && customBrowserConfig.getPostURL() == null) {
                if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().getPostData() != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().getPostURL() != null) {
                    customBrowserConfig.setPayuPostData(CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().getPostData());
                    customBrowserConfig.setPostURL(CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().getPostURL());

                    // deleting payment related details from callback class
                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().setPostURL(null);
                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().setPostData(null);

                } else {
                    // throw runtime exception if post data or post url is missing or (post url is not equal to first url loaded by merchant)
                    throw new MissingParamException("POST Data or POST URL Missing or wrong POST URL");
                }
            }

            if(customBrowserConfig!=null) {
                isTxnNBType = checkIfTransactionNBType(customBrowserConfig.getPayuPostData());
            }
            // set first load to true after first load
            isFirstURLLoaded = true;
        }

        showSnoozeWindow = true;

        if (pageType != null && !pageType.equalsIgnoreCase("")) {
            timeOfDeparture = getSystemCurrentTime();
            addEventAnalytics(CBAnalyticsConstant.DEPARTURE, timeOfDeparture);
            pageType = "";
        }

        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            cbUtil.setStringSharedPreferenceLastURL(activity.getApplicationContext(), CBAnalyticsConstant.LAST_URL, "s:" + url);

            // progress bar is set visible
            if (cbWebPageProgressBar != null) {
                cbWebPageProgressBar.setVisibility(View.VISIBLE);
            }

            // DISMISS previous PayUChromeLoader Timer
            if (payUChromeLoaderDisableTimer != null) {
                payUChromeLoaderDisableTimer.cancel();
            }

            if (cbWebPageProgressBar != null) {
                cbWebPageProgressBar.setVisibility(View.VISIBLE);
                cbWebPageProgressBar.setProgress(10);
            }

            backwardJourneyStarted = isInBackWardJourney(url);

            // Only show payuChromeLoader in:
            // 1) Forward journey
            // 2) Backward journey
            // Note: Loader should not appear while user is interacting with the bank page
            if (!forwardJourneyForChromeLoaderIsComplete || backwardJourneyStarted) {
                progressBarVisibilityPayuChrome(View.VISIBLE, url);
            }

            // ################################################################################ //
            // Not using only url as it does not gives correct url in case browser history
            // is changed using JS. e.g. paytxn being inserted by PayU.
            // Using cbWebView.getUrl() instead to get correct url being loaded
            // webviewUrl = url;
            webviewUrl = (cbWebView.getUrl() == null || cbWebView.getUrl().equalsIgnoreCase("")) ? url : cbWebView.getUrl();
            // ################################################################################ //

            // check  from backward journer started
            if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                // check for confirm transaction - to avoid looping again
                //   if (!backwardJourneyStarted) {
                // backwardJourneyUrls - list of backward journey url (backward journey PG url + backward journey PayU url)
                if (backwardJourneyStarted) {
                    //      backwardJourneyStarted = true;// check for backward journey
                    if (isTxnNBType) {
                        isSnoozeWindowVisible = false; // snooze dialog visiblility is set false so that backward journey snooze dialog can overrite forward one if it is appearing
                    } else {
                        dismissSnoozeWindow();
                    }
                    //bindService();
                }
                //  }

                // checkValue is retry URL of payu
                // dismiss payu dialog if retry screen loading
                /*if (checkValue != null && url.contains(checkValue)) {
                    update();
                }*/
                // Initialize snooze counter.

                // check the url loaded , dismiss snooze dialog if it is 'surl' and 'furl' -
                // 'frl' and 'surl' is from payment postdata
                // 'furl' and 'surl' loading means payment is either success or failure so no need to call verify API
                if (url.contains(Bank.DEBUG ? PAYMENT_OPTION_URL_DEV : PAYMENT_OPTION_URL_PROD)) {
                    mJS = null;
                }

                try {
                    if ((!cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.SURL).equals("") &&
                            url.contains(URLDecoder.decode(cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.SURL), "UTF-8"))) ||
                            (!cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.FURL).equals("") &&
                                    url.contains(URLDecoder.decode(cbUtil.getDataFromPostData(customBrowserConfig.getPayuPostData(), CBConstant.FURL), "UTF-8"))) ||
                            isRetryURL(url)) {

                        showSnoozeWindow = false;
                        dismissSnoozeWindow();
                        hideCB();
                        if (isRetryURL(url)) {
                            // reset value of auto select OTP to value set by merchant
                            resetAutoSelectOTP();
                            backwardJourneyStarted = false;
                        }
                        stopSnoozeCountDownTimer();
                        //  backwardJourneyStarted = false;
                        if (null != snoozeService) {
                            // kill snooze service if it is running

                            snoozeService.killSnoozeService();
                        }
                        // initializeSnoozeTimer();

                    } else {
                        // in case of warn mode only we show the snooze window.
                        // in case of fail mode we launch snooze window at only on Error received.
                        if (isSnoozeEnabled && customBrowserConfig.getSurePayMode() == WARN_MODE) {
                            // TODO: move this isSnoozeEnabled flag to other place where we check other snozoe flags.
                            // TODO : here we re-assign the dynamic snooze config values based on the url
                            if (!backwardJourneyStarted) {
                                snoozeLoadPercentageAndTimeOut = snoozeConfigMap.getPercentageAndTimeout(url);
                                snoozeUrlLoadingPercentage = snoozeLoadPercentageAndTimeOut[0];
                                snoozeUrlLoadingTimeout = snoozeLoadPercentageAndTimeOut[1];
                                //   snoozeUrlLoadingPercentage=100;
                                // snoozeUrlLoadingTimeout=1;

                                initializeSnoozeTimer();
                            }
                        }
                    }
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        // For testing backward journey sure pay
       /*if(!stopOnlyOnce && backwardJourneyStarted && isTxnNBType){
            stopOnlyOnce=true;
            stopWIFI();
        }*/
    }

    public void stopWIFI(){
     // WifiManager wifiManager = (WifiManager)activity.getSystemService(Context.WIFI_SERVICE);
     // wifiManager.setWifiEnabled(false);
    }

    /**
     * Special method for JellyBean onReceivedError,
     * anything to be done in case of onReceivedError
     * for Jellybean devices can be done here
     */
    private void jellyBeanOnReceivedError() {
        setIsPageStoppedForcefully(true);
    }


    /**
     * If url is in backw
     * <p/>
     * ardJourneyUrls, mark as backward journey
     *
     * @param url
     * @return TRUE if url is in the list, FALSE otherwise
     */
    public boolean isInBackWardJourney(String url) {

        try {
            if (!backwardJourneyStarted) {
                if ((url.contains(CBConstant.PAYU_DOMAIN_PROD) || url.contains(CBConstant.PAYU_DOMAIN_TEST)) && url.contains(CBConstant.RESPONSE_BACKWARD)) {
                    return true;
                }
                if (backwardJourneyUrls != null) {
                    for (String backwardJourneyUrl : backwardJourneyUrls) {
                        if (url.contains(backwardJourneyUrl)) {
                            return true;
                        }
                    }
                    return false;
                }
            }
            return backwardJourneyStarted;
        } catch (Exception e) {
            e.printStackTrace();
            return backwardJourneyStarted;
        }
    }

    /**
     * Call back function from {@link PayUWebViewClient#onLoadResource(WebView, String)}
     *
     * @param view instance of cbWebView
     * @param url  resourse url which  is loading
     */
    public void onLoadResourse(WebView view, String url) {
        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            if (url.equalsIgnoreCase(rupeeURL) || url.contains(rupeeURL1) || url.contains(rupeeURL2)) {
                /* old progressBarVisibilityPayuChrome(View.GONE); */
                //checkProgress = DURING_PAYMENT;
            }
        }
    }

    /**
     * Call back function from {@link PayUWebViewClient#onPageFinished(WebView, String)}
     * It takes care keyboard open issue and dissmiss the payu dialog.
     *
     * @param url - finish url
     */
    public void onPageFinishWebclient(String url) {

        //  maximiseWebviewHeight();
        pageStarted = false;

        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            cbUtil.setStringSharedPreferenceLastURL(activity.getApplicationContext(), CBAnalyticsConstant.LAST_URL, "f:" + url);
            // progressBarVisibilityPayuChrome(View.GONE, 1, url);
            // Start waitingOTPTimer of 5secs to dismiss PayuChromeLoader
            startPayUChromeLoaderDisbaleTimer();

            /*if (checkProgress == PRE_PAYMENT) {
                // progressBarVisibilityPayuChrome(View.GONE, 1);
                checkProgress = DURING_PAYMENT;
            }*/

            if (firstFinish && (getArguments() != null && getArguments().getInt(CBConstant.MAIN_LAYOUT, -1) != -1)) {
                try {
                    final View activityRootView = activity.findViewById(getArguments().getInt(CBConstant.MAIN_LAYOUT));
                    activityRootView.getViewTreeObserver().addOnGlobalLayoutListener(
                            new ViewTreeObserver.OnGlobalLayoutListener() {
                                private final int DefaultKeyboardDP = 100;
                                private final int EstimatedKeyboardDP = DefaultKeyboardDP + (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP ? 48 : 0);
                                private final Rect r = new Rect();

                                @Override
                                public void onGlobalLayout() {
                                    if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
                                        // Convert the dp to pixels.
                                        int estimatedKeyboardHeight = (int) TypedValue
                                                .applyDimension(TypedValue.COMPLEX_UNIT_DIP, EstimatedKeyboardDP, activityRootView.getResources().getDisplayMetrics());
                                        // Conclude whether the keyboard is shown or not.
                                        activityRootView.getWindowVisibleDisplayFrame(r);
                                        int heightDiff = activityRootView.getRootView().getHeight() - (r.bottom - r.top);
                                        boolean isShown = heightDiff >= estimatedKeyboardHeight;
                                        if (isShown) {
                                            if (checkForInput == 0) {
                                                InputMethodManager imm = (InputMethodManager) activity.getSystemService(Activity.INPUT_METHOD_SERVICE);
                                                imm.toggleSoftInput(InputMethodManager.RESULT_HIDDEN, 0);
                                                checkForInput = 1;
                                            }
                                        }
                                    }
                                }
                            });
                    firstFinish = false;

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }


        if (!isPageStoppedForcefully) {
            stopSnoozeCountDownTimer();
        }

        // if a new page is not started in another 1 sec we are going to kill snooze window.
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                // isPageStoppedForcefully - user interacted with snoozewindow.
                // page started - new page started loading on webview
                // isSnoozeWindowVisible - snooze window is on the screen.
                // backwardJourneyTransactionStarted - backward journey started. (We will dismiss snooze only in forward journey)
                if (!isPageStoppedForcefully && !pageStarted && isSnoozeWindowVisible && !backwardJourneyStarted) {
                    //snoozeCount--;
                    if (isSnoozeWindowVisible) {
                        addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_AUTOMATICALLY_DISAPPEAR_TIME, getSystemCurrentTime());
                    }

                    dismissSnoozeWindow();
                }
            }
        }, 1000);
    }

    @JavascriptInterface
    public void setSnoozeEnabled(boolean snoozeEnabled) {

        if (!snoozeEnabled) {

            // snooze is dynamically disabled,
            // override snooze count set by merchant
            customBrowserConfig.setEnableSurePay(0);
        }

        cbUtil.setBooleanSharedPreference(SNOOZE_ENABLED, snoozeEnabled, activity.getApplicationContext());

    }

    /**
     * Don't close the PayUChromeLoader abruptly on page
     * load finish call, instead wait for sometime - if it's
     * a redirect and another page loads then cancel dismiss
     * of loader and continue showing it
     */
    private void startPayUChromeLoaderDisbaleTimer() {

        // Cancel any previous timers
        if (payUChromeLoaderDisableTimer != null) {
            payUChromeLoaderDisableTimer.cancel();
        }

        if (payUChromeLoaderEnableTimer != null) {
            payUChromeLoaderEnableTimer.cancel();
        }

        payUChromeLoaderDisableTimer = new CountDownTimer(2000, 1000) {

            public void onTick(long millisUntilFinished) {
                // mTextField.setText("seconds remaining: " + millisUntilFinished / 1000);
            }

            public void onFinish() {
                dismissPayULoader();
            }
        }.start();
    }

    /**
     * After user has landed on bank page,
     * don't show PayUChromeLoader as soon as url starts loading.
     * Instead wait for sometime - if url loads in that 'some time',
     * no need to show PayUChromeLoader in that case
     *
     * @deprecated
     */

    private void startPayUChromeLoaderEnableTimer() {

        // This waitingOTPTimer is used after CB has been seen by user once
        if (payUChromeLoaderEnableTimer != null) {
            payUChromeLoaderEnableTimer.cancel();
        }

        payUChromeLoaderEnableTimer = new CountDownTimer(1000, 1000) {

            public void onTick(long millisUntilFinished) {
                // mTextField.setText("seconds remaining: " + millisUntilFinished / 1000);
            }

            public void onFinish() {
                // Show PayU Loader as 1 second has elapsed
                progressBarVisibilityPayuChrome(View.VISIBLE, "");
                forwardJourneyForChromeLoaderIsComplete = true;
            }
        }.start();
    }

    /**
     * Stores the user id on NetBanking.
     */
    @JavascriptInterface
    public void getUserId() {
        if (activity != null && !activity.isFinishing()) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        // load javascript to get user ID which call setUserID(from JS)
                        cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_populate_user_id)) + "(\"" + cbUtil.getStringSharedPreference(activity.getApplicationContext(), bankName) + "\")");

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    /**
     * Stores the user id on Netbanking.
     *
     * @param params - JSON object from js
     */
    @JavascriptInterface
    public void setUserId(final String params) {
        // saveUserIDCheck to check if user given the permission to save USER ID
        if (saveUserIDCheck) {
            if (activity != null && !activity.isFinishing()) {
                //SH: Can we please make use of SP helper here? And every other place where SP is accessed?
                //APPLIED CHANGE
                cbUtil.storeInSharedPreferences(activity.getApplicationContext(), bankName, params);
            }

        } else {
            //APPLIED CHANGE
            String savedParam = cbUtil.getStringSharedPreference(activity.getApplicationContext(), bankName);
            if (!savedParam.equals("") && savedParam.equals(params)) {
                //APPLIED CHANGE
                cbUtil.removeFromSharedPreferences(activity.getApplicationContext(), bankName);
            }
        }

    }

    /**
     * Adds remember username and password peak view for NB
     *
     * @param fields key for handling net banking custom browser
     * @param params JSON string for net banking custom browser key
     */
    @JavascriptInterface
    public void nativeHelperForNB(final String fields, final String params) {
        if (activity != null && !activity.isFinishing()) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {

                        if (isSnoozeWindowVisible) {
                            dismissSnoozeWindow();
                           /* if (snoozeCount > 0 && !isPageStoppedForcefully) { // if custom browser dismisses the snooze window we dont consider that as snooze count.
                                snoozeCount--;
                            }*/
                            addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_WINDOW_DISMISSED_BY_CB);
                            addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_AUTOMATICALLY_DISAPPEAR_TIME, getSystemCurrentTime());

                        }
                        pageType = CBAnalyticsConstant.NBLOGIN_PAGE;
                        timeOfArrival = getSystemCurrentTime();
                        addEventAnalytics(CBAnalyticsConstant.ARRIVAL, timeOfArrival);
                        onHelpAvailable();
                        addEventAnalytics(CBAnalyticsConstant.CB_STATUS, CBAnalyticsConstant.NB_CUSTOM_BROWSER);
                        if (fields != null && activity != null) {
                            dismissSnoozeWindow();
                            View nbView = activity.getLayoutInflater().inflate(R.layout.nb_layout, null);
                            final Button bContinue = (Button) nbView.findViewById(R.id.b_continue);
                            final CheckBox checkBox = (CheckBox) (nbView.findViewById(R.id.checkbox));
                            JSONObject jsonObject = new JSONObject(params);
                            String bText = getString(R.string.cb_btn_text);
                            if (jsonObject.has(bText) && jsonObject.getString(bText) != null && !jsonObject.getString(bText).equalsIgnoreCase("")) {
                                if (fields.equals(getString(R.string.cb_button))) {
                                    if (jsonObject.has(getString(R.string.cb_checkbox))) {
                                        if (jsonObject.getBoolean(getString(R.string.cb_checkbox))) {
                                            // check if user has given permission to save userID
                                            if (saveUserIDCheck) {
                                                addEventAnalytics(CBAnalyticsConstant.INITIAL_USER_NAME_CHECKBOX_STATUS, "y");
                                                checkBox.setChecked(true);
                                            } else {
                                                addEventAnalytics(CBAnalyticsConstant.INITIAL_USER_NAME_CHECKBOX_STATUS, "n");
                                                checkBox.setChecked(false);
                                            }


                                            checkBox.setOnClickListener(new View.OnClickListener() {
                                                @Override
                                                public void onClick(View v) {
                                                    saveUserIDCheck = checkBox.isChecked();
                                                    if (saveUserIDCheck) {
                                                        addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.USER_NAME_CHECKBOX_STATUS + "y");

                                                    } else {
                                                        addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.USER_NAME_CHECKBOX_STATUS + "n");

                                                    }
                                                }
                                            });
                                            checkBox.setVisibility(View.VISIBLE);
                                        } else {
                                            checkBox.setVisibility(View.GONE);
                                        }

                                    } else {
                                        checkBox.setVisibility(View.GONE);
                                    }
                                    bContinue.setText(jsonObject.getString(bText));
                                    bContinue.setTransformationMethod(null);
                                    bContinue.setOnClickListener(new View.OnClickListener() {
                                        @Override
                                        public void onClick(View v) {
                                            try {
                                                addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.NB_BUTTON_CLICK + bContinue.getText());

                                                cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_btn_action)));
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    });
                                    cbBaseView.removeAllViews();
                                    cbBaseView.addView(nbView);
                                    nbhelpVisible = true;
                                } else if (fields.equals(getString(R.string.cb_pwd_btn))) { // for pwd button flow
                                    bContinue.setText(jsonObject.getString(bText));
                                    if (showToggleCheck)
                                        checkBox.setChecked(true);
                                    else
                                        checkBox.setChecked(false);
                                    if (checkBox.isChecked()) {
                                        try {
                                            cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_toggle_field)) + "(\"" + true + "\")");
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    checkBox.setText(getString(R.string.cb_show_password));
                                    checkBox.setVisibility(View.VISIBLE);
                                    checkBox.setOnClickListener(new View.OnClickListener() {
                                        @Override
                                        public void onClick(View v) {
                                            showToggleCheck = checkBox.isChecked();
                                            if (checkBox.isChecked()) {
                                                try {
                                                    // mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_btn_action)));
                                                    cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_toggle_field)) + "(\"" + true + "\")");
                                                } catch (Exception e) {
                                                    e.printStackTrace();
                                                }


                                            } else {
                                                try {
                                                    cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_toggle_field)) + "(\"" + false + "\")");
                                                } catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                            }

                                        }
                                    });
                                    bContinue.setOnClickListener(new View.OnClickListener() {
                                        @Override
                                        public void onClick(View v) {
                                            try {
                                                cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_btn_action)));
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                            }

                                        }
                                    });
                                    nbhelpVisible = true;
                                    cbBaseView.removeAllViews();
                                    cbBaseView.addView(nbView);
                                }

                            } else {
                                onHelpUnavailable();
                                cbBaseView.removeAllViews();
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

            });
        }

        // CB should be visible, dismiss PayUChromeLoader
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                dismissPayULoader();
            }
        });
    }

    /**
     * run initialize.js manually.
     */
    @JavascriptInterface
    public void reInit() {
        if (activity != null && !activity.isFinishing()) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    onPageFinished();
                }
            });
        }
    }

    /**
     * We found the bank, call back from initialize.js with the bank name.
     *
     * @param bank name of bank recived by js
     */
    @JavascriptInterface
    public void bankFound(final String bank) {

        if (!visibilitychecked) {
            checkVisibilityCB(bank);
            visibilitychecked = true;
        }
        //isBankFound = true;
        cbSetBankDrawable(bank);
        CBUtil.setVariableReflection(CBConstant.MAGIC_RETRY_PAKAGE, bank, CBConstant.BANKNAME);
        if (activity != null && !activity.isFinishing()) {
            // initialize loading
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    calculateMaximumWebViewHeight();
                }
            });
        }

        // bank name
        bankName = bank;
        if (!mPageReady) {
            try {

                if (loadingLayout != null) {
                    activity.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            customProgressBar.removeProgressDialog(loadingLayout.findViewById(R.id.progress));
                        }
                    });
                }
                if (!isPageStoppedForcefully) {
                    if (loadingLayout == null) {
                        convertToNative(CBConstant.LOADING, "{}");
                    } else {

                        View view;
                        if (activity != null) {
                            view = ((ViewGroup) activity.findViewById(R.id.help_view)).getChildAt(0);
                            if (loadingLayout != view) {
                                convertToNative(CBConstant.LOADING, "{}");
                            }
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();

            }

        }

        if (!mLoadingJS && mJS == null) {
            // do we have the js file already?


            Runnable serialRunnable = new Runnable() {
                @Override
                public void run() {
                    mLoadingJS = true;
                    File file;
                    try {
                        if (activity != null) {
                            String fileName = mBankJS.getString(bank);
                            file = new File(activity.getFilesDir(), fileName);
                            if (!file.exists()) {
                                // SH: Please move this to a HTTP downloader, may be a helper, at least a function
                                java.net.URL url = new URL(CB_URL + fileName + ".js");

                                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                                conn.setRequestMethod("GET");
                                conn.setRequestProperty("Accept-Charset", "UTF-8");
                                if (conn.getResponseCode() == HttpURLConnection.HTTP_OK) {
                                    cbUtil.writeFileOutputStream(conn.getInputStream(), activity, fileName, Context.MODE_PRIVATE);
                                }

                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    } finally {
                        try {
                            if (activity != null) {
                                String fileName = mBankJS.getString(bank);
                                mJS = new JSONObject(CBUtil.decodeContents(activity.openFileInput(fileName)));
                                if (mPageReady) {
                                    if (activity != null) {
                                        activity.runOnUiThread(new Runnable() {
                                            @Override
                                            public void run() {
                                                onPageFinished();
                                            }
                                        });
                                    }
                                }
                                mLoadingJS = false;
                            }
                        } catch (JSONException | FileNotFoundException e) {
                            e.printStackTrace();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            serialExecutor.execute(serialRunnable);
        }

    }

    /**
     * Js interface from Bank specific javascript.
     * Convert to native shows the bank specific native ui on the cbWebView
     *
     * @param fields can be anyone of choose, retry, incorrectotp, enterotp.
     * @param params regen: true, pin: false, otp: true.
     */
    @JavascriptInterface
    public void convertToNative(final String fields, final String params) {
        // isPageStoppedForcefully check is added with is snoozeWindowVisible.
        // Because when user clicks on snooze(try later) button it calls webview.stopLoading();
        // Webview.stopLoading calls onPageFinished()
        // which calls converttonative.
        // and snooze count is reduced by one. which breaks the logic.


        if (isSnoozeWindowVisible) {
            dismissSnoozeWindow();

            killSnoozeService();
            cancelTransactionNotification();

           /* if (snoozeCount > 0 && !isPageStoppedForcefully) { // if custom browser dismisses the snooze window we dont consider that as snooze count.
                snoozeCount--;
            }*/
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_WINDOW_DISMISSED_BY_CB);
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_AUTOMATICALLY_DISAPPEAR_TIME, getSystemCurrentTime());

        }

        // CB should be visible, dismiss PayUChromeLoader
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                dismissPayULoader();
            }
        });

        if (pageType != null && !pageType.equalsIgnoreCase("")) {
            addEventAnalytics(CBAnalyticsConstant.DEPARTURE, getSystemCurrentTime());
            pageType = "";
        }

        if (activity != null && showCB) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (loadingLayout != null)
                        customProgressBar.removeProgressDialog(loadingLayout.findViewById(R.id.progress));
                    if (enterOTPView != null)
                        customProgressBar.removeProgressDialog(enterOTPView.findViewById(R.id.progress));

                    try {
                        if (waitingOTPTimer != null && enterOtpRunnable != null) {
                            cbUtil.cancelTimer(waitingOTPTimer);
                        }

                        if (fields.equals(getString(R.string.cb_error))) {  // Error
                            // fail the payment
                            // hide the view
                            onBankError();
                        } else if (fields.equals("parse error")) {
                            // hide the view
                            onBankError();
                        } else if (fields.contentEquals(CBConstant.LOADING) && !pin_selected_flag && checkLoading) { // Bank page is still loading
                            onHelpAvailable();

                            if (cbTransparentView != null)
                                cbTransparentView.setVisibility(View.VISIBLE);
//
                            if (loadingLayout == null)
                                loadingLayout = activity.getLayoutInflater().inflate(R.layout.loading, null);
                            ImageView im = (ImageView) loadingLayout.findViewById(R.id.bank_logo);

                            if (drawable != null)
                                im.setImageDrawable(drawable);

                            // Adjust the size of the cbWebView,
                            // updateLoaderHeight();
                            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, chooseActionHeight);
                            View layoutView = loadingLayout.findViewById(R.id.loading);
                            layoutView.setLayoutParams(params);
                            layoutView.requestLayout();
                            layoutView.invalidate();
                            customProgressBar.showDialog(loadingLayout.findViewById(R.id.progress));

                            cbBaseView.removeAllViews();
                            cbBaseView.addView(loadingLayout);
                            if (cbBaseView.isShown()) {
                                frameState = MAXIMISED;
                            } else {
                                maximiseWebviewHeight();
                            }
                            updateHeight(loadingLayout);
                        } else if (fields.equals(getString(R.string.cb_choose))) { // choose flow.

                            addCustomBrowserEventAnalytics();
                            frameState = MAXIMISED;
                            checkLoading = true;

                            if (cbTransparentView != null)
                                cbTransparentView.setVisibility(View.VISIBLE);

                            // show the options
                            View view = activity.getLayoutInflater().inflate(R.layout.choose_action, null);
                            if (maxWebview == 0) {
                                calculateMaximumWebViewHeight();
                                maximiseWebviewHeight();
                            }
                            cbBaseView.setVisibility(View.VISIBLE);
                            if (cbSlideBarView != null) {
                                cbSlideBarView.setVisibility(View.GONE);
                            }
                            calculateCBHeight(view);
                            onHelpAvailable();
                            view.measure(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                            chooseActionHeight = view.getMeasuredHeight();

                            ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                            if (drawable != null)
                                im.setImageDrawable(drawable);

                            cbBaseView.removeAllViews();
                            cbBaseView.addView(view);
                            if (cbBaseView.isShown())
                                frameState = MAXIMISED;


                            final SpannableStringBuilder str = new SpannableStringBuilder("Select an option for Faster payment");
                            str.setSpan(new android.text.style.StyleSpan(android.graphics.Typeface.BOLD), 21, 27, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
                            TextView tv = (TextView) view.findViewById(R.id.choose_text);
                            tv.setText(str);
                            final JSONObject jsonObject;

                            try {
                                jsonObject = new JSONObject(params);

                                if((jsonObject.has(getString(R.string.cb_otp)) && jsonObject.getBoolean(getString(R.string.cb_otp)))||(jsonObject.has(getString(R.string.cb_pin)) && jsonObject.getBoolean(getString(R.string.cb_pin)))){
                                    pageType = CBAnalyticsConstant.CHOOSE_SCREEN;
                                }else{
                                    pageType="";
                                }
                                if (jsonObject.has(getString(R.string.cb_otp)) && !jsonObject.getBoolean(getString(R.string.cb_otp))) { // otp flow is not visible
                                    view.findViewById(R.id.otp).setVisibility(View.GONE);
                                    view.findViewById(R.id.view).setVisibility(View.GONE);
                                } else {
                                    view.findViewById(R.id.otp).setOnClickListener(buttonClickListener);
                                    if (autoSelectOtp) {
                                        eventRecorded = CBAnalyticsConstant.CB_AUTO_OTP_SELECT;
                                        addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                                        view.findViewById(R.id.otp).performClick();
                                        autoSelectOtp = false;
                                    }
                                }
                                view.findViewById(R.id.otp).setOnClickListener(buttonClickListener);
                                if (jsonObject.has(getString(R.string.cb_pin)) && !jsonObject.getBoolean(getString(R.string.cb_pin))) { // pin flow is not visible
                                    view.findViewById(R.id.pin).setVisibility(View.GONE);
                                    view.findViewById(R.id.view).setVisibility(View.GONE);
                                } else {
                                    view.findViewById(R.id.pin).setOnClickListener(new View.OnClickListener() { // we have pin flow.

                                        @Override
                                        public void onClick(View view) {
                                            //   backwardJourneyTransactionStarted = true;
                                            //c_hdfc = 1;
                                            pin_selected_flag = true;
                                            approve_flag = true;
                                            maximiseWebviewHeight();
                                            frameState = MINIMISED;
                                            if (cbTransparentView != null)
                                                cbTransparentView.setVisibility(View.GONE);
                                            try {
                                                if (jsonObject.has(getString(R.string.cb_register)) && jsonObject.getBoolean(getString(R.string.cb_register))) { // Register user flow.
                                                    view = activity.getLayoutInflater().inflate(R.layout.register_pin, null);
                                                    cbBaseView.removeAllViews();
                                                    cbBaseView.addView(view);

                                                    if (cbBaseView.isShown())
                                                        frameState = MAXIMISED;

                                                    view.findViewById(R.id.pin).setOnClickListener(new View.OnClickListener() {
                                                        @Override
                                                        public void onClick(View view) {
                                                            try {
                                                                eventRecorded = CBAnalyticsConstant.PASSWORD;
                                                                addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                                                                cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_pin)));
                                                            } catch (JSONException e) {
                                                                e.printStackTrace();
                                                            }
                                                        }
                                                    });
                                                    if (jsonObject.has(getString(R.string.cb_otp)) && !jsonObject.getBoolean(getString(R.string.cb_otp))) {
                                                        view.findViewById(R.id.otp).setVisibility(View.GONE);
                                                    }
                                                    view.findViewById(R.id.otp).setOnClickListener(buttonClickListener);
                                                } else {
                                                    eventRecorded = CBAnalyticsConstant.PASSWORD;
                                                    addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                                                    onHelpUnavailable();

                                                    cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_pin)));
                                                }
                                            } catch (JSONException e) {
                                                e.printStackTrace();
                                            }
                                            updateHeight(view);
                                        }
                                    });
                                }
                                if (jsonObject.has(getString(R.string.cb_error))) { // oops sorry some error occured
                                    view.findViewById(R.id.error_message).setVisibility(View.VISIBLE);
                                    ((TextView) view.findViewById(R.id.error_message)).setText(jsonObject.getString("error"));
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        } else if (fields.equals(getString(R.string.cb_incorrect_OTP_2))) { // incorrect otp.
                            pageType = CBAnalyticsConstant.OTP_PAGE;
                            addCustomBrowserEventAnalytics();
                            checkLoading = true;
                            onHelpAvailable(); // gotta show cb
                            final View view = activity.getLayoutInflater().inflate(R.layout.retry_otp, null);
                            ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                            if (drawable != null)
                                im.setImageDrawable(drawable);

                            cbBaseView.removeAllViews();
                            cbBaseView.addView(view);

                            if (cbBaseView.isShown()) {
                                frameState = MAXIMISED;
                            } else {
                                if (cbSlideBarView != null)
                                    cbSlideBarView.setVisibility(View.VISIBLE);
                                maximiseWebviewHeight();
                            }

                            if (mPassword == null) {
                                view.findViewById(R.id.regenerate_layout).setVisibility(View.VISIBLE);
                                view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.GONE);
                                try {
                                    JSONObject p = new JSONObject(params);
                                    final boolean pin = p.has(getString(R.string.cb_pin)) && p.getBoolean(getString(R.string.cb_pin));

                                    view.findViewById(R.id.enter_manually).setOnClickListener(buttonClickListener);
                                    if (pin)
                                        view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                                    else
                                        view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);

                                    view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            updateHeight(view);
                        } else if (fields.equals(getString(R.string.cb_retry_otp))) { // Retry flow.
                            pageType = CBAnalyticsConstant.OTP_PAGE;
                            addCustomBrowserEventAnalytics();
                            checkLoading = true;
                            onHelpAvailable(); // show cb
                            hideSoftKeyboard(); // if the keyboard still on the screen, just force it to hide
                            if (cbTransparentView != null)
                                cbTransparentView.setVisibility(View.VISIBLE);

                            final View view;
                            view = activity.getLayoutInflater().inflate(R.layout.retry_otp, null);
                            ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                            if (drawable != null)
                                im.setImageDrawable(drawable);

                            cbBaseView.removeAllViews();
                            cbBaseView.addView(view);

                            if (cbBaseView.isShown()) {
                                frameState = MAXIMISED;
                            } else {
                                if (cbSlideBarView != null)
                                    cbSlideBarView.setVisibility(View.VISIBLE);
                                maximiseWebviewHeight();
                            }

                            try {
                                if (mPassword == null) {
                                    JSONObject p = new JSONObject(params);
                                    final boolean regenerate = p.has(getString(R.string.cb_regenerate)) && p.getBoolean(getString(R.string.cb_regenerate));
                                    final boolean pin = p.has(getString(R.string.cb_pin)) && p.getBoolean(getString(R.string.cb_pin));

                                    view.findViewById(R.id.regenerate_layout).setVisibility(View.VISIBLE);
                                    if (regenerate) {
                                        view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.VISIBLE);
                                        if (pin) {
                                            view.findViewById(R.id.Enter_manually_gone).setVisibility(View.GONE);
                                            view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                                        } else {
                                            view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                                            view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);
                                        }
                                    } else {
                                        if (pin)
                                            view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                                        else
                                            view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);

                                        view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.GONE);
                                        view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                                    }

                                }
                                view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);
                                view.findViewById(R.id.enter_manually).setOnClickListener(buttonClickListener);
                                view.findViewById(R.id.retry).setOnClickListener(buttonClickListener);
                                buttonClickListener.setView(view);
                                view.findViewById(R.id.approve).setOnClickListener(buttonClickListener);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            updateHeight(view);
                        } else if (fields.equals(getString(R.string.cb_enter_pin))) { // user has just selected pin flow.
                            //   backwardJourneyTransactionStarted = true;
                            pageType = CBAnalyticsConstant.PIN_PAGE;
                            addCustomBrowserEventAnalytics();

                            if (cbSlideBarView != null)
                                cbSlideBarView.setVisibility(View.GONE);

                            onHelpUnavailable();
                            pin_selected_flag = true;
                            approve_flag = true;
                            maximiseWebviewHeight();
                            frameState = MINIMISED;
                            if (cbTransparentView != null)
                                cbTransparentView.setVisibility(View.GONE);

                            maximiseWebviewHeight();
                            cbBaseView.removeAllViews();
                        } else if (fields.equals(getString(R.string.cb_enter_otp))) { // user is waiting for otp
                            pageType = CBAnalyticsConstant.OTP_PAGE;
                            SMSOTPClicked = false;
                            // launchSnoozeWindow();
                            checkPermission();
                            enterOtpParams = params;
                            if (!checkPermissionVisibility) {
                                addCustomBrowserEventAnalytics();
                                /*if (bankName.equalsIgnoreCase("hdfc") && c_hdfc == 0)
                                    c_hdfc = 1;
                                else if (bankName.equalsIgnoreCase("hdfc") && c_hdfc > 0)
                                enter_otp(params);
                                else*/
                                //   convertToNative("enterPIN","");
                                enter_otp(params);


                                /*if (!eventArray.contains(CBAnalyticsConstant.CUSTOM_BROWSER)) {
                                    eventRecorded = CBAnalyticsConstant.CUSTOM_BROWSER;
                                    eventArray.add(CBAnalyticsConstant.CUSTOM_BROWSER);
                                    addEventAnalytics(eventRecorded);
                                }*/
                            }

                        } else if (fields.equals(getString(R.string.cb_incorrect_pin))) { // oops wrong pin attempt.
                            pageType = CBAnalyticsConstant.CHOOSE_SCREEN;
                            addCustomBrowserEventAnalytics();

                            final JSONObject jsonObject;
                            try {
                                jsonObject = new JSONObject(params);
                                if (jsonObject.has(getString(R.string.cb_otp)) && jsonObject.getBoolean(getString(R.string.cb_otp))) {
                                    checkLoading = true;
                                    onHelpAvailable();
                                    final View view = activity.getLayoutInflater().inflate(R.layout.choose_action, null);

                                    ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                                    if (drawable != null)
                                        im.setImageDrawable(drawable);

                                    TextView errorText = (TextView) view.findViewById(R.id.error_message);
                                    errorText.setVisibility(View.VISIBLE);
                                    errorText.setText(activity.getResources().getString(R.string.cb_incorrect_password));

                                    TextView chooseText = (TextView) view.findViewById(R.id.choose_text);
                                    chooseText.setVisibility(View.VISIBLE);
                                    chooseText.setText(activity.getResources().getString(R.string.cb_retry));


                                    cbBaseView.removeAllViews();
                                    cbBaseView.addView(view);

                                    view.findViewById(R.id.otp).setOnClickListener(buttonClickListener);
                                    view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);

                                    updateHeight(view);
                                    if (cbBaseView.isShown()) {
                                        frameState = MAXIMISED;
                                    } else {
                                        maximiseWebviewHeight();
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else if (fields.equals(getString(R.string.cb_register_option))) { // Register new user.
                            pageType = CBAnalyticsConstant.REGISTER_PAGE;
                            addCustomBrowserEventAnalytics();
                            onHelpAvailable();
                            final View view = activity.getLayoutInflater().inflate(R.layout.register, null);
                            cbBaseView.removeAllViews();
                            cbBaseView.addView(view);
                            ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                            if (drawable != null)
                                im.setImageDrawable(drawable);

                            updateHeight(view);
                            if (cbBaseView.isShown()) {
                                frameState = MAXIMISED;
                            } else {
                                maximiseWebviewHeight();
                            }
                        } else {
                            maximiseWebviewHeight();
                            frameState = MINIMISED;
                            if (cbSlideBarView != null)
                                cbSlideBarView.setVisibility(View.GONE);

                            onHelpUnavailable();

                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (pageType != null && !pageType.equalsIgnoreCase("")) {
                        addEventAnalytics(CBAnalyticsConstant.ARRIVAL, getSystemCurrentTime());
                    }
                }

            });
        }

    }

    /**
     * add event 'custom-browser' to the array for Custom Browser payment flow
     */
    void addCustomBrowserEventAnalytics() {
        if (!eventArray.contains(CBAnalyticsConstant.CUSTOM_BROWSER)) {
            eventRecorded = CBAnalyticsConstant.CUSTOM_BROWSER;
            eventArray.add(CBAnalyticsConstant.CUSTOM_BROWSER);
            addEventAnalytics(CBAnalyticsConstant.CB_STATUS, eventRecorded);
        }
    }

    public void onPageFinished() {
        if (this.isAdded() && !this.isRemoving() && null != activity) {
            mPageReady = true;

            if (approve_flag) {
                onHelpUnavailable();
                approve_flag = false;
            }

            if (loadingLayout != null && loadingLayout.isShown()) {
                frameState = MINIMISED;
                maximiseWebviewHeight();
                onHelpUnavailable();
            }

            activity.getWindow().setSoftInputMode(WindowManager.
                    LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);

            if (mJS != null && showCB && !isPageStoppedForcefully) { // we have cb and we have the bankspecific js, lets show cb.
                try {
                    cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_init)));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (mBankJS != null && mJS == null) {
                if (cbTransparentView != null)
                    cbTransparentView.setVisibility(View.GONE); // Hide the translayout our page is loaded successfully.
            }
        }

    }

    public void onPageStarted() {
        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            if (nbhelpVisible) {
                onHelpUnavailable();
                nbhelpVisible = false;
            }
            if (this.isAdded() && !this.isRemoving()) {
                mPageReady = false;
                if (mBankJS != null) { // we have successfully downloaded initialize.js
                    try {
                        if (showCB) {
                            cbWebView.loadUrl("javascript:" + mBankJS.getString(getString(R.string.cb_detect_bank)));
                            showMagicRetryCB();
                        }

                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                if (cbTransparentView != null)
                    cbTransparentView.setVisibility(View.GONE); // Hide the translayout our page is loaded successfully.
            }
        }
    }

    /**
     * @param result json data of post param.
     *               call back function from furl - failure transaction.
     *               keep the value in {@link #merchantResponse}
     *               set result ok, and send the received data.
     * @param result json string
     */

    @JavascriptInterface
    public void onFailure(String result) {
        merchantResponse = result;
    }

    /**
     * Attempt to deprecate furl.
     * Javascript call from payu server.
     * Lets keep the data in local variable and pass it to calling activity.
     *
     * @param result json string result of failure transaction
     */
    @JavascriptInterface
    public void onPayuFailure(String result) {
        // This happens just before furlpost: Transaction should have been done: we can kill the service now.
        if (null != snoozeService) {
            snoozeService.killSnoozeService();
        }

        if (activity != null) {
            eventRecorded = CBAnalyticsConstant.FAILURE_TRANSACTION;
            addEventAnalytics(CBAnalyticsConstant.TRNX_STATUS, eventRecorded);
            isSuccessTransaction = false;
            payuReponse = result;
        }

        cancelTransactionNotification();
        callTimer();
    }

    /**
     * Call back from surl - sucess transaction
     * with no argument.
     * just send empty string back to calling activity
     */
    @JavascriptInterface
    public void onSuccess() {
        onSuccess("");
    }

    /**
     * Attempt to deprecate surl.
     * Javascript interface call from payu server.
     * Lets keep the data in local variable and pass it to main activity.
     *
     * @param result json data of post param.
     */

    @JavascriptInterface
    public void onPayuSuccess(final String result) {

        // This happens just before surlpost: Transaction should have been done: we can kill the service now.
        if (null != snoozeService) {
            snoozeService.killSnoozeService();
        }

        isSuccessTransaction = true;

        // lets do the analytics.
        eventRecorded = CBAnalyticsConstant.SUCCESS_TRANSACTION;
        addEventAnalytics(CBAnalyticsConstant.TRNX_STATUS, eventRecorded);

        payuReponse = result;

        if (storeOneClickHash == CBAnalyticsConstant.STORE_ONE_CLICK_HASH_MOBILE) { // store it only if i need to store it
            try {
                JSONObject hashObject = new JSONObject(payuReponse);
                // store the cvv in shared preferences.
                cbUtil.storeInSharedPreferences(activity.getApplicationContext(), hashObject.getString(CBAnalyticsConstant.CARD_TOKEN), hashObject.getString(CBAnalyticsConstant.MERCHANT_HASH));
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        cancelTransactionNotification();
        callTimer();
    }

    /**
     * call back function from surl - success transaction.
     * keep the data in {@link #merchantResponse}
     * set result ok, and send the received data.
     *
     * @param result success result received from surl
     */
    @JavascriptInterface
    public void onSuccess(String result) {
        merchantResponse = result;
    }

    /**
     * will be called in case of curl
     * mostly handled by furl
     */
    @JavascriptInterface
    public void onCancel() {
        onCancel("");
    }

    /**
     * will be called in case of curl
     * mostly handled by furl
     */
    @JavascriptInterface
    public void onCancel(final String result) {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (activity != null && !activity.isFinishing() && Bank.this.isAdded()) {
                    Intent intent = new Intent();
                    intent.putExtra(getString(R.string.cb_result), result);
                    activity.setResult(Activity.RESULT_CANCELED, intent);
                    activity.finish();
                }
            }
        });
    }

    /**
     * Method for enter otp.
     * User is waiting to receive otp.
     *
     * @param params - Json object
     */

    void enter_otp(final String params) {
        {
            //  cbBaseView.setVisibility(View.VISIBLE);
            //   convertToNative("loading","{}");

//            launchSnoozeWindow();
            // Make sure sms listener is prepared.
            prepareSmsListener();
            // log event, cb appeared.
            if (eventRecorded.equals(CBAnalyticsConstant.PAYMENT_INITIATED)) {
                eventRecorded = CBAnalyticsConstant.CUSTOM_BROWSER;
                eventArray.add(CBAnalyticsConstant.CUSTOM_BROWSER);
                addEventAnalytics(CBAnalyticsConstant.CB_STATUS, eventRecorded);
            }

            if (enterOTPView != null)
                customProgressBar.removeProgressDialog(enterOTPView.findViewById(R.id.progress));

            //   approveButton.setAlpha(1);
            /*if (chooseActionHeight == 0)
                frameState = MAXIMISED;*/

            checkLoading = true;
            onHelpAvailable(); // show cb

            if (cbTransparentView != null)
                cbTransparentView.setVisibility(View.VISIBLE);

            if (enterOTPView == null) {
                enterOTPView = activity.getLayoutInflater().inflate(R.layout.wait_for_otp, null);
            }
            final Button approveButton = (Button) enterOTPView.findViewById(R.id.approve);
            final View regenerateLayoutGone = enterOTPView.findViewById(R.id.Regenerate_layout_gone);
            final View enterManuallyGone = enterOTPView.findViewById(R.id.Enter_manually_gone);
            final View pinLayoutGone = enterOTPView.findViewById(R.id.pin_layout_gone);
            final View regenerateLayout = enterOTPView.findViewById(R.id.regenerate_layout);
            ImageView im = (ImageView) enterOTPView.findViewById(R.id.bank_logo);
            final TextView timerView = (TextView) enterOTPView.findViewById(R.id.timer);
            final EditText otpSms = (EditText) enterOTPView.findViewById(R.id.otp_sms);
            final View waiting = enterOTPView.findViewById(R.id.waiting);
            final View pinButton = enterOTPView.findViewById(R.id.pin);
            final View retryButton = enterOTPView.findViewById(R.id.retry);
            final View enterManuallyButton = enterOTPView.findViewById(R.id.enter_manually);
            final View retryText = enterOTPView.findViewById(R.id.retry_text);
            View mProgress = enterOTPView.findViewById(R.id.progress);
            View otpReceived = enterOTPView.findViewById(R.id.otp_recieved);
            approveButton.setVisibility(View.VISIBLE);
            CBUtil.setAlpha(0.3f, approveButton);
            regenerateLayoutGone.setVisibility(View.GONE);
            enterManuallyGone.setVisibility(View.VISIBLE);
            pinLayoutGone.setVisibility(View.GONE);
            regenerateLayout.setVisibility(View.GONE);
            timerView.setVisibility(View.VISIBLE);
            otpSms.setVisibility(View.GONE);
            waiting.setVisibility(View.VISIBLE);
            pinButton.setVisibility(View.VISIBLE);
            retryButton.setVisibility(View.VISIBLE);
            enterManuallyButton.setVisibility(View.VISIBLE);
            retryText.setVisibility(View.GONE);
            mProgress.setVisibility(View.VISIBLE);
            otpReceived.setVisibility(View.GONE);
            if (drawable != null)
                im.setImageDrawable(drawable);
            otpSms.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                    String otp = otpSms.getText().toString();
                    if (otp.length() > 5) {
                        buttonClickListener.setView(enterOTPView);

                        approveButton.setOnClickListener(buttonClickListener);
                        approveButton.setClickable(true);
                        CBUtil.setAlpha(1, approveButton);

                    } else {
                        approveButton.setClickable(false);
                        CBUtil.setAlpha(1, approveButton);
                        approveButton.setOnClickListener(null);
                    }
                }

                @Override
                public void afterTextChanged(Editable editable) {

                }
            });

            customProgressBar.showDialog(mProgress);
            cbBaseView.removeAllViews();
            cbBaseView.addView(enterOTPView);

            if (cbBaseView.isShown()) {
                frameState = MAXIMISED;
            } else {
                maximiseWebviewHeight();
            }

            if (frameState == MINIMISED) {
                if (cbSlideBarView != null)
                    cbSlideBarView.setVisibility(View.VISIBLE);
            }

            try {
                JSONObject p = new JSONObject(params);
                final boolean regenerate = p.has(getString(R.string.cb_regenerate)) && p.getBoolean(getString(R.string.cb_regenerate));
                final boolean skipScreen = p.has(getString(R.string.cb_skip_screen)) && p.getBoolean(getString(R.string.cb_skip_screen));
                final boolean pin = p.has(getString(R.string.cb_pin)) && p.getBoolean(getString(R.string.cb_pin));

                if (skipScreen) {

                    if (activity != null && otpSms != null && otpSms.getVisibility() != View.VISIBLE) {

                        retryText.setVisibility(View.VISIBLE);
                        if (regenerate) {
                            regenerateLayoutGone.setVisibility(View.VISIBLE);
                            pinLayoutGone.setVisibility(View.GONE);
                            enterManuallyGone.setVisibility(View.VISIBLE);
                        } else {
                            if (pin)
                                pinLayoutGone.setVisibility(View.VISIBLE);
                            else
                                pinLayoutGone.setVisibility(View.GONE);

                            regenerateLayoutGone.setVisibility(View.GONE);
                            enterManuallyGone.setVisibility(View.VISIBLE);
                        }

                        regenerateLayout.setVisibility(View.VISIBLE);
                        approveButton.setVisibility(View.GONE);
                        waiting.setVisibility(View.GONE);
                        pinButton.setOnClickListener(buttonClickListener);
                        retryButton.setOnClickListener(buttonClickListener);
                        enterManuallyButton.setOnClickListener(buttonClickListener);
                        updateHeight(enterOTPView);

                    }
                } else {
                    waitingOTPTimer = new Timer();
                    waitingOTPTimer.scheduleAtFixedRate(new TimerTask() {  // Timer to gain user's attention while waiting for otp.

                        @Override
                        synchronized public void run() {
                            if (activity != null) {
                                activity.runOnUiThread(enterOtpRunnable);  // updating time.
                            }
                        }
                    }, 0, 1000);
                }

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {

                    if (!permissionGranted) {
                        // if we dont have permission to read
                        // sms or merchant has set MERCHANT_SMS_PERMISSION flag false
                        // then we follow the IOS flow...
                        // final EditText otpSMS = (EditText) enterOTPView.findViewById(R.id.otp_sms);
                        approveButton.setClickable(false);
                        LinearLayout otpLayout = (LinearLayout) enterOTPView.findViewById(R.id.linear_layout_waiting_for_otp);
                        showSoftKeyboard(otpSms);
                        otpSms.setVisibility(View.VISIBLE);
                        approveButton.setVisibility(View.VISIBLE);
                        waiting.setVisibility(View.GONE);
                        mProgress.setVisibility(View.GONE);
                        regenerateLayout.setVisibility(View.VISIBLE);
                        enterManuallyGone.setVisibility(View.GONE);

                        otpSms.addTextChangedListener(new TextWatcher() {

                            @Override
                            public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {

                            }

                            @Override
                            public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                                String otp = otpSms.getText().toString();
                                if (otp.length() > 5) {
                                    buttonClickListener.setView(enterOTPView);
                                    approveButton.setOnClickListener(buttonClickListener);
                                    approveButton.setClickable(true);
                                    CBUtil.setAlpha(1, approveButton);


                                } else {
                                    float val = (float) .3;
                                    approveButton.setClickable(false);
                                    CBUtil.setAlpha(val, approveButton);
                                    approveButton.setOnClickListener(null);
                                }
                            }

                            @Override
                            public void afterTextChanged(Editable editable) {

                            }
                        });
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            final int time_wait_for_sms;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && !permissionGranted) {// while permission is denied we follow IOS flow and we will wait for 45 secs before showing regenerate layout
                time_wait_for_sms = 45;
            } else {
                time_wait_for_sms = 30;
            }

            enterOtpRunnable = new Runnable() {
                // update every seconds.Build.VERSION.SDK_INT >= Build.VERSION_CODES.M

                int i = time_wait_for_sms;

                @Override
                public void run() {

                    if (i == 0) {
                        try {
                            if (activity != null && enterOTPView.isShown() && activity.findViewById(R.id.otp_sms) != null /*&& ((TextView) activity.findViewById(R.id.otp_sms)).getVisibility() != View.VISIBLE*/) {
                                timerView.setVisibility(View.GONE);
                                JSONObject p = new JSONObject(params);
                                final boolean regenerate = p.has(getString(R.string.cb_regenerate)) && p.getBoolean(getString(R.string.cb_regenerate));
                                final boolean pin = p.has(getString(R.string.cb_pin)) && p.getBoolean(getString(R.string.cb_pin));

                                if (regenerate) {
                                    regenerateLayoutGone.setVisibility(View.VISIBLE);
                                    pinLayoutGone.setVisibility(View.GONE);
                                    enterManuallyGone.setVisibility(View.VISIBLE);
                                } else {
                                    if (pin)
                                        pinLayoutGone.setVisibility(View.VISIBLE);
                                    else
                                        pinLayoutGone.setVisibility(View.GONE);

                                    regenerateLayoutGone.setVisibility(View.GONE);
                                    enterManuallyGone.setVisibility(View.VISIBLE);
                                }

                                retryText.setVisibility(View.VISIBLE);
                                regenerateLayout.setVisibility(View.VISIBLE);
                                approveButton.setVisibility(View.GONE);
                                waiting.setVisibility(View.GONE);
                                otpSms.setVisibility(View.GONE);
                                pinButton.setOnClickListener(buttonClickListener);
                                retryButton.setOnClickListener(buttonClickListener);
                                enterManuallyButton.setOnClickListener(buttonClickListener);
                                updateHeight(enterOTPView);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (!otpSms.hasFocus() && otpSms.getText().toString().matches("")) {

                        if (i == time_wait_for_sms) {
                            timerView.setVisibility(View.VISIBLE);
                        }
                        String tMessage;

                        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && !permissionGranted) {
                            if (i != 1) {
                                tMessage = i + "  secs remaining to regenerate OTP\n";
                            } else {
                                tMessage = i + " sec remaining to regenerate OTP\n";
                            }
                        } else {
                            tMessage = i + "";
                        }
                        timerView.setText(tMessage);
                        i--;
                    }
                }
            };

            if (mPassword != null && otpSms != null && !(otpSms.getVisibility() == View.VISIBLE)) {
                cbUtil.cancelTimer(waitingOTPTimer);
                activity.findViewById(R.id.timer).setVisibility(View.GONE);
                if (eventRecorded.equals(CBAnalyticsConstant.PAYMENT_INITIATED) || eventRecorded.equals(CBAnalyticsConstant.CUSTOM_BROWSER)) {
                    eventRecorded = CBAnalyticsConstant.RECEIVED_OTP_DIRECT;
                    addEventAnalytics(CBAnalyticsConstant.OTP_RECIEVED, eventRecorded);
                }

                otpSms.setText(mPassword);
                approveButton.setText(getString(R.string.cb_approve_otp));
                approveButton.setClickable(true);
                if (autoApprove) {
                    approveButton.performClick();
                    eventRecorded = CBAnalyticsConstant.CB_AUTO_APPROVE;
                    addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                }

                //approve.setAlpha(1);
                CBUtil.setAlpha(1, approveButton);

                otpReceived.setVisibility(View.VISIBLE);

                customProgressBar.removeDialog(mProgress);
                retryText.setVisibility(View.GONE);
                regenerateLayout.setVisibility(View.GONE);

                approveButton.setVisibility(View.VISIBLE);

                waiting.setVisibility(View.GONE);
                otpSms.setVisibility(View.VISIBLE);
                buttonClickListener.setView(enterOTPView);
                approveButton.setOnClickListener(buttonClickListener);

            }
            updateHeight(enterOTPView);
            if (cbBaseView.isShown()) {
                frameState = MAXIMISED;
            } else {
                maximiseWebviewHeight();
            }
        }
    }

    /**
     * Mapping the string with integers to make sure it works on java 1.6 and below.
     *
     * @param str name
     * @return numnber
     */

    int getCode(String str) {
        if (str.equalsIgnoreCase("pin"))
            return PIN;
        else if (str.equalsIgnoreCase("password"))
            return PASSWORD;
        else if (str.equalsIgnoreCase("enter manually"))
            return ENTER_MANUALLY;
        else if (str.equalsIgnoreCase("approve"))
            return APPROVE;
        else if (str.equalsIgnoreCase("otp") || str.equalsIgnoreCase("use sms otp"))
            return OTP;
        else if (str.equalsIgnoreCase("sms otp"))
            return SMS_OTP;
        else if (str.equalsIgnoreCase("regenerate otp"))
            return REGENERATE_OTP;

        return DEFAULT;
    }

    /**
     * On page start of every url we keep monitor LOADING_THRESHOLD is loaded with in snoozeUrlLoadingTimeout
     * if the page is able to load LOADING_THRESHOLD in snoozeUrlLoadingTimeout then it is running on good internet speed,
     * else we consider it is running on slow connection and we launch snooze dialog.
     */
    private void startSnoozeCountDownTimer() {
        mCountDownTimer = new CountDownTimer(snoozeUrlLoadingTimeout, 500) {
            @Override
            public void onTick(long l) {
                isSnoozeTimerRunning = true;
            }

            @Override
            public void onFinish() {
                isSnoozeTimerRunning = false;
                if (cbWebView.getProgress() < snoozeUrlLoadingPercentage) {

                    if (!isSnoozeWindowVisible && showSnoozeWindow && !isTransactionStatusReceived) { // we already have an snooze window! lets use the window which is available on screen.

                        //dismissSnoozeWindow(); // We dont need this
                        launchSnoozeWindow();
                    }
                }
                stopSnoozeCountDownTimer();
            }
        };
        mCountDownTimer.start();
    }

    /**
     * Method to kill existing snooze counter which
     * determines if snooze window has to be displayed or
     * not on this page
     */
    private void stopSnoozeCountDownTimer() {
        if (null != mCountDownTimer) {
            isSnoozeTimerRunning = false;
            mCountDownTimer.cancel();
            mCountDownTimer = null;
        }
    }

    /**
     * Launch snooze window in based on merchant's input.
     */
    public void launchSnoozeWindow() {
        launchSnoozeWindow(WARN_MODE);
    }

    /**
     * This function will be called once the web chorme client identifies the page is not loaded to THRESHOLD VALUE in the given TIME INTERVAL
     * progress webview loading progress in percentage.
     *
     * @param mode WARN_MODE, FAIL_MODE [MR replacement]
     */

    public void launchSnoozeWindow(int mode) {

        // dismiss cb blank overlay
        showCbBlankOverlay(View.GONE);

        boolean showSnoozeWindow;

        // check for snooze count for backward and forward journey
        // return if snooze count are already consumed
        if (backwardJourneyStarted) {
            if (!(snoozeCountBackwardJourney < customBrowserConfig.getEnableSurePay())) {
                return;
            }
        } else if (!(snoozeCount < customBrowserConfig.getEnableSurePay())) {
            return;
        }

        // Setting Snooze Mode
        this.snoozeMode = mode;
        if (activity != null && !activity.isFinishing()) {
            // Dismiss slow user warning dialog, if any
            dismissSlowUserWarning();
            // Remove PayUChromeLoader
            progressBarVisibilityPayuChrome(View.GONE, "");
            // Flag, to know state of snooze window -- VISIBLE / NOT VISIBLE
            isSnoozeWindowVisible = true;
            // Event analytics
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_STATUS, CBAnalyticsConstant.SNOOZE_VISIBLE);
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_APPEAR_URL, webviewUrl);

            String modeStr = ((mode == CBConstant.WARN_MODE) ? STR_SNOOZE_MODE_WARN : STR_SNOOZE_MODE_FAIL);
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_LAUNCH_MODE, modeStr);
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_APPEAR_TIME, getSystemCurrentTime());

            // No matter what option user clicks we count as one more.
            // lets launch snooze window.
            LayoutInflater layoutInflater = activity.getLayoutInflater();
            if (null == snoozeLayout) {
                snoozeLayout = layoutInflater.inflate(R.layout.cb_layout_snooze, null);
            }
            final TextView snoozeMessageTextView = (TextView) snoozeLayout.findViewById(R.id.text_view_snooze_message);
            final TextView transactionSnoozedMessageTextView1 = (TextView) snoozeLayout.findViewById(R.id.text_view_transaction_snoozed_message1);
            final TextView dismissSnoozeWindow = (TextView) snoozeLayout.findViewById(R.id.button_cancel_transaction);
            final Button snoozeTransactionButton = (Button) snoozeLayout.findViewById(R.id.button_snooze_transaction);
            final Button retryTransactionButton = (Button) snoozeLayout.findViewById(R.id.button_retry_transaction);
            final TextView cancelTxnSnooze = (TextView) snoozeLayout.findViewById(R.id.text_view_cancel_snooze_window);
            final TextView tConfirm = (TextView) snoozeLayout.findViewById(R.id.t_confirm);
            final TextView tNConfirm = (TextView) snoozeLayout.findViewById(R.id.t_nconfirm);
            final TextView snoozeDialogHeaderText = (TextView) snoozeLayout.findViewById(R.id.snooze_header_txt);
            final TextView snoozeRetryDetailText = (TextView) snoozeLayout.findViewById(R.id.text_view_retry_message_detail);
            final Button retryAnywayButton = (Button) snoozeLayout.findViewById(R.id.button_retry_anyway);
            snoozeLoaderView = (SnoozeLoaderView) snoozeLayout.findViewById(R.id.snooze_loader_view);

            snoozeLoaderView.setVisibility(View.GONE);
            cancelTxnSnooze.setVisibility(View.VISIBLE);
            dismissSnoozeWindow.setVisibility(View.VISIBLE);
            snoozeTransactionButton.setVisibility(View.VISIBLE);
            retryTransactionButton.setVisibility(View.VISIBLE);
            snoozeMessageTextView.setVisibility(View.VISIBLE);
            transactionSnoozedMessageTextView1.setVisibility(View.GONE);
            snoozeRetryDetailText.setVisibility(View.VISIBLE);
            tConfirm.setVisibility(View.GONE);
            tNConfirm.setVisibility(View.GONE);
            retryAnywayButton.setVisibility(View.GONE);


            snoozeMessageTextView.setText(activity.getString(R.string.cb_slownetwork_status));
            snoozeDialogHeaderText.setText(activity.getString(R.string.cb_try_later));
            snoozeRetryDetailText.setText(activity.getString(R.string.cb_retry_restart));


            // show backward journey dialog only if backward journey started and payu PG is used
            if (backwardJourneyStarted && payuPG) {
                //addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_STATUS, CBAnalyticsConstant.SNOOZE_WITH_CONFIRM_DEDUCTION_VISIBLE);
                snoozeMessageTextView.setText(activity.getResources().getString(R.string.cb_slow_internet_confirmation));
                transactionSnoozedMessageTextView1.setText(activity.getResources().getString(R.string.cb_receive_sms));
                snoozeDialogHeaderText.setText(activity.getResources().getString(R.string.cb_confirm_transaction));
                snoozeTransactionButton.setVisibility(View.GONE);
                snoozeRetryDetailText.setVisibility(View.GONE);
                retryTransactionButton.setVisibility(View.GONE);
                dismissSnoozeWindow.setVisibility(View.GONE);
                snoozeMessageTextView.setVisibility(View.VISIBLE);
                transactionSnoozedMessageTextView1.setVisibility(View.VISIBLE);
                tConfirm.setVisibility(View.VISIBLE);
                tNConfirm.setVisibility(View.VISIBLE);
                retryAnywayButton.setVisibility(View.GONE);

                snoozeVisibleCountBackwdJourney++;
//                addEventAnalytics(CBAnalyticsConstant.SNOOZE_BACKWARD_WINDOW_APPEAR_TIME, );
                addEventAnalytics(CBAnalyticsConstant.SNOOZE_BACKWARD_VISIBLE, "Y");

            } else {
                snoozeVisibleCountFwdJourney++;
            }

            // if user confirm amount deducted
            tConfirm.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_BACKWARD_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_CONFIRM_DEDUCTION_Y);

                    if (waitingOTPTimer != null) {
                        waitingOTPTimer.cancel();
                        waitingOTPTimer.purge();
                    }
                    snoozeCountBackwardJourney++;

//                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_BACKWARD_USER_INTERACTION_TIME, getSystemCurrentTime());

                    snoozeDialog.setCanceledOnTouchOutside(false);
                    snoozeDialogHeaderText.setText(activity.getResources().getString(R.string.cb_confirm_transaction));
                    snoozeMessageTextView.setText(activity.getString(R.string.cb_transaction_status));
                    snoozeLoaderView.setVisibility(View.VISIBLE);
                    snoozeLoaderView.startAnimation();
                    snoozeTransactionButton.setVisibility(View.GONE);
                    transactionSnoozedMessageTextView1.setVisibility(View.GONE);
                    tConfirm.setVisibility(View.GONE);
                    tNConfirm.setVisibility(View.GONE);
                    if(verificationMsgReceived) {
                        startSnoozeServiceVerifyPayment(activity.getResources().getString(R.string.cb_verify_message_received));
                    }else{
                        startSnoozeServiceVerifyPayment(activity.getResources().getString(R.string.cb_user_input_confirm_transaction));
                    }
                }
            });

            // if user confirm amount not deducted
            tNConfirm.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    snoozeCountBackwardJourney++;

//                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_BACKWARD_USER_INTERACTION_TIME, getSystemCurrentTime());
                    dismissSnoozeWindow();
                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_BACKWARD_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_CONFIRM_DEDUCTION_N);

                }
            });
            cancelTxnSnooze.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (backwardJourneyStarted) {
                        snoozeCountBackwardJourney++;
                    } else {
                        snoozeCount++;
                    }

                    // Dismiss snooze window.
                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_INTERACTION_TIME, getSystemCurrentTime());
                    if (backwardJourneyStarted) {
                        // This doest not require.
//                        addEventAnalytics(CBAnalyticsConstant.SNOOZE_BACKWARD_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_CANCEL_WINDOW_CLICK);
                    } else {
                        addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_CANCEL_WINDOW_CLICK);
                    }
                    dismissSnoozeWindow();
                }
            });

            retryTransactionButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    //Close CB if transaction is restart
                    hideCB();

                    retryPayment(view);

                    /*snoozeCount++;
                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_INTERACTION_TIME, getSystemCurrentTime());
                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_RETRY_CLICK);
                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, cbWebView.getUrl());
                   // addEventAnalytics(CBAnalyticsConstant.SNOOZE_RETRY_NOW_URL, cbWebView.getUrl());
                    isTransactionStatusReceived = false;
                    // check -  loading url is from magic retry list
                    // CBConstant.PAYMENT_URL does not allow to call webview.reload();
                    if (CBUtil.isNetworkAvailable(activity.getApplicationContext())) {
                        if (cbWebView.getUrl() != null && !cbWebView.getUrl().contentEquals(CBConstant.PAYMENT_URL) && Bank.isUrlWhiteListed(cbWebView.getUrl())) {
                            *//*cbWebView.reload();*//*
                            reloadWVUsingJS();
                        } else {
                            if(customBrowserConfig.getPostURL().contentEquals(CBConstant.PAYMENT_URL)){
                                // mark the previous txn as sure pay canceled.
                                markPreviousTxnAsUserCanceled(CBUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.SURE_PAY_CANCELLED, customBrowserConfig.getTransactionID(), "", Bank.keyAnalytics, customBrowserConfig.getTransactionID(), ""));
                            }

                            reloadWebView(customBrowserConfig.getPostURL(), customBrowserConfig.getPayuPostData());
                            //cbWebView.postUrl(CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getPostURL(), CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getPayuPostData().getBytes());
                        }

                        dismissSnoozeWindow();

                        // Setting slow user warning waitingOTPTimer to null, so that it can be resumed
                        slowUserCountDownTimer = null;

                    } else {

                        addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, CBConstant.MSG_NO_INTERNET);
                        Toast.makeText(activity.getApplicationContext(), CBConstant.MSG_NO_INTERNET, Toast.LENGTH_SHORT).show();
                    }*/
                }
            });


            snoozeTransactionButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {


                    snoozeCount++;
                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_INTERACTION_TIME, getSystemCurrentTime());
                    maximiseWebviewHeight();
                    frameState = MINIMISED;
                    if (cbSlideBarView != null)
                        cbSlideBarView.setVisibility(View.GONE);

                    onHelpUnavailable();
                    // Store snooze Clicked Time
                    snoozeClickedTime = System.currentTimeMillis();

                    // Register broadcast
                    isSnoozeBroadCastReceiverRegistered = true;
                    //LocalBroadcastManager.getInstance(activity.getApplicationContext()).registerReceiver(snoozeBroadCastReceiver, new IntentFilter(SNOOZE_GET_WEBVIEW_STATUS_INTENT_ACTION));
                    // set pageForcefullyStopped to true
                    isPageStoppedForcefully = true;
                    // we need to stop the current loading page.
                    cbWebView.stopLoading();
                    if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
                        bindService();
                    }
                    // reset the password as transaction is snoozed
                    mPassword = null;
                    // unregister sms receiver as transaction is snoozed, so no sms receiver required
                    unregisterBroadcast(mBroadcastReceiver);


                    //snoozeHeaderTextView.setText("Transaction snoozed");
                    cancelTxnSnooze.setVisibility(View.GONE);
                    dismissSnoozeWindow.setVisibility(View.GONE);
                    snoozeTransactionButton.setVisibility(View.GONE);
                    retryTransactionButton.setVisibility(View.GONE);
                    snoozeMessageTextView.setText("We have paused your transaction because the network was unable to process it now. We will notify you when the network improves.");
                    //snoozeMessageTextView.setVisibility(View.GONE);
                    snoozeRetryDetailText.setVisibility(View.GONE);
                    snoozeDialogHeaderText.setText(activity.getResources().getString(R.string.cb_transaction_paused));
                    transactionSnoozedMessageTextView1.setVisibility(View.VISIBLE);
                    retryAnywayButton.setVisibility(View.VISIBLE);

                    // killing payu loader (there are situations payu loader may be visible.)
                    progressBarVisibilityPayuChrome(View.GONE, "");

                    // snooze Event Analytics
                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_CLICK);
                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_LOAD_URL, null == cbWebView.getUrl() ? webviewUrl : cbWebView.getUrl());

                    // Setting slow user warning waitingOTPTimer to null, so that it can be resumed
                    slowUserCountDownTimer = null;
                    // show blank overlay.
                    showCbBlankOverlay(View.VISIBLE);


                }
            });

            dismissSnoozeWindow.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (backwardJourneyStarted) {
                        snoozeCountBackwardJourney++;
                    } else {
                        snoozeCount++;
                    }
                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_INTERACTION_TIME, getSystemCurrentTime());
                    addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_CANCEL_TRANSACTION_CLICK);
                    showBackButtonDialog();
                }
            });

            retryAnywayButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    // hide Custom browser if transaction is restart
                    hideCB();
                    retryPayment(view);
                }
            });


            if (null == snoozeDialog) {
                snoozeDialog = new AlertDialog.Builder(activity).create();
                snoozeDialog.setView(snoozeLayout);
                snoozeDialog.setCanceledOnTouchOutside(false);
                snoozeDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialogInterface) {
                        showCbBlankOverlay(View.GONE);
                    }
                });
                snoozeDialog.setOnKeyListener(new DialogInterface.OnKeyListener() {

                    @Override
                    public boolean onKey(DialogInterface arg0, int keyCode,
                                         KeyEvent event) {
                        // TODO Auto-generated method stub
                        if (keyCode == KeyEvent.KEYCODE_BACK && event.getAction() == KeyEvent.ACTION_DOWN) {
                            showBackButtonDialog();
                            /*finish();
                            dialog.dismiss();*/
                        }
                        return true;
                    }
                });


            }

            snoozeDialog.show();

        }
    }

    /**
     * Start broadcast receiver for Handshake (to know if CB is alive or not)
     * Also, start snooze service to detect good network and launch notification
     * to resume transactions
     */
    public void bindService() {
        LocalBroadcastManager.getInstance(activity).unregisterReceiver(snoozeBroadCastReceiver); // TODO: remove unregister, and register broadcast receiver only if it is not registered yet.
        LocalBroadcastManager.getInstance(activity.getApplicationContext()).registerReceiver(snoozeBroadCastReceiver, new IntentFilter(SNOOZE_GET_WEBVIEW_STATUS_INTENT_ACTION));
        Intent intent = new Intent(activity, SnoozeService.class);
        // This intent will have all the post data.
        // should have the checkout page's class name.
        intent.putExtra(CB_CONFIG, customBrowserConfig);
        //intent.putExtra(POST_DATA, customBrowserConfig.getPayuPostData());
        intent.putExtra(CURRENT_URL, webviewUrl);


        //intent.putExtra(POST_URL, customBrowserConfig.getPostURL());
        intent.putExtra(MERCHANT_CHECKOUT_ACTIVITY, customBrowserConfig.getMerchantCheckoutActivityPath());

        // Binding the service.
        isSnoozeServiceBounded = true;
        activity.bindService(intent, snoozeServiceConnection, Context.BIND_AUTO_CREATE);

        // starting the service.
        activity.startService(intent);
    }

    /**
     * Start snooze service to verify payment
     */
    public void startSnoozeServiceVerifyPayment(String verifyParam) {
        LocalBroadcastManager.getInstance(activity).unregisterReceiver(snoozeBroadCastReceiver); // TODO remove unregister, and register it only if it is not registered yet.
        LocalBroadcastManager.getInstance(activity.getApplicationContext()).registerReceiver(snoozeBroadCastReceiver, new IntentFilter(SNOOZE_GET_WEBVIEW_STATUS_INTENT_ACTION));
        Intent intent = new Intent(activity, SnoozeService.class);
        // This intent will have all the post data.
        intent.putExtra(CB_CONFIG, customBrowserConfig);
        intent.putExtra(VERIFICATION_MSG_RECEIVED, true);
        intent.putExtra(MERCHANT_CHECKOUT_ACTIVITY, customBrowserConfig.getMerchantCheckoutActivityPath());
        intent.putExtra(VERIFY_ADDON_PARAMS, verifyParam);
        // Binding the service.
        isSnoozeServiceBounded = true;
        activity.bindService(intent, snoozeServiceConnection, Context.BIND_AUTO_CREATE);
        isSnoozeBroadCastReceiverRegistered = true;
        //  intent.putExtra(POST_DATA, customBrowserConfig.getPayuPostData());
        // intent.putExtra(POST_URL,customBrowserConfig.getPostURL());
        // starting the service.
        activity.startService(intent);
    }


    /**
     * Method to dismiss snooze window.
     */
    public void dismissSnoozeWindow() {
        isSnoozeWindowVisible = false;
        //snoozeWindowDismissTime = System.currentTimeMillis();

        if (null != snoozeDialog) {
            snoozeDialog.dismiss();
            snoozeDialog.cancel();

            // dismiss cb blank overlay
            showCbBlankOverlay(View.GONE);
        }
    }

    /**
     * set the whtelisted url of magic etry
     *
     * @param urlList white listed url for magic retry
     */
    public void setMagicRetry(Map<String, String> urlList) {
        if (magicRetryFragment != null) {
            magicRetryFragment.setUrlListWithPostData(urlList);
        }
    }

    /**
     * initialize magic retry
     */
    public void initMagicRetry() {
        FragmentManager fragmentManager = getActivity().getSupportFragmentManager();
        magicRetryFragment = new MagicRetryFragment();
        Bundle newInformationBundle = new Bundle();
        if (CustomBrowserData.SINGLETON != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {

            newInformationBundle.putString(MagicRetryFragment.KEY_TXNID, customBrowserConfig.getTransactionID());
        }
        magicRetryFragment.setArguments(newInformationBundle);
        fragmentManager.beginTransaction().add(R.id.magic_retry_container, magicRetryFragment, "magicRetry").commit();
        toggleFragmentVisibility(Util.HIDE_FRAGMENT);
        magicRetryFragment.isWhiteListingEnabled(true);
        magicRetryFragment.setWebView(cbWebView);
        magicRetryFragment.initMRSettingsFromSharedPreference(activity);

        if (customBrowserConfig.getEnableSurePay() > 0) {
            // snooze is enabled use SnoozeWebViewClient
            cbWebView.setWebViewClient(new PayUSurePayWebViewClient(this, Bank.keyAnalytics));
        } else {
            // snooze is disabled use PayUwebViewClient which has MagicRetry
            cbWebView.setWebViewClient(new PayUWebViewClient(this, magicRetryFragment, Bank.keyAnalytics));
        }
    }

    /**
     * Change the visibility of magic retry
     *
     * @param flag if true magic retry visible else gone
     */
    public void toggleFragmentVisibility(int flag) {
        if (getActivity() != null && !getActivity().isFinishing() && isAdded() && !isRemoving()) {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            if (magicRetryFragment != null && flag == Util.SHOW_FRAGMENT) {
                // Show fragment
                ft.show(magicRetryFragment).commitAllowingStateLoss();
            } else if (magicRetryFragment != null && flag == Util.HIDE_FRAGMENT) {
                // Hide fragment
                ft.hide(magicRetryFragment).commitAllowingStateLoss();
                // ft.hide(magicRetryFragment);}

            }
        }
    }

    /**
     * set MR visibility true
     */
    public void showMagicRetry() {

        dismissSnoozeWindow();
        toggleFragmentVisibility(Util.SHOW_FRAGMENT);
    }

    /**
     * set MR visibility false
     */
    public void hideMagicRetry() {
        toggleFragmentVisibility(Util.HIDE_FRAGMENT);
    }

    public void showBackButtonDialog() {

        android.app.AlertDialog.Builder backButtonClickAlertDialog = new android.app.AlertDialog.Builder(activity);
        backButtonClickAlertDialog.setCancelable(false);

        backButtonClickAlertDialog.setMessage("Do you really want to cancel the transaction ?");
        backButtonClickAlertDialog.setPositiveButton("Ok", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                if (snoozeDialog != null && snoozeDialog.isShowing()) {
                    snoozeDialog.cancel();
                }
                // kill snooze service if user cancel transactiob
                killSnoozeService();
                // remove notification for forward and backward journey if it is appearing
                cancelTransactionNotification();

                addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_OK_CLICK);
                dismissSnoozeWindow();
                CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentTerminate();

                //onBackApproved();
                CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackApprove();
                activity.finish();
            }
        });
        backButtonClickAlertDialog.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                addEventAnalytics(CBAnalyticsConstant.USER_INPUT, CBAnalyticsConstant.BACK_BUTTON_CANCEL_CLICK);
                //  onBackCancelled();
                dialog.dismiss();
                CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackDismiss();
            }
        });
        android.app.AlertDialog dialog = backButtonClickAlertDialog.create();
        WindowManager.LayoutParams wmlp = dialog.getWindow().getAttributes();
        wmlp.type = WindowManager.LayoutParams.TYPE_SYSTEM_ALERT;
        //wmlp.setType();
        // wmlp.flags = WindowManager.LayoutParams.TYPE_SYSTEM_DIALOG;
        backButtonClickAlertDialog.show();
    }

    /**
     * Helper to set flag isPageStoppedForcefully,
     * call this when user interacts with Snooze
     * action buttons
     *
     * @param isPageStoppedForcefully
     */
    public void setIsPageStoppedForcefully(boolean isPageStoppedForcefully) {
        this.isPageStoppedForcefully = isPageStoppedForcefully;
    }

    /**
     * List of whitelisted urls where retry works from
     * same hop
     *
     * @param urls
     */
    private void updateWhitelistedRetryUrls(List<String> urls) {

        whiteListedUrls.clear();
        L.v("#### PAYU", "MR Cleared whitelisted urls, length: " + whiteListedUrls.size());
        whiteListedUrls.addAll(urls);
        L.v("#### PAYU", "MR Updated whitelisted urls, length: " + whiteListedUrls.size());
    }

    /**
     * Javascript interface to get the snooze config from initialize.js
     * This method will be called from {@link PayUCBLifecycle#getInitializeJS}
     * <p/>
     * 1. Collect the object from javascript {@param snoozeConfig}
     * 2. Set the default snoozeLoadPercentage in sharedpref.
     * 3. Set the default snoozeLoadTime in sharedpref.
     * 4. Collect all the merchant specific urls and its loadPercentage, loadTime and put them in sharedpref.
     * 5. Get the default {@link PayUCBLifecycle#snoozeUrlLoadingTimeout} and {@link PayUCBLifecycle#snoozeUrlLoadingPercentage} from shared pref on {@link PayUCBLifecycle#onCreate(Bundle)}
     * 6. On every new page load   get the url from shard pref, initialize the waitingOTPTimer with new load percentage and load time,
     * <p/>
     * Shared pref storing format.
     * <p/>
     * key - url
     * value - percentage||timeout
     * <p/>
     * sample value of snoozeConfig {"default":[{"url":"default_payment_urls","time_out":"5","progress_percent":"20"}],"0MQaQP":[{"url":"url21||url22","time_out":"5","progress_percent":"50"},{"url":"url23","time_out":"5","progress_percent":"20"}]}
     * <p/>
     * TODO : probably need to used another shard pref. should not conflict with existing urls collections.
     * TODO : Js should not return * in case of all url instead it should return default_payment_urls. {@link CBConstant#DEFAULT_PAYMENT_URLS}
     *
     * @param snoozeConfig is the configuration for given bank code and the default values.
     */
    @JavascriptInterface
    public void setSnoozeConfig(String snoozeConfig) {
        snoozeConfigMap = cbUtil.storeSnoozeConfigInSharedPref(activity.getApplicationContext(), snoozeConfig);
    }

    /**
     * Use this method to disable PayUChromeLoader along with marking
     * forward journey complete
     * <p/>
     * IMPORTANT: To decide better on closing PayUChromeLoader, also see
     * {@link #progressBarVisibilityPayuChrome(int, String)}
     */
    @JavascriptInterface
    public void dismissPayULoader() {
        // payuChromeLoaderDisabled = true;
        if (activity != null && !activity.isFinishing() && progressDialog != null) {
            progressDialog.dismiss();
            progressDialog.cancel();

            // If dismissing payu loader after webpage not found there can be still more pages waiting to load
            // which might be recovered from retry option, so don't update forwardJourneyForChromeLoaderIsComplete
            // to true. Also, in case of webpageNoFound - don't start slow user warning
            if (!webpageNotFoundError) {
                // Ideally a dismiss call to PayUChromeLoader should mean that forward journey is complete
                // But it can also happen that PayUChromeLoader got dismissed due to loader waitingOTPTimer getting
                // finished even before redirect is complete, so this is more or less a calculated guess
                forwardJourneyForChromeLoaderIsComplete = true;
                L.v("stag", "Setting forwardJourneyForChromeLoaderIsComplete = " + forwardJourneyForChromeLoaderIsComplete);
                // Assuming final bank page has loaded, start waitingOTPTimer to understand user interaction
                // if no activity is found in next 2 minutes, show slow user warning
                startSlowUserWarningTimer();


            }
        }
    }

    /**
     * After bank page is loaded start waitingOTPTimer which displays
     * slow user warning in case no interaction is detected within
     * 2 minutes
     */
    protected void startSlowUserWarningTimer() {

        L.v("sTag", "Attempting to start slowUserCountDownTimer");

        if (slowUserCountDownTimer == null) {
            L.v("sTag", "Starting slowUserCountDownTimer");
            /* DISABLING
            slowUserCountDownTimer = new CountDownTimer(10000, 1000) {
                @Override
                public void onTick(long l) {
                    // Just wait!
                    L.v("sTag", "Tik Tok: next 10secs elapsed" + l);
                }

                @Override
                public void onFinish() {
                    L.v("sTag", "Times UP!");
                    showSlowUserWarning();
                    dismissSlowUserWarningTimer();
                }
            };
            slowUserCountDownTimer.start();*/
        }

    }

    /**
     * Method to dismiss the slow user warning waitingOTPTimer
     */
    protected void dismissSlowUserWarningTimer() {
        if (slowUserCountDownTimer != null) {
            L.v("sTag", "Shutting down slowUserCountDownTimer");
            slowUserCountDownTimer.cancel();
        }
    }

    /**
     * Custom onClick listener for cb's buttons.
     */
    public class ButtonOnclickListener implements View.OnClickListener {
        private View view_edit;

        public void setView(View view_ed) {
            this.view_edit = view_ed;
        }

        @Override
        public void onClick(View v) {
            String str = "";
            if (v instanceof Button) // we have buttons.
                str = (((Button) v).getText()).toString();
            else if (v instanceof TextView) // we have textviews too!.
                str = (((TextView) v).getText()).toString();
            int code = getCode(str.toLowerCase());
            switch (code) {
                case REGENERATE_OTP:
                    try {
                        eventRecorded = CBAnalyticsConstant.REGENERATE;
                        addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                        mPassword = null;
                        cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_regen_otp)));
                        prepareSmsListener();
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case SMS_OTP:
                case OTP:
                    //backwardJourneyTransactionStarted = true;
                    SMSOTPClicked = true;
                    checkPermission();
                    eventRecorded = CBAnalyticsConstant.OTP;
                    addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                    if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
                        mPassword = null;
                        prepareSmsListener();
                    }
                    break;
                case APPROVE:
                    try {
                        hideKeyboardForcefully();
                        mPassword = null;
                        checkLoading = false;
                        approve_flag = true;
                        onHelpUnavailable();
                        maximiseWebviewHeight();
                        frameState = MINIMISED;
                        prepareSmsListener();
                        if (((EditText) view_edit.findViewById(R.id.otp_sms)).getText().toString().length() > 5) {
                            eventRecorded = CBAnalyticsConstant.APPROVED_OTP;
                            addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                            addEventAnalytics(CBAnalyticsConstant.APPROVE_BTN_CLICK_TIME, getSystemCurrentTime());
                            cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_process_otp)) + "(\"" + ((TextView) activity.findViewById(R.id.otp_sms)).getText().toString() + "\")");
                            ((EditText) view_edit.findViewById(R.id.otp_sms)).setText("");
                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case ENTER_MANUALLY: {
                    final View view;
                    view = activity.getLayoutInflater().inflate(R.layout.wait_for_otp, null);
                    eventRecorded = CBAnalyticsConstant.ENTER_MANUALLY;

                    addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);

                    if (chooseActionHeight == 0) {
                        view.measure(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                        chooseActionHeight = view.getMeasuredHeight();
                    }

                    cbBaseView.removeAllViews();
                    cbBaseView.addView(view);

                    if (cbBaseView.isShown()) {
                        frameState = MAXIMISED;
                    } else {
                        maximiseWebviewHeight();
                    }

                    ImageView im = (ImageView) view.findViewById(R.id.bank_logo);


                    if (drawable != null)
                        im.setImageDrawable(drawable);

                    view.findViewById(R.id.waiting).setVisibility(View.GONE);
                    float val = (float) .3;
                    final Button approveButton = (Button) view.findViewById(R.id.approve);
                    approveButton.setClickable(false);

                    EditText otpSMS = (EditText) view.findViewById(R.id.otp_sms);
                    showSoftKeyboard(otpSMS);
                    CBUtil.setAlpha(val, approveButton);

                    approveButton.setVisibility(View.VISIBLE);
                    otpSMS.setVisibility(View.VISIBLE);
                    view.findViewById(R.id.regenerate_layout).setVisibility(View.GONE);
                    view.findViewById(R.id.progress).setVisibility(View.INVISIBLE);
                    showSoftKeyboard(otpSMS);

                    otpSMS.addTextChangedListener(new TextWatcher() {

                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                            String otp = ((EditText) view.findViewById(R.id.otp_sms)).getText().toString();
                            if (otp.length() > 5) {
                                buttonClickListener.setView(view);
                                approveButton.setOnClickListener(buttonClickListener);
                                approveButton.setClickable(true);
                                //  approveButton.setAlpha(1);
                                CBUtil.setAlpha(1, approveButton);


                            } else {
                                float val = (float) .3;
                                approveButton.setClickable(false);
                                // approveButton.setAlpha(val);
                                CBUtil.setAlpha(val, approveButton);
                                approveButton.setOnClickListener(null);
                            }
                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                        }
                    });
                    updateHeight(view);
                }
                break;

                case PASSWORD:
                case PIN:
                    //   backwardJourneyTransactionStarted = true;
                    pin_selected_flag = true;
                    approve_flag = true;
                    maximiseWebviewHeight();
                    frameState = MINIMISED;
                    onHelpUnavailable();

                    if (cbSlideBarView != null)
                        cbSlideBarView.setVisibility(View.GONE);

                    if (cbTransparentView != null)
                        cbTransparentView.setVisibility(View.GONE);

                    try {
                        cbWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_pin)));
                        eventRecorded = CBAnalyticsConstant.PASSWORD;
                        addEventAnalytics(CBAnalyticsConstant.USER_INPUT, eventRecorded);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case DEFAULT:
                    if (DEBUG)
                        Toast.makeText(activity, "button text not matching any click listener option", Toast.LENGTH_SHORT).show();
                    break;
            }
        }
    }

    /**
     * Helper method to reload webview using JS reload, from server
     */
    public void reloadWVUsingJS() {
        cbWebView.loadUrl("javascript:window.location.reload(true)");
    }

    /**
     * Helper method to reload webview using WebView's native reload
     */
    public void reloadWVNative() {
        cbWebView.reload();
    }

    /**
     * Helper method to reload webview using JS reload, from cache
     */
    public void reloadWVUsingJSFromCache() {
        cbWebView.loadUrl("javascript:window.location.reload()");
    }


    /**
     * Method to mark the previous txn as user canceled.
     * Should be called on every reposting at _payment url.
     * currently we call this on the following places.
     * 1. on Click of notification
     * 2. Retry on snooze window.
     * 3. Retry anyway on Snooze txn paused window.
     *
     * @param logMessage should be the log message in json format.
     *                   example: {"payu_id":"","txnid":"1467622816434","merchant_key":"0MQaQP","page_type":"","event_key":"sure_pay_cancelled","event_value":"1467622816434","bank":"","package_name":"com.payu.testapp"}
     */

    public void markPreviousTxnAsUserCanceled(String logMessage) {
        new SurePayCancelAsyncTaskHelper(logMessage).execute();
    }

    private void retryPayment(View view) {

        if (view.getId() == R.id.button_retry_transaction) {
            snoozeCount++;
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_INTERACTION_TIME, getSystemCurrentTime());
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_WINDOW_ACTION, CBAnalyticsConstant.SNOOZE_RETRY_CLICK);
//            addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, cbWebView.getUrl());
        } else if (view.getId() == R.id.button_retry_anyway) {
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_TXN_PAUSED_USER_INTERACTION_TIME, getSystemCurrentTime());
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_TXN_PAUSED_WINDOW_ACTION, CBAnalyticsConstant.RETRY_ANYWAY_CLICK);
//            addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, cbWebView.getUrl());
        }

        isTransactionStatusReceived = false;

        if (CBUtil.isNetworkAvailable(activity.getApplicationContext())) { // internet available.
                cbUtil.clearCookie();
            if (cbWebView.getUrl() != null && !(cbWebView.getUrl().contentEquals(CBConstant.PAYMENT_URL) || cbWebView.getUrl().contentEquals(CBConstant.PRODUCTION_PAYMENT_URL_SEAMLESS))&& Bank.isUrlWhiteListed(cbWebView.getUrl())) {
                reloadWebView();
            } else {
                if (customBrowserConfig.getPostURL().contentEquals(CBConstant.PAYMENT_URL) || customBrowserConfig.getPostURL().contentEquals(CBConstant.TEST_PAYMENT_URL)) {
                    // mark the previous txn as sure pay canceled.
                    markPreviousTxnAsUserCanceled(cbUtil.getLogMessage(activity.getApplicationContext(), CBAnalyticsConstant.SURE_PAY_CANCELLED, customBrowserConfig.getTransactionID(), "", Bank.keyAnalytics, customBrowserConfig.getTransactionID(), ""));
                }
                reloadWebView(customBrowserConfig.getPostURL(), customBrowserConfig.getPayuPostData());
            }

            dismissSnoozeWindow();

            // Setting slow user warning waitingOTPTimer to null, so that it can be resumed
            slowUserCountDownTimer = null;

            if (view.getId() == R.id.button_retry_anyway) { // if it is retry anyway kill service and remove notification.
                // Kill snooze service and remove if any notification launched.
                killSnoozeService();
                // if any notification from snooze service lets clear it.
                NotificationManager mNotificationManager = (NotificationManager) activity.getSystemService(Context.NOTIFICATION_SERVICE);
                mNotificationManager.cancel(CBConstant.SNOOZE_NOTIFICATION_ID);

            }

        } else { // no internet found.
            addEventAnalytics(CBAnalyticsConstant.SNOOZE_RESUME_URL, CBConstant.MSG_NO_INTERNET);
            Toast.makeText(activity.getApplicationContext(), CBConstant.MSG_NO_INTERNET, Toast.LENGTH_SHORT).show();
        }
    }
}