/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser.analytics;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import com.payu.custombrowser.util.CBUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CBAnalytics {
    private static final String TEST_URL = "https://mobiletest.payu.in/merchant/postservice.php?form=2";
    private static final String PRODUCTION_URL = "https://info.payu.in/merchant/postservice.php?form=2";
    private String fileName;
    private static final long TIMER_DELAY = 5000L;
    private static CBAnalytics INSTANCE;
    private final Context mcontext;
    private final String ANALYTICS_URL = "https://info.payu.in/merchant/postservice.php?form=2";
    private boolean mIsLocked = false;
    private ArrayList<String> mBuffer;
    private Timer mTimer;

    private CBAnalytics(Context context, String filename) {
        this.mcontext = context;
        this.fileName = filename;
        this.mBuffer = new ArrayList();
        final Thread.UncaughtExceptionHandler defaultUEH = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler _unCaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                while (CBAnalytics.this.mIsLocked) {
                }
                CBAnalytics.this.setLock();
                try {
                    FileOutputStream fileOutputStream = CBAnalytics.this.mcontext.openFileOutput(CBAnalytics.this.fileName, 0);
                    int c = CBAnalytics.this.mBuffer.size();
                    if (c > 0) {
                        JSONArray jsonArray = new JSONArray();
                        for (int i = 0; i < c; ++i) {
                            JSONObject jsonObject = new JSONObject((String)CBAnalytics.this.mBuffer.get(i));
                            jsonArray.put(jsonArray.length(), (Object)jsonObject);
                        }
                        fileOutputStream.write(jsonArray.toString().getBytes());
                        CBAnalytics.this.mBuffer = new ArrayList();
                    }
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                CBAnalytics.this.releaseLock();
                defaultUEH.uncaughtException(thread, ex);
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(_unCaughtExceptionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CBAnalytics getInstance(Context context, String fileName) {
        if (INSTANCE != null) return INSTANCE;
        Class<CBAnalytics> clazz = CBAnalytics.class;
        synchronized (CBAnalytics.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new CBAnalytics(context, fileName);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void log(final String msg) {
        this.resetTimer();
        if (this.mIsLocked) {
            try {
                this.mBuffer.add(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... voids) {
                    CBAnalytics.this.setLock();
                    try {
                        JSONObject newobject = new JSONObject(msg);
                        String temp = CBUtil.readFileInputStream(CBAnalytics.this.mcontext, CBAnalytics.this.fileName, 0);
                        JSONArray jsonArray = temp.equalsIgnoreCase("") ? new JSONArray() : new JSONArray(temp);
                        FileOutputStream fileOutputStream = CBAnalytics.this.mcontext.openFileOutput(CBAnalytics.this.fileName, 0);
                        jsonArray.put(jsonArray.length(), (Object)newobject);
                        fileOutputStream.write(jsonArray.toString().getBytes());
                        fileOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        CBAnalytics.this.mBuffer.add(msg);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        CBAnalytics.this.mBuffer.add(msg);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        CBAnalytics.this.mBuffer.add(msg);
                    }
                    CBAnalytics.this.releaseLock();
                    return null;
                }
            }.execute((Object[])new Void[]{null, null, null});
        }
    }

    private void resetTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread.currentThread().setName("resetTimer");
                while (CBAnalytics.this.mIsLocked) {
                }
                CBAnalytics.this.setLock();
                if (CBAnalytics.this.isOnline()) {
                    String temp = "";
                    try {
                        temp = CBUtil.readFileInputStream(CBAnalytics.this.mcontext, CBAnalytics.this.fileName, 0);
                    }
                    finally {
                        try {
                            if (!temp.equalsIgnoreCase("")) {
                                JSONObject jsonObject;
                                StringBuffer responseStringBuffer;
                                int responseCode;
                                String postData;
                                HttpURLConnection conn;
                                JSONArray tempJsonArray = new JSONArray(temp);
                                if (CBAnalytics.this.mBuffer.size() > 0) {
                                    for (int i = 0; i < CBAnalytics.this.mBuffer.size(); ++i) {
                                        JSONObject jsonObject2 = new JSONObject((String)CBAnalytics.this.mBuffer.get(i));
                                        tempJsonArray.put((Object)jsonObject2);
                                    }
                                }
                                if (tempJsonArray.length() > 0 && (conn = CBUtil.getHttpsConn(CBAnalytics.PRODUCTION_URL, postData = "command=sdkWsNew&var1=" + tempJsonArray.toString())) != null && (responseCode = conn.getResponseCode()) == 200 && conn.getInputStream() != null && (responseStringBuffer = CBUtil.getStringBufferFromInputStream(conn.getInputStream())) != null && (jsonObject = new JSONObject(responseStringBuffer.toString())).has("status")) {
                                    CBAnalytics.this.mcontext.deleteFile(CBAnalytics.this.fileName);
                                    CBAnalytics.this.mBuffer = new ArrayList();
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (CBAnalytics.this.mBuffer.size() > 0) {
                    CBAnalytics.this.resetTimer();
                }
                CBAnalytics.this.releaseLock();
            }
        }, 5000L);
    }

    private synchronized void setLock() {
        this.mIsLocked = true;
    }

    private synchronized void releaseLock() {
        this.mIsLocked = false;
    }

    private boolean isOnline() {
        ConnectivityManager cm = (ConnectivityManager)this.mcontext.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnectedOrConnecting();
    }
}

