/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import com.payu.custombrowser.Bank;
import com.payu.custombrowser.R;
import com.payu.custombrowser.analytics.CBAnalytics;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.util.CBUtil;
import com.payu.magicretry.MagicRetryFragment;

public class CBActivity
extends FragmentActivity
implements MagicRetryFragment.ActivityCallback {
    private Bank payUCustomBrowser;

    protected void onStart() {
        super.onStart();
    }

    protected void onResume() {
        super.onResume();
    }

    protected void onPause() {
        super.onPause();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.cb_payments);
        this.payUCustomBrowser = new Bank();
        this.getSupportFragmentManager().beginTransaction().add(R.id.main_frame, (Fragment)this.payUCustomBrowser).commit();
    }

    public void onBackPressed() {
        final CBAnalytics cbAnalytics = CBAnalytics.getInstance(this.getApplicationContext(), "");
        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig() != null && CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getDisableBackButtonDialog() != 1) {
            AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this);
            alertDialog.setCancelable(false);
            alertDialog.setMessage((CharSequence)"Do you really want to cancel the transaction ?");
            alertDialog.setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackApprove();
                    cbAnalytics.log(CBUtil.getLogMessage(CBActivity.this.getBaseContext(), "user_input", "back_button_ok".toLowerCase(), CBActivity.this.payUCustomBrowser.getBankName(), Bank.keyAnalytics, Bank.transactionID));
                    CBActivity.this.finish();
                }
            });
            alertDialog.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    cbAnalytics.log(CBUtil.getLogMessage(CBActivity.this.getBaseContext(), "user_input", "back_button_cancel".toLowerCase(), CBActivity.this.payUCustomBrowser.getBankName(), Bank.keyAnalytics, Bank.transactionID));
                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackDismiss();
                }
            });
            cbAnalytics.log(CBUtil.getLogMessage(this.getBaseContext(), "user_input", "payu_back_button".toLowerCase(), this.payUCustomBrowser.getBankName(), Bank.keyAnalytics, Bank.transactionID));
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onBackButton(alertDialog);
            alertDialog.show();
        } else {
            this.finish();
        }
    }

    public void showMagicRetry() {
        this.payUCustomBrowser.showMagicRetry();
    }

    public void hideMagicRetry() {
        this.payUCustomBrowser.hideMagicRetry();
    }

    public void onDestroy() {
        if (CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback() != null) {
            CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentTerminate();
        }
        super.onDestroy();
    }
}

