package com.payu.custombrowser;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.TranslateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.payu.custombrowser.analytics.CBAnalytics;
import com.payu.custombrowser.analytics.PayuDeviceAnalytics;
import com.payu.custombrowser.bean.CustomBrowserData;
import com.payu.custombrowser.util.CustomBrowserConstant;
import com.payu.custombrowser.util.CBAnalyticsConstant;
import com.payu.custombrowser.util.CBUtil;
import com.payu.magicretry.MagicRetryFragment;
import org.json.JSONObject;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;

public class CustomBrowserMain extends Fragment implements CustomBrowserConstant {

    // getActivity() for the fragment.
    Activity activity;

    //Receiver for sms reading
    BroadcastReceiver mBroadcastReceiver;

    //initilize js which is common for all banks
    JSONObject mBankJS;

    //Bank specific javascript file
    JSONObject mJS;

    // check got keyboard
     int checkForInput;

    //instance for switching between production and testing env. True - testing and false - production
    public static final boolean DEBUG = false;

  /*  // Mix panel Analytics Instance
    private MixpanelAPI mixpanel;*/

    //Event analytics Insatnce
    private CBAnalytics mAnalytics;

    // Event for analytics
    String eventRecorded;

    // Analytics event array for custom browser and non custom browser flow
    ArrayList<String> eventArray= new ArrayList<>();

    // MagicRetry Fragment Instance
    MagicRetryFragment magicRetryFragment;

    //Check for netbanking custom browser visibility
    boolean nbhelpVisible;

    // banklogo drawable insatnev
    Drawable drawable;

    //URL for javascript
    final String CB_URL = DEBUG ? TEST_URL : PRODUCTION_URL;

    WebView cbWebView;

    int loading_height, minWebview, maxWebview;

    ProgressDialog progressDialog;

    int checkProgress = 0;

    int lastProgress;

    ProgressBar cbWebPageProgressBar;

    int frameState;

    BroadcastReceiver mReceiver = null;

    String checkValue; //url set

    String webviewUrl; //url set

    Set<String> urlSet; //url set

    Set<String> postPaymentURL; //url set
    boolean merchantSMSPermission;
    String bankName;

    // response received from payu js interface
     String payuReponse;

    // response received from surl/furl js interface
     String merchantResponse;

    // status of the transaction should be set from payu's js interface functions.
     Boolean isSuccessTransaction;

    // true - one tap payment
    int storeOneClickHash;

    Bundle bundle;

    boolean cbOldFlow;

    // framelayout in which CB is added
    FrameLayout cbBaseView;

    // instance of arrow at the top of CB
    View cbSlideBarView;

    // instance of transparent layer on the bank page
    View cbTransparentView;


    // minie
    public Drawable cbGetDrawable(Context context, int resID) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            return context.getResources().getDrawable(resID, context.getTheme());
        } else {
            return context.getResources().getDrawable(resID);
        }
    }

    /**
     * Change the visibility of transview to visble with animation.
     *
     * @param view transview which is shown with animation
     * @param mContext context of the base activity
     */
     void showTransparentView(final View view, Context mContext) {
        if (view != null) {
            final Animation animation = AnimationUtils.loadAnimation(mContext, R.anim.cb_fade_in);
            view.startAnimation(animation);
            Handler handler = new Handler();
            handler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    view.setVisibility(View.VISIBLE);
                }
            }, 500);
        }
    }

    /**
     * Force display soft keyboard.
     *
     * @param editText focused edittext for which input method is opened
     */
     void showSoftKeyboard(View editText) {
        editText.setFocusableInTouchMode(true);
        editText.requestFocus();
        ((InputMethodManager) activity.getSystemService(Context.INPUT_METHOD_SERVICE)).showSoftInput(editText, InputMethodManager.SHOW_FORCED);
    }

    /**
     * Force hide soft keyboard
     */
     void hideSoftKeyboard() {
        activity.getWindow().setSoftInputMode(
                WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN
        );
    }

    /**
     * Initializing analytics and mixpanel.
     */
    protected void initAnalytics(String sdkMerchantKey) {

        // code update the event on mixpanel only when DEBUG is true
        /*if (DEBUG) // check for mixpanel
            mixpanel = MixpanelAPI.getInstance(getActivity(), projectToken);*/
        // SH: File name as constant?
        // minie
        mAnalytics = CBAnalytics.getInstance(activity, "local_cache_analytics");
        deviceAnalytics(sdkMerchantKey);
    }

    /**
     * Put the device Analytics data to bean and call PayUDeviceAnalytics which logs the device analytics.
     *
     * @param sdkMerchantKey  merchant key logged by PayU SDK
     */
    private void deviceAnalytics(String sdkMerchantKey){
        JSONObject deviceDetails= new JSONObject();
        try {
            deviceDetails.put(CBAnalyticsConstant.SDK_VERSION_NAME,  Bank.sdkVersion);
            deviceDetails.put(CBAnalyticsConstant.CB_VERSION_NAME, BuildConfig.VERSION_NAME+ "");
            deviceDetails.put(CBAnalyticsConstant.DEVICE_OS_VERSION, Build.VERSION.SDK_INT + "");
            deviceDetails.put(CBAnalyticsConstant.DEVICE_RESOLUTION, CBUtil.getDeviceDensity(activity));
            deviceDetails.put(CBAnalyticsConstant.DEVICE_MANUFACTURE,Build.MANUFACTURER);
            deviceDetails.put(CBAnalyticsConstant.DEVICE_MODEL,Build.MODEL);
            deviceDetails.put(CBAnalyticsConstant.MERCHANT_KEY,sdkMerchantKey);
            CBUtil.setVariableReflection(CustomBrowserConstant.MAGIC_RETRY_PAKAGE, sdkMerchantKey, CustomBrowserConstant.ANALYTICS_KEY);

            deviceDetails.put(CBAnalyticsConstant.TRANSACTION_ID, Bank.transactionID);
            deviceDetails.put(CBAnalyticsConstant.NETWORK_INFO, CBUtil.getNetworkStatus(activity));
            deviceDetails.put(CBAnalyticsConstant.NETWORK_STRENGTH, CBUtil.getNetworkStrength(activity));
            new PayuDeviceAnalytics(activity,"cb_local_cache_device").log(deviceDetails.toString());

        }catch(Exception e)
        {
            e.printStackTrace();
        }
    }





    /**
     * Logging events with txnid and package name.
     * Mixpannel used only in debug mode.
     *
     *
     * @param key  analytics event key
     * @param value analytics event value
      */
     void addEventAnalytics(String key, String value) {
        try {
            mAnalytics.log(CBUtil.getLogMessage(activity.getBaseContext(), key, value.toLowerCase(), bankName, Bank.keyAnalytics, Bank.transactionID));
            /*if (DEBUG) {
                JSONObject props = new JSONObject();
                props.put("Pakage Name", activity.getPackageName() + "");
                props.put("Transaction ID",Bank.transactionID);
                mixpanel.track(value, props);
            }*/
        } catch (Exception e) {
            if (DEBUG)
                Log.e("CUSTOM BROWSER", "Unable to add properties to JSONObject", e);
        }
    }

    /**
     * Finds the corresponding image name for the given bank
     *
     * @param bankNameImage bank image name
     */
     void cbSetBankDrawable(final String bankNameImage) {
        if (drawable == null) {
            if (bankNameImage != null) {
                try {

                    if (bankNameImage.equalsIgnoreCase("sbinet") || bankNameImage.equalsIgnoreCase("sbi"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.sbi);
                    else if (bankNameImage.equalsIgnoreCase("icici") || bankNameImage.equalsIgnoreCase("icicinet") || bankNameImage.equalsIgnoreCase("icicicc"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.icici);
                    else if (bankNameImage.equalsIgnoreCase("kotaknet") || bankNameImage.equalsIgnoreCase("kotak"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.kotak);
                    else if (bankNameImage.equalsIgnoreCase("indus"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.induslogo);
                    else if (bankNameImage.equalsIgnoreCase("hdfc") || bankNameImage.equalsIgnoreCase("hdfcnet"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.hdfc_bank);
                    else if (bankNameImage.equalsIgnoreCase("yesnet"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.yesbank_logo);
                    else if (bankNameImage.equalsIgnoreCase("sc"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.scblogo);
                    else if (bankNameImage.equalsIgnoreCase("axisnet") || bankNameImage.equalsIgnoreCase("axis"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.axis_logo);
                    else if (bankNameImage.equalsIgnoreCase("amex"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.cb_amex_logo);
                    else if (bankNameImage.equalsIgnoreCase("hdfcnet") || bankNameImage.equalsIgnoreCase("hdfc"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.hdfc_bank);
                    else if (bankNameImage.equalsIgnoreCase("ing"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.ing_logo);
                    else if (bankNameImage.equalsIgnoreCase("idbi"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.idbi);
                    else if (bankNameImage.equalsIgnoreCase("citi"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.citi);
                    else
                        drawable = null;

                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        }
    }

    /**
     * Hide soft keyboard.
     */
     void hideKeyboardForcefully() {
        View view = activity.getCurrentFocus();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager) activity.getSystemService(Context.INPUT_METHOD_SERVICE);
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }


    /**
     * Measure the height of cbWebView
     *
     * @param view - view to calculate height
     */
     void calculateCBHeight(View view) {
        view.measure(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        loading_height = view.getMeasuredHeight();
        minWebview = maxWebview - loading_height;
    }

    /**
     * Measure cbWebView heigt
     */
     void calculateMaximumWebViewHeight() {
         // SH: rename it
        try {
            if (maxWebview == 0) {
                cbWebView.measure(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
                cbWebView.requestLayout();
                maxWebview = cbWebView.getMeasuredHeight();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Adjust Webview size
     */
     void maximiseWebviewHeight() {
        if (maxWebview == 0)
         calculateMaximumWebViewHeight();
        cbWebView.getLayoutParams().height = maxWebview;
        cbWebView.requestLayout();
    }

    /**
     * Adjust cbWebView size
     */
     void minimizeWebviewHeight() {
        cbWebView.getLayoutParams().height = minWebview;
        cbWebView.requestLayout();
    }


    /**
     * Displaying Payuloader.
     *
     * @param context base activity context
     * @return progress dialog.
     */
    private ProgressDialog showProgress(Context context) {
        if (null != activity && this.isAdded() && context != null && !activity.isFinishing()) {
            LayoutInflater mInflater = LayoutInflater.from(context);
            final Drawable[] drawables =
                    { cbGetDrawable(activity, R.drawable.l_icon1),
                            cbGetDrawable(activity, R.drawable.l_icon2),
                            cbGetDrawable(activity, R.drawable.l_icon3),
                            cbGetDrawable(activity, R.drawable.l_icon4)
                    };

            View layout = mInflater.inflate(R.layout.cb_prog_dialog, null);
            final ImageView imageView = (ImageView) layout.findViewById(R.id.imageView);

            ProgressDialog progDialog = new ProgressDialog(context, R.style.cb_progress_dialog);

            final Timer timer = new Timer();
            timer.scheduleAtFixedRate(new TimerTask() {
                int i = -1;

                @Override
                synchronized public void run() {
                    if (activity != null) {
                        activity.runOnUiThread(new Runnable() {
                                                   @Override
                                                   public void run() {
                                                       if (activity != null) {
                                                           i++;
                                                           if (i >= drawables.length) {
                                                               i = 0;
                                                           }
                                                           imageView.setImageBitmap(null);
                                                           imageView.destroyDrawingCache();
                                                           imageView.refreshDrawableState();
                                                           imageView.setImageDrawable(drawables[i]);
                                                       }
                                                   }
                                               }
                        );
                    }

                }
            }, 0, 500);
            progDialog.show();
            progDialog.setContentView(layout);
            progDialog.setCancelable(true);
            progDialog.setCanceledOnTouchOutside(false);
            progDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                @Override
                public void onDismiss(DialogInterface dialog) {
                    CBUtil.cancelTimer(timer);
                    if (checkProgress == PRE_PAYMENT)
                        checkProgress = DURING_PAYMENT;
                }
            });
            return progDialog;
        }
        return null;
    }

    /**
     * Funtion to show or hide the progress bar.
     *
     * @param visibility input can be View.INVISIBLE View.GONE View.VISIBLE
     *
     */
     void progressBarVisibilityPayuChrome(int visibility) {
         if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded())  {
             if (visibility == View.GONE || visibility == View.INVISIBLE) {

                 if (progressDialog != null && progressDialog.isShowing()) {
                     progressDialog.dismiss();
                     checkForInput = 1;
                 }
             } else if (progressDialog == null) {
                 progressDialog = showProgress(activity);
             }
         }
    }

    /**
     * OOPS something went wrong, hide payu loader
     */
     void communicationError() {
        progressBarVisibilityPayuChrome(View.GONE);
    }

    /**
     * Start animation of progress bar
     * @param newProgress updated progress of weburl
     */

     void startAnimation(int newProgress) {
        if (activity != null && !activity.isFinishing() && !isRemoving() && isAdded()) {
            if(lastProgress>newProgress)
                cbWebPageProgressBar.setProgress(newProgress);
            if(Build.VERSION.SDK_INT>=11) {
                ObjectAnimator animation = ObjectAnimator.ofInt(cbWebPageProgressBar, "progress", newProgress);
                animation.setDuration(50); // 0.5 second
                animation.setInterpolator(new AccelerateInterpolator());
                animation.start();
            }else{
                cbWebPageProgressBar.setProgress(newProgress);
            }
            lastProgress=newProgress;
        }
    }




    /**
     * Maximize the cbWebView and changes the cb to minimize state
     */
     void update() {
        maximiseWebviewHeight();
        frameState = MINIMISED;
        onHelpUnavailable();
    }


    /**
     * Should be implemented by Calling activity
     * @param broadcastReceiver broadcast receiver to set up.
     * @param filter - filter for receiving broadcast
     */

      public void registerBroadcast(BroadcastReceiver broadcastReceiver, IntentFilter filter){
        mReceiver = broadcastReceiver;
        getActivity().registerReceiver(broadcastReceiver, filter);
    }

    /**
     * Unregister the broad cast receiver.
     * @param broadcastReceiver reference of broadcast receiver
     */
     public void unregisterBroadcast(BroadcastReceiver broadcastReceiver){
        if(mReceiver != null){
            activity.unregisterReceiver(broadcastReceiver);
            mReceiver = null;
        }
    }

    /**
     * Hide the custombowser fragement
     */
    public  void onHelpUnavailable(){
         if(activity!=null && !activity.isFinishing())
        activity.findViewById(R.id.parent).setVisibility(View.GONE);
    }

    /**
     * OOPS something went wrong hide cb or progerss dialog.
     */
    public void onBankError(){
        activity.findViewById(R.id.parent).setVisibility(View.GONE);
    }

    /**
     * Yey we support cb for this bank, lets show cb
     */
   public  void onHelpAvailable(){
        activity.findViewById(R.id.parent).setVisibility(View.VISIBLE);
    }

    public void updateSet(Set<String> urlSet, String check) {
        if (urlSet != null && urlSet.size() > 0 && webviewUrl != null && !urlSet.contains(webviewUrl)) {
            progressBarVisibilityPayuChrome(View.GONE);
            checkProgress = DURING_PAYMENT;
        }
        checkValue = check;
    }


    /**
     *
     * update the list of url where progress dialog to be shown
     */
     void setUrlString() {
        if (mBankJS != null) {
            try {
                if (mBankJS.has("pgUrlList")) {
                    String urlStr = mBankJS.getString("pgUrlList");
                    StringTokenizer st = new StringTokenizer(urlStr.replace(" ", ""), "||");
                    while (st.hasMoreTokens()) {
                        urlSet.add(st.nextToken());
                    }
                } else {
                    communicationError();
                }
                if (mBankJS.has("postPaymentPgUrlList")) {
                    String urlStr = mBankJS.getString("postPaymentPgUrlList");
                    StringTokenizer st = new StringTokenizer(urlStr.replace(" ", ""), "||");
                    while (st.hasMoreTokens()) {
                        postPaymentURL.add(st.nextToken());
                    }
                }
                updateSet(urlSet, PAYMENT_OPTION_URL);
            } catch (Exception e) {
                communicationError();
                e.printStackTrace();
            }
        }
    }

    /**
     * Just to make sure we finish activity even if the merchant's url got into trouble,
     * should be called from
     */
     void callTimer(){
        new CountDownTimer(5000, 1000) {

            public void onTick(long millisUntilFinished) {
                // tick tick tick tick....
            }

            public void onFinish() {
                if(activity != null){
                    activity.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            if (activity != null && !activity.isFinishing() && isAdded()) {
                                onMerchantUrlFinished();
                            }
                        }
                    });
                }
            }
        }.start();
    }


    /**
     * This function takes care of sending the data back to calling activity with the status, merchantResponse, payuresponse.
     */
    void onMerchantUrlFinished(){
        if (activity != null) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (activity != null && !activity.isFinishing() && isAdded()) {
                        if (cbOldFlow) {
                            Intent intent = new Intent();
                            intent.putExtra(getString(R.string.cb_result), merchantResponse);
                            intent.putExtra(getString(R.string.cb_payu_response), payuReponse);
                            if (isSuccessTransaction) {
                                if (storeOneClickHash == 1) {
                                    StoreMerchantHashTask mStoreMerchantHashTask = new StoreMerchantHashTask();
                                    mStoreMerchantHashTask.execute(payuReponse);

                                }
                                activity.setResult(Activity.RESULT_OK, intent);
                            }else{
                                activity.setResult(Activity.RESULT_CANCELED, intent);
                            }

                        }else {
                                if (isSuccessTransaction) {
                                    if (CustomBrowserData.SINGLETON.getPayuCustomBrowserConfig().getStoreOneClickHash() == 1) {
                                        StoreMerchantHashTask mStoreMerchantHashTask = new StoreMerchantHashTask();
                                        mStoreMerchantHashTask.execute(payuReponse);
                                    }
                                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentSuccess(payuReponse, merchantResponse);
                                }else{
                                    CustomBrowserData.SINGLETON.getPayuCustomBrowserCallback().onPaymentFailure(payuReponse, merchantResponse);

                                }

                            }
                        activity.finish();
                    }
                }
            });
        }
    }

    public class CBMainViewOnTouchListener implements View.OnTouchListener {

        float initialY;
        boolean isTouch = true;
        int height = 0;

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            if (!nbhelpVisible) {
                maximiseWebviewHeight();
                if (!isTouch)
                    return false;
                int action = event.getActionMasked();
                if (cbSlideBarView.getVisibility() == View.VISIBLE) {
                    cbSlideBarView.setClickable(false);
                    cbSlideBarView.setOnTouchListener(null);

                    TranslateAnimation animate = new TranslateAnimation(0, 0, height, 0);
                    animate.setDuration(500);
                    animate.setFillBefore(true);
                    v.startAnimation(animate);
                    cbBaseView.setVisibility(View.VISIBLE);
                    isTouch = false;
                    final Handler handler = new Handler();
                    handler.postDelayed(new Runnable() {

                        @Override
                        public void run() {
                            cbSlideBarView.setVisibility(View.GONE);
                        }
                    }, 20);
                    final Handler handlertrans = new Handler();
                    handlertrans.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            isTouch = true;
                            frameState = MAXIMISED;
                            if (cbTransparentView != null) {
                                if (activity != null && !activity.isFinishing())
                                    showTransparentView(cbTransparentView, activity);
                            }
                        }
                    }, 500);

                } else {

                    switch (action) {
                        case MotionEvent.ACTION_DOWN:
                            initialY = event.getY();
                            break;
                        case MotionEvent.ACTION_MOVE:
                            break;

                        case MotionEvent.ACTION_UP:
                            //  float finalX = event.getX();
                            float finalY = event.getY();


                            /*    if (initialX < finalX) {
                                }

                                if (initialX > finalX) {
                                }*/

                            if (initialY < finalY) {
                                if (cbBaseView.getVisibility() == View.VISIBLE && (finalY - initialY) > 0) {
                                    height = v.getHeight();
                                    TranslateAnimation animate = new TranslateAnimation(0, 0, 0, v.getHeight() - 30);
                                    animate.setDuration(500);
                                    animate.setFillBefore(false);
                                    animate.setFillEnabled(true);
                                    animate.setZAdjustment(TranslateAnimation.ZORDER_TOP);
                                    v.startAnimation(animate);
                                    if (cbTransparentView != null)
                                        cbTransparentView.setVisibility(View.GONE);
                                    isTouch = false;
                                    isTouch = true;
                                    final Handler handler = new Handler();
                                    handler.postDelayed(new Runnable() {
                                        @Override
                                        public void run() {
                                            frameState = MINIMISED;
                                            cbBaseView.setVisibility(View.GONE);
                                            cbSlideBarView.setVisibility(View.VISIBLE);
                                        }
                                    }, 400);
                                }
                            }
                              /*  if (initialY > finalY) {
                                }*/
                            break;

                        case MotionEvent.ACTION_CANCEL:
                            break;

                        case MotionEvent.ACTION_OUTSIDE:
                            break;
                    }
                }
                return true;
            }

            return false;
        }
    }

    public void loadUrlWebView(JSONObject mJS, String functName){

    }

    public void onBackPressed(AlertDialog.Builder alertDialog){
    }

    public void onBackApproved(){

    }

    public void onBackCancelled(){

    }
}
