package com.payu.custombrowser;

import android.app.Activity;
import android.content.Intent;
import android.support.annotation.NonNull;

import com.payu.custombrowser.bean.CustomBrowserConfig;
import com.payu.custombrowser.bean.CustomBrowserData;


public class CustomBrowser {

    /**
     * Call this method to add CustomBrowser to application
     * @param activity base class activity
     * @param cbCustomBrowserConfig contain the specification of CB
     * @param cbPayUCustomBrowserCallback provide callbacks
     */
    public void addCustomBrowser(Activity activity, @NonNull CustomBrowserConfig cbCustomBrowserConfig, @NonNull PayUCustomBrowserCallback cbPayUCustomBrowserCallback) {
        CustomBrowserData.SINGLETON.setPayuCustomBrowserCallback(cbPayUCustomBrowserCallback);
        CustomBrowserData.SINGLETON.setPayuCustomBrowserConfig(cbCustomBrowserConfig);
        Intent intent = new Intent(activity, CBActivity.class);
        activity.startActivity(intent);
    }
}
