package com.payu.custombrowser;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

/**
 * Created by Minie on 9/30/15.
 */
public class PayuDeviceAnalytics {
    private  long TIMER_DELAY = 0;
    private final Activity mActivity;
    private static final String TEST_URL_DEVICE_ANALYTICS = "https://mobiletest.payu.in/merchant/mobileWebService.php";
    private static final String PRODUCTION_URL_DEVICE_ANALYTICS = "https://info.payu.in/merchant/mobileWebService.php";
    private final String ANALYTICS_URL = Bank.DEBUG? TEST_URL_DEVICE_ANALYTICS : PRODUCTION_URL_DEVICE_ANALYTICS;
    private boolean mIsLocked = false;
    private ArrayList<String> mBuffer;
    private Timer mTimer;
    private String file_name = "cb_local_cache_device";

    /**
     * Constructor
     *
     * @param activity base activity
     */
    public PayuDeviceAnalytics(Activity activity, final String fileName) {
        mActivity = activity;
        this.file_name=fileName;
        mBuffer = new ArrayList<>();
        final Thread.UncaughtExceptionHandler defaultUEH = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler _unCaughtExceptionHandler = new Thread.UncaughtExceptionHandler() {
            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                while (mIsLocked) ;
                setLock();
                try {
                    FileOutputStream fileOutputStream = mActivity.openFileOutput(fileName, Context.MODE_PRIVATE);
                    int c = mBuffer.size();
                    for (int i = 0; i < c; i++) {
                        fileOutputStream.write((mBuffer.get(i) + "\r\n").getBytes());
                    }
                    fileOutputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
                releaseLock();
                defaultUEH.uncaughtException(thread, ex);
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(_unCaughtExceptionHandler);
    }

    /**
     * Adding log information to a local file.
     *
     * @param msg json string
     */
    public void log(final String msg) {

        if (mIsLocked) {
            mBuffer.add(msg);
        } else {
            /*new AsyncTask<Void, Void, Void>() {
                @Override
                protected Void doInBackground(Void... voids) {*/
            setLock();
            try {
                JSONObject newobject = new JSONObject(msg);
                JSONArray jsonArray;
                int c;
                String temp = "";
                File file = new File(mActivity.getFilesDir(), file_name);
                if (!file.exists()) { // create the file if not created yet.
                    mActivity.openFileOutput(file_name, Context.MODE_PRIVATE);
                }
                FileInputStream fileInputStream = mActivity.openFileInput(file_name);
                while ((c = fileInputStream.read()) != -1) {
                    temp = temp + Character.toString((char) c);
                }
                if(temp.equalsIgnoreCase(""))
                    jsonArray = new JSONArray();
                else
                jsonArray = new JSONArray(temp);
                fileInputStream.close();
                FileOutputStream fileOutputStream = mActivity.openFileOutput(file_name, Context.MODE_PRIVATE);
                jsonArray.put(jsonArray.length(), newobject);
                fileOutputStream.write((jsonArray.toString()).getBytes());
                fileOutputStream.close();
            } catch (IOException e) {
                e.printStackTrace();
                mBuffer.add(msg);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            releaseLock();
            // return null;
        }
        resetTimer();
            /*}.execute(null, null, null);*/
    }

    /**
     * Open file and read the content.
     * Send the contents to payu server
     * command should be sdkWs and var1 should be the actual data.
     */
    private void resetTimer() {
        if (mTimer != null) {
            mTimer.cancel();
        }
        mTimer = new Timer();
        mTimer.schedule(new TimerTask() {
            @Override
            public void run() {
                while (mIsLocked) ;
                TIMER_DELAY = 5000;
                setLock();
                String temp = "";
                int c;
                try {
                    File file = new File(mActivity.getFilesDir(), file_name);
                    if (!file.exists()) { // create the file if not created yet.
                        mActivity.openFileOutput(file_name, Context.MODE_PRIVATE);
                    }
                    FileInputStream fileInputStream = mActivity.openFileInput(file_name);
                    while ((c = fileInputStream.read()) != -1) {
                        temp = temp + Character.toString((char) c);

                    }
                    fileInputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                } finally {
                    c = mBuffer.size();
                    while (c > 0) {
                        c--;
                        temp = temp + mBuffer.get(c) + "\r\n";
                        if (c >= 0 && mBuffer.size() > c)
                            mBuffer.remove(c);
                    }
                    temp = temp.trim();
                    if (temp.length() > 0) {
                        // lets prepare data

                        //put data here
                        new UploadData(temp).execute(temp);

                    }else{
                        mTimer.cancel();
                    }
                }
                if (mBuffer.size() > 0) {
                    resetTimer();
                }
                releaseLock();
            }
        }, TIMER_DELAY);
    }

    private synchronized void setLock() {
        mIsLocked = true;
    }

    private synchronized void releaseLock() {
        mIsLocked = false;
    }


   private  static JSONArray removeJsonObjectAtJsonArrayIndex(JSONArray source, int index) throws JSONException {
        if (index < 0 || index > source.length() - 1) {
            throw new IndexOutOfBoundsException();
        }

        final JSONArray copy = new JSONArray();
        for (int i = 0, count = source.length(); i < count; i++) {
            if (i != index) copy.put(source.get(i));
        }
        return copy;
    }
    public class UploadData extends AsyncTask<String,Void,String>{
        /**
         * temporary string
         */
        private String temp;
        UploadData(String temp){
            this.temp=temp;
        }
        @Override
        protected void onPostExecute(String aVoid) {
            super.onPostExecute(aVoid);
        }

        @Override
        protected String doInBackground(String... strarr) {
            try{
                try {

                    JSONArray jsonArray=new JSONArray(strarr[0]);

                    JSONArray editorJsonArray=jsonArray;
                    for(int j=0;j<editorJsonArray.length();j++){
                        if(CBUtil.getbooleanSharedPreference(((JSONObject) editorJsonArray.get(j)).getString(CBConstant.ANALYTICS_KEY) + "|" + ((JSONObject) editorJsonArray.get(j)).getString(CBConstant.TRANSACTION_ID), mActivity)){
                            jsonArray=removeJsonObjectAtJsonArrayIndex(editorJsonArray,j);
                        }
                    }
                    if(jsonArray.length()>0) {

                        String postData = "mobile_data="+jsonArray.toString();
                        byte[] postParamsByte = postData.getBytes("UTF-8");
                        URL url = new URL(ANALYTICS_URL);
                        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                        conn.setRequestMethod("POST");
                        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        conn.setRequestProperty("Content-Length", String.valueOf(postData.length()));
                        conn.setDoOutput(true);
                        conn.getOutputStream().write(postParamsByte);
                        int responseCode = conn.getResponseCode();
                        InputStream responseInputStream = conn.getInputStream();
                        StringBuffer responseStringBuffer = new StringBuffer();
                        byte[] byteContainer = new byte[1024];
                        for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                            responseStringBuffer.append(new String(byteContainer, 0, i));
                        }

                        if (responseCode == HttpURLConnection.HTTP_OK) {

                            try {
                                JSONObject jsonObject=new JSONObject(responseStringBuffer.toString());
                                if (jsonObject.has("status") && !jsonObject.getString("status").equalsIgnoreCase("")) {
                                    if(jsonObject.has("status") && (jsonObject.getString("status").equalsIgnoreCase("1")||jsonObject.getString("status").equalsIgnoreCase("-1"))){
                                        mActivity.deleteFile(file_name);
                                        for (int j = 0; j < jsonArray.length(); j++) {
                                            CBUtil.setBooleanSharedPreference(((JSONObject) jsonArray.get(j)).getString(CBConstant.ANALYTICS_KEY) + "|" + ((JSONObject) jsonArray.get(j)).getString(CBConstant.TRANSACTION_ID), true, mActivity);
                                        }
                                    }else{
                                        try {
                                            FileOutputStream fileOutputStream = mActivity.openFileOutput(file_name, Context.MODE_PRIVATE);
                                            fileOutputStream.write(temp.getBytes());
                                            fileOutputStream.close();
                                        } catch (IOException e1) {
                                            e1.printStackTrace();
                                        }
                                    }
                                }else{
                                    try {
                                        FileOutputStream fileOutputStream = mActivity.openFileOutput(file_name, Context.MODE_PRIVATE);
                                        fileOutputStream.write(temp.getBytes());
                                        fileOutputStream.close();
                                    } catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                }

                            }catch(Exception e)
                            {
                                e.printStackTrace();
                                try {
                                    FileOutputStream fileOutputStream = mActivity.openFileOutput(file_name, Context.MODE_PRIVATE);
                                    fileOutputStream.write(temp.getBytes());
                                    fileOutputStream.close();
                                } catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        } else {

                            try {
                                FileOutputStream fileOutputStream = mActivity.openFileOutput(file_name, Context.MODE_PRIVATE);
                                fileOutputStream.write(temp.getBytes());
                                fileOutputStream.close();
                            } catch (IOException e1) {

                                e1.printStackTrace();
                            }
                        }
                    }else{

                       mActivity.deleteFile(file_name);
                    }

                } catch (MalformedURLException | ProtocolException e) {
                    e.printStackTrace();

                } catch (IOException e) {
                    e.printStackTrace();
                }
            }catch (Exception e){
                e.printStackTrace();
            }
            return null;
        }
    }
}