// The MIT License (MIT)
//
// Copyright (c) 2014-2015 PayU India
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package com.payu.custombrowser;

import android.Manifest;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.telephony.SmsMessage;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.TranslateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.payu.magicretry.MagicRetryFragment;
import org.json.JSONException;
import org.json.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

/**
 * Custom browser's Fragment.
 * Keeping it as abstract for providing call back function to implementing Activities.
 * Following functions needs to be overridden.
 * {@link Bank#registerBroadcast(BroadcastReceiver, IntentFilter)}}
 * {@link Bank#unregisterBroadcast(BroadcastReceiver)}
 * {@link Bank#onHelpAvailable()}
 * {@link Bank#onHelpUnavailable()}
 * {@link Bank#onBankError()}
 */
public abstract class Bank extends Fragment implements CBConstant{

    //switch between testing and production enviroment
    // true - testing env
    // false - production enviroment
    public static final boolean DEBUG = false;

    // analytics key
    private static String keyAnalytics;

    // initialize javasript
    private JSONObject mJS;

    // webview instance
    private WebView mWebView;

    // Javasript URL
    private final String CB_URL = DEBUG ? TEST_URL : PRODUCTION_URL;

    // Instance of receiver
    private BroadcastReceiver mBroadcastReceiver;

    // bank specific js
    private JSONObject mBankJS;

    // Check for showing loader
    private boolean mLoadingJS = false;

    // minimum height of webview
    private int minWebview;

    // maximum height of webview
    private int maxWebview;

    // state of Custom Browser - MAXIMUM or MINIMUM
    private int frameState;

    // true if PIN or OTP button of native is clicked else false
   // private boolean mCVClicked = false;

    // bank logo
    private String bank_logo;

    // true - Pin of CB is clicked
    private boolean pin_selected_flag;

    // height of choose layout
    private int chooseActionHeight;

    // true - approve button is clicked
    private Boolean approve_flag = false;

    // check of hdfc bank page
    private int c_hdfc = 0;

    // Url set for dismissing progress dialog
    private Set<String> urlSet;

    // post payment URL where payu loader to be shown
    private Set<String> postPaymentURL;

    // bank name
    private String bankName;

    // view of arrow at the top of CB
    private View viewarrow;

    // true - when page 100% loaded
    private boolean mPageReady = false;

    // password
    private String mPassword;

    // tranlayer instance
    private View transView;

    // transacrion id
    private String mTxnID;

    // instance of analytics
    private CBAnalytics mAnalytics;

    //
    private boolean checkLoading;

    //true - CB for net banking is visible
    private boolean nbhelpVisible;

    // check to save user ID for Net banking
    private boolean saveUserIDCheck;

    // Instance of button click listener
    private ButtonOnclickListener buttonClickListener;

    // Instance of loading layour
    private View loadingLayout;

    // Payu progress dialog
    private ProgressDialog progressDialog;

    // check for progress dialog
    private String checkValue;

    // Activity instance
    private Activity activity;

    // keeps the state of progress
    private int checkProgress;

    // url loading in webview
    private String webviewUrl;

    // check got keyboard
    private int checkForInput;

    // bank icon drawable
    private Drawable drawable;

    // otp timer runnable
    private Runnable enterOtpRunnable;

    //timer for waiting for otp
    private Timer timer;

    // analytics events
    private String eventRecorded;

    // event array
    private ArrayList<String> eventArray;

    // instance of mix panel for analytics
    private MixpanelAPI mixpanel;

    // Check for enbling and disabling the CB. true - enable CB false- disable CB
    private boolean showCB;

    // true when otp button from CB selected
    private boolean SMSOTPClicked;

    // false when onPageFinished  called second time
    private boolean firstFinish;

    // error popup window
    private PopupWindow optionspu;

    // instance of bundle
    private Bundle bundle;

    // help view
    private FrameLayout helpView;

    // check for visibility of
    private boolean visibilitychecked;

    //CB version
    public static String Version;
    static {
        Version = BuildConfig.VERSION_NAME;
    }

    // Android M handling permission check
    private boolean permissionGranted;

    // check for permission
    private boolean checkedPermission;

    // json string params for enter otp
    private String enterOtpParams;

    // checl for visiblity of permission dialog
    private boolean checkPermissionVisibility;

    // true - otp is auto approve
    private boolean autoApprove;

    // true - otp is auto selected
    private boolean autoSelectOtp;

    // true - one tap payment
    private int storeOneClickHash;

    // merchant hash for one tap
    private String merchantHash;

    // MR integration
    private boolean isMRDataSet;

    // response received from payu js interface
    private String payuReponse;

    // response received from surl/furl js interface
    private String merchantResponse;

    // status of the transaction should be set from payu's js interface functions.
    private Boolean isSuccessTransaction;

    //progress bar for webview loading url
    private ProgressBar progressBar;

    // webview last progress
    private int lastProgress;

    // util class instance
    private CBUtil cbUtil;

  public Bank(){
      urlSet = new HashSet<>();
      postPaymentURL = new HashSet<>();
      eventArray = new ArrayList<>();
      buttonClickListener = new ButtonOnclickListener();
      permissionGranted = true;
      saveUserIDCheck = true;
      showCB = true;
      firstFinish = true;
      cbUtil=new CBUtil();
  }

    /**
     * Finds the corresponding image name for the given bank and store the value at {@link Bank#drawable}
     *
     * @param bankNameImage name of bank
     *//*
    private void getDrawable(final String bankNameImage) {
        if (drawable == null) {
            new AsyncTask<Void, Void, Void>() {  // getIdentifier is a heavy operation. lets make it on another thread.
                @Override
                protected Void doInBackground(Void... voids) {

                    if (bankNameImage != null) {
                        try {
                            String imageBankName;
                            if (bankNameImage.equalsIgnoreCase("sbinet"))
                                imageBankName = "sbi";
                            else if (bankNameImage.equalsIgnoreCase("icicinet") || bankNameImage.equalsIgnoreCase("icicicc"))
                                imageBankName = "icici";
                            else if (bankNameImage.equalsIgnoreCase("kotaknet"))
                                imageBankName = "kotak";
                            else if (bankNameImage.equalsIgnoreCase("indus"))
                                imageBankName = "induslogo";
                            else if (bankNameImage.equalsIgnoreCase("hdfc"))
                                imageBankName = "hdfc_bank";
                            else if (bankNameImage.equalsIgnoreCase("yesnet"))
                                imageBankName = "yesbank_logo";
                            else if (bankNameImage.equalsIgnoreCase("sc"))
                                imageBankName = "scblogo";
                            else if (bankNameImage.equalsIgnoreCase("axisnet"))
                                imageBankName = "axis_logo";
                            else if (bankNameImage.equalsIgnoreCase("amex"))
                                imageBankName = "cb_amex_logo";
                            else if (bankNameImage.equalsIgnoreCase("hdfcnet"))
                                imageBankName = "hdfc_bank";
                            else if (bankNameImage.equalsIgnoreCase("ing"))
                                imageBankName = "ing_logo";
                            else
                                imageBankName = bankNameImage;

                            int resID = getResources().getIdentifier(imageBankName, "drawable"
                                    , activity.getPackageName());

                            if (resID == 0)
                                return null;
                            else
                                drawable = getDrawableCB(activity, resID);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return null;
                }
            }.execute(null, null, null);
        }
    }*/

    /**
     * Logging events with txnid and package name.
     * Mixpannel used only in debug mode.
     *
     * @param key event key for analytics
     * @param value event value for analytics
     */
    private void addEventAnalytics(String key, String value) {
        try {
            mAnalytics.log(getLogMessage(key, value.toLowerCase(), bankName));
            if (DEBUG) {
                JSONObject props = new JSONObject();
                props.put("Pakage Name", activity.getPackageName() + "");
                props.put("Transaction ID", mTxnID);
                mixpanel.track(value, props);
            }
        } catch (JSONException e) {
            if (DEBUG)
                Log.e("CUSTOM BROWSER", "Unable to add properties to JSONObject", e);
        }catch(Exception e)
        {
            e.printStackTrace();
        }
    }


    private void checkPermission() {//this method checks permission to read SMS for androidM and above
      //  if (!checkedPermission) { // this is to check if this method was called before.
            if (!checkedPermission && Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && getArguments().getBoolean(MERCHANT_SMS_PERMISSION)) {

                   checkedPermission = true;
                   if (ContextCompat.checkSelfPermission(activity, Manifest.permission.RECEIVE_SMS) != PackageManager.PERMISSION_GRANTED) {// this checks if we have permission to receive sms or not,

                       requestPermissions(new String[]{Manifest.permission.RECEIVE_SMS}, 1); // if we dont have permission we request permission
                   } else {
                       permissionGranted = true;
                       if (SMSOTPClicked) {
                           try {
                               mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_otp)));
                           } catch (JSONException e) {
                               e.printStackTrace();
                           } catch (Exception e) {
                               e.printStackTrace();
                           }
                       }
                   }

            } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && !getArguments().getBoolean(MERCHANT_SMS_PERMISSION)) { // here we check for androidM and above devices if merchant receive sms permission is not set
                permissionGranted = false;
                if (SMSOTPClicked) {
                    try {
                        mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_otp)));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }catch(Exception e){
                        e.printStackTrace();
                    }
                }
            } else {
                onHelpAvailable();
                if(!checkedPermission)
                permissionGranted = true;
                if (SMSOTPClicked) {
                    try {
                        mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_otp)));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }catch(Exception e){
                        e.printStackTrace();
                    }
                }
            }

      //  }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String permissions[], @NonNull int[] grantResults) {// here we get the respose of the above request for receiving sms
        switch (requestCode) {
            case 1: {
                checkPermissionVisibility = false;
                if (SMSOTPClicked) {
                    try {
                        mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_otp)));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }

                if(ContextCompat.checkSelfPermission(activity, Manifest.permission.RECEIVE_SMS) == PackageManager.PERMISSION_GRANTED) {// this condition checks if the user has given us the permission to read sms
                    permissionGranted = true;
                    mPassword = null;
                    prepareSmsListener();
                }
//                }else if (grantResults[0] == PackageManager.PERMISSION_GRANTED) { this condition can be used later. so commenting out
//
//                    permissionGranted = true;
//
//                    mPassword = null;
//                    prepareSmsListener();
//
//                }
                else {
                    permissionGranted = false;
                    enter_otp(enterOtpParams);

                }
            }

        }
    }

    /**
     * Dynamic Custom browser.
     * Now we can enable/disable cb based on javascript rules.
     *
     * @param bank name of bank
     */
    private void checkVisibilityCB(final String bank) {
        try {
            if (activity != null) activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        String sdkCode = (getArguments().getString("sdkname") == null ? "" : getArguments().getString("sdkname"));
                        String merchantId = (getArguments().getString("merchantid") == null ? "" : getArguments().getString("merchantid"));
                        JSONObject obj = new JSONObject();
                        obj.put("androidosversion", Build.VERSION.RELEASE + "");
                        obj.put("androidmanufacturer", (Build.MANUFACTURER + "").toLowerCase());
                        obj.put("model", (Build.MODEL + "").toLowerCase());
                        obj.put("merchantid", (merchantId == null) ? "" : merchantId.toLowerCase());
                        obj.put("sdkname", sdkCode);
                        obj.put("cbname", BuildConfig.VERSION_NAME);
                        obj.put("bankname", bank.toLowerCase());
                        mWebView.loadUrl("javascript:" + mBankJS.getString("checkVisibilityCBCall") + "(" + obj + ")");

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Callback from custombrowser tells the bank.java to show or hide the custom browser.
     *
     * @param showCustomBrowser check to enable or disable custom browser
     */
    @JavascriptInterface
    public void showCustomBrowser(final boolean showCustomBrowser) {
        showCB = showCustomBrowser;
        if (activity != null) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (!showCustomBrowser) {
                        maximiseWebviewHeight();
                        frameState = MINIMISED;
                        try {

                            if (viewarrow != null)
                                viewarrow.setVisibility(View.GONE);

                            onHelpUnavailable();

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    // MR Integration
    @JavascriptInterface
    public void setMRData(String data) {
        if (!isMRDataSet) {
            // Store the Magic retry setting in shared preference
            if(getActivity()!=null) {
                MagicRetryFragment.setMRData(data, getActivity().getApplicationContext());
                isMRDataSet = true;
            }
        }
    }


    /**
     * Dismiss error page
     */
    public void onOverrideURL(String url) {

        if(progressBar!=null)
        progressBar.setProgress(0);
        if (optionspu != null) {
            optionspu.dismiss();
        }
    }



    /**
     * Custom browser shows the error page.
     *
     */
    public void onReceivedErrorWebClient() {
        try {
            if (activity != null && !activity.isFinishing()) {
                onHelpUnavailable();
                helpView.removeAllViews();
                if(progressBar!=null){
                    progressBar.setVisibility(View.GONE);
                    progressBar.setProgress(0);
                }
                if (optionspu != null)
                    optionspu.dismiss();

                if (maxWebview != 0) {
                    maximiseWebviewHeight();
                    frameState = MINIMISED;
                }
                progressBarVisibilityPayuChrome(View.GONE);

                LayoutInflater inflater = (LayoutInflater) activity.getSystemService(Activity.LAYOUT_INFLATER_SERVICE);
                View view = inflater.inflate(R.layout.error_page, null);
                view.measure(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);

                if (CBUtil.isNetworkAvailable(activity)) {

                    ((TextView) view.findViewById(R.id.error_title)).setText(activity.getResources().getString(R.string.cb_error));
                } else {
                    ((TextView) view.findViewById(R.id.error_title)).setText(activity.getResources().getString(R.string.cb_no_internet));
                }
                view.setAnimation(AnimationUtils.loadAnimation(getActivity(), R.anim.cb_tranlateup));
                optionspu = new PopupWindow(view, LinearLayout.LayoutParams.MATCH_PARENT, view.getMeasuredHeight() + 20);
                optionspu.setFocusable(false);
                //optionspu.showAtLocation(view, Gravity.BOTTOM, 0, 0);
                // optionspu.showAtLocation(view, Gravity.BOTTOM, 0, 0);
                // MR integration
                onHelpUnavailable();

                ( view.findViewById(R.id.cancel)).setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        Intent intent = new Intent();
                        intent.putExtra(getString(R.string.cb_result), "Transaction canceled due to cancel pressed!");
                        activity.setResult(Activity.RESULT_CANCELED, intent);
                        activity.finish();
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // MR Integration
    private void showMagicRetry() {
        String merchantId = (getArguments().getString("merchantid") == null ? "" : getArguments().getString("merchantid"));
        try {
            mWebView.loadUrl("javascript:" + mBankJS.getString("getMagicRetryUrls") + "('" + merchantId + "')");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        activity = getActivity();
        bundle = getArguments();
        CBUtil.setVariableReflection("com.payu.magicretry.MagicRetryFragment", BuildConfig.VERSION_NAME, "cbVersion");

        // Enable auto approve button
        autoApprove = bundle.getBoolean(AUTO_APPROVE, false);
        // Enable auto otp click
        autoSelectOtp = bundle.getBoolean(AUTO_SELECT_OTP, false);


        // initializing analytics , mixpanel
        initAnalytics();

        // Enable auto approve
        autoApprove = bundle.getBoolean(AUTO_APPROVE, false);
        storeOneClickHash = bundle.getInt(STORE_ONE_CLICK_HASH);

        // enable auto otp click
        autoSelectOtp = bundle.getBoolean(AUTO_SELECT_OTP, false);


        if (activity != null) {
            pin_selected_flag = false;

            CookieManager cookieManager = CookieManager.getInstance();

            if (Build.VERSION.SDK_INT >= 21) { // for icici white page fix.
                cookieManager.removeSessionCookies(null);
            } else {
                cookieManager.removeSessionCookie();
            }

            mTxnID = (bundle.containsKey(TXN_ID) ? bundle.getString(TXN_ID) : "123");
            if (mTxnID == null || mTxnID.equals("")) {
                mTxnID = "123";
            }
            mWebView = (WebView) activity.findViewById(getArguments().getInt("webView"));
            mWebView.getSettings().setJavaScriptEnabled(true);
            mWebView.addJavascriptInterface(this, "PayU");
            mWebView.getSettings().setDomStorageEnabled(true);
            mWebView.getSettings().setSupportMultipleWindows(true);
            mWebView.setOnTouchListener(new View.OnTouchListener() {
                @Override
                public boolean onTouch(View v, MotionEvent event) {
                    if (transView != null)
                        transView.setVisibility(View.GONE);
                    if (frameState == MAXIMISED) {
                        minimizeWebviewHeight();
                    }

                    return false;
                }
            });

            if (getArguments().getBoolean(CBConstant.WV_KEY_VIEWPORT)) {
                mWebView.getSettings().setUseWideViewPort(true);
            }

            // download initialize.js file
            getInitializeJS();
        }


    }


    @JavascriptInterface
    @Deprecated
    public void onMerchantHashReceived(final String result) {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                switch (storeOneClickHash) {
                    case CBConstant.STORE_ONE_CLICK_HASH_MOBILE:
                        try {
                            JSONObject hashObject = new JSONObject(result);
                            // store the cvv in shared preferences.
                            CBUtil.storeInSharedPreferences(activity, hashObject.getString(CBConstant.CARD_TOKEN), hashObject.getString(CBConstant.MERCHANT_HASH));
                        } catch (JSONException e) {
                            e.printStackTrace();

                        }
                        break;
                    case CBConstant.STORE_ONE_CLICK_HASH_SERVER:
                        merchantHash = result;
                        break;
                    case CBConstant.STORE_ONE_CLICK_HASH_NONE:
                        break;
                }
            }
        });
    }


    /**
     * Initializing analytics and mixpanel.
     */
    private void initAnalytics() {
        if (DEBUG)
            mixpanel = MixpanelAPI.getInstance(activity, projectToken);


        mAnalytics = CBAnalytics.getInstance(activity, "local_cache_analytics");
        deviceAnalytics();
    }

    private void deviceAnalytics() {
        JSONObject deviceDetails = new JSONObject();
        try {
            deviceDetails.put(CBConstant.SDK_VERSION_NAME, (bundle.getString(SDK_DETAILS) == null) ? "" : (bundle.getString(SDK_DETAILS)));
            deviceDetails.put(CBConstant.CB_VERSION_NAME, BuildConfig.VERSION_NAME + "");
            deviceDetails.put(CBConstant.DEVICE_OS_VERSION, Build.VERSION.SDK_INT + "");
            deviceDetails.put(CBConstant.DEVICE_RESOLUTION, CBUtil.getDeviceDensity(activity));
            deviceDetails.put(CBConstant.DEVICE_MANUFACTURE, Build.MANUFACTURER);
            deviceDetails.put(CBConstant.DEVICE_MODEL, Build.MODEL);
           // deviceDetails.put(CBConstant.MERCHANT_KEY, bundle.getString(MERCHANT_KEY));
              if(keyAnalytics!=null && !keyAnalytics.equals("")){
                 deviceDetails.put(CBConstant.ANALYTICS_KEY,keyAnalytics);
                  CBUtil.setVariableReflection("com.payu.magicretry.MagicRetryFragment", keyAnalytics, "analyticsKey");
             }else if((bundle.getString(MERCHANT_KEY) != null) && !bundle.getString(MERCHANT_KEY).trim().equals("")) {
                  deviceDetails.put(CBConstant.ANALYTICS_KEY, bundle.getString(MERCHANT_KEY));
                  CBUtil.setVariableReflection("com.payu.magicretry.MagicRetryFragment", bundle.getString(MERCHANT_KEY), "analyticsKey");
              }else {
                deviceDetails.put(CBConstant.ANALYTICS_KEY, "");
                  CBUtil.setVariableReflection("com.payu.magicretry.MagicRetryFragment", "", "analyticsKey");
            }
            deviceDetails.put(CBConstant.TRANSACTION_ID, bundle.getString(TXN_ID));
            deviceDetails.put(CBConstant.NETWORK_INFO, CBUtil.getNetworkStatus(activity));
            deviceDetails.put(CBConstant.NETWORK_STRENGTH, CBUtil.getNetworkStrenght(activity));

        } catch (Exception e) {
            e.printStackTrace();
        }

        new PayuDeviceAnalytics(activity, "cb_local_cache_device").log(deviceDetails.toString());
    }
    /**
     * Preparing sms listener.
     * Reads the sms and checks whether its a otp message.
     */
    private void prepareSmsListener() {

        if (mBroadcastReceiver == null) {
            mBroadcastReceiver = new BroadcastReceiver() {
                @Override
                public void onReceive(Context context, Intent intent) {
                    try {
                        if (mBankJS == null) {
                            return;
                        }
                        if (activity != null) {
                            Bundle extras = intent.getExtras();
                            if (extras != null) {
                                // Get received SMS array
                                SmsMessage[] msgs;
                                String msgBody = null;

                                try {
                                    Object[] pdus = (Object[]) extras.get("pdus");
                                    if(pdus!=null) {
                                        msgs = new SmsMessage[pdus.length];
                                        for (int i = 0; i < msgs.length; i++) {
                                            msgs[i] = SmsMessage.createFromPdu((byte[]) pdus[i]);
                                            msgBody += msgs[i].getMessageBody();
                                        }
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }

                                // We have the message!
                                if(msgBody!=null) {
                                    Matcher match = Pattern.compile(mBankJS.getString(getString(R.string.cb_detect_otp)), Pattern.CASE_INSENSITIVE).matcher(msgBody);
                                    if (match.find()) {
                                        // we have otp sms
                                        match = Pattern.compile(mBankJS.getString(getString(R.string.cb_find_otp)), Pattern.CASE_INSENSITIVE).matcher(msgBody);
                                        if (match.find()) {
                                            mPassword = match.group(1).replaceAll("[^0-9]", "");
                                        }
                                    }
                                }
                                if (activity.findViewById(R.id.otp_sms) != null) {
                                    final TextView otpSMS = (TextView) activity.findViewById(R.id.otp_sms);


                                    if (showCB && mPassword != null && otpSMS.getVisibility() != View.VISIBLE) {
                                        if (timer != null) {
                                            timer.cancel();
                                            timer.purge();
                                        }
                                        switch (eventRecorded) {
                                            case CBConstant.PAYMENT_INITIATED:
                                            case CBConstant.CUSTOM_BROWSER:
                                                eventRecorded = CBConstant.RECEIVED_OTP_DIRECT;
                                                break;
                                            case CBConstant.OTP_CLICK:
                                                eventRecorded = CBConstant.RECEIVED_OTP_SELECTED;
                                                break;
                                            case CBConstant.REGENERATE:
                                                eventRecorded = CBConstant.RECEIVED_OTP_REGENERATE;
                                                break;
                                            default:
                                                eventRecorded = CBConstant.OTP_WEB;
                                                break;
                                        }
                                        addEventAnalytics(CBConstant.OTP_RECIEVED, eventRecorded);


                                        otpSMS.setText(mPassword);
                                        mPassword = null;
                                        CustomProgressBar.removeDialog(activity.findViewById(R.id.progress));

                                        if (timer != null)
                                            timer.cancel();
                                        Button approveButton = (Button) activity.findViewById(R.id.approve);
                                        approveButton.setClickable(true);
                                        //approveButton.setAlpha(1);
                                        CBUtil.setAlpha(1, approveButton);
                                        approveButton.setVisibility(View.VISIBLE);

                                        activity.findViewById(R.id.timer).setVisibility(View.GONE);
                                        activity.findViewById(R.id.retry_text).setVisibility(View.GONE);
                                        activity.findViewById(R.id.regenerate_layout).setVisibility(View.GONE);
                                        activity.findViewById(R.id.waiting).setVisibility(View.GONE);
                                        activity.findViewById(R.id.otp_recieved).setVisibility(View.VISIBLE);

                                        otpSMS.setVisibility(View.VISIBLE);

                                        if (autoApprove) {
                                            approveButton.performClick();
                                            eventRecorded = CBConstant.CB_AUTO_APPROVE;
                                            addEventAnalytics(CBConstant.USER_INPUT, eventRecorded);
                                        }

                                        approveButton.setOnClickListener(new View.OnClickListener() {
                                            @Override
                                            public void onClick(View view) {
                                                try {
                                                    eventRecorded = CBConstant.APPROVED_OTP;
                                                    addEventAnalytics(CBConstant.USER_INPUT, eventRecorded);
                                                    prepareSmsListener();
                                                    checkLoading = false;
                                                    approve_flag = true;
                                                    onHelpUnavailable();
                                                    maximiseWebviewHeight();
                                                    frameState = MINIMISED;
                                                    mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_process_otp)) + "(\"" + otpSMS.getText().toString() + "\")");
                                                    cbUtil.hideSoftKeyboard(activity);

                                                } catch (JSONException e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                        });
                                        // unregister the broadcast receiver.
                                        abortBroadcast();

                                        if (mBroadcastReceiver != null) {
                                            unregisterBroadcast(mBroadcastReceiver);
                                            mBroadcastReceiver = null;
                                        }
                                    }
                                }
                            }

                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            // Register the broadcast receiver
            IntentFilter filter = new IntentFilter();
            filter.setPriority(9999999);
            filter.addAction("android.provider.Telephony.SMS_RECEIVED");
            registerBroadcast(mBroadcastReceiver, filter);
        }
    }


    /**
     * should be called for {@link PayUWebViewClient#onPageStarted(WebView, String, Bitmap)}
     *
     * @param url webview url
     */
    void onPageStartedWebclient(String url) {

        if (activity != null)
            CBUtil.setStringSharedPreference(activity, CBConstant.LAST_URL, "s:" + url);
      //  progressBar.setProgress(0);
        if(progressBar!=null)
        progressBar.setVisibility(View.VISIBLE);

        progressBarVisibilityPayuChrome(View.VISIBLE);
        webviewUrl = url;

        if (checkProgress == 0) {
            if (urlSet != null && urlSet.size() > 0 && !urlSet.contains(url)) {
                checkProgress = PRE_PAYMENT;
            }
        }
        if (checkProgress == POST_PAYMENT) {
            progressBarVisibilityPayuChrome(View.GONE);
        }

        if (checkProgress == DURING_PAYMENT) {
            if (postPaymentURL != null && postPaymentURL.size() > 0) {
                for (String aPostPaymentURL : postPaymentURL) {
                    if (url.contains(aPostPaymentURL)) {
                        progressDialog = null;
                        progressBarVisibilityPayuChrome(View.VISIBLE);
                        update();
                        checkProgress = POST_PAYMENT;
                        break;
                    }
                }
            }
        }

        if (checkValue != null && url.contains(checkValue)) {
            update();
            progressBarVisibilityPayuChrome(View.GONE);
        }

    }

    /**
     * Calling activity needs webview
     *
     * @return webview insatnce
     */
    public WebView getWebView() {
        return mWebView;
    }

    /**
     * Call back function from {@link PayUWebViewClient#onLoadResource(WebView, String)}
     *
     * @param url webview url
     */
    void onLoadResourse(String url) {

        if (url.equalsIgnoreCase(CBConstant.rupeeURL) || url.contains(CBConstant.rupeeURL1) || url.contains(CBConstant.rupeeURL2)) {
            progressBarVisibilityPayuChrome(View.GONE);
            checkProgress = DURING_PAYMENT;
        }
    }

    /**
     * Call back function from {@link PayUWebViewClient#onPageFinished(WebView, String)}
     * It takes care keyboard open issue and dissmiss the payu dialog.
     *
     * @param url webview url
     */
    void onPageFinishWebclient(String url) {

        if (activity != null)
            CBUtil.setStringSharedPreference(activity, CBConstant.LAST_URL, "f:" + url);

        if (checkProgress == PRE_PAYMENT) {
            progressBarVisibilityPayuChrome(View.GONE);
            checkProgress = DURING_PAYMENT;
        }
        if (firstFinish) {
            final View activityRootView = activity.findViewById(getArguments().getInt("mainLayout"));
            activityRootView.getViewTreeObserver().addOnGlobalLayoutListener(
                    new ViewTreeObserver.OnGlobalLayoutListener() {
                        private final int DefaultKeyboardDP = 100;
                        private final int EstimatedKeyboardDP = DefaultKeyboardDP + (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP ? 48 : 0);
                        private final Rect r = new Rect();

                        @Override
                        public void onGlobalLayout() {
                            // Convert the dp to pixels.
                            int estimatedKeyboardHeight = (int) TypedValue
                                    .applyDimension(TypedValue.COMPLEX_UNIT_DIP, EstimatedKeyboardDP, activityRootView.getResources().getDisplayMetrics());
                            // Conclude whether the keyboard is shown or not.
                            activityRootView.getWindowVisibleDisplayFrame(r);
                            int heightDiff = activityRootView.getRootView().getHeight() - (r.bottom - r.top);
                            boolean isShown = heightDiff >= estimatedKeyboardHeight;
                            if (isShown) {
                                if (checkForInput == 0) {
                                    InputMethodManager imm = (InputMethodManager) activity.getSystemService(Activity.INPUT_METHOD_SERVICE);
                                    imm.toggleSoftInput(InputMethodManager.RESULT_HIDDEN, 0);
                                    checkForInput = 1;
                                }
                            }
                        }
                    });
            firstFinish = false;
        }

    }

    public void onDestroy() {
        super.onDestroy();

        try {
            String lastUrl= URLEncoder.encode(CBUtil.updateLastUrl(CBUtil.getStringSharedPreference(activity, CBConstant.LAST_URL)), "UTF-8");

            if(lastUrl!=null && !lastUrl.equals("")) {
                addEventAnalytics(CBConstant.LAST_URL, lastUrl);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            CBUtil.delSharedLastURL(activity, CBConstant.LAST_URL);
        }
        try {
            if (optionspu != null)
                optionspu.dismiss();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
            eventRecorded = CBConstant.NON_CUSTOM_BROWSER;
            addEventAnalytics(CBConstant.CB_STATUS, eventRecorded);
        }

        eventRecorded = CBConstant.TERMINATE_TRANSACTION;
        addEventAnalytics(CBConstant.USER_INPUT, eventRecorded);

        if (mBroadcastReceiver != null) {

            unregisterBroadcast(mBroadcastReceiver);
            mBroadcastReceiver = null;
        }
        if (progressDialog != null && progressDialog.isShowing())
            progressDialog.dismiss();
    }

    /**
     * Stores the user id on NetBanking.
     */
    @JavascriptInterface
    public void getUserId() {
        if (activity != null && !activity.isFinishing()) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        SharedPreferences sherPref = activity.getSharedPreferences("com.payu.custombrowser", Context.MODE_PRIVATE);
                        mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_populate_user_id)) + "(\"" + sherPref.getString(bankName, "") + "\")");
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    /**
     * Stroes the user id on Netbanking.
     *
     * @param params userID
     */
    @JavascriptInterface
    public void setUserId(final String params) {
        if (saveUserIDCheck) {
            if (activity != null && !activity.isFinishing()) {
                SharedPreferences.Editor sherPrefEditor = activity.getSharedPreferences("com.payu.custombrowser", Context.MODE_PRIVATE).edit();
                sherPrefEditor.putString(bankName, params);
                sherPrefEditor.apply();
            }
        }

    }

    /**
     * Shows custom  browser for netbanking
     *
     * @param fields key of the event of cb
     * @param params json params corrosponding to string
     */
    @JavascriptInterface
    public void nativeHelperForNB(final String fields, final String params) {
        if (activity != null && !activity.isFinishing()) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        onHelpAvailable();
                        View nbView = activity.getLayoutInflater().inflate(R.layout.nb_layout, null);
                        if (fields != null) {
                            if (fields.equals("Button")) {
                                JSONObject jsonObject = new JSONObject(params);
                                if (jsonObject.has("btn_text") && jsonObject.getString("btn_text") != null && !jsonObject.getString("btn_text").equals("")) {
                                    //   'checkbox': <true||false> }
                                    final CheckBox checkBox = (CheckBox) (nbView.findViewById(R.id.checkbox));
                                    if (jsonObject.has("checkbox") && jsonObject.getBoolean("checkbox")) {
                                        if (saveUserIDCheck)
                                            checkBox.setChecked(true);
                                        else
                                            checkBox.setChecked(false);


                                        checkBox.setOnClickListener(new View.OnClickListener() {
                                            @Override
                                            public void onClick(View v) {
                                                saveUserIDCheck=checkBox.isChecked();
                                            }
                                        });
                                        checkBox.setVisibility(View.VISIBLE);
                                    } else {
                                        checkBox.setVisibility(View.GONE);
                                    }

                                    Button nativeButton = (Button) nbView.findViewById(R.id.native_button);
                                    nativeButton.setText(jsonObject.getString("btn_text"));
                                    nativeButton.setTransformationMethod(null);
                                    nativeButton.setOnClickListener(new View.OnClickListener() {
                                        @Override
                                        public void onClick(View v) {
                                            try {
                                                mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_btn_action)));
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    });
                                }
                                helpView.removeAllViews();
                                helpView.addView(nbView);

                                nbhelpVisible = true;
                            } else {
                                onHelpUnavailable();
                                helpView.removeAllViews();
                            }

                        } else {
                            onHelpUnavailable();
                            helpView.removeAllViews();
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

            });
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        try {
            if (activity != null && isAdded())
                transView = activity.findViewById(getArguments().getInt("tranLayout"));
        } catch (Exception e) {
            e.printStackTrace();
        }


        final View view = inflater.inflate(R.layout.bank, null);
        view.bringToFront();
        addProgressBar();
      //  if(getArguments().getBoolean(BACK_BUTTON,true)) {
            mWebView.setOnKeyListener(new View.OnKeyListener() {
                @Override
                public boolean onKey(View v, int keyCode, KeyEvent event) {

                    if (event.getAction() == KeyEvent.ACTION_UP && keyCode == KeyEvent.KEYCODE_BACK) {
                        if(getArguments().getBoolean(BACK_BUTTON,true)) {
                            AlertDialog.Builder alertDialog = new AlertDialog.Builder(activity);
                            alertDialog.setCancelable(false);
                            alertDialog.setMessage("Do you really want to cancel the transaction ?");
                            alertDialog.setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    addEventAnalytics(CBConstant.USER_INPUT, CBConstant.BACK_BUTTON_OK_CLICK);
                                    dialog.dismiss();

                                    onBackApproved();
                                    // CustomBrowserData.SINGLETON.getCbPayUCustomBrowserCallback().onBackApprove();
                                    activity.finish();
                                }
                            });
                            alertDialog.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    addEventAnalytics(CBConstant.USER_INPUT, CBConstant.BACK_BUTTON_CANCEL_CLICK);
                                    onBackCancelled();
                                    dialog.dismiss();

                                    //  CustomBrowserData.SINGLETON.getCbPayUCustomBrowserCallback().onBackDismiss();
                                }
                            });
                            // CustomBrowserData.SINGLETON.getCbPayUCustomBrowserCallback().onBackButton(alertDialog);
                            addEventAnalytics(CBConstant.USER_INPUT, CBConstant.PAYU_BACK_BUTTON_CLICK);
                            onBackPressed(alertDialog);
                            alertDialog.show();

                            return true;
                        }else{
                            addEventAnalytics(CBConstant.USER_INPUT, CBConstant.MERCHANT_BACK_BUTTON_CLICK);
                            activity.onBackPressed();
                        }
                    }
                    return false;
                }
            });


        helpView = (FrameLayout) view.findViewById(R.id.help_view);
        viewarrow = view.findViewById(R.id.view);

        view.setOnTouchListener(new View.OnTouchListener() {
            //float initialX,
            float   initialY;
            boolean isTouch = true;
            int height = 0;

            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (!nbhelpVisible) {
                    maximiseWebviewHeight();
                    if (!isTouch)
                        return false;
                    int action = event.getActionMasked();
                    if (viewarrow.getVisibility() == View.VISIBLE) {
                        viewarrow.setClickable(false);
                        viewarrow.setOnTouchListener(null);

                        TranslateAnimation animate = new TranslateAnimation(0, 0, height, 0);
                        animate.setDuration(500);
                        animate.setFillBefore(true);
                        v.startAnimation(animate);
                        helpView.setVisibility(View.VISIBLE);
                        isTouch = false;
                        final Handler handler = new Handler();
                        handler.postDelayed(new Runnable() {

                            @Override
                            public void run() {
                                viewarrow.setVisibility(View.GONE);
                            }
                        }, 20);
                        final Handler handlertrans = new Handler();
                        handlertrans.postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                isTouch = true;
                                frameState = MAXIMISED;
                                if (transView != null) {
                                    if (activity != null && !activity.isFinishing())
                                        showLayout(transView, activity);
                                }
                            }
                        }, 500);

                    } else {

                        switch (action) {
                            case MotionEvent.ACTION_DOWN:
                                //initialX = event.getX();
                                initialY = event.getY();

                                break;

                            case MotionEvent.ACTION_MOVE:
                                break;

                            case MotionEvent.ACTION_UP:
                                //  float finalX = event.getX();
                                float finalY = event.getY();

                                if (initialY < finalY) {
                                    if (helpView.getVisibility() == View.VISIBLE && (finalY - initialY) > 0) {
                                        height = v.getHeight();
                                        TranslateAnimation animate = new TranslateAnimation(0, 0, 0, v.getHeight() - 30);
                                        animate.setDuration(500);
                                        animate.setFillBefore(false);
                                        animate.setFillEnabled(true);
                                        animate.setZAdjustment(TranslateAnimation.ZORDER_TOP);
                                        v.startAnimation(animate);
                                        if (transView != null)
                                            transView.setVisibility(View.GONE);
                                        isTouch = false;
                                        isTouch = true;
                                        final Handler handler = new Handler();
                                        handler.postDelayed(new Runnable() {

                                            @Override
                                            public void run() {
                                                frameState = MINIMISED;
                                                helpView.setVisibility(View.GONE);
                                                viewarrow.setVisibility(View.VISIBLE);

                                            }
                                        }, 400);
                                    }
                                }
                                break;

                            case MotionEvent.ACTION_CANCEL:
                                break;

                            case MotionEvent.ACTION_OUTSIDE:
                                break;
                        }
                    }
                    return true;
                }

                return false;
            }
        });

        return view;
    }

    /**
     * called on OnClick from javascript
     *
     * @param fields analtytics event for pin or otp select from web
     */
    @JavascriptInterface
    public void analyticsLog(final String fields) {
        /*if (!mCVClicked) {
            if (fields.equals(getString(R.string.cb_otp_wv))) {

            } else if (fields.equals(getString(R.string.cb_pin_wv))) {

            }
        }*/
        reInit();
    }

    /**
     * run initialize.js manually.
     */
    @JavascriptInterface
    public void reInit() {
        if (activity != null && !activity.isFinishing()) {
           // mCVClicked = false;
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    onPageFinished();
                }
            });
        }
    }

    /**
     * We found the bank, call back from initialize.js with the bank name.
     *
     * @param bank name of bank
     */
    @JavascriptInterface
    public void bankFound(final String bank) {
        if (!visibilitychecked) {
            checkVisibilityCB(bank);
            visibilitychecked = true;
        }

        getDrawable(bank);
        if (activity != null && !activity.isFinishing()) {
            // initialize loading
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    calclateMaximizewebView();
                }
            });
        }

        // bank name
        bankName = bank;
        CBUtil.setVariableReflection("com.payu.magicretry.MagicRetryFragment", bankName, "bankName");
        // bank logo
        bank_logo = bank;
        if (!mPageReady) {
            try {
                if (loadingLayout == null) {
                    convertToNative("loading", "{}");
                } else {
                    View view = ((ViewGroup) activity.findViewById(R.id.help_view)).getChildAt(0);
                    if (loadingLayout != view) {
                        convertToNative("loading", "{}");
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();

            }

        }

        if (!mLoadingJS && mJS == null) {
            // do we have the js file already?
            new AsyncTask<Void, Void, Void>() { // downloading bank specific javascript file.
                @Override
                protected Void doInBackground(Void... voids) {
                    mLoadingJS = true;
                    File file;
                    try {
                        if (activity != null) {
                            String fileName = mBankJS.getString(bank);
                            file = new File(activity.getFilesDir(), fileName);
                            if (!file.exists()) {

                                java.net.URL url = new URL(CB_URL + fileName + ".js");

                                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                                conn.setRequestMethod("GET");
                                conn.setRequestProperty("Accept-Charset", "UTF-8");

                                if (conn.getResponseCode() == HttpURLConnection.HTTP_OK) {
                                    GZIPInputStream responseInputStream = new GZIPInputStream(conn.getInputStream());
                                    byte[] buf = new byte[1024];
                                    int len;
                                    FileOutputStream outputStream = activity.openFileOutput(fileName, Context.MODE_PRIVATE);
                                    while ((len = responseInputStream.read(buf)) > 0) {
                                        outputStream.write(buf, 0, len);
                                    }
                                    responseInputStream.close();
                                    outputStream.close();
                                }

                            }
                        }

                    } catch (JSONException e) {
                        e.printStackTrace();
                    } catch (IOException e) {
                        e.printStackTrace();
                    } catch (Exception e) {
                        e.printStackTrace();
                    } finally {
                        try {
                            if (activity != null) {
                                String fileName = mBankJS.getString(bank);
                                mJS = new JSONObject(cbUtil.decodeContents(activity.openFileInput(fileName)));
                                if (mPageReady) {
                                    if (activity != null) {
                                        activity.runOnUiThread(new Runnable() {
                                            @Override
                                            public void run() {
                                                onPageFinished();
                                            }
                                        });
                                    }
                                }
                                mLoadingJS = false;
                            }
                        } catch (JSONException | FileNotFoundException e) {
                            e.printStackTrace();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return null;
                }
            }.execute();
        }

    }


    /**
     * Download initialize.js form payu server.
     */
    private void getInitializeJS() {
        // listen for OTP
        prepareSmsListener();
        eventRecorded = CBConstant.PAYMENT_INITIATED;

        addEventAnalytics(CBConstant.USER_INPUT, eventRecorded);
        // make an http request!
        new AsyncTask<Void, Void, Void>() {
            @Override
            protected Void doInBackground(Void... voids) {

                String fileName = "initialize";

                try {
                    URL url = new URL(CB_URL + fileName + ".js");
                    HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setRequestProperty("Accept-Charset", "UTF-8");

                    if (conn.getResponseCode() == HttpURLConnection.HTTP_OK) {
                        GZIPInputStream responseInputStream = new GZIPInputStream(conn.getInputStream());
                        byte[] buf = new byte[1024];
                        int len;
                        FileOutputStream outputStream = activity.openFileOutput(fileName, Context.MODE_PRIVATE);
                        while ((len = responseInputStream.read(buf)) > 0) {
                            outputStream.write(buf, 0, len);
                        }
                        responseInputStream.close();
                        outputStream.close();
                    }

                } catch (MalformedURLException e) {
                    e.printStackTrace();
                } catch (ProtocolException e) {
                    e.printStackTrace();
                } catch (IOException e) {
                    e.printStackTrace();
                } finally {
                    // reading initialize.js form file.
                    try {
                        if (activity != null) {
                            mBankJS = new JSONObject(cbUtil.decodeContents(activity.openFileInput(fileName)));
                            if (mBankJS != null) {
                                setUrlString();
                            } else {
                                communicationError();
                            }
                            if (mPageReady) {
                                if (activity != null) {
                                    activity.runOnUiThread(new Runnable() {
                                        @Override
                                        public void run() {
                                            onPageStarted();
                                        }
                                    });
                                }
                            }
                        }
                    } catch (FileNotFoundException e) {
                        communicationError();
                        e.printStackTrace();
                    } catch (JSONException e) {
                        communicationError();
                        e.printStackTrace();
                    } catch (Exception e) {
                        communicationError();
                        e.printStackTrace();
                    }
                }

                return null;
            }
        }.execute(null, null, null);
    }

    /**
     * Js interface from Bank specific javascript.
     * Convert to native shows the bank specific native ui on the webview
     *
     * @param fields can be anyone of choose, retry, incorrectotp, enterotp.
     * @param params regen: true, pin: false, otp: true.
     */
    @JavascriptInterface
    public void convertToNative(final String fields, final String params) {

        if (activity != null && showCB) activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {

                try {
                    if (timer != null && enterOtpRunnable != null) {
                        timer.cancel();
                        timer.purge();

                    }

                    if (fields.equals(getString(R.string.cb_error))) {  // Error
                        // fail the payment
                        // hide the view
                        onBankError();
                    } else if (fields.equals("parse error")) {
                        // hide the view
                        onBankError();
                    } else if (fields.contentEquals("loading") && !pin_selected_flag && checkLoading) { // Bank page is still loading
                        onHelpAvailable();

                        if (transView != null)
                            transView.setVisibility(View.VISIBLE);
//
                        loadingLayout = activity.getLayoutInflater().inflate(R.layout.loading, null);
                        ImageView im = (ImageView) loadingLayout.findViewById(R.id.bank_logo);

                        if (drawable != null)
                            im.setImageDrawable(drawable);

                        // Adjust the size of the webview,
                        updateLoaderHeight();

                        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, chooseActionHeight);
                        View layoutView = loadingLayout.findViewById(R.id.loading);
                        layoutView.setLayoutParams(params);
                        layoutView.requestLayout();
                        layoutView.invalidate();
                        CustomProgressBar.showDialog(activity, loadingLayout.findViewById(R.id.progress));

                        helpView.removeAllViews();
                        helpView.addView(loadingLayout);
                        if (helpView.isShown()) {
                            frameState = MAXIMISED;
                        } else {
                            maximiseWebviewHeight();
                        }
                        updateHeight(loadingLayout);
                    } else if (fields.equals(getString(R.string.cb_choose))) { // choose flow.

                        if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
                            eventRecorded = CBConstant.CUSTOM_BROWSER;
                            eventArray.add(CBConstant.CUSTOM_BROWSER);

                            addEventAnalytics(CBConstant.CB_STATUS, eventRecorded);
                        }

                        frameState = MAXIMISED;
                        checkLoading = true;

                        if (transView != null)
                            transView.setVisibility(View.VISIBLE);

//                    // show the options

                        View view = activity.getLayoutInflater().inflate(R.layout.choose_action, null);
                        helpView.setVisibility(View.GONE);

                        if (maxWebview == 0) {
                            calclateMaximizewebView();
                            maximiseWebviewHeight();
                        }

                        helpView.setVisibility(View.VISIBLE);
                        if (viewarrow != null)
                            viewarrow.setVisibility(View.GONE);

                        calclateHeight(view);
                        onHelpAvailable();
                        view.measure(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                        chooseActionHeight = view.getMeasuredHeight();

                        ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                        if (drawable != null)
                            im.setImageDrawable(drawable);

                        helpView.removeAllViews();
                        helpView.addView(view);
                        if (helpView.isShown())
                            frameState = MAXIMISED;


                        final SpannableStringBuilder str = new SpannableStringBuilder("Select an option for Faster payment");
                        str.setSpan(new android.text.style.StyleSpan(android.graphics.Typeface.BOLD), 21, 27, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
                        TextView tv = (TextView) view.findViewById(R.id.choose_text);
                        tv.setText(str);
                        final JSONObject jsonObject;
                        try {
                            jsonObject = new JSONObject(params);
                            if (jsonObject.has(getString(R.string.cb_otp)) && !jsonObject.getBoolean(getString(R.string.cb_otp))) { // otp flow is not visible
                                view.findViewById(R.id.otp).setVisibility(View.GONE);
                                view.findViewById(R.id.view).setVisibility(View.GONE);
                            } else {
                                view.findViewById(R.id.otp).setOnClickListener(buttonClickListener);
                                if (autoSelectOtp) {
                                    eventRecorded = CBConstant.CB_AUTO_OTP_SELECT;
                                    addEventAnalytics(CBConstant.USER_INPUT, eventRecorded);
                                    view.findViewById(R.id.otp).performClick();
                                    autoSelectOtp = false;
                                }
                            }
                            view.findViewById(R.id.otp).setOnClickListener(buttonClickListener);
                            if (jsonObject.has(getString(R.string.cb_pin)) && !jsonObject.getBoolean(getString(R.string.cb_pin))) { // pin flow is not visible
                                view.findViewById(R.id.pin).setVisibility(View.GONE);
                                view.findViewById(R.id.view).setVisibility(View.GONE);
                            } else {
                                view.findViewById(R.id.pin).setOnClickListener(new View.OnClickListener() { // we have pin flow.

                                    @Override
                                    public void onClick(View view) {
                                        c_hdfc = 1;
                                        pin_selected_flag = true;
                                        approve_flag = true;
                                        maximiseWebviewHeight();
                                        frameState = MINIMISED;
                                        if (transView != null)
                                            transView.setVisibility(View.GONE);
                                        try {
                                            if (jsonObject.has(getString(R.string.cb_register)) && jsonObject.getBoolean(getString(R.string.cb_register))) { // Register user flow.
                                                view = activity.getLayoutInflater().inflate(R.layout.register_pin, null);
                                                helpView.removeAllViews();
                                                helpView.addView(view);

                                                if (helpView.isShown())
                                                    frameState = MAXIMISED;

                                                view.findViewById(R.id.pin).setOnClickListener(new View.OnClickListener() {
                                                    @Override
                                                    public void onClick(View view) {
                                                        try {
                                                            eventRecorded = CBConstant.PASSWORD_CLICK;
                                                            addEventAnalytics(CBConstant.USER_INPUT, eventRecorded);

                                                         //   mCVClicked = true;
                                                            mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_pin)));
                                                        } catch (JSONException e) {
                                                            e.printStackTrace();
                                                        }
                                                    }
                                                });
                                                if (jsonObject.has(getString(R.string.cb_otp)) && !jsonObject.getBoolean(getString(R.string.cb_otp))) {
                                                    view.findViewById(R.id.otp).setVisibility(View.GONE);
                                                }
                                                view.findViewById(R.id.otp).setOnClickListener(buttonClickListener);
                                            } else {
                                                eventRecorded = CBConstant.PASSWORD_CLICK;
                                                addEventAnalytics(CBConstant.USER_INPUT, eventRecorded);
                                                onHelpUnavailable();
                                                //mCVClicked = true;
                                                mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_pin)));
                                            }
                                        } catch (JSONException e) {
                                            e.printStackTrace();
                                        }
                                        updateHeight(view);
                                    }
                                });
                            }
                            if (jsonObject.has(getString(R.string.cb_error))) { // oops sorry some error occured
                                view.findViewById(R.id.error_message).setVisibility(View.VISIBLE);
                                ((TextView) view.findViewById(R.id.error_message)).setText(jsonObject.getString("error"));
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    } else if (fields.equals(getString(R.string.cb_incorrect_OTP_2))) { // incorrect otp.

                        if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
                            eventRecorded = CBConstant.CUSTOM_BROWSER;
                            eventArray.add(CBConstant.CUSTOM_BROWSER);
                            addEventAnalytics(CBConstant.CB_STATUS, eventRecorded);
                        }

                        checkLoading = true;
                        onHelpAvailable(); // gotta show cb
                        final View view = activity.getLayoutInflater().inflate(R.layout.retry_otp, null);
                        ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                        if (drawable != null)
                            im.setImageDrawable(drawable);

                        helpView.removeAllViews();
                        helpView.addView(view);

                        if (helpView.isShown()) {
                            frameState = MAXIMISED;
                        } else {
                            if (viewarrow != null)
                                viewarrow.setVisibility(View.VISIBLE);
                            maximiseWebviewHeight();
                        }

                        if (mPassword == null) {
                            view.findViewById(R.id.regenerate_layout).setVisibility(View.VISIBLE);
                            view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.GONE);
                            try {
                                JSONObject p = new JSONObject(params);
                                final boolean pin = p.has(getString(R.string.cb_pin)) && p.getBoolean(getString(R.string.cb_pin));

                                view.findViewById(R.id.enter_manually).setOnClickListener(buttonClickListener);
                                if (pin)
                                    view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                                else
                                    view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);

                                view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        updateHeight(view);
                    } else if (fields.equals(getString(R.string.cb_retry_otp))) { // Retry flow.

                        if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
                            eventRecorded = CBConstant.CUSTOM_BROWSER;
                            eventArray.add(CBConstant.CUSTOM_BROWSER);
                            addEventAnalytics(CBConstant.CB_STATUS, eventRecorded);
                        }

                        checkLoading = true;
                        onHelpAvailable(); // show cb
                        cbUtil.hideSoftKeyboard(activity); // if the keyboard still on the screen, just force it to hide
                        if (transView != null)
                            transView.setVisibility(View.VISIBLE);

                        final View view = activity.getLayoutInflater().inflate(R.layout.retry_otp, null);
                        ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                        if (drawable != null)
                            im.setImageDrawable(drawable);

                        helpView.removeAllViews();
                        helpView.addView(view);

                        if (helpView.isShown()) {
                            frameState = MAXIMISED;
                        } else {
                            if (viewarrow != null) {
                                viewarrow.setVisibility(View.VISIBLE);
                            }
                            maximiseWebviewHeight();
                        }

                        try {
                            if (mPassword == null) {
                                JSONObject p = new JSONObject(params);
                                final boolean regenerate = p.has(getString(R.string.cb_regenerate)) && p.getBoolean(getString(R.string.cb_regenerate));
                                final boolean pin = p.has(getString(R.string.cb_pin)) && p.getBoolean(getString(R.string.cb_pin));

                                view.findViewById(R.id.regenerate_layout).setVisibility(View.VISIBLE);
                                if (regenerate) {
                                    view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.VISIBLE);
                                    if (pin) {
                                        view.findViewById(R.id.Enter_manually_gone).setVisibility(View.GONE);
                                        view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                                    } else {
                                        view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                                        view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);
                                    }
                                } else {
                                    if (pin)
                                        view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                                    else
                                        view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);

                                    view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.GONE);
                                    view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                                }

                            }
                            view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);
                            view.findViewById(R.id.enter_manually).setOnClickListener(buttonClickListener);
                            view.findViewById(R.id.retry).setOnClickListener(buttonClickListener);
                            buttonClickListener.setView(view);
                            view.findViewById(R.id.approve).setOnClickListener(buttonClickListener);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        updateHeight(view);
                    } else if (fields.equals(getString(R.string.cb_enter_pin))) { // user has just selected pin flow.

                        if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
                            eventRecorded = CBConstant.CUSTOM_BROWSER;
                            eventArray.add(CBConstant.CUSTOM_BROWSER);
                            addEventAnalytics(CBConstant.CB_STATUS, eventRecorded);
                        }

                        if (viewarrow != null)
                            viewarrow.setVisibility(View.GONE);

                        onHelpUnavailable();
                        pin_selected_flag = true;
                        approve_flag = true;
                        maximiseWebviewHeight();
                        frameState = MINIMISED;
                        if (transView != null)
                            transView.setVisibility(View.GONE);

                        maximiseWebviewHeight();
                        helpView.removeAllViews();
                    } else if (fields.equals(getString(R.string.cb_enter_otp))) { // user is waiting for otp
                        SMSOTPClicked = false;
                        checkPermission();
                        enterOtpParams = params;
                        if (!checkPermissionVisibility) {
                            if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
                                eventRecorded = CBConstant.CUSTOM_BROWSER;
                                eventArray.add(CBConstant.CUSTOM_BROWSER);
                                addEventAnalytics(CBConstant.USER_INPUT, eventRecorded);
                            }

                            if (bank_logo.equalsIgnoreCase("hdfc") && c_hdfc == 0)
                                c_hdfc = 1;
                            else if (bank_logo.equalsIgnoreCase("hdfc") && c_hdfc > 0)
                                enter_otp(params);
                            else
                                enter_otp(params);


                                /*if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
                                    eventRecorded = CBConstant.CUSTOM_BROWSER;
                                    eventArray.add(CBConstant.CUSTOM_BROWSER);
                                    addEventAnalytics(eventRecorded);
                                }*/
                        }

                    } else if (fields.equals(getString(R.string.cb_incorrect_pin))) { // oops wrong pin attempt.

                        if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
                            eventRecorded = CBConstant.CUSTOM_BROWSER;
                            eventArray.add(CBConstant.CUSTOM_BROWSER);
                            addEventAnalytics(CBConstant.CB_STATUS, eventRecorded);
                        }

                        final JSONObject jsonObject;
                        try {
                            jsonObject = new JSONObject(params);
                            if (jsonObject.has(getString(R.string.cb_otp)) && jsonObject.getBoolean(getString(R.string.cb_otp))) {
                                checkLoading = true;
                                onHelpAvailable();
                                final View view = activity.getLayoutInflater().inflate(R.layout.choose_action, null);

                                ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                                if (drawable != null)
                                    im.setImageDrawable(drawable);

                                TextView errorText = (TextView) view.findViewById(R.id.error_message);
                                errorText.setVisibility(View.VISIBLE);
                                errorText.setText(activity.getResources().getString(R.string.cb_incorrect_password));

                                TextView chooseText = (TextView) view.findViewById(R.id.choose_text);
                                chooseText.setVisibility(View.VISIBLE);
                                chooseText.setText(activity.getResources().getString(R.string.cb_retry));


                                helpView.removeAllViews();
                                helpView.addView(view);

                                view.findViewById(R.id.otp).setOnClickListener(buttonClickListener);
                                view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);

                                updateHeight(view);
                                if (helpView.isShown()) {
                                    frameState = MAXIMISED;
                                } else {
                                    maximiseWebviewHeight();
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (fields.equals(getString(R.string.cb_register_option))) { // Register new user.

                        if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
                            eventRecorded = CBConstant.CUSTOM_BROWSER;
                            eventArray.add(CBConstant.CUSTOM_BROWSER);
                            addEventAnalytics(CBConstant.CB_STATUS, eventRecorded);
                        }
                        onHelpAvailable();
                        final View view = activity.getLayoutInflater().inflate(R.layout.register, null);
                        helpView.removeAllViews();
                        helpView.addView(view);
                        ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                        if (drawable != null)
                            im.setImageDrawable(drawable);

                        updateHeight(view);
                        if (helpView.isShown()) {
                            frameState = MAXIMISED;
                        } else {
                            maximiseWebviewHeight();
                        }
                    } else {
                        maximiseWebviewHeight();
                        frameState = MINIMISED;
                        if (viewarrow != null)
                            viewarrow.setVisibility(View.GONE);

                        onHelpUnavailable();

                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }

        });
    }

    public void onPageFinished() {
        if (this.isAdded() && !this.isRemoving() && null != activity) {
            mPageReady = true;
            if (approve_flag) {

                onHelpUnavailable();
                approve_flag = false;
            }

            if (loadingLayout != null && loadingLayout.isShown()) {
                frameState = MINIMISED;
                maximiseWebviewHeight();
                onHelpUnavailable();
            }
            activity.getWindow().setSoftInputMode(WindowManager.
                    LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);


            if (mJS != null && showCB) { // we have cb and we have the bankspecific js, lets show cb.
                try {
                    mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_init)));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (mBankJS != null && mJS == null) {
                if(transView!=null)
                transView.setVisibility(View.GONE); // Hide the translayout our page is loaded successfully.
            }
        }
    }

    public void onPageStarted() {
        if (nbhelpVisible) {
            onHelpUnavailable();
            nbhelpVisible = false;
        }
        if (this.isAdded() && !this.isRemoving()) {
            mPageReady = false;
            if (mBankJS != null) { // we have successfully downloaded initialize.js
                try {
                    if (showCB) {
                        mWebView.loadUrl("javascript:" + mBankJS.getString(getString(R.string.cb_detect_bank)));
                        showMagicRetry();

                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * Call back from surl - sucess transaction
     * with no argument.
     * just send empty string back to calling activity
     */
    @JavascriptInterface
    public void onSuccess() {
        onSuccess("");
    }

    /**
     * call back function from surl - success transaction.
     * keep the data in {@link #merchantResponse}
     * set result ok, and send the received data.
     * @param result success result received from surl
     */
    @JavascriptInterface
    public void onSuccess(final String result) {
        merchantResponse = result;
    }

    /**
     * Attempt to deprecate surl.
     * Javascript interface call from payu server.
     * Lets keep the data in local variable and pass it to main activity.
     * @param result json data of post param.
     */

    @JavascriptInterface
    public void onPayuSuccess(final String result){

        isSuccessTransaction = true;

        // lets do the analytics.
        eventRecorded = CBConstant.SUCCESS_TRANSACTION;
        addEventAnalytics(CBConstant.TRNX_STATUS, eventRecorded);

        payuReponse = result;

        if (storeOneClickHash == CBConstant.STORE_ONE_CLICK_HASH_MOBILE){ // store it only if i need to store it
            try {
                JSONObject hashObject = new JSONObject(payuReponse);
                // store the cvv in shared preferences.
                CBUtil.storeInSharedPreferences(activity, hashObject.getString(CBConstant.CARD_TOKEN), hashObject.getString(CBConstant.MERCHANT_HASH));
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        callTimer();
    }

    /**
     * Call back from furl - failure transaction
     * with no argument.
     * just send empty string back to calling activity
     */
    @JavascriptInterface
    public void onFailure() {
        onFailure("");
    }

    /**
     * call back function from furl - failure transaction.
     * keep the value in {@link #merchantResponse}
     * set result ok, and send the received data.
     *
     * @param result json string
     */
    @JavascriptInterface
    public void onFailure(final String result) {
        merchantResponse = result;
    }

    /**
     * Attempt to deprecate furl.
     * Javascript call from payu server.
     * Lets keep the data in local variable and pass it to calling activity.
     * @param result json string result of failure transaction
     */
    @JavascriptInterface
    public void onPayuFailure(final String result){
        if (activity != null) {

            eventRecorded = CBConstant.FAILURE_TRANSACTION;
            addEventAnalytics(CBConstant.TRNX_STATUS, eventRecorded);
            isSuccessTransaction = false;
            payuReponse = result;
        }
        callTimer();
    }

    /**
     * will be called in case of curl
     * mostly handled by furl
     */
    @JavascriptInterface
    public void onCancel() {
        onCancel("");
    }

    /**
     * will be called in case of curl
     * mostly handled by furl
     */
    @JavascriptInterface
    public void onCancel(final String result) {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (activity != null && !activity.isFinishing() && Bank.this.isAdded()) {
                    Intent intent = new Intent();
                    intent.putExtra(getString(R.string.cb_result), result);
                    activity.setResult(Activity.RESULT_CANCELED, intent);
                    activity.finish();
                }
            }
        });
    }

    /**
     * Generate a hash for analytics url
     *
     * @param key event key
     * @param value event value
     * @param bank name of bank
     * @return json string for analytics
     */
    private String getLogMessage(String key, String value, String bank) {
        try {
            JSONObject eventAnalytics = new JSONObject();
            eventAnalytics.put(CBConstant.TRANSACTION_ID, (mTxnID == null ? "" : mTxnID));
            eventAnalytics.put(CBConstant.CB_VERSION_NAME, BuildConfig.VERSION_NAME);
            eventAnalytics.put(CBConstant.PAKAGE_NAME, activity.getPackageName());
            eventAnalytics.put(CBConstant.BANK_NAME, (bank == null ? "" : bank));
            eventAnalytics.put(CBConstant.KEY, key);
            eventAnalytics.put(CBConstant.VALUE, value);
           // eventAnalytics.put(CBConstant.MERCHANT_KEY, bundle.getString(MERCHANT_KEY));
            if(keyAnalytics!=null && !keyAnalytics.trim().equals("")){
                eventAnalytics.put(CBConstant.ANALYTICS_KEY, keyAnalytics);
            }else if(bundle.getString(MERCHANT_KEY)!=null && !bundle.getString(MERCHANT_KEY).trim().equals("")) {
                eventAnalytics.put(CBConstant.ANALYTICS_KEY, bundle.getString(MERCHANT_KEY));
            }else{
                eventAnalytics.put(CBConstant.ANALYTICS_KEY,"");
            }
            return eventAnalytics.toString();
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * Should be implemented by Calling activity
     *
     * @param broadcastReceiver broadcast receiver to set up.
     * @param filter intent filter
     */

    public abstract void registerBroadcast(BroadcastReceiver broadcastReceiver, IntentFilter filter);

    /**
     * Unregister the broad cast receiver.
     *
     * @param broadcastReceiver instance of receiver
     */
    public abstract void unregisterBroadcast(BroadcastReceiver broadcastReceiver);

    /**
     * Hide the custombowser fragement
     */
    public abstract void onHelpUnavailable();

    /**
     * OOPS something went wrong hide cb or progerss dialog.
     */
    public abstract void onBankError();

    /**
     * Yey we support cb for this bank, lets show cb
     */
    public abstract void onHelpAvailable();


    /**
     * Known ulrs will be passed to cb,
     * if the current url is not being found hide Progress loader.
     *
     * @param urlSet set of url from js, progress dialog will be visble on these url
     * @param postUrlSet post payment url where progress dialog where progress dialog will be visible
     * @param check check for progress dialog
     */
    private void updateSet(Set<String> urlSet, Set<String> postUrlSet, String check) {
        if (urlSet != null && urlSet.size() > 0 && webviewUrl != null && !urlSet.contains(webviewUrl)) {
            progressBarVisibilityPayuChrome(View.GONE);
            checkProgress = DURING_PAYMENT;
        }
        checkValue = check;
    }

    /**
     * OOPS something went wrong, hide payu loader
     */
    private void communicationError() {
        progressBarVisibilityPayuChrome(View.GONE);
    }

    /**
     * Should be used with progress dialog.
     *
     * @param view view to shown with animation
     * @param mContext base context of activity
     */
    private void showLayout(final View view, Context mContext) {
        if (view != null) {
            final Animation animation = AnimationUtils.loadAnimation(mContext, R.anim.cb_fade_in);

            view.startAnimation(animation);
            Handler handler = new Handler();
            handler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    view.setVisibility(View.VISIBLE);
                }
            }, 500);
        }
    }


    /**
     * Measure the height of webview
     *
     * @param view insatnce of view for which height to be calculated
     */
    private void calclateHeight(View view) {
        // height of the loader

        view.measure(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        int loading_height = view.getMeasuredHeight();
        minWebview = maxWebview - loading_height;
    }

    /**
     * Measure webview heigt
     */
    private void calclateMaximizewebView() {
        try {
            if (maxWebview == 0) {

                mWebView.measure(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
                mWebView.requestLayout();
                maxWebview = mWebView.getMeasuredHeight();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Adjust Webview size
     */
    private void maximiseWebviewHeight() {
        if (maxWebview == 0)
            calclateMaximizewebView();
        mWebView.getLayoutParams().height = maxWebview;
        mWebView.requestLayout();

    }

    /**
     * Adjust webview size
     */
    private void minimizeWebviewHeight() {
        mWebView.getLayoutParams().height = minWebview;
        mWebView.requestLayout();
    }

    /**
     * Adjust webview size
     *
     * @param view instance of view for which height to be updated
     */
    private void updateHeight(View view) {
        if (maxWebview == 0) {
            calclateMaximizewebView();
            maximiseWebviewHeight();
        }
        calclateHeight(view);
    }

    /**
     * Calculate and update loader height.
     */
    private void updateLoaderHeight() {
        if (chooseActionHeight == 0) {
            mWebView.measure(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            int maxWebview = mWebView.getMeasuredHeight();
            chooseActionHeight = (int) (maxWebview * (0.35));
        }
    }

    /**
     * filter the url for which dialog to be shown
     */
    private void setUrlString() {
        if (mBankJS != null) {
            try {
                if (mBankJS.has("pgUrlList")) {
                    String urlStr = mBankJS.getString("pgUrlList");
                    StringTokenizer st = new StringTokenizer(urlStr.replace(" ", ""), "||");
                    while (st.hasMoreTokens()) {
                        urlSet.add(st.nextToken());
                    }
                } else {
                    communicationError();
                }
                if (mBankJS.has("postPaymentPgUrlList")) {
                    String urlStr = mBankJS.getString("postPaymentPgUrlList");
                    StringTokenizer st = new StringTokenizer(urlStr.replace(" ", ""), "||");
                    while (st.hasMoreTokens()) {
                        postPaymentURL.add(st.nextToken());
                    }
                }
                updateSet(urlSet, postPaymentURL, url);
            } catch (Exception e) {
                communicationError();
                e.printStackTrace();
            }
        }

    }

    /**
     * Method for enter otp.
     * User is waiting to receive otp.
     *
     * @param params json from js
     */
    private void enter_otp(final String params) {
        {
            // Make sure sms listener is prepared.
            prepareSmsListener();


            // log event, cb appeared.
            if (eventRecorded.equals(CBConstant.PAYMENT_INITIATED)) {
                eventRecorded = CBConstant.CUSTOM_BROWSER;
                eventArray.add(CBConstant.CUSTOM_BROWSER);
                addEventAnalytics(CBConstant.CB_STATUS, eventRecorded);
            }

            if (chooseActionHeight == 0)
                frameState = MAXIMISED;

            checkLoading = true;
            onHelpAvailable(); // show cb

            if (transView != null)
                transView.setVisibility(View.VISIBLE);

            final View view = activity.getLayoutInflater().inflate(R.layout.wait_for_otp, null);
            ImageView im = (ImageView) view.findViewById(R.id.bank_logo);
            final TextView timerView = (TextView) view.findViewById(R.id.timer);
           final Button approveButton = (Button) view.findViewById(R.id.approve);
            if (drawable != null)
                im.setImageDrawable(drawable);

            ((EditText) view.findViewById(R.id.otp_sms)).addTextChangedListener(new TextWatcher() {

                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                    String otp = ((EditText) view.findViewById(R.id.otp_sms)).getText().toString();

                    if (otp.length() > 5) {
                        buttonClickListener.setView(view);
                        approveButton.setOnClickListener(buttonClickListener);
                        approveButton.setClickable(true);
                        CBUtil.setAlpha(1, approveButton);
                    } else {
                        approveButton.setClickable(false);
                        CBUtil.setAlpha(1, approveButton);
                        approveButton.setOnClickListener(null);
                    }
                }

                @Override
                public void afterTextChanged(Editable editable) {

                }
            });

            View mProgress = view.findViewById(R.id.progress);
            CustomProgressBar.showDialog(activity, mProgress);
            helpView.removeAllViews();
            helpView.addView(view);

            if (helpView.isShown()) {
                frameState = MAXIMISED;
            } else {
                maximiseWebviewHeight();
            }

            if (frameState == MINIMISED) {

                if (viewarrow != null)
                    viewarrow.setVisibility(View.VISIBLE);
            }

            try {
                JSONObject p = new JSONObject(params);
                final boolean regenerate = p.has(getString(R.string.cb_regenerate)) && p.getBoolean(getString(R.string.cb_regenerate));
                final boolean skipScreen = p.has(getString(R.string.cb_skip_screen)) && p.getBoolean(getString(R.string.cb_skip_screen));
                final boolean pin = p.has(getString(R.string.cb_pin)) && p.getBoolean(getString(R.string.cb_pin));

                if (skipScreen) {
                    if ((activity != null) && (activity.findViewById(R.id.otp_sms) != null) &&
                            (activity.findViewById(R.id.otp_sms).getVisibility() != View.VISIBLE)) {

                        view.findViewById(R.id.retry_text).setVisibility(View.VISIBLE);
                        if (regenerate) {
                            view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.VISIBLE);
                            view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);
                            view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                        } else {
                            if (pin)
                                view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                            else
                                view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);

                            view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.GONE);
                            view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                        }
                        view.findViewById(R.id.retry_text).setVisibility(View.VISIBLE);
                        view.findViewById(R.id.regenerate_layout).setVisibility(View.VISIBLE);
                        view.findViewById(R.id.approve).setVisibility(View.GONE);
                        view.findViewById(R.id.waiting).setVisibility(View.GONE);
                        view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);
                        view.findViewById(R.id.retry).setOnClickListener(buttonClickListener);
                        view.findViewById(R.id.enter_manually).setOnClickListener(buttonClickListener);
                        updateHeight(view);
                    }
                } else {
                    if (timer != null) {
                        timer.cancel();
                        timer.purge();
                    }
                    timer = new Timer();
                    timer.scheduleAtFixedRate(new TimerTask() {  // Timer to gain user's attention while waiting for otp.

                        @Override
                        synchronized public void run() {
                            if (activity != null) {

                                activity.runOnUiThread(enterOtpRunnable);  // updating time.

                            }
                        }
                    }, 0, 1000);
                }

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    if (!getArguments().getBoolean(MERCHANT_SMS_PERMISSION) || !permissionGranted) {// if we dont have permission to read sms or merchant has set MERCHANT_SMS_PERMISSION flag false then we follow the IOS flow...

                        final EditText otpSMS = (EditText) view.findViewById(R.id.otp_sms);
                       // final Button approveButton = (Button) view.findViewById(R.id.approve);
                        approveButton.setClickable(false);
                        LinearLayout otpLayout = (LinearLayout) view.findViewById(R.id.linear_layout_waiting_for_otp);


                        otpLayout.setOnTouchListener(new View.OnTouchListener() {
                            @Override
                            public boolean onTouch(View v, MotionEvent event) {
                                if (event.getAction() == MotionEvent.ACTION_DOWN) {
                                    if (otpSMS.isFocused()) {
                                        Rect outRect = new Rect();
                                        otpSMS.getGlobalVisibleRect(outRect);
                                        if (!outRect.contains((int)event.getRawX(), (int)event.getRawY())) {
                                            otpSMS.clearFocus();
                                            InputMethodManager imm = (InputMethodManager) v.getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
                                            imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
                                        }
                                    }
                                }
                                return false;
                            }
                        });


                        otpSMS.setVisibility(View.VISIBLE);
                        approveButton.setVisibility(View.VISIBLE);
                        view.findViewById(R.id.waiting).setVisibility(View.GONE);
                        view.findViewById(R.id.progress).setVisibility(View.GONE);
                        view.findViewById(R.id.regenerate_layout).setVisibility(View.VISIBLE);
                        view.findViewById(R.id.Enter_manually_gone).setVisibility(View.GONE);


                        otpSMS.addTextChangedListener(new TextWatcher() {

                            @Override
                            public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {

                            }

                            @Override
                            public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                                String otp = ((EditText) view.findViewById(R.id.otp_sms)).getText().toString();
                                if (otp.length() > 5) {
                                    buttonClickListener.setView(view);
                                    approveButton.setOnClickListener(buttonClickListener);
                                    approveButton.setClickable(true);
                                    CBUtil.setAlpha(1, approveButton);


                                } else {
                                    float val = (float) .3;
                                    approveButton.setClickable(false);
                                    CBUtil.setAlpha(val, approveButton);
                                    approveButton.setOnClickListener(null);
                                }
                            }

                            @Override
                            public void afterTextChanged(Editable editable) {

                            }
                        });

//
                    }

                }

            } catch (Exception e) {
                e.printStackTrace();
            }

            final int TIME_WAIT_FOR_SMS;
            if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && !permissionGranted){// while permission is denied we follow IOS flow and we will wait for 45 secs before showing regenerate layout
                TIME_WAIT_FOR_SMS = 45;
            }else{
                TIME_WAIT_FOR_SMS=30;
            }

            enterOtpRunnable = new Runnable() {
                // update every seconds.Build.VERSION.SDK_INT >= Build.VERSION_CODES.M

                int i = TIME_WAIT_FOR_SMS;
                EditText otpSMS = (EditText) view.findViewById(R.id.otp_sms);

                @Override
                public void run() {
                    if (i == 0) {
                        try {
                            if (activity != null && view.isShown() && activity.findViewById(R.id.otp_sms) != null /*&& ((TextView) activity.findViewById(R.id.otp_sms)).getVisibility() != View.VISIBLE*/) {
                                timerView.setVisibility(View.GONE);

                                JSONObject p = new JSONObject(params);
                                final boolean regenerate = p.has(getString(R.string.cb_regenerate)) && p.getBoolean(getString(R.string.cb_regenerate));
                                final boolean pin = p.has(getString(R.string.cb_pin)) && p.getBoolean(getString(R.string.cb_pin));


                                view.findViewById(R.id.retry_text).setVisibility(View.VISIBLE);
                                if (regenerate) {
                                    view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.VISIBLE);
                                    view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);
                                    view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                                } else {
                                    if (pin)
                                        view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                                    else
                                        view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);

                                    view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.GONE);
                                    view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                                }
                                view.findViewById(R.id.retry_text).setVisibility(View.VISIBLE);
                                view.findViewById(R.id.regenerate_layout).setVisibility(View.VISIBLE);
                                view.findViewById(R.id.approve).setVisibility(View.GONE);
                                view.findViewById(R.id.waiting).setVisibility(View.GONE);
                                view.findViewById(R.id.otp_sms).setVisibility(View.GONE);
                                view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);
                                view.findViewById(R.id.retry).setOnClickListener(buttonClickListener);
                                view.findViewById(R.id.enter_manually).setOnClickListener(buttonClickListener);
                                updateHeight(view);
                            }

                        } catch (Exception e) {

                            e.printStackTrace();
                        }

                    } else if(!otpSMS.hasFocus() && otpSMS.getText().toString().matches("")){
                        if (i == TIME_WAIT_FOR_SMS)
                            timerView.setVisibility(View.VISIBLE);
                        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && !permissionGranted) {
                            if (i != 1) {
                                String input=i + "  secs remaining to regenerate OTP\n";
                                timerView.setText(input);
                            } else {
                                String input=i + " sec remaining to regenerate OTP\n";
                                timerView.setText(input);
                            }
                        }else {
                            timerView.setText(i+"");
                        }

                        i--;
                    }
                }
            };

            if (mPassword != null && activity.findViewById(R.id.otp_sms) != null && !(activity.findViewById(R.id.otp_sms).getVisibility() == View.VISIBLE)) {

                if (timer != null)
                    timer.cancel();

                activity.findViewById(R.id.timer).setVisibility(View.GONE);

                if (eventRecorded.equals(CBConstant.PAYMENT_INITIATED)|| eventRecorded.equals(CBConstant.CUSTOM_BROWSER)) {
                    eventRecorded = CBConstant.RECEIVED_OTP_DIRECT;
                    addEventAnalytics(CBConstant.OTP_RECIEVED, eventRecorded);
                }

                ((TextView) view.findViewById(R.id.otp_sms)).setText(mPassword);


                approveButton.setText(getString(R.string.cb_approve_otp));
                approveButton.setClickable(true);

                if (autoApprove) {
                    approveButton.performClick();
                    eventRecorded = CBConstant.CB_AUTO_APPROVE;
                    addEventAnalytics(CBConstant.USER_INPUT, eventRecorded);
                }

                //approve.setAlpha(1);
                CBUtil.setAlpha(1, approveButton);
                activity.findViewById(R.id.otp_recieved).setVisibility(View.VISIBLE);

                CustomProgressBar.removeDialog(mProgress);
                view.findViewById(R.id.retry_text).setVisibility(View.GONE);
                view.findViewById(R.id.regenerate_layout).setVisibility(View.GONE);

                view.findViewById(R.id.approve).setVisibility(View.VISIBLE);
                view.findViewById(R.id.waiting).setVisibility(View.GONE);
                view.findViewById(R.id.otp_sms).setVisibility(View.VISIBLE);
                buttonClickListener.setView(view);
                view.findViewById(R.id.approve).setOnClickListener(buttonClickListener);

            }
            updateHeight(view);
            if (helpView.isShown()) {
                frameState = MAXIMISED;
            } else {
                maximiseWebviewHeight();
            }
        }
    }



    /**
     * Maximize the webview and changes the cb to minimize state
     */
    private void update() {
        maximiseWebviewHeight();
        frameState = MINIMISED;
        onHelpUnavailable();
    }

    /**
     * Displaying Payuloader.
     *
     * @param context base activity context
     * @return progress dialog.
     */
    private ProgressDialog showProgress(Context context) {

        if (null != activity && this.isAdded() && context != null && !activity.isFinishing()) {
            LayoutInflater mInflater = LayoutInflater.from(context);
            final Drawable[] drawables =
                    {CBUtil.getDrawableCB(activity, R.drawable.l_icon1),
                            CBUtil.getDrawableCB(activity, R.drawable.l_icon2),
                            CBUtil.getDrawableCB(activity, R.drawable.l_icon3),
                            CBUtil.getDrawableCB(activity, R.drawable.l_icon4)
                    };

            View layout = mInflater.inflate(R.layout.cb_prog_dialog, null);
            final ImageView imageView = (ImageView) layout.findViewById(R.id.imageView);

            ProgressDialog progDialog = new ProgressDialog(context, R.style.cb_progress_dialog);

            final Timer timer = new Timer();
            timer.scheduleAtFixedRate(new TimerTask() {
                int i = -1;

                @Override
                synchronized public void run() {
                    if (activity != null) {
                        activity.runOnUiThread(new Runnable() {
                                                   @Override
                                                   public void run() {
                                                       if (activity != null) {
                                                           i++;
                                                           if (i >= drawables.length) {
                                                               i = 0;
                                                           }
                                                           imageView.setImageBitmap(null);
                                                           imageView.destroyDrawingCache();
                                                           imageView.refreshDrawableState();
                                                           imageView.setImageDrawable(drawables[i]);
                                                       }
                                                   }
                                               }
                        );
                    }

                }
            }, 0, 500);

            progDialog.show();
            progDialog.setContentView(layout);
            progDialog.setCancelable(true);
            progDialog.setCanceledOnTouchOutside(false);
            progDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                @Override
                public void onDismiss(DialogInterface dialog) {
                    timer.cancel();
                    if (checkProgress == PRE_PAYMENT)
                        checkProgress = DURING_PAYMENT;
                }
            });
            return progDialog;
        }

        return null;
    }

    /**
     * Funtion to show or hide the progress bar.
     *
     * @param visibility possible values View.VISIBLE, View.GONE, View.INVISIBLE
     */
    private void progressBarVisibilityPayuChrome(int visibility) {
        if (visibility == View.GONE || visibility == View.INVISIBLE) {

            if (progressDialog != null && progressDialog.isShowing()) {
                progressDialog.dismiss();
                checkForInput = 1;
            }
        } else if (progressDialog == null) {
            progressDialog = showProgress(activity);
        }
    }


    /**
     * Custom onClick listener for cb's buttons.
     */
    public class ButtonOnclickListener implements View.OnClickListener {
        private View view_edit;

        public void setView(View view_ed) {
            this.view_edit = view_ed;
        }

        @Override
        public void onClick(View v) {
            String str = "";
            if (v instanceof Button) // we have buttons.
                str = (((Button) v).getText()).toString();
            else if (v instanceof TextView) // we have textviews too!.
                str = (((TextView) v).getText()).toString();
            int code = CBUtil.getCode(str.toLowerCase());
            switch (code) {
                case REGENERATE_OTP:
                    try {
                        eventRecorded = CBConstant.REGENERATE;
                        addEventAnalytics(CBConstant.USER_INPUT, eventRecorded);

                        mPassword = null;
                        mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_regen_otp)));
                        prepareSmsListener();
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case SMS_OTP:
                case OTP:
                    SMSOTPClicked = true;
                    checkPermission();
                    eventRecorded = CBConstant.OTP_CLICK;
                    addEventAnalytics(CBConstant.USER_INPUT, eventRecorded);

                    if(Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
                        mPassword = null;
                        prepareSmsListener();
                    }
                   // mCVClicked = true;

//                    try {
//                        checkPermission();
//                        eventRecorded = CBConstant.OTP;
//                        addEventAnalytics(CBConstant.USER_INPUT,eventRecorded);
//
//                        mPassword = null;
//                        prepareSmsListener();
//                        mCVClicked = true;
//                        mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_otp)));
//                    } catch (JSONException e) {
//                        e.printStackTrace();
//                    }

                    break;
                case APPROVE:
                    try {

                        cbUtil.hideKeyboardForcefully(activity);
                        mPassword = null;
                        checkLoading = false;
                        approve_flag = true;

                        onHelpUnavailable();
                        maximiseWebviewHeight();
                        frameState = MINIMISED;
                        prepareSmsListener();
                        if (((EditText) view_edit.findViewById(R.id.otp_sms)).getText().toString().length() > 5) {
                            eventRecorded = CBConstant.APPROVED_OTP;
                            addEventAnalytics(CBConstant.USER_INPUT, eventRecorded);

                            mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_process_otp)) + "(\"" + ((TextView) activity.findViewById(R.id.otp_sms)).getText().toString() + "\")");
                        }

                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case ENTER_MANUALLY: {
                    final View view = activity.getLayoutInflater().inflate(R.layout.wait_for_otp, null);
                    eventRecorded = CBConstant.ENTER_MANUALLY_CLICK;

                    addEventAnalytics(CBConstant.USER_INPUT, eventRecorded);

                    if (chooseActionHeight == 0) {
                        view.measure(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                        chooseActionHeight = view.getMeasuredHeight();
                    }

                    helpView.removeAllViews();
                    helpView.addView(view);

                    if (helpView.isShown()) {
                        frameState = MAXIMISED;
                    } else {
                        maximiseWebviewHeight();
                    }

                    ImageView im = (ImageView) view.findViewById(R.id.bank_logo);


                    if (drawable != null)
                        im.setImageDrawable(drawable);

                    view.findViewById(R.id.waiting).setVisibility(View.GONE);
                    float val = (float) .3;
                    final Button approveButton = (Button) view.findViewById(R.id.approve);
                    approveButton.setClickable(false);

                    EditText otpSMS = (EditText) view.findViewById(R.id.otp_sms);
                    cbUtil.showSoftKeyboard(otpSMS,activity);


                    // approveButton.setAlpha(val);
                    CBUtil.setAlpha(val, approveButton);

                    approveButton.setVisibility(View.VISIBLE);
                    otpSMS.setVisibility(View.VISIBLE);
                    view.findViewById(R.id.regenerate_layout).setVisibility(View.GONE);
                    view.findViewById(R.id.progress).setVisibility(View.INVISIBLE);
                    cbUtil.showSoftKeyboard(otpSMS, activity);

                    otpSMS.addTextChangedListener(new TextWatcher() {

                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                            String otp = ((EditText) view.findViewById(R.id.otp_sms)).getText().toString();
                            if (otp.length() > 5) {
                                buttonClickListener.setView(view);
                                approveButton.setOnClickListener(buttonClickListener);
                                approveButton.setClickable(true);
                                //  approveButton.setAlpha(1);
                                CBUtil.setAlpha(1, approveButton);


                            } else {
                                float val = (float) .3;
                                approveButton.setClickable(false);
                                // approveButton.setAlpha(val);
                                CBUtil.setAlpha(val, approveButton);
                                approveButton.setOnClickListener(null);
                            }
                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                        }
                    });
                    updateHeight(view);
                }
                break;

                case PASSWORD:
                case PIN:
                    pin_selected_flag = true;
                    approve_flag = true;
                    maximiseWebviewHeight();
                    frameState = MINIMISED;
                    onHelpUnavailable();

                    if (viewarrow != null)
                        viewarrow.setVisibility(View.GONE);

                    if (transView != null)
                        transView.setVisibility(View.GONE);
                //    mCVClicked = true;
                    try {
                        mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_pin)));
                        eventRecorded = CBConstant.PASSWORD_CLICK;
                        addEventAnalytics(CBConstant.USER_INPUT, eventRecorded);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case DEFAULT:
                    if (DEBUG)
                        Toast.makeText(activity, "button text not matching any click listener option", Toast.LENGTH_SHORT).show();
                    break;

            }

        }
    }

    /**
     * This function takes care of sending the data back to calling activity with the status, merchantResponse, payuresponse.
     */
     void onMerchantUrlFinished(){
        // finish the activity.
        // finish the activity.

        if (activity != null) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (activity != null && !activity.isFinishing() && Bank.this.isAdded()) {
                        Intent intent = new Intent();
                        intent.putExtra(getString(R.string.cb_result), merchantResponse);
                        intent.putExtra(getString(R.string.cb_payu_response), payuReponse);
                        if(storeOneClickHash == CBConstant.STORE_ONE_CLICK_HASH_SERVER && null != merchantHash){
                            intent.putExtra(CBConstant.MERCHANT_HASH, merchantHash);
                        }
                        if(isSuccessTransaction)
                            activity.setResult(Activity.RESULT_OK, intent);
                        else
                            activity.setResult(Activity.RESULT_CANCELED, intent);


                        activity.finish();
                    }
                }
            });
        }
    }

    /**
     * Helper function return the availablity of payu response given by {@link #onPayuSuccess(String)}
     * @return true or false.
     */
    boolean isPayuResponseReceived(){
        return null != payuReponse;
    }


    /**
     * Just to make sure we finish activity even if the merchant's url got into trouble,
     * should be called from {@link #onPayuSuccess(String)} or {@link #onPayuFailure(String)}
     */
   private void callTimer(){
        new CountDownTimer(5000, 1000) {

            public void onTick(long millisUntilFinished) {
                // tick tick tick tick....
            }

            public void onFinish() {
                if(activity != null){
                    activity.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            if (activity != null && !activity.isFinishing() && Bank.this.isAdded()) {
                                onMerchantUrlFinished();
                            }
                        }
                    });
                }
            }
        }.start();
    }

    /**
     * add the progress bar to the layout
     */
    private void addProgressBar(){
        progressBar = new ProgressBar(activity,null,android.R.attr.progressBarStyleHorizontal);
        progressBar.setMax(100);
        progressBar.setProgressDrawable(CBUtil.getDrawableCB(activity, R.drawable.cb_progress_bar));
        progressBar.setVisibility(View.VISIBLE);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT,(int)getResources().getDimension(R.dimen.cb_progress_bar_height));
        params.addRule(RelativeLayout.ALIGN_PARENT_TOP);
        progressBar.setLayoutParams(params);
        ((RelativeLayout)activity.findViewById(getArguments().getInt("mainLayout"))).addView(progressBar, params);

        /*(new Handler()).postDelayed(new Runnable() {
            @Override
            public void run() {
                Log.d("testing ","addProgressBar handler--"+progressBar.getProgress());
                if(progressBar.getProgress()!=0 && progressBar.getProgress()!=100){
                    startAnimation(progressBar.getProgress());
                }
            }
        },5);*/
       /*final Timer mTimer = new Timer();

        final TimerTask task = new TimerTask() {
            @Override
            public void run() {
                activity.runOnUiThread(new Runnable() {

                    @Override
                    public void run() {
                        Log.d("testing ", "addProgressBar handler--"+progressBar.getProgress());
                        if(progressBar.getProgress()!=0 && progressBar.getProgress()!=100){
                            startAnimation(progressBar.getProgress());
                        }
                    }});
            }
        };
        mTimer.schedule(task,500,500);*/
    }


    /**
     * Start animation of progress bar
     * @param newProgress updated progress of weburl
     */
     private void startAnimation(int newProgress){
        if(lastProgress>newProgress)
            progressBar.setProgress(newProgress);
        if(Build.VERSION.SDK_INT>=11) {
            ObjectAnimator animation = ObjectAnimator.ofInt(progressBar, "progress", newProgress);
            animation.setDuration(50); // 0.5 second
            animation.setInterpolator(new AccelerateInterpolator());
            animation.start();
        }else{
            progressBar.setProgress(newProgress);
        }
        lastProgress=newProgress;
    }


    /**
     * update progress bar according to progress recieved
     *
     * @param progress percentage completion of loading url
     */
     void onProgressChanged(int progress){
        if(progressBar!=null) {
            progressBar.setVisibility(View.VISIBLE);
            // progressBar.setProgress(progress);

            if(progress==100){
                if (progressBar != null) {
                    progressBar.setProgress(100);
                    Handler handler = new Handler();
                    handler.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            if (activity != null) {
                                progressBar.setVisibility(View.GONE);
                                progressBar.setProgress(0);
                                lastProgress = 0;
                            /*final Animation animation = AnimationUtils.loadAnimation(activity, R.anim.cb_face_out);
                            progressBar.startAnimation(animation);
                            Handler handler = new Handler();
                            handler.postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    progressBar.setProgress(0);
                                    progressBar.setVisibility(View.GONE);
                                }
                            }, 500);
                        }*/
                            }
                        }
                    }, 100);
                }
            }else{
                startAnimation(progress);
            }
           /* if (progress == 100) {
                Log.d("testing", "testing onProgressChanged progress ==100" +progress);
                progressBar.setProgress(100);
                Handler handler = new Handler();
                handler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (activity != null) {
                            Log.d("testing", "testing onProgressChanged inside handler");
                            progressBar.setVisibility(View.GONE);
                            progressBar.setProgress(0);
                            lastProgress=0;
                            *//*final Animation animation = AnimationUtils.loadAnimation(activity, R.anim.cb_face_out);
                            progressBar.startAnimation(animation);
                            Handler handler = new Handler();
                            handler.postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    progressBar.setProgress(0);
                                    progressBar.setVisibility(View.GONE);
                                }
                            }, 500);
                        }*//*
                    }
                }}, 50);
            }*/
        }
    }



    /**
     * Finds the corresponding image name for the given bank
     *
     * @param bankNameImage bank image name
     */
    private void getDrawable(final String bankNameImage) {
        if (drawable == null) {
            if (bankNameImage != null) {
                try {

                    if (bankNameImage.equalsIgnoreCase("sbinet")||bankNameImage.equalsIgnoreCase("sbi"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.sbi);
                    else if (bankNameImage.equalsIgnoreCase("icici")||bankNameImage.equalsIgnoreCase("icicinet") || bankNameImage.equalsIgnoreCase("icicicc"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.icici);
                    else if (bankNameImage.equalsIgnoreCase("kotaknet")||bankNameImage.equalsIgnoreCase("kotak"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.kotak);
                    else if (bankNameImage.equalsIgnoreCase("indus"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.induslogo);
                    else if (bankNameImage.equalsIgnoreCase("hdfc")||bankNameImage.equalsIgnoreCase("hdfcnet"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.hdfc_bank);
                    else if (bankNameImage.equalsIgnoreCase("yesnet"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.yesbank_logo);
                    else if (bankNameImage.equalsIgnoreCase("sc"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.scblogo);
                    else if (bankNameImage.equalsIgnoreCase("axisnet")||bankNameImage.equalsIgnoreCase("axis"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.axis_logo);
                    else if (bankNameImage.equalsIgnoreCase("amex"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.cb_amex_logo);
                    else if (bankNameImage.equalsIgnoreCase("hdfcnet")||bankNameImage.equalsIgnoreCase("hdfc"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.hdfc_bank);
                    else if (bankNameImage.equalsIgnoreCase("ing"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.ing_logo);
                    else if (bankNameImage.equalsIgnoreCase("idbi"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.idbi);
                    else if (bankNameImage.equalsIgnoreCase("citi"))
                        drawable = CBUtil.getDrawableCB(activity, R.drawable.citi);
                    else
                        drawable =null;

                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        }
    }

    void setAnalyticsKey(String analyticsKey){
        if(keyAnalytics==null ||keyAnalytics.trim().equals("")){
            keyAnalytics=analyticsKey;
        }
    }

    //set of callback functions for back button

    //'OK' is pressed on alertdialog
    public void onBackApproved(){

    }

    //'Cancel' is pressed on alertdialog
    public void onBackCancelled(){

    }

    //provide the alertdialog builder to merchant
    public void onBackPressed(AlertDialog.Builder dialog){

    }




}