/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.app.Activity;
import android.os.AsyncTask;
import com.payu.custombrowser.CBUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PayuDeviceAnalytics {
    private static long TIMER_DELAY = 0L;
    private final Activity mActivity;
    static final String TEST_URL_DEVICE_ANALYTICS = "https://mobiletest.payu.in/merchant/mobileWebService.php";
    static final String PRODUCTION_URL_DEVICE_ANALYTICS = "https://info.payu.in/merchant/mobileWebService.php";
    private String ANALYTICS_URL = "https://info.payu.in/merchant/mobileWebService.php";
    private boolean mIsLocked = false;
    private ArrayList<String> mBuffer = new ArrayList();
    private Timer mTimer;
    private String file_name = "cb_local_cache_device";

    public PayuDeviceAnalytics(Activity activity, final String fileName) {
        this.mActivity = activity;
        this.file_name = fileName;
        final Thread.UncaughtExceptionHandler defaultUEH = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler _unCaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                while (PayuDeviceAnalytics.this.mIsLocked) {
                }
                PayuDeviceAnalytics.this.setLock();
                try {
                    FileOutputStream fileOutputStream = PayuDeviceAnalytics.this.mActivity.openFileOutput(fileName, 0);
                    int c = PayuDeviceAnalytics.this.mBuffer.size();
                    for (int i = 0; i < c; ++i) {
                        fileOutputStream.write(((String)PayuDeviceAnalytics.this.mBuffer.get(i) + "\r\n").getBytes());
                    }
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                PayuDeviceAnalytics.this.releaseLock();
                defaultUEH.uncaughtException(thread, ex);
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(_unCaughtExceptionHandler);
    }

    public void log(String msg) {
        if (this.mIsLocked) {
            this.mBuffer.add(msg);
        } else {
            this.setLock();
            try {
                int c;
                JSONObject newobject = new JSONObject(msg);
                JSONArray jsonArray = new JSONArray();
                String temp = "";
                File file = new File(this.mActivity.getFilesDir(), this.file_name);
                if (!file.exists()) {
                    this.mActivity.openFileOutput(this.file_name, 0);
                }
                FileInputStream fileInputStream = this.mActivity.openFileInput(this.file_name);
                while ((c = fileInputStream.read()) != -1) {
                    temp = temp + Character.toString((char)c);
                }
                jsonArray = temp.equalsIgnoreCase("") ? new JSONArray() : new JSONArray(temp);
                fileInputStream.close();
                FileOutputStream fileOutputStream = this.mActivity.openFileOutput(this.file_name, 0);
                jsonArray.put(jsonArray.length(), (Object)newobject);
                fileOutputStream.write(jsonArray.toString().getBytes());
                fileOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.mBuffer.add(msg);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.releaseLock();
        }
        this.resetTimer();
    }

    private void resetTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int c;
                while (PayuDeviceAnalytics.this.mIsLocked) {
                }
                TIMER_DELAY = 5000L;
                PayuDeviceAnalytics.this.setLock();
                String temp = "";
                try {
                    File file = new File(PayuDeviceAnalytics.this.mActivity.getFilesDir(), PayuDeviceAnalytics.this.file_name);
                    if (!file.exists()) {
                        PayuDeviceAnalytics.this.mActivity.openFileOutput(PayuDeviceAnalytics.this.file_name, 0);
                    }
                    FileInputStream fileInputStream = PayuDeviceAnalytics.this.mActivity.openFileInput(PayuDeviceAnalytics.this.file_name);
                    while ((c = fileInputStream.read()) != -1) {
                        temp = temp + Character.toString((char)c);
                    }
                    fileInputStream.close();
                    c = PayuDeviceAnalytics.this.mBuffer.size();
                }
                catch (IOException e) {
                    int c22;
                    try {
                        e.printStackTrace();
                        c22 = PayuDeviceAnalytics.this.mBuffer.size();
                    }
                    catch (Throwable throwable) {
                        int c22 = PayuDeviceAnalytics.this.mBuffer.size();
                        while (c22 > 0) {
                            temp = temp + (String)PayuDeviceAnalytics.this.mBuffer.get(--c22) + "\r\n";
                            if (c22 < 0 || PayuDeviceAnalytics.this.mBuffer.size() <= c22) continue;
                            PayuDeviceAnalytics.this.mBuffer.remove(c22);
                        }
                        if ((temp = temp.trim()).length() > 0) {
                            new UploadData(temp).execute(new String[]{temp});
                        }
                        throw throwable;
                    }
                    while (c22 > 0) {
                        temp = temp + (String)PayuDeviceAnalytics.this.mBuffer.get(--c22) + "\r\n";
                        if (c22 < 0 || PayuDeviceAnalytics.this.mBuffer.size() <= c22) continue;
                        PayuDeviceAnalytics.this.mBuffer.remove(c22);
                    }
                    if ((temp = temp.trim()).length() > 0) {
                        new UploadData(temp).execute(new String[]{temp});
                    }
                }
                while (c > 0) {
                    temp = temp + (String)PayuDeviceAnalytics.this.mBuffer.get(--c) + "\r\n";
                    if (c < 0 || PayuDeviceAnalytics.this.mBuffer.size() <= c) continue;
                    PayuDeviceAnalytics.this.mBuffer.remove(c);
                }
                if ((temp = temp.trim()).length() > 0) {
                    new UploadData(temp).execute(new String[]{temp});
                }
                if (PayuDeviceAnalytics.this.mBuffer.size() > 0) {
                    PayuDeviceAnalytics.this.resetTimer();
                }
                PayuDeviceAnalytics.this.releaseLock();
            }
        }, TIMER_DELAY);
    }

    synchronized void setLock() {
        this.mIsLocked = true;
    }

    synchronized void releaseLock() {
        this.mIsLocked = false;
    }

    public static JSONArray removeJsonObjectAtJsonArrayIndex(JSONArray source, int index) throws JSONException {
        if (index < 0 || index > source.length() - 1) {
            throw new IndexOutOfBoundsException();
        }
        JSONArray copy = new JSONArray();
        int count = source.length();
        for (int i = 0; i < count; ++i) {
            if (i == index) continue;
            copy.put(source.get(i));
        }
        return copy;
    }

    public class UploadData
    extends AsyncTask<String, Void, String> {
        private String temp;

        UploadData(String temp) {
            this.temp = temp;
        }

        protected void onPostExecute(String aVoid) {
            super.onPostExecute((Object)aVoid);
        }

        protected String doInBackground(String ... strarr) {
            block24: {
                try {
                    try {
                        JSONArray jsonArray = new JSONArray(strarr[0]);
                        ArrayList keyArr = new ArrayList();
                        JSONArray editorJsonArray = jsonArray;
                        for (int j = 0; j < editorJsonArray.length(); ++j) {
                            if (!CBUtil.getbooleanSharedPreference(((JSONObject)editorJsonArray.get(j)).getString("merchant_key") + "|" + ((JSONObject)editorJsonArray.get(j)).getString("txnid"), PayuDeviceAnalytics.this.mActivity)) continue;
                            jsonArray = PayuDeviceAnalytics.removeJsonObjectAtJsonArrayIndex(editorJsonArray, j);
                        }
                        if (jsonArray.length() > 0) {
                            int i;
                            String postData = "mobile_data=" + jsonArray.toString();
                            byte[] postParamsByte = postData.getBytes("UTF-8");
                            URL url = new URL(PayuDeviceAnalytics.this.ANALYTICS_URL);
                            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                            conn.setRequestMethod("POST");
                            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            conn.setRequestProperty("Content-Length", String.valueOf(postData.length()));
                            conn.setDoOutput(true);
                            conn.getOutputStream().write(postParamsByte);
                            int responseCode = conn.getResponseCode();
                            InputStream responseInputStream = conn.getInputStream();
                            StringBuffer responseStringBuffer = new StringBuffer();
                            byte[] byteContainer = new byte[1024];
                            while ((i = responseInputStream.read(byteContainer)) != -1) {
                                responseStringBuffer.append(new String(byteContainer, 0, i));
                            }
                            if (responseCode == 200) {
                                try {
                                    JSONObject jsonObject = new JSONObject(responseStringBuffer.toString());
                                    if (jsonObject.has("status") && !jsonObject.getString("status").equalsIgnoreCase("")) {
                                        if (jsonObject.has("status") && (jsonObject.getString("status").equalsIgnoreCase("1") || jsonObject.getString("status").equalsIgnoreCase("-1"))) {
                                            PayuDeviceAnalytics.this.mActivity.deleteFile(PayuDeviceAnalytics.this.file_name);
                                            for (int j = 0; j < jsonArray.length(); ++j) {
                                                CBUtil.setBooleanSharedPreference(((JSONObject)jsonArray.get(j)).getString("merchant_key") + "|" + ((JSONObject)jsonArray.get(j)).getString("txnid"), true, PayuDeviceAnalytics.this.mActivity);
                                            }
                                        } else {
                                            try {
                                                FileOutputStream fileOutputStream = PayuDeviceAnalytics.this.mActivity.openFileOutput(PayuDeviceAnalytics.this.file_name, 0);
                                                fileOutputStream.write(this.temp.getBytes());
                                                fileOutputStream.close();
                                            }
                                            catch (IOException e1) {
                                                e1.printStackTrace();
                                            }
                                        }
                                        break block24;
                                    }
                                    try {
                                        FileOutputStream fileOutputStream = PayuDeviceAnalytics.this.mActivity.openFileOutput(PayuDeviceAnalytics.this.file_name, 0);
                                        fileOutputStream.write(this.temp.getBytes());
                                        fileOutputStream.close();
                                        break block24;
                                    }
                                    catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    try {
                                        FileOutputStream fileOutputStream = PayuDeviceAnalytics.this.mActivity.openFileOutput(PayuDeviceAnalytics.this.file_name, 0);
                                        fileOutputStream.write(this.temp.getBytes());
                                        fileOutputStream.close();
                                        break block24;
                                    }
                                    catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                break block24;
                            }
                            try {
                                FileOutputStream fileOutputStream = PayuDeviceAnalytics.this.mActivity.openFileOutput(PayuDeviceAnalytics.this.file_name, 0);
                                fileOutputStream.write(this.temp.getBytes());
                                fileOutputStream.close();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            break block24;
                        }
                        PayuDeviceAnalytics.this.mActivity.deleteFile(PayuDeviceAnalytics.this.file_name);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    catch (ProtocolException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

