/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import com.payu.custombrowser.Bank;
import com.payu.magicretry.MagicRetryFragment;
import com.payu.magicretry.WebClient.MagicRetryWebViewClient;

public class PayUWebViewClient
extends MagicRetryWebViewClient {
    boolean loadingFinished = true;
    boolean redirect = false;
    String mainUrl = "";
    private Bank bank;
    private boolean isMerchantUrlStarted;

    public PayUWebViewClient(Bank bank) {
        this.bank = bank;
    }

    public PayUWebViewClient(Bank bank, MagicRetryFragment magicRetryFragment) {
        super(magicRetryFragment);
        this.bank = bank;
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.loadingFinished = false;
        if (this.bank != null) {
            this.bank.onPageStartedWebclient(url);
        }
        if (this.bank.isPayuResponseReceived()) {
            this.isMerchantUrlStarted = true;
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (!this.redirect) {
            this.loadingFinished = true;
        }
        if (url.equals(this.mainUrl)) {
            this.loadingFinished = true;
            this.redirect = false;
        } else {
            this.redirect = false;
        }
        if (this.bank != null) {
            this.bank.onPageFinishWebclient(url);
        }
        if (this.isMerchantUrlStarted) {
            this.bank.onMerchantUrlFinished();
        }
    }

    public void onLoadResource(WebView view, String url) {
        if (this.bank != null) {
            this.bank.onLoadResourse(view, url);
        }
        super.onLoadResource(view, url);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        if (this.bank != null) {
            this.bank.onReceivedErrorWebClient(errorCode, description, failingUrl);
        }
    }

    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        super.onReceivedError(view, request, error);
        if (this.bank != null) {
            this.bank.onReceivedErrorWebClient(error.getErrorCode(), error.getDescription().toString(), request.getUrl().toString());
        }
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        if (Build.VERSION.SDK_INT <= 10) {
            handler.proceed();
        } else if (Build.VERSION.SDK_INT >= 14) {
            if (error.getUrl().contains("https://jsbeasynet.jsbnet.in")) {
                handler.proceed();
            } else if (this.bank != null) {
                this.bank.onReceivedErrorWebClient(-1, null, null);
            }
        } else if (error.getCertificate().toString().contains("jsbeasynet.jsbnet.in")) {
            handler.proceed();
        } else if (this.bank != null) {
            this.bank.onReceivedErrorWebClient(-1, null, null);
        }
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        this.mainUrl = url;
        if (!this.loadingFinished) {
            this.redirect = true;
        }
        this.loadingFinished = false;
        if (this.bank != null) {
            this.bank.onOverrideURL();
        }
        return super.shouldOverrideUrlLoading(view, url);
    }
}

