// The MIT License (MIT)
//
// Copyright (c) 2014-2015 PayU India
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package com.payu.custombrowser;

import android.Manifest;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.telephony.SmsMessage;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.TranslateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import android.widget.Toast;

import com.mixpanel.android.mpmetrics.MixpanelAPI;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

/**
 * Custom browser's Fragment.
 * Keeping it as abstract for providing call back function to implementing Activities.
 * Following functions needs to be overridden.
 * {@link Bank#registerBroadcast(BroadcastReceiver, IntentFilter)}}
 * {@link Bank#unregisterBroadcast(BroadcastReceiver)}
 * {@link Bank#onHelpAvailable()}
 * {@link Bank#onHelpUnavailable()}
 * {@link Bank#onBankError()}
 */

public abstract class Bank extends Fragment {
    public static final boolean DEBUG = false;
    public static final String TXN_ID = "txnid";
    public static final String MERCHANT_KEY = "merchantid";
    public static final String SDK_DETAILS = "sdkname";
    public static final String WEBVIEW = "webView";
    public static final String TRANS_LAYOUT = "tranLayout";
    public static final String MAIN_LAYOUT = "mainLayout";
    public static final String INITURL = "intURL";
    public static final String DATA = "data";
    public static final String VIEWPORTWIDE = "viewPortWide";
    public static final String SHOW_CUSTOMROWSER = "showCustom";
    private static final String TEST_URL = "https://mobiletest.payu.in/js/sdk_js/v3/";
    private static final String PRODUCTION_URL = "https://secure.payu.in/js/sdk_js/v3/";
    private final static int MINIMISED = 1;
    private final static int MAXIMISED = 2;
    private final static int PASSWORD = 1;
    private final static int REGENERATE_OTP = 2;
    private final static int PIN = 3;
    private final static int ENTER_MANUALLY = 4;
    private final static int APPROVE = 5;
    private final static int OTP = 6;
    private final static int SMS_OTP = 7;
    private final static int DEFAULT = 0;
    private final int PRE_PAYMENT = 1;
    private final int DURING_PAYMENT = 2;
    private final int POST_PAYMENT = 3;
    private final String WV_KEY_VIEWPORT = "viewPortWide";
    protected JSONObject mJS;
    protected WebView mWebView;
    private String CB_URL = DEBUG ? TEST_URL : PRODUCTION_URL;
    private BroadcastReceiver mBroadcastReceiver;
    private JSONObject mBankJS;
    private boolean mLoadingJS = false;
    private int loading_height, minWebview, maxWebview;
    private int frameState;
    private boolean mCVClicked = false;
    private String bank_logo;
    private boolean pin_selected_flag;
    private int chooseActionHeight;
    private Boolean approve_flag = false;
    private int c_hdfc = 0;
    private Set<String> urlSet = new HashSet<String>();
    private Set<String> postPaymentURL = new HashSet<String>();
    private String url = "https://secure.payu.in/_payment_options";
    private String bankName;
    private View viewarrow;
    private boolean mPageReady = false;
    private String mPassword;
    private View transView;
    private String mTxnID;
    private CBAnalytics mAnalytics;
    private boolean checkLoading;
    private boolean nbhelpVisible;
    private boolean saveUserIDCheck = true;
    private ButtonOnclickListener buttonClickListener = new ButtonOnclickListener();
    private View loadingLayout;
    private ProgressDialog progressDialog;
    private String checkValue;
    private Activity activity;
    private int checkProgress = 0;
    private String webviewUrl;
    private int checkForInput;
    private Drawable drawable;
    private Runnable enterOtpRunnable;
    private Timer timer;
    private String eventRecorded;
    private ArrayList<String> eventArray = new ArrayList<String>();
    private MixpanelAPI mixpanel;
    private boolean showCB = true;
    private String projectToken = "68dbbac2c25bc048154999d13cb77a55";
    private boolean firstFinish = true;
    private PopupWindow optionspu;
    private Bundle bundle;
    private FrameLayout helpView;
    private boolean visibilitychecked;
    //Rupay card URL
    private String rupeeURL = "https://mwsrec.npci.org.in/MWS/Scripts/MerchantScript_v1.0.js";
    private String rupeeURL1 = "https://swasrec2.npci.org.in";
    private String rupeeURL2 = "https://swasrec.npci.org.in";


    /**
     * Decode the downloaded javascript files.
     * should be used to decode initialize.js and bank specific js.
     * @param fileInputStream
     * @return decoded string.
     */

    private String decodeContents(FileInputStream fileInputStream) {
        StringBuilder decoded = new StringBuilder();
        try {
            int c;
            int i = 0;
            while ((c = fileInputStream.read()) != -1) {
                if (i % 2 == 0) {
                    decoded.append((char) (c - ((i % 5) + 1)));
                } else {
                    decoded.append((char) (c + ((i % 5) + 1)));
                }
                i++;
            }
            fileInputStream.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return decoded.toString();
    }

    /**
     * Finds the corresponding image name for the given bank and store the value at {@link Bank#drawable}
     * @param bankNameImage
     */
    public void getDrawable(final String bankNameImage) {
        if (drawable == null) {
            new AsyncTask<Void, Void, Void>() {  // getIdentifier is a heavy operation. lets make it on another thread.
                @Override
                protected Void doInBackground(Void... voids) {

                    if (bankNameImage != null) {
                        try {
                            String imageBankName;
                            if (bankNameImage.equalsIgnoreCase("sbinet"))
                                imageBankName = "sbi";
                            else if (bankNameImage.equalsIgnoreCase("icicinet") || bankNameImage.equalsIgnoreCase("icicicc"))
                                imageBankName = "icici";
                            else if (bankNameImage.equalsIgnoreCase("kotaknet"))
                                imageBankName = "kotak";
                            else if (bankNameImage.equalsIgnoreCase("indus"))
                                imageBankName = "induslogo";
                            else if (bankNameImage.equalsIgnoreCase("hdfc"))
                                imageBankName = "hdfc_bank";
                            else if (bankNameImage.equalsIgnoreCase("yesnet"))
                                imageBankName = "yesbank_logo";
                            else if (bankNameImage.equalsIgnoreCase("sc"))
                                imageBankName = "scblogo";
                            else if (bankNameImage.equalsIgnoreCase("axisnet"))
                                imageBankName = "axis_logo";
                            else if (bankNameImage.equalsIgnoreCase("amex"))
                                imageBankName = "amex_logo";
                            else if (bankNameImage.equalsIgnoreCase("hdfcnet"))
                                imageBankName = "hdfc_bank";
                            else if (bankNameImage.equalsIgnoreCase("ing"))
                                imageBankName = "ing_logo";
                            else
                                imageBankName = bankNameImage;

                            int resID = getResources().getIdentifier(imageBankName, "drawable"
                                    , activity.getPackageName());

                            if (resID == 0)
                                return null;
                            else
                                drawable = activity.getResources().getDrawable(resID);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return null;
                }
            }.execute(null, null, null);
        }
    }

    /**
     * Logging events with txnid and package name.
     * Mixpannel used only in debug mode.
     * @param eventName
     */
    public void callMixPanel(String eventName) {
        try {
            mAnalytics.log(getLogMessage(eventName.toLowerCase(), bankName));
            if (DEBUG) {
                JSONObject props = new JSONObject();
                props.put("Pakage Name", activity.getPackageName() + "");
                props.put("Transaction ID", mTxnID);
                mixpanel.track(eventName, props);
            }
        } catch (JSONException e) {
            Log.e("CUSTOM BROWSER", "Unable to add properties to JSONObject", e);
        }
    }

    /**
     * Dynamic Custom browser.
     * Now we can enable/disable cb based on javascript rules.
     *
     * @param bank
     */
    void checkVisibilityCB(final String bank) {
        try {
            if (activity != null) activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        String sdkCode = (getArguments().getString("sdkname") == null ? "" : getArguments().getString("sdkname"));
                        String merchantId = (getArguments().getString("merchantid") == null ? "" : getArguments().getString("merchantid"));
                        JSONObject obj = new JSONObject();
                        obj.put("androidosversion", Build.VERSION.RELEASE + "");
                        obj.put("androidmanufacturer", (Build.MANUFACTURER + "").toLowerCase());
                        obj.put("model", (Build.MODEL + "").toLowerCase());
                        obj.put("merchantid", merchantId.toLowerCase());
                        obj.put("sdkname", sdkCode);
                        obj.put("cbname", BuildConfig.VERSION_NAME);
                        obj.put("bankname", bank.toLowerCase());
                        mWebView.loadUrl("javascript:" + mBankJS.getString("checkVisibilityCBCall") + "(" + obj + ")");

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Callback from custombrowser tells the bank.java to show or hide the custom browser.
     * @param showCustomBrowser
     */
    @JavascriptInterface
    public void showCustomBrowser(final boolean showCustomBrowser) {
        showCB = showCustomBrowser;
        if (activity != null) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (!showCustomBrowser) {
                        maximiseWebviewHeight();
                        frameState = MINIMISED;
                        try {

                            if (viewarrow != null)
                                viewarrow.setVisibility(View.GONE);

                            onHelpUnavailable();

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }


    @Override
    public void onResume() {
        super.onResume();
    }

    /**
     * Dismiss error page
     */
    public void onOverrideURL() {
        if (optionspu != null) {
            optionspu.dismiss();
        }
    }

    /**
     * Custom browser shows the error page.
     * @param errorCode
     * @param description
     * @param failingUrl
     */
    public void onReceivedErrorWebClient(int errorCode, String description, String failingUrl) {
        try {
            if (activity != null && !activity.isFinishing()) {
                onHelpUnavailable();
                helpView.removeAllViews();
                if (optionspu != null)
                    optionspu.dismiss();

                if (maxWebview != 0) {
                    maximiseWebviewHeight();
                    frameState = MINIMISED;
                }
                progressBarVisibilityPayuChrome(View.GONE);

                LayoutInflater inflater = (LayoutInflater) activity.getSystemService(Activity.LAYOUT_INFLATER_SERVICE);
                View view = inflater.inflate(R.layout.error_page, null);
                view.measure(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);


                if (CBUtil.isNetworkAvailable(activity)) {

                    ((TextView) view.findViewById(R.id.error_title)).setText("Oops.. something bad happened");
                } else {
                    ((TextView) view.findViewById(R.id.error_title)).setText("NO INTERNET CONNECTIVITY");
                }
                view.setAnimation(AnimationUtils.loadAnimation(getActivity(), R.anim.cb_tranlateup));
                optionspu = new PopupWindow(view, LinearLayout.LayoutParams.MATCH_PARENT, view.getMeasuredHeight() + 20);
                optionspu.setFocusable(false);
                optionspu.showAtLocation(view, Gravity.BOTTOM, 0, 0);

                ((Button) view.findViewById(R.id.cancel)).setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        Intent intent = new Intent();
                        intent.putExtra(getString(R.string.cb_result), "Transaction canceled due to cancel pressed!");
                        activity.setResult(Activity.RESULT_CANCELED, intent);
                        activity.finish();
                    }
                });
            }
        } catch (Exception e) {

        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        activity = getActivity();
        bundle = getArguments();
        // initializing analytics , mixpanel
        initAnalytics();

        if (activity != null) {
            pin_selected_flag = false;

            CookieManager cookieManager = CookieManager.getInstance();

            if (Build.VERSION.SDK_INT >= 21) { // for icici white page fix.
                cookieManager.removeSessionCookies(null);
            } else {
                cookieManager.removeSessionCookie();
            }

            mTxnID = (bundle.containsKey(TXN_ID) ? bundle.getString(TXN_ID) : "123");
            if (mTxnID == null || mTxnID.equals("")) {
                mTxnID = "123";
            }
            mWebView = (WebView) activity.findViewById(getArguments().getInt("webView"));
            mWebView.getSettings().setJavaScriptEnabled(true);
            mWebView.addJavascriptInterface(this, "PayU");
            mWebView.getSettings().setDomStorageEnabled(true);
            mWebView.getSettings().setSupportMultipleWindows(true);
            mWebView.setOnTouchListener(new View.OnTouchListener() {
                @Override
                public boolean onTouch(View v, MotionEvent event) {
                    if (transView != null)
                        transView.setVisibility(View.GONE);
                    if (frameState == MAXIMISED) {
                        minimizeWebviewHeight();
                    }

                    return false;
                }
            });

            if (getArguments().getBoolean(WV_KEY_VIEWPORT)) {
                mWebView.getSettings().setUseWideViewPort(true);
            }

            // download initialize.js file
            getInitializeJS();
        }



    }

    /**
     * Initializing analytics and mixpanel.
     */
    protected void initAnalytics() {
        if (DEBUG)
            mixpanel = MixpanelAPI.getInstance(activity, projectToken);

        mAnalytics = CBAnalytics.getInstance(activity);
    }


    private void logStaticData(HashMap<String, String> staticAnalyticsData) {
        final StringBuffer postData = new StringBuffer();
        if (null != staticAnalyticsData && null != activity && !activity.isFinishing()) {
            for (String key : staticAnalyticsData.keySet()) {
                postData.append(key).append(": ").append(staticAnalyticsData.get(key)).append(",");
            }
            postData.deleteCharAt(postData.length() - 1);
        }
        mAnalytics.log(getLogMessage(null, postData.toString()));
    }

    /**
     * Preparing sms listener.
     * Reads the sms and checks whether its a otp message.
     */
    private void prepareSmsListener() {

        if (mBroadcastReceiver == null) {
            mBroadcastReceiver = new BroadcastReceiver() {
                @Override
                public void onReceive(Context context, Intent intent) {
                    try {
                        if (mBankJS == null) {
                            return;
                        }
                        if (activity != null) {
                            Bundle extras = intent.getExtras();
                            if (extras != null) {
                                // Get received SMS array
                                SmsMessage[] msgs = null;
                                String msgBody = null;

                                try {
                                    Object[] pdus = (Object[]) extras.get("pdus");
                                    msgs = new SmsMessage[pdus.length];
                                    for (int i = 0; i < msgs.length; i++) {
                                        msgs[i] = SmsMessage.createFromPdu((byte[]) pdus[i]);
                                        msgBody += msgs[i].getMessageBody();
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }

                                // We have the message!

                                Matcher match = Pattern.compile(mBankJS.getString(getString(R.string.cb_detect_otp)), Pattern.CASE_INSENSITIVE).matcher(msgBody);
                                if (match.find()) {
                                    // we have otp sms
                                    match = Pattern.compile(mBankJS.getString(getString(R.string.cb_find_otp)), Pattern.CASE_INSENSITIVE).matcher(msgBody);
                                    if (match.find()) {
                                        mPassword = match.group(1).replaceAll("[^0-9]", "");
                                    }
                                }

                                if (activity.findViewById(R.id.otp_sms) != null) {
                                    final TextView otpSMS = (TextView) activity.findViewById(R.id.otp_sms);


                                    if (showCB && mPassword != null && otpSMS.getVisibility() != View.VISIBLE) {
                                        if(timer!=null)
                                        {
                                            timer.cancel();
                                            timer.purge();
                                        }
                                        if (eventRecorded == CBConstant.PAYMENT_INITIATED || eventRecorded == CBConstant.CUSTOM_BROWSER) {
                                            eventRecorded = CBConstant.RECEIVED_OTP_DIRECT;
                                        } else if (eventRecorded == CBConstant.OTP) {
                                            eventRecorded = CBConstant.RECEIVED_OTP_SELECTED;
                                        } else if (eventRecorded == CBConstant.REGENERATE) {
                                            eventRecorded = CBConstant.RECEIVED_OTP_REGENERATE;
                                        } else {
                                            eventRecorded = CBConstant.RECEIVED_OTP_WEB;
                                        }
                                        callMixPanel(eventRecorded);


                                        otpSMS.setText(mPassword);
                                        mPassword = null;
                                        CustomProgressBar.removeDialog(activity.findViewById(R.id.progress));

                                        if (timer != null)
                                            timer.cancel();
                                        Button approveButton = (Button) activity.findViewById(R.id.approve);
                                        approveButton.setClickable(true);
                                        //approveButton.setAlpha(1);
                                        CBUtil.setAlpha(1, approveButton);
                                        approveButton.setVisibility(View.VISIBLE);

                                        activity.findViewById(R.id.timer).setVisibility(View.GONE);
                                        activity.findViewById(R.id.retry_text).setVisibility(View.GONE);
                                        activity.findViewById(R.id.regenerate_layout).setVisibility(View.GONE);
                                        activity.findViewById(R.id.waiting).setVisibility(View.GONE);
                                        activity.findViewById(R.id.otp_recieved).setVisibility(View.VISIBLE);

                                        otpSMS.setVisibility(View.VISIBLE);

                                        approveButton.setOnClickListener(new View.OnClickListener() {
                                            @Override
                                            public void onClick(View view) {
                                                try {
                                                    eventRecorded = CBConstant.APPROVED;
                                                    callMixPanel(eventRecorded);
                                                    prepareSmsListener();
                                                    checkLoading = false;
                                                    approve_flag = true;
                                                    onHelpUnavailable();
                                                    maximiseWebviewHeight();
                                                    frameState = MINIMISED;
                                                    mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_process_otp)) + "(\"" + otpSMS.getText().toString() + "\")");
                                                    hideSoftKeyboard();

                                                } catch (JSONException e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                        });

                                        // unregister the broadcast receiver.
                                        abortBroadcast();

                                        if (mBroadcastReceiver != null) {
                                            unregisterBroadcast(mBroadcastReceiver);
                                            mBroadcastReceiver = null;
                                        }
                                    }
                                }
                            }

                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            // Register the broadcast receiver
            IntentFilter filter = new IntentFilter();
            filter.setPriority(9999999);
            filter.addAction("android.provider.Telephony.SMS_RECEIVED");
            registerBroadcast(mBroadcastReceiver, filter);
        }
    }


    /**
     * should be called for {@link PayUWebViewClient#onPageStarted(WebView, String, Bitmap)}
     * @param url
     */
    void onPageStartedWebclient(String url) {
        if(activity!=null)
        CBUtil.setStringSharedPreference(activity,"lasturl","s:"+url);


        progressBarVisibilityPayuChrome(View.VISIBLE);
        webviewUrl = url;

        if (checkProgress == 0) {
            if (urlSet != null && urlSet.size() > 0 && !urlSet.contains(url)) {
                checkProgress = PRE_PAYMENT;
            }
        }
        if (checkProgress == POST_PAYMENT) {
            progressBarVisibilityPayuChrome(View.GONE);
        }

        if (checkProgress == DURING_PAYMENT) {
            if (postPaymentURL != null && postPaymentURL.size() > 0) {
                Iterator<String> iterator = postPaymentURL.iterator();
                while (iterator.hasNext()) {
                    if (url.contains(iterator.next())) {
                        progressDialog = null;
                        progressBarVisibilityPayuChrome(View.VISIBLE);
                        update();
                        checkProgress = POST_PAYMENT;
                        break;
                    }
                }
            }
        }

        if (checkValue != null && url.contains(checkValue)) {
            update();
            progressBarVisibilityPayuChrome(View.GONE);
        }

    }

    /**
     * Calling activity needs webview
     * @return
     */
    public WebView getWebView() {
        return mWebView;
    }

    /**
     * Call back function from {@link PayUWebViewClient#onLoadResource(WebView, String)}
     * @param view
     * @param url
     */
    void onLoadResourse(WebView view, String url) {

        if (url.equalsIgnoreCase(rupeeURL) || url.contains(rupeeURL1) || url.contains(rupeeURL2)) {
            progressBarVisibilityPayuChrome(View.GONE);
            checkProgress = DURING_PAYMENT;
        }
    }

    /**
     * Call back function from {@link PayUWebViewClient#onPageFinished(WebView, String)}
     * It takes care keyboard open issue and dissmiss the payu dialog.
     * @param url
     */
    void onPageFinishWebclient(String url) {
        if(activity!=null)
            CBUtil.setStringSharedPreference(activity,"lasturl","f:"+url);

        if (checkProgress == PRE_PAYMENT) {
            progressBarVisibilityPayuChrome(View.GONE);
            checkProgress = DURING_PAYMENT;
        }
        if (firstFinish) {
            final View activityRootView = activity.findViewById(getArguments().getInt("mainLayout"));
            activityRootView.getViewTreeObserver().addOnGlobalLayoutListener(
                    new ViewTreeObserver.OnGlobalLayoutListener() {
                        private final int DefaultKeyboardDP = 100;
                        private final int EstimatedKeyboardDP = DefaultKeyboardDP + (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP ? 48 : 0);
                        private final Rect r = new Rect();

                        @Override
                        public void onGlobalLayout() {
                            // Convert the dp to pixels.
                            int estimatedKeyboardHeight = (int) TypedValue
                                    .applyDimension(TypedValue.COMPLEX_UNIT_DIP, EstimatedKeyboardDP, activityRootView.getResources().getDisplayMetrics());
                            // Conclude whether the keyboard is shown or not.
                            activityRootView.getWindowVisibleDisplayFrame(r);
                            int heightDiff = activityRootView.getRootView().getHeight() - (r.bottom - r.top);
                            boolean isShown = heightDiff >= estimatedKeyboardHeight;
                            if (isShown) {
                                if (checkForInput == 0) {
                                    InputMethodManager imm = (InputMethodManager) activity.getSystemService(Activity.INPUT_METHOD_SERVICE);
                                    imm.toggleSoftInput(InputMethodManager.RESULT_HIDDEN, 0);
                                    checkForInput = 1;
                                }
                            }
                        }
                    });
            firstFinish = false;
        }

    }

    public void onDestroy() {
        super.onDestroy();
        mAnalytics.log(getLogMessage("0", CBUtil.getStringSharedPreference(activity, "lasturl")));

        try {
            if (optionspu != null)
                optionspu.dismiss();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
            eventRecorded = CBConstant.NON_CUSTOM_BROWSER;
            callMixPanel(eventRecorded);
        }

        eventRecorded = CBConstant.TERMINATE;
        callMixPanel(eventRecorded);

        if (mAnalytics != null && bankName != null)
            if (mBroadcastReceiver != null) {
                unregisterBroadcast(mBroadcastReceiver);
                mBroadcastReceiver = null;
            }
        if (progressDialog != null && !progressDialog.isShowing())
            progressDialog.dismiss();
    }

    /**
     * Stores the user id on NetBanking.
     */
    @JavascriptInterface
    public void getUserId() {
        if (activity != null && !activity.isFinishing()) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        SharedPreferences sherPref = activity.getSharedPreferences("com.payu.custombrowser", Context.MODE_PRIVATE);
                        mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_populate_user_id)) + "(\"" + sherPref.getString(bankName, "") + "\")");
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    /**
     * Stroes the user id on Netbanking.
     * @param params
     */
    @JavascriptInterface
    public void setUserId(final String params) {
        if (saveUserIDCheck) {
            if (activity != null && !activity.isFinishing()) {
                SharedPreferences.Editor sherPrefEditor = activity.getSharedPreferences("com.payu.custombrowser", Context.MODE_PRIVATE).edit();
                sherPrefEditor.putString(bankName, params);
                sherPrefEditor.commit();
            }
        }

    }

    /**
     * Shows custom  browser for netbanking
     * @param fields
     * @param params
     */
    @JavascriptInterface
    public void nativeHelperForNB(final String fields, final String params) {
        if (activity != null && !activity.isFinishing()) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        onHelpAvailable();
                        View nbView = activity.getLayoutInflater().inflate(R.layout.nb_layout, null);
                        if (fields != null) {
                            if (fields.equals("Button")) {
                                JSONObject jsonObject = new JSONObject(params);
                                if (jsonObject.has("btn_text") && jsonObject.getString("btn_text") != null && jsonObject.getString("btn_text") != "") {
                                    //   'checkbox': <true||false> }
                                    final CheckBox checkBox = (CheckBox) (nbView.findViewById(R.id.checkbox));
                                    if (jsonObject != null && jsonObject.has("checkbox") && jsonObject.getBoolean("checkbox")) {
                                        if (saveUserIDCheck)
                                            checkBox.setChecked(true);
                                        else
                                            checkBox.setChecked(false);


                                        checkBox.setOnClickListener(new View.OnClickListener() {
                                            @Override
                                            public void onClick(View v) {
                                                if (checkBox.isChecked()) {
                                                    saveUserIDCheck = true;
                                                } else {
                                                    saveUserIDCheck = false;
                                                }
                                            }
                                        });
                                        checkBox.setVisibility(View.VISIBLE);
                                    } else {
                                        checkBox.setVisibility(View.GONE);
                                    }

                                    Button nativeButton = (Button) nbView.findViewById(R.id.native_button);
                                    nativeButton.setText(jsonObject.getString("btn_text"));
                                    nativeButton.setTransformationMethod(null);
                                    nativeButton.setOnClickListener(new View.OnClickListener() {
                                        @Override
                                        public void onClick(View v) {
                                            try {
                                                mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_btn_action)));
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    });
                                }
                                helpView.removeAllViews();
                                helpView.addView(nbView);

                                nbhelpVisible = true;
                            } else {
                                onHelpUnavailable();
                                helpView.removeAllViews();
                            }

                        } else {
                            onHelpUnavailable();
                            helpView.removeAllViews();
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

            });
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        try {
            if (activity != null && isAdded())
                transView = (View) activity.findViewById(getArguments().getInt("tranLayout"));
        } catch (Exception e) {
            e.printStackTrace();
        }

        final View view = inflater.inflate(R.layout.bank, null);
        view.bringToFront();
        helpView = (FrameLayout) view.findViewById(R.id.help_view);
        viewarrow = view.findViewById(R.id.view);

        view.setOnTouchListener(new View.OnTouchListener() {
            float initialX,
                    initialY;
            boolean isTouch = true;
            int height = 0;

            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (!nbhelpVisible) {
                    maximiseWebviewHeight();
                    if (!isTouch)
                        return false;
                    int action = event.getActionMasked();
                    if (viewarrow.getVisibility() == View.VISIBLE) {
                        viewarrow.setClickable(false);
                        viewarrow.setOnTouchListener(null);

                        TranslateAnimation animate = new TranslateAnimation(0, 0, height, 0);
                        animate.setDuration(500);
                        animate.setFillBefore(true);
                        v.startAnimation(animate);
                        helpView.setVisibility(View.VISIBLE);
                        isTouch = false;
                        final Handler handler = new Handler();
                        handler.postDelayed(new Runnable() {

                            @Override
                            public void run() {
                                viewarrow.setVisibility(View.GONE);
                            }
                        }, 20);
                        final Handler handlertrans = new Handler();
                        handlertrans.postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                isTouch = true;
                                frameState = MAXIMISED;
                                if (transView != null) {
                                    if (activity != null && !activity.isFinishing())
                                        showLayout(transView, activity);
                                }
                            }
                        }, 500);

                    } else {

                        switch (action) {
                            case MotionEvent.ACTION_DOWN:
                                initialX = event.getX();
                                initialY = event.getY();

                                break;

                            case MotionEvent.ACTION_MOVE:
                                break;

                            case MotionEvent.ACTION_UP:
                                float finalX = event.getX();
                                float finalY = event.getY();


                                if (initialX < finalX) {
                                }

                                if (initialX > finalX) {
                                }

                                if (initialY < finalY) {


                                    if (helpView.getVisibility() == View.VISIBLE && (finalY - initialY) > 0) {

                                        height = v.getHeight();
                                        TranslateAnimation animate = new TranslateAnimation(0, 0, 0, v.getHeight() - 30);
                                        animate.setDuration(500);
                                        animate.setFillBefore(false);
                                        animate.setFillEnabled(true);
                                        animate.setZAdjustment(TranslateAnimation.ZORDER_TOP);
                                        v.startAnimation(animate);
                                        if (transView != null)
                                            transView.setVisibility(View.GONE);
                                        isTouch = false;
                                        isTouch = true;
                                        final Handler handler = new Handler();
                                        handler.postDelayed(new Runnable() {

                                            @Override
                                            public void run() {
                                                frameState = MINIMISED;
                                                helpView.setVisibility(View.GONE);
                                                viewarrow.setVisibility(View.VISIBLE);

                                            }
                                        }, 400);
                                    }
                                }
                                if (initialY > finalY) {
                                }
                                break;

                            case MotionEvent.ACTION_CANCEL:
                                break;

                            case MotionEvent.ACTION_OUTSIDE:
                                break;
                        }
                    }
                    return true;
                }

                return false;
            }
        });

        return view;
    }

    /**
     * called on OnClick from javascript
     *
     * @param fields
     */
    @JavascriptInterface
    public void analyticsLog(final String fields) {
        if (!mCVClicked) {
            if (fields.equals(getString(R.string.cb_otp_wv))) {
                try {
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (fields.equals(getString(R.string.cb_pin_wv))) {
                try {
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        reInit();
    }

    /**
     * run initialize.js manually.
     */
    @JavascriptInterface
    public void reInit() {
        if (activity != null && !activity.isFinishing()) {
            mCVClicked = false;
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    onPageFinished();
                }
            });
        }
    }

    /**
     * We found the bank, call back from initialize.js with the bank name.
     * @param bank
     */
    @JavascriptInterface
    public void bankFound(final String bank) {
        if (!visibilitychecked) {
            checkVisibilityCB(bank);
            visibilitychecked = true;
        }

        getDrawable(bank);
        if (activity != null && !activity.isFinishing()) {
            // initialize loading
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    calclateMaximizewebView();
                }
            });
        }

        // bank name
        bankName = bank;
        // bank logo
        bank_logo = bank;
        if (!mPageReady) {
            try {
                if (loadingLayout == null) {
                    convertToNative("loading", "{}");
                } else {
                    View view = ((ViewGroup) activity.findViewById(R.id.help_view)).getChildAt(0);
                    if (loadingLayout != view) {
                        convertToNative("loading", "{}");
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();

            }

        }

        if (!mLoadingJS && mJS == null) {
            // do we have the js file already?
            new AsyncTask<Void, Void, Void>() { // downloading bank specific javascript file.
                @Override
                protected Void doInBackground(Void... voids) {
                    mLoadingJS = true;
                    File file;
                    try {
                        if (activity != null) {
                            String fileName = mBankJS.getString(bank);
                            file = new File(activity.getFilesDir(), fileName);
                            if (!file.exists()) {

                                java.net.URL url = new URL(CB_URL + fileName + ".js");

                                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                                conn.setRequestMethod("GET");
                                conn.setRequestProperty("Accept-Charset", "UTF-8");

                                if (conn.getResponseCode() == HttpURLConnection.HTTP_OK) {
                                    GZIPInputStream responseInputStream = new GZIPInputStream(conn.getInputStream());
                                    byte[] buf = new byte[1024];
                                    int len;
                                    FileOutputStream outputStream = activity.openFileOutput(fileName, Context.MODE_PRIVATE);
                                    while ((len = responseInputStream.read(buf)) > 0) {
                                        outputStream.write(buf, 0, len);
                                    }
                                    responseInputStream.close();
                                    outputStream.close();
                                }

                            }
                        }

                    } catch (JSONException e) {
                        e.printStackTrace();
                    } catch (IOException e) {
                        e.printStackTrace();
                    } catch (Exception e) {
                        e.printStackTrace();
                    } finally {
                        try {
                            if (activity != null) {
                                String fileName = mBankJS.getString(bank);
                                mJS = new JSONObject(decodeContents(activity.openFileInput(fileName)));
                                if (mPageReady) {
                                    if (activity != null) {
                                        activity.runOnUiThread(new Runnable() {
                                            @Override
                                            public void run() {
                                                onPageFinished();
                                            }
                                        });
                                    }
                                }
                                mLoadingJS = false;
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        } catch (FileNotFoundException e) {
                            e.printStackTrace();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return null;
                }
            }.execute();
        }

    }


    /**
     * Download initialize.js form payu server.
     */
    private void getInitializeJS() {
        // listen for OTP
        prepareSmsListener();
        eventRecorded = CBConstant.PAYMENT_INITIATED;

        callMixPanel(eventRecorded);
        // make an http request!
        new AsyncTask<Void, Void, Void>() {
            @Override
            protected Void doInBackground(Void... voids) {

                String fileName = "initialize";

                try {
                    URL url = new URL(CB_URL + fileName + ".js");
                    HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setRequestProperty("Accept-Charset", "UTF-8");

                    if (conn.getResponseCode() == HttpURLConnection.HTTP_OK) {
                        GZIPInputStream responseInputStream = new GZIPInputStream(conn.getInputStream());
                        byte[] buf = new byte[1024];
                        int len;
                        FileOutputStream outputStream = activity.openFileOutput(fileName, Context.MODE_PRIVATE);
                        while ((len = responseInputStream.read(buf)) > 0) {
                            outputStream.write(buf, 0, len);
                        }
                        responseInputStream.close();
                        outputStream.close();
                    }

                } catch (MalformedURLException e) {
                    e.printStackTrace();
                } catch (ProtocolException e) {
                    e.printStackTrace();
                } catch (IOException e) {
                    e.printStackTrace();
                } finally {
                    // reading initialize.js form file.
                    try {
                        if (activity != null) {
                            mBankJS = new JSONObject(decodeContents(activity.openFileInput(fileName)));
                            if (mBankJS != null) {
                                setUrlString();
                            } else {
                                communicationError();
                            }
                            if (mPageReady) {
                                if (activity != null) {
                                    activity.runOnUiThread(new Runnable() {
                                        @Override
                                        public void run() {
                                            onPageStarted();
                                        }
                                    });
                                }
                            }
                        }
                    } catch (FileNotFoundException e) {
                        communicationError();
                        e.printStackTrace();
                    } catch (JSONException e) {
                        communicationError();
                        e.printStackTrace();
                    } catch (Exception e) {
                        communicationError();
                        e.printStackTrace();
                    }
                }

                return null;
            }
        }.execute(null, null, null);
    }

    /**
     * Js interface from Bank specific javascript.
     * Convert to native shows the bank specific native ui on the webview
     * @param fields can be anyone of choose, retry, incorrectotp, enterotp.
     * @param params regen: true, pin: false, otp: true.
     */
    @JavascriptInterface
    public void convertToNative(final String fields, final String params) {

        if (activity != null && showCB == true) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {

                    try {
                        if (timer != null && enterOtpRunnable != null) {
                            timer.cancel();
                            timer.purge();

                        }

                        if (fields.equals(getString(R.string.cb_error))) {  // Error
                            // fail the payment
                            // hide the view
                            onBankError();
                        } else if (fields.equals("parse error")) {
                            // hide the view
                            onBankError();
                        } else if (fields.contentEquals("loading") && !pin_selected_flag && checkLoading) { // Bank page is still loading
                            onHelpAvailable();

                            if (transView != null)
                                transView.setVisibility(View.VISIBLE);
//
                            loadingLayout = activity.getLayoutInflater().inflate(R.layout.loading, null);
                            ImageView im = (ImageView) loadingLayout.findViewById(R.id.bank_logo);

                            if (drawable != null)
                                im.setImageDrawable(drawable);

                            // Adjust the size of the webview,
                            updateLoaderHeight();

                            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, chooseActionHeight);
                            View layoutView = loadingLayout.findViewById(R.id.loading);
                            layoutView.setLayoutParams(params);
                            layoutView.requestLayout();
                            layoutView.invalidate();
                            CustomProgressBar.showDialog(activity, loadingLayout.findViewById(R.id.progress));

                            helpView.removeAllViews();
                            helpView.addView(loadingLayout);
                            if (helpView.isShown()) {
                                frameState = MAXIMISED;
                            } else {
                                maximiseWebviewHeight();
                            }
                            updateHeight(loadingLayout);
                        } else if (fields.equals(getString(R.string.cb_choose))) { // choose flow.

                            if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
                                eventRecorded = CBConstant.CUSTOM_BROWSER;
                                eventArray.add(CBConstant.CUSTOM_BROWSER);

                                callMixPanel(eventRecorded);
                            }

                            frameState = MAXIMISED;
                            checkLoading = true;

                            if (transView != null)
                                transView.setVisibility(View.VISIBLE);

//                    // show the options

                            View view = activity.getLayoutInflater().inflate(R.layout.choose_action, null);
                            helpView.setVisibility(View.GONE);

                            if (maxWebview == 0) {
                                calclateMaximizewebView();
                                maximiseWebviewHeight();
                            }

                            helpView.setVisibility(View.VISIBLE);
                            if (viewarrow != null)
                                viewarrow.setVisibility(View.GONE);

                            calclateHeight(view);
                            onHelpAvailable();
                            view.measure(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                            chooseActionHeight = view.getMeasuredHeight();

                            ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                            if (drawable != null)
                                im.setImageDrawable(drawable);

                            helpView.removeAllViews();
                            helpView.addView(view);
                            if (helpView.isShown())
                                frameState = MAXIMISED;


                            final SpannableStringBuilder str = new SpannableStringBuilder("Select an option for Faster payment");
                            str.setSpan(new android.text.style.StyleSpan(android.graphics.Typeface.BOLD), 21, 27, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
                            TextView tv = (TextView) view.findViewById(R.id.choose_text);
                            tv.setText(str);
                            final JSONObject jsonObject;
                            try {
                                jsonObject = new JSONObject(params);
                                if (jsonObject.has(getString(R.string.cb_otp)) && !jsonObject.getBoolean(getString(R.string.cb_otp))) { // otp flow is not visible
                                    view.findViewById(R.id.otp).setVisibility(View.GONE);
                                    view.findViewById(R.id.view).setVisibility(View.GONE);
                                }
                                view.findViewById(R.id.otp).setOnClickListener(buttonClickListener);
                                if (jsonObject.has(getString(R.string.cb_pin)) && !jsonObject.getBoolean(getString(R.string.cb_pin))) { // pin flow is not visible
                                    view.findViewById(R.id.pin).setVisibility(View.GONE);
                                    view.findViewById(R.id.view).setVisibility(View.GONE);
                                } else {
                                    view.findViewById(R.id.pin).setOnClickListener(new View.OnClickListener() { // we have pin flow.

                                        @Override
                                        public void onClick(View view) {
                                            c_hdfc = 1;
                                            pin_selected_flag = true;
                                            approve_flag = true;
                                            maximiseWebviewHeight();
                                            frameState = MINIMISED;
                                            if (transView != null)
                                                transView.setVisibility(View.GONE);
                                            try {
                                                if (jsonObject.has(getString(R.string.cb_register)) && jsonObject.getBoolean(getString(R.string.cb_register))) { // Register user flow.
                                                    view = activity.getLayoutInflater().inflate(R.layout.register_pin, null);
                                                    helpView.removeAllViews();
                                                    helpView.addView(view);

                                                    if (helpView.isShown())
                                                        frameState = MAXIMISED;

                                                    view.findViewById(R.id.pin).setOnClickListener(new View.OnClickListener() {
                                                        @Override
                                                        public void onClick(View view) {
                                                            try {
                                                                eventRecorded = CBConstant.PASSWORD;
                                                                callMixPanel(eventRecorded);

                                                                mCVClicked = true;
                                                                mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_pin)));
                                                            } catch (JSONException e) {
                                                                e.printStackTrace();
                                                            }
                                                        }
                                                    });
                                                    if (jsonObject.has(getString(R.string.cb_otp)) && !jsonObject.getBoolean(getString(R.string.cb_otp))) {
                                                        view.findViewById(R.id.otp).setVisibility(View.GONE);
                                                    }
                                                    view.findViewById(R.id.otp).setOnClickListener(buttonClickListener);
                                                } else {
                                                    eventRecorded = CBConstant.PASSWORD;
                                                    callMixPanel(eventRecorded);
                                                    onHelpUnavailable();
                                                    mCVClicked = true;
                                                    mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_pin)));
                                                }
                                            } catch (JSONException e) {
                                                e.printStackTrace();
                                            }
                                            updateHeight(view);
                                        }
                                    });
                                }
                                if (jsonObject.has(getString(R.string.cb_error))) { // oops sorry some error occured
                                    view.findViewById(R.id.error_message).setVisibility(View.VISIBLE);
                                    ((TextView) view.findViewById(R.id.error_message)).setText(jsonObject.getString("error"));
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        } else if (fields.equals(getString(R.string.cb_incorrect_OTP_2))) { // incorrect otp.

                            if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
                                eventRecorded = CBConstant.CUSTOM_BROWSER;
                                eventArray.add(CBConstant.CUSTOM_BROWSER);
                                callMixPanel(eventRecorded);
                            }

                            checkLoading = true;
                            onHelpAvailable(); // gotta show cb
                            final View view = activity.getLayoutInflater().inflate(R.layout.retry_otp, null);
                            ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                            if (drawable != null)
                                im.setImageDrawable(drawable);

                            helpView.removeAllViews();
                            helpView.addView(view);

                            if (helpView.isShown()) {
                                frameState = MAXIMISED;
                            } else {
                                if (viewarrow != null)
                                    viewarrow.setVisibility(View.VISIBLE);
                                maximiseWebviewHeight();
                            }

                            if (mPassword == null) {
                                view.findViewById(R.id.regenerate_layout).setVisibility(View.VISIBLE);
                                view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.GONE);
                                try {
                                    JSONObject p = new JSONObject(params);
                                    final boolean pin = p.has(getString(R.string.cb_pin)) && p.getBoolean(getString(R.string.cb_pin));

                                    view.findViewById(R.id.enter_manually).setOnClickListener(buttonClickListener);
                                    if (pin)
                                        view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                                    else
                                        view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);

                                    view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            updateHeight(view);
                        } else if (fields.equals(getString(R.string.cb_retry_otp))) { // Retry flow.

                            if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
                                eventRecorded = CBConstant.CUSTOM_BROWSER;
                                eventArray.add(CBConstant.CUSTOM_BROWSER);
                                callMixPanel(eventRecorded);
                            }

                            checkLoading = true;
                            onHelpAvailable(); // show cb
                            hideSoftKeyboard(); // if the keyboard still on the screen, just force it to hide
                            if (transView != null)
                                transView.setVisibility(View.VISIBLE);

                            final View view = activity.getLayoutInflater().inflate(R.layout.retry_otp, null);
                            ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                            if (drawable != null)
                                im.setImageDrawable(drawable);

                            helpView.removeAllViews();
                            helpView.addView(view);

                            if (helpView.isShown()) {
                                frameState = MAXIMISED;
                            } else {
                                if (viewarrow != null)
                                    viewarrow.setVisibility(View.VISIBLE);
                                maximiseWebviewHeight();
                            }

                            try {
                                if (mPassword == null) {
                                    JSONObject p = new JSONObject(params);
                                    final boolean regenerate = p.has(getString(R.string.cb_regenerate)) && p.getBoolean(getString(R.string.cb_regenerate));
                                    final boolean pin = p.has(getString(R.string.cb_pin)) && p.getBoolean(getString(R.string.cb_pin));

                                    view.findViewById(R.id.regenerate_layout).setVisibility(View.VISIBLE);
                                    if (regenerate) {
                                        view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.VISIBLE);
                                        if (pin) {
                                            view.findViewById(R.id.Enter_manually_gone).setVisibility(View.GONE);
                                            view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                                        } else {
                                            view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                                            view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);
                                        }
                                    } else {
                                        if (pin)
                                            view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                                        else
                                            view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);

                                        view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.GONE);
                                        view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                                    }

                                }
                                view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);
                                view.findViewById(R.id.enter_manually).setOnClickListener(buttonClickListener);
                                view.findViewById(R.id.retry).setOnClickListener(buttonClickListener);
                                buttonClickListener.setView(view);
                                view.findViewById(R.id.approve).setOnClickListener(buttonClickListener);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            updateHeight(view);
                        } else if (fields.equals(getString(R.string.cb_enter_pin))) { // user has just selected pin flow.

                            if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
                                eventRecorded = CBConstant.CUSTOM_BROWSER;
                                eventArray.add(CBConstant.CUSTOM_BROWSER);
                                callMixPanel(eventRecorded);
                            }

                            if (viewarrow != null)
                                viewarrow.setVisibility(View.GONE);

                            onHelpUnavailable();
                            pin_selected_flag = true;
                            approve_flag = true;
                            maximiseWebviewHeight();
                            frameState = MINIMISED;
                            if (transView != null)
                                transView.setVisibility(View.GONE);

                            maximiseWebviewHeight();
                            helpView.removeAllViews();
                        } else if (fields.equals(getString(R.string.cb_enter_otp))) { // user is waiting for otp

                                if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
                                    eventRecorded = CBConstant.CUSTOM_BROWSER;
                                    eventArray.add(CBConstant.CUSTOM_BROWSER);
                                    callMixPanel(eventRecorded);
                                }

                                if (bank_logo.equalsIgnoreCase("hdfc") && c_hdfc == 0)
                                    c_hdfc = 1;
                                else if (bank_logo.equalsIgnoreCase("hdfc") && c_hdfc > 0)
                                    enter_otp(params);
                                else
                                    enter_otp(params);

                        } else if (fields.equals(getString(R.string.cb_incorrect_pin))) { // oops wrong pin attempt.

                            if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
                                eventRecorded = CBConstant.CUSTOM_BROWSER;
                                eventArray.add(CBConstant.CUSTOM_BROWSER);
                                callMixPanel(eventRecorded);
                            }

                            final JSONObject jsonObject;
                            try {
                                jsonObject = new JSONObject(params);
                                if (jsonObject.has(getString(R.string.cb_otp)) && jsonObject.getBoolean(getString(R.string.cb_otp))) {
                                    checkLoading = true;
                                    onHelpAvailable();
                                    final View view = activity.getLayoutInflater().inflate(R.layout.choose_action, null);

                                    ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                                    if (drawable != null)
                                        im.setImageDrawable(drawable);

                                    TextView errorText = (TextView) view.findViewById(R.id.error_message);
                                    errorText.setVisibility(View.VISIBLE);
                                    errorText.setText(activity.getResources().getString(R.string.cb_incorrect_password));

                                    TextView chooseText = (TextView) view.findViewById(R.id.choose_text);
                                    chooseText.setVisibility(View.VISIBLE);
                                    chooseText.setText(activity.getResources().getString(R.string.cb_retry));


                                    helpView.removeAllViews();
                                    helpView.addView(view);

                                    view.findViewById(R.id.otp).setOnClickListener(buttonClickListener);
                                    view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);

                                    updateHeight(view);
                                    if (helpView.isShown()) {
                                        frameState = MAXIMISED;
                                    } else {
                                        maximiseWebviewHeight();
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else if (fields.equals(getString(R.string.cb_register_option))) { // Register new user.

                            if (!eventArray.contains(CBConstant.CUSTOM_BROWSER)) {
                                eventRecorded = CBConstant.CUSTOM_BROWSER;
                                eventArray.add(CBConstant.CUSTOM_BROWSER);
                                callMixPanel(eventRecorded);
                            }


                            onHelpAvailable();
                            final View view = activity.getLayoutInflater().inflate(R.layout.register, null);
                            helpView.removeAllViews();
                            helpView.addView(view);
                            ImageView im = (ImageView) view.findViewById(R.id.bank_logo);

                            if (drawable != null)
                                im.setImageDrawable(drawable);

                            updateHeight(view);
                            if (helpView.isShown()) {
                                frameState = MAXIMISED;
                            } else {
                                maximiseWebviewHeight();
                            }
                        } else {
                            maximiseWebviewHeight();
                            frameState = MINIMISED;
                            if (viewarrow != null)
                                viewarrow.setVisibility(View.GONE);

                            onHelpUnavailable();

                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                }

            });
        }
    }

    public void onPageFinished() {
        if (this.isAdded() && !this.isRemoving()) {
            mPageReady = true;
            if (approve_flag) {

                onHelpUnavailable();
                approve_flag = false;
            }

            if (loadingLayout != null && loadingLayout.isShown()) {
                frameState = MINIMISED;
                maximiseWebviewHeight();
                onHelpUnavailable();
            }
            activity.getWindow().setSoftInputMode(WindowManager.
                    LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);


            if (mJS != null && showCB) { // we have cb and we have the bankspecific js, lets show cb.
                try {
                    mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_init)));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (mBankJS != null && mJS == null) {
                transView.setVisibility(View.GONE); // Hide the translayout our page is loaded successfully.
            }
        }
    }

    public void onPageStarted() {
        if (nbhelpVisible) {
            onHelpUnavailable();
            nbhelpVisible = false;
        }
        if (this.isAdded() && !this.isRemoving()) {
            mPageReady = false;
            if (mBankJS != null) { // we have successfully downloaded initialize.js
                try {
                    if (showCB) {
                        mWebView.loadUrl("javascript:" + mBankJS.getString(getString(R.string.cb_detect_bank)));
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * Call back from surl - sucess transaction
     * with no argument.
     * just send empty string back to calling activity
     */
    @JavascriptInterface
    public void onSuccess() {
        onSuccess("");
    }

    /**
     * call back function from surl - success transaction.
     * set result ok, and send the received data.
     * @param result
     */
    @JavascriptInterface
    public void onSuccess(final String result) {

        eventRecorded = CBConstant.SUCCESS;
        callMixPanel(eventRecorded);

        if (activity != null) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (activity != null && !activity.isFinishing() && Bank.this.isAdded()) {
                        Intent intent = new Intent();
                        intent.putExtra(getString(R.string.cb_result), result);
                        activity.setResult(Activity.RESULT_OK, intent);
                        activity.finish();
                    }
                }
            });
        }

    }

    /**
     * Call back from furl - failure transaction
     * with no argument.
     * just send empty string back to calling activity
     */
    @JavascriptInterface
    public void onFailure() {
        onFailure("");
    }

    /**
     * call back function from furl - failure transaction.
     * set result ok, and send the received data.
     * @param result
     */
    @JavascriptInterface
    public void onFailure(final String result) {
        if (activity != null) {

            eventRecorded = CBConstant.FAILURE;

            callMixPanel(eventRecorded);

            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {

                    if (activity != null && !activity.isFinishing() && Bank.this.isAdded()) {
                        Intent intent = new Intent();
                        intent.putExtra(getString(R.string.cb_result), result);
                        activity.setResult(Activity.RESULT_CANCELED, intent);
                        activity.finish();
                    }
                }
            });
        }
    }

    /**
     * will be called in case of curl
     * mostly handled by furl
     */
    @JavascriptInterface
    public void onCancel() {
        onCancel("");
    }

    /**
     * will be called in case of curl
     * mostly handled by furl
     */
    @JavascriptInterface
    public void onCancel(final String result) {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (activity != null && !activity.isFinishing() && Bank.this.isAdded()) {
                    Intent intent = new Intent();
                    intent.putExtra(getString(R.string.cb_result), result);
                    activity.setResult(Activity.RESULT_CANCELED, intent);
                    activity.finish();
                }
            }
        });
    }

    /**
     * Generate a hash for analytics url
     * @param action
     * @param bank
     * @return
     */
    String getLogMessage(String action, String bank) {
        try {
            String msg = activity.getPackageName() + "," + (bank == null ? "" : bank) + "," + System.currentTimeMillis() + "," + mTxnID + "," + action;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(msg.getBytes());
            byte[] digest = messageDigest.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            return msg + "," + bigInt.toString(16);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * Should be implemented by Calling activity
     * @param broadcastReceiver broadcast receiver to set up.
     * @param filter
     */

    public abstract void registerBroadcast(BroadcastReceiver broadcastReceiver, IntentFilter filter);

    /**
     * Unregister the broad cast receiver.
     * @param broadcastReceiver
     */
    public abstract void unregisterBroadcast(BroadcastReceiver broadcastReceiver);

    /**
     * Hide the custombowser fragement
     */
    public abstract void onHelpUnavailable();

    /**
     * OOPS something went wrong hide cb or progerss dialog.
     */
    public abstract void onBankError();

    /**
     * Yey we support cb for this bank, lets show cb
     */
    public abstract void onHelpAvailable();


    /**
     * Known ulrs will be passed to cb,
     * if the current url is not being found hide Progress loader.
     * @param urlSet
     * @param postUrlSet
     * @param check
     */
    public void updateSet(Set<String> urlSet, Set<String> postUrlSet, String check) {
        if (urlSet != null && urlSet.size() > 0 && webviewUrl != null && !urlSet.contains(webviewUrl)) {
            progressBarVisibilityPayuChrome(View.GONE);
            checkProgress = DURING_PAYMENT;
        }
        checkValue = check;
    }

    /**
     * OOPS something went wrong, hide payu loader
     */
    public void communicationError() {
        progressBarVisibilityPayuChrome(View.GONE);
    }

    /**
     * Should be userd with progress dialog.
     * @param view
     * @param mContext
     */
    public void showLayout(final View view, Context mContext) {
        if (view != null) {
            final Animation animation = AnimationUtils.loadAnimation(mContext, R.anim.cb_fade_in);

            view.startAnimation(animation);
            Handler handler = new Handler();
            handler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    view.setVisibility(View.VISIBLE);
                }
            }, 500);
        }
    }

    /**
     * Force display soft keyboard.
     * @param editText
     */
    private void showSoftKeyboard(View editText) {
        editText.setFocusableInTouchMode(true);
        editText.requestFocus();
        ((InputMethodManager) activity.getSystemService(Context.INPUT_METHOD_SERVICE)).showSoftInput((EditText) editText, InputMethodManager.SHOW_FORCED);
    }

    /**
     * Force hide soft keyboard
     */
    private void hideSoftKeyboard() {
        activity.getWindow().setSoftInputMode(
                WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN
        );
    }

    /**
     * Measure the height of webview
     * @param view
     */
    public void calclateHeight(View view) {
        view.measure(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        loading_height = view.getMeasuredHeight();
        minWebview = maxWebview - loading_height;
    }

    /**
     * Measure webview heigt
     */
    public void calclateMaximizewebView() {
        try {
            if (maxWebview == 0) {

                mWebView.measure(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
                mWebView.requestLayout();
                maxWebview = mWebView.getMeasuredHeight();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Adjust Webview size
     */
    public void maximiseWebviewHeight() {
        if (maxWebview == 0)
            calclateMaximizewebView();
        mWebView.getLayoutParams().height = maxWebview;
        mWebView.requestLayout();

    }

    /**
     * Adjust webview size
     */
    public void minimizeWebviewHeight() {
        mWebView.getLayoutParams().height = minWebview;
        mWebView.requestLayout();
    }

    /**
     * Adjust webview size
     * @param view
     */
    public void updateHeight(View view) {
        if (maxWebview == 0) {
            calclateMaximizewebView();
            maximiseWebviewHeight();
        }
        calclateHeight(view);
    }

    /**
     * Calculate and update loader height.
     */
    public void updateLoaderHeight() {
        if (chooseActionHeight == 0) {
            mWebView.measure(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            int maxWebview = mWebView.getMeasuredHeight();
            chooseActionHeight = (int) (maxWebview * (0.35));
        }
    }

    /**
     * i
     */
    public void setUrlString() {
        if (mBankJS != null) {
            try {
                if (mBankJS.has("pgUrlList")) {
                    String urlStr = mBankJS.getString("pgUrlList");
                    StringTokenizer st = new StringTokenizer(urlStr.replace(" ", ""), "||");
                    while (st.hasMoreTokens()) {
                        urlSet.add(st.nextToken());
                    }
                } else {
                    communicationError();
                }
                if (mBankJS.has("postPaymentPgUrlList")) {
                    String urlStr = mBankJS.getString("postPaymentPgUrlList");
                    StringTokenizer st = new StringTokenizer(urlStr.replace(" ", ""), "||");
                    while (st.hasMoreTokens()) {
                        postPaymentURL.add(st.nextToken());
                    }
                }
                updateSet(urlSet, postPaymentURL, url);
            } catch (Exception e) {
                communicationError();
                e.printStackTrace();
            }
        }

    }

    /**
     * Method for enter otp.
     * User is waiting to receive otp.
     * @param params
     */
    public void enter_otp(final String params) {
        {
            // Make sure sms listener is prepared.
            prepareSmsListener();

            if (chooseActionHeight == 0)
                frameState = MAXIMISED;

            checkLoading = true;
            onHelpAvailable(); // show cb

            if (transView != null)
                transView.setVisibility(View.VISIBLE);

            final View view = activity.getLayoutInflater().inflate(R.layout.wait_for_otp, null);
            ImageView im = (ImageView) view.findViewById(R.id.bank_logo);
            final TextView timerView = (TextView) view.findViewById(R.id.timer);

            if (drawable != null)
                im.setImageDrawable(drawable);

            ((EditText) view.findViewById(R.id.otp_sms)).addTextChangedListener(new TextWatcher() {

                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                    String otp = ((EditText) view.findViewById(R.id.otp_sms)).getText().toString();
                    if (otp.length() > 5) {
                        buttonClickListener.setView(view);
                        Button approveButton = (Button) view.findViewById(R.id.approve);
                        approveButton.setOnClickListener(buttonClickListener);
                        approveButton.setClickable(true);
                     //   approveButton.setAlpha(1);
                        CBUtil.setAlpha(1, approveButton);

                    } else {
                        float val = (float) .3;
                        Button approveButton = (Button) view.findViewById(R.id.approve);
                        approveButton.setClickable(false);
                       // approveButton.setAlpha(val);
                        CBUtil.setAlpha(1, approveButton);
                        approveButton.setOnClickListener(null);
                    }
                }

                @Override
                public void afterTextChanged(Editable editable) {

                }
            });

            View mProgress = view.findViewById(R.id.progress);
            CustomProgressBar.showDialog(activity, mProgress);
            helpView.removeAllViews();
            helpView.addView(view);

            if (helpView.isShown()) {
                frameState = MAXIMISED;
            } else {
                maximiseWebviewHeight();
            }

            if (frameState == MINIMISED) {

                if (viewarrow != null)
                    viewarrow.setVisibility(View.VISIBLE);
            }

            try {
                JSONObject p = new JSONObject(params);
                final boolean regenerate = p.has(getString(R.string.cb_regenerate)) && p.getBoolean(getString(R.string.cb_regenerate));
                final boolean skipScreen = p.has(getString(R.string.cb_skip_screen)) && p.getBoolean(getString(R.string.cb_skip_screen));
                final boolean pin = p.has(getString(R.string.cb_pin)) && p.getBoolean(getString(R.string.cb_pin));

                if (skipScreen) {
                    if (activity != null && ((TextView) activity.findViewById(R.id.otp_sms)) != null &&
                            ((TextView) activity.findViewById(R.id.otp_sms)).getVisibility() != View.VISIBLE) {

                        view.findViewById(R.id.retry_text).setVisibility(View.VISIBLE);
                        if (regenerate) {
                            view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.VISIBLE);
                            view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);
                            view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                        } else {
                            if (pin)
                                view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                            else
                                view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);

                            view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.GONE);
                            view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                        }
                        view.findViewById(R.id.retry_text).setVisibility(View.VISIBLE);
                        view.findViewById(R.id.regenerate_layout).setVisibility(View.VISIBLE);
                        view.findViewById(R.id.approve).setVisibility(View.GONE);
                        view.findViewById(R.id.waiting).setVisibility(View.GONE);
                        view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);
                        view.findViewById(R.id.retry).setOnClickListener(buttonClickListener);
                        view.findViewById(R.id.enter_manually).setOnClickListener(buttonClickListener);
                        updateHeight(view);
                    }
                } else {
                    timer = new Timer();
                    timer.scheduleAtFixedRate(new TimerTask() {  // Timer to gain user's attention while waiting for otp.

                        @Override
                        synchronized public void run() {
                            if (activity != null) {

                                activity.runOnUiThread(enterOtpRunnable);  // updating time.

                            }
                        }
                    }, 0, 1000);
                }
            } catch (Exception e) {

                e.printStackTrace();
            }


            enterOtpRunnable = new Runnable() { // update every seconds.
                int i = 30;

                @Override
                public void run() {
                    if (i == 0) {
                        try {
                            if (activity != null && view.isShown() && ((TextView) activity.findViewById(R.id.otp_sms)) != null && ((TextView) activity.findViewById(R.id.otp_sms)).getVisibility() != View.VISIBLE) {
                            timerView.setVisibility(View.GONE);
                                JSONObject p = new JSONObject(params);
                                final boolean regenerate = p.has(getString(R.string.cb_regenerate)) && p.getBoolean(getString(R.string.cb_regenerate));
                                final boolean pin = p.has(getString(R.string.cb_pin)) && p.getBoolean(getString(R.string.cb_pin));


                                view.findViewById(R.id.retry_text).setVisibility(View.VISIBLE);
                                if (regenerate) {
                                    view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.VISIBLE);
                                    view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);
                                    view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                                } else {
                                    if (pin)
                                        view.findViewById(R.id.pin_layout_gone).setVisibility(View.VISIBLE);
                                    else
                                        view.findViewById(R.id.pin_layout_gone).setVisibility(View.GONE);

                                    view.findViewById(R.id.Regenerate_layout_gone).setVisibility(View.GONE);
                                    view.findViewById(R.id.Enter_manually_gone).setVisibility(View.VISIBLE);
                                }
                                view.findViewById(R.id.retry_text).setVisibility(View.VISIBLE);
                                view.findViewById(R.id.regenerate_layout).setVisibility(View.VISIBLE);
                                view.findViewById(R.id.approve).setVisibility(View.GONE);
                                view.findViewById(R.id.waiting).setVisibility(View.GONE);
                                view.findViewById(R.id.otp_sms).setVisibility(View.GONE);
                                view.findViewById(R.id.pin).setOnClickListener(buttonClickListener);
                                view.findViewById(R.id.retry).setOnClickListener(buttonClickListener);
                                view.findViewById(R.id.enter_manually).setOnClickListener(buttonClickListener);
                                updateHeight(view);
                            }

                        } catch (Exception e) {

                            e.printStackTrace();
                        }

                    } else {
                        if (i == 30)
                            timerView.setVisibility(View.VISIBLE);
                        timerView.setText(i + "");
                        i--;
                    }
                }
            };

            if (mPassword != null && activity.findViewById(R.id.otp_sms) != null && !(((TextView) activity.findViewById(R.id.otp_sms)).getVisibility() == View.VISIBLE)) {

                if (timer != null)
                    timer.cancel();

                activity.findViewById(R.id.timer).setVisibility(View.GONE);

                if (eventRecorded == CBConstant.PAYMENT_INITIATED || eventRecorded == CBConstant.CUSTOM_BROWSER) {
                    eventRecorded = CBConstant.RECEIVED_OTP_DIRECT;
                    callMixPanel(eventRecorded);
                }

                ((TextView) view.findViewById(R.id.otp_sms)).setText(mPassword);
                Button approve = (Button) view.findViewById(R.id.approve);

                approve.setText(getString(R.string.cb_approve_otp));
                approve.setClickable(true);
                //approve.setAlpha(1);
                CBUtil.setAlpha(1, approve);
                activity.findViewById(R.id.otp_recieved).setVisibility(View.VISIBLE);

                CustomProgressBar.removeDialog(mProgress);
                view.findViewById(R.id.retry_text).setVisibility(View.GONE);
                view.findViewById(R.id.regenerate_layout).setVisibility(View.GONE);

                view.findViewById(R.id.approve).setVisibility(View.VISIBLE);
                view.findViewById(R.id.waiting).setVisibility(View.GONE);
                view.findViewById(R.id.otp_sms).setVisibility(View.VISIBLE);
                buttonClickListener.setView(view);
                ((Button) view.findViewById(R.id.approve)).setOnClickListener(buttonClickListener);

            }
            updateHeight(view);
            if (helpView.isShown()) {
                frameState = MAXIMISED;
            } else {
                maximiseWebviewHeight();
            }
        }
    }

    /**
     * Mapping the string with integers to make sure it works on java 1.6 and below.
     * @param str name
     * @return numnber
     */
    public int getCode(String str) {
        if (str.equalsIgnoreCase("pin"))
            return PIN;
        else if (str.equalsIgnoreCase("password"))
            return PASSWORD;
        else if (str.equalsIgnoreCase("enter manually"))
            return ENTER_MANUALLY;
        else if (str.equalsIgnoreCase("approve"))
            return APPROVE;
        else if (str.equalsIgnoreCase("otp") || str.equalsIgnoreCase("use sms otp"))
            return OTP;
        else if (str.equalsIgnoreCase("sms otp"))
            return SMS_OTP;
        else if (str.equalsIgnoreCase("regenerate otp"))
            return REGENERATE_OTP;

        return DEFAULT;
    }

    /**
     * Maximize the webview and changes the cb to minimize state
     */
    public void update() {
        maximiseWebviewHeight();
        frameState = MINIMISED;
        onHelpUnavailable();
    }

    /**
     * Displaying Payuloader.
     * @param context
     * @return progress dialog.
     */
    public ProgressDialog showProgress(Context context) {

        if (this.isAdded() && context != null && !activity.isFinishing()) {
            LayoutInflater mInflater = LayoutInflater.from(context);
            final Drawable[] drawables =
                    {getResources().getDrawable(R.drawable.l_icon1),
                            getResources().getDrawable(R.drawable.l_icon2),
                            getResources().getDrawable(R.drawable.l_icon3),
                            getResources().getDrawable(R.drawable.l_icon4)
                    };

            View layout = mInflater.inflate(R.layout.cb_prog_dialog, null);
            final ImageView imageView;
            imageView = (ImageView) layout.findViewById(R.id.imageView);

            ProgressDialog progDialog = new ProgressDialog(context, R.style.cb_progress_dialog);

            final Timer timer = new Timer();
            timer.scheduleAtFixedRate(new TimerTask() {
                int i = -1;

                @Override
                synchronized public void run() {
                    if (activity != null) {
                        activity.runOnUiThread(new Runnable() {
                                                   @Override
                                                   public void run() {
                                                       if (activity != null) {
                                                           i++;
                                                           if (i >= drawables.length) {
                                                               i = 0;
                                                           }
                                                           imageView.setImageBitmap(null);
                                                           imageView.destroyDrawingCache();
                                                           imageView.refreshDrawableState();
                                                           imageView.setImageDrawable(drawables[i]);
                                                       }
                                                   }
                                               }
                        );
                    }

                }
            }, 0, 500);

            progDialog.show();
            progDialog.setContentView(layout);
            progDialog.setCancelable(true);
            progDialog.setCanceledOnTouchOutside(false);
            progDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                @Override
                public void onDismiss(DialogInterface dialog) {
                    timer.cancel();
                    if (checkProgress == PRE_PAYMENT)
                        checkProgress = DURING_PAYMENT;
                }
            });
            return progDialog;
        }

        return null;
    }

    /**
     * Funtion to show or hide the progress bar.
     * @param visibility
     */
    public void progressBarVisibilityPayuChrome(int visibility) {
        if (visibility == View.GONE || visibility == View.INVISIBLE) {

            if (progressDialog != null && progressDialog.isShowing()) {
                progressDialog.dismiss();
                checkForInput = 1;
            }
        } else if (progressDialog == null) {
            progressDialog = showProgress(activity);
        }
    }

    /**
     * Hide soft keyboard.
     */
    private void hideKeyboardForcefully() {
        View view = activity.getCurrentFocus();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager) activity.getSystemService(Context.INPUT_METHOD_SERVICE);
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    /**
     * Custom onClick listener for cb's buttons.
     */
    public class ButtonOnclickListener implements View.OnClickListener {
        private View view_edit;

        public void setView(View view_ed) {
            this.view_edit = view_ed;
        }

        @Override
        public void onClick(View v) {
            String str = "";
            if (v instanceof Button) // we have buttons.
                str = (((Button) v).getText()).toString();
            else if (v instanceof TextView) // we have textviews too!.
                str = (((TextView) v).getText()).toString();
            int code = getCode(str.toLowerCase());
            switch (code) {
                case REGENERATE_OTP:
                    try {
                        eventRecorded = CBConstant.REGENERATE;
                        callMixPanel(eventRecorded);

                        mPassword = null;
                        mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_regen_otp)));
                        prepareSmsListener();
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case SMS_OTP:
                case OTP:
                    try {
                        //checkPermission();
                        eventRecorded = CBConstant.OTP;
                        callMixPanel(eventRecorded);

                        mPassword = null;
                        prepareSmsListener();
                        mCVClicked = true;
                        mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_otp)));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case APPROVE:
                    try {

                        hideKeyboardForcefully();
                        mPassword = null;
                        checkLoading = false;
                        approve_flag = true;

                        onHelpUnavailable();
                        maximiseWebviewHeight();
                        frameState = MINIMISED;
                        prepareSmsListener();
                        if (((EditText) view_edit.findViewById(R.id.otp_sms)).getText().toString().length() > 5) {
                            eventRecorded = CBConstant.APPROVED;
                            callMixPanel(eventRecorded);
                            mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_process_otp)) + "(\"" + ((TextView) activity.findViewById(R.id.otp_sms)).getText().toString() + "\")");
                        }

                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case ENTER_MANUALLY: {
                    final View view = activity.getLayoutInflater().inflate(R.layout.wait_for_otp, null);
                    eventRecorded = CBConstant.ENTER_MANUALLY;

                    callMixPanel(eventRecorded);

                    if (chooseActionHeight == 0) {
                        view.measure(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                        chooseActionHeight = view.getMeasuredHeight();
                    }

                    helpView.removeAllViews();
                    helpView.addView(view);

                    if (helpView.isShown()) {
                        frameState = MAXIMISED;
                    } else {
                        maximiseWebviewHeight();
                    }

                    ImageView im = (ImageView) view.findViewById(R.id.bank_logo);


                    if (drawable != null)
                        im.setImageDrawable(drawable);

                    view.findViewById(R.id.waiting).setVisibility(View.GONE);
                    float val = (float) .3;
                    final Button approveButton = (Button) view.findViewById(R.id.approve);
                    approveButton.setClickable(false);

                    EditText otpSMS = (EditText) view.findViewById(R.id.otp_sms);
                    showSoftKeyboard(otpSMS);


                   // approveButton.setAlpha(val);
                    CBUtil.setAlpha(val, approveButton);

                    approveButton.setVisibility(View.VISIBLE);
                    otpSMS.setVisibility(View.VISIBLE);
                    view.findViewById(R.id.regenerate_layout).setVisibility(View.GONE);
                    view.findViewById(R.id.progress).setVisibility(View.INVISIBLE);
                    showSoftKeyboard(otpSMS);

                    otpSMS.addTextChangedListener(new TextWatcher() {

                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                            String otp = ((EditText) view.findViewById(R.id.otp_sms)).getText().toString();
                            if (otp.length() > 5) {
                                buttonClickListener.setView(view);
                                approveButton.setOnClickListener(buttonClickListener);
                                approveButton.setClickable(true);
                              //  approveButton.setAlpha(1);
                                CBUtil.setAlpha(1, approveButton);


                            } else {
                                float val = (float) .3;
                                approveButton.setClickable(false);
                               // approveButton.setAlpha(val);
                                CBUtil.setAlpha(val, approveButton);
                                approveButton.setOnClickListener(null);
                            }
                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                        }
                    });
                    updateHeight(view);
                }
                break;

                case PASSWORD:
                case PIN:
                    pin_selected_flag = true;
                    approve_flag = true;
                    maximiseWebviewHeight();
                    frameState = MINIMISED;
                    onHelpUnavailable();

                    if (viewarrow != null)
                        viewarrow.setVisibility(View.GONE);

                    if (transView != null)
                        transView.setVisibility(View.GONE);
                    mCVClicked = true;
                    try {
                        mWebView.loadUrl("javascript:" + mJS.getString(getString(R.string.cb_pin)));
                        eventRecorded = CBConstant.PASSWORD;
                        callMixPanel(eventRecorded);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                case DEFAULT:
                    if (DEBUG)
                        Toast.makeText(activity, "button text not matching any click listener option", Toast.LENGTH_SHORT).show();
                    break;

            }

        }
    }
}