// The MIT License (MIT)
//
// Copyright (c) 2014-2015 PayU India
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package com.payu.custombrowser;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;

/**
 * Created by minie on 2/3/15.
 * Implementing 5 dots animation.
 */
public class DotsProgressBar extends View {
    private float mRadius;
    private float mOuterRadius;
    private Paint mPaintFill = new Paint(Paint.ANTI_ALIAS_FLAG);
    private Paint mPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
    private Handler mHandler = new Handler();
    private int mIndex = 0;
    private int widthSize, heightSize;
    private int margin = 10;
    private int mDotCount = 5;
    private int step = 1;
    private Runnable mRunnable = new Runnable() {

        @Override
        public void run() {
            mIndex += step;
            if (mIndex < 0) {
                mIndex = 1;
                step = 1;
            } else if (mIndex > (mDotCount - 1)) {
                // Start from beginning all over again
                mIndex = 0;
                step = 1;


            }
            invalidate();
            mHandler.postDelayed(mRunnable, 400);

        }

    };

    public DotsProgressBar(Context context) {
        super(context);
        init(context);
    }

    public DotsProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public DotsProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init(context);
    }

    private void init(Context context) {
        mRadius = context.getResources().getDimension(R.dimen.circle_indicator_radius);
        mOuterRadius = context.getResources().getDimension(R.dimen.circle_indicator_outer_radius);
        // dot fill color
        mPaintFill.setStyle(Style.FILL);
        // mPaintFill.setColor(Color.BLACK);
        mPaintFill.setColor(context.getResources().getColor(R.color.payu_blue));
        // dot background color
        mPaint.setStyle(Style.FILL);
        mPaint.setColor(0x33000000);

        start();
    }

    /**
     * Who told its 5 dots animation.
     * its n dot animation.
     * @param count no of dots
     */
    public void setDotsCount(int count) {
        mDotCount = count;
    }

    /**
     * start animation.
     */
    public void start() {
        mIndex = -1;
        mHandler.removeCallbacks(mRunnable);
        mHandler.post(mRunnable);
    }

    /**
     * Stop animation.
     */
    public void stop() {
        mHandler.removeCallbacks(mRunnable);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        widthSize = (int) ((mRadius * 2) * mDotCount + margin * mDotCount + margin + (mOuterRadius - mRadius));
        heightSize = (int) mRadius * 2 + getPaddingBottom() + getPaddingTop();
        setMeasuredDimension(widthSize, heightSize);

    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        float dX = (widthSize - mDotCount * mRadius * 2 - (mDotCount - 1) * margin) / 2.0f;
        float dY = heightSize / 2;
        for (int i = 0; i < mDotCount; i++) {
            if (i == mIndex) {
                canvas.drawCircle(dX, dY, mOuterRadius, mPaintFill);
            } else {
                canvas.drawCircle(dX, dY, mRadius, mPaint);
            }

            dX += (2 * mRadius + margin);
        }

    }
}