package com.paytm.pg.merchant;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.security.*;
import java.util.*;


public class PaytmChecksum {
    private static final String ALGTHM_TYPE_AES = "AES";
    private static final String ALGTHM_CBC_PAD_AES = "AES/CBC/PKCS5PADDING";
    private static final String ALGTHM_PROVIDER_BC = "SunJCE";
    private static final byte[] ivParamBytes = {'@', '@', '@', '@', '&', '&', '&', '&', '#', '#', '#', '#', '$', '$', '$', '$'};

    public static String encrypt(String input,String key) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        String encryptedValue = "";
        Cipher cipher = Cipher.getInstance(ALGTHM_CBC_PAD_AES,ALGTHM_PROVIDER_BC);
        cipher.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(key.getBytes(), ALGTHM_TYPE_AES),new IvParameterSpec(ivParamBytes));
        byte[] baseEncodedByte = Base64.getEncoder().encode(cipher.doFinal(input.getBytes()));
        encryptedValue = new String(baseEncodedByte);
        return encryptedValue;
    }
    public static String decrypt(String input, String key) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, IOException, BadPaddingException, IllegalBlockSizeException {
        String decryptedValue = "";
        Cipher cipher = Cipher.getInstance(ALGTHM_CBC_PAD_AES,ALGTHM_PROVIDER_BC);
        cipher.init(Cipher.DECRYPT_MODE, new SecretKeySpec(key.getBytes(), ALGTHM_TYPE_AES),new IvParameterSpec(ivParamBytes));
        byte[] baseDecodedByte = Base64.getDecoder().decode(input);
        decryptedValue = new String(cipher.doFinal(baseDecodedByte));
        return decryptedValue;
    }

    public static String generateSignature(TreeMap<String, String> params, String key) throws Exception {
        return generateSignature(getStringByParams(params), key);
    }

    public static String generateSignature(String params, String key) throws Exception {
        String salt = generateRandomString(4);
        return calculateChecksum(params, key, salt);
    }

    public static boolean verifySignature(TreeMap<String, String> params, String key, String checksum)
            throws Exception {
        return verifySignature(getStringByParams(params), key, checksum);
    }
    public static boolean verifySignature(String params, String key, String checksum)
            throws Exception {
        String paytm_hash = decrypt(checksum, key);
        String salt = paytm_hash.substring(paytm_hash.length() - 4);
        String calculatedHash = calculateHash(params, salt);
        return paytm_hash.equals(calculatedHash);
    }

    private static String generateRandomString(int length) {
        String ALPHA_NUM = "9876543210ZYXWVUTSRQPONMLKJIHGFEDCBAabcdefghijklmnopqrstuvwxyz!@#$&_";
        StringBuilder random = new StringBuilder(length);
        for (int i = 0; i < length; i++) {
            int ndx = (int) (Math.random() * ALPHA_NUM.length());
            random.append(ALPHA_NUM.charAt(ndx));
        }
        return random.toString();
    }

    private static String getStringByParams(TreeMap<String, String> params) {
        if (params == null) return "";

        Set<String> keys = params.keySet();
        StringBuilder string = new StringBuilder();

        TreeSet<String> parameterSet = new TreeSet<>(keys);
        for (String paramName : parameterSet) {
            String value = (params.get(paramName) == null || params.get(paramName).toLowerCase() == "null") ? "" : params.get(paramName);
            string.append(value).append("|");
        }
        return string.substring(0, string.length() - 1);
    }

    private static String calculateChecksum(String params, String key, String salt) throws NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException, InvalidAlgorithmParameterException {
        String hashString = calculateHash(params , salt);
        String checksum = encrypt(hashString, key);
        if (checksum != null) {
            checksum = checksum.replaceAll("\r\n", "")
                    .replaceAll("\r", "")
                    .replaceAll("\n", "");

        }
        return checksum;
    }

    private static String calculateHash(String params, String salt) throws NoSuchAlgorithmException {
        String finalString = params + "|" + salt;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        Formatter hash = new Formatter();
        for (byte b : messageDigest.digest(finalString.getBytes())) {
            hash.format("%02x", b);
        }
        return hash.toString().concat(salt);
    }
}
