package com.paystack.android_sdk.ui.components

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import com.paystack.android_sdk.ui.components.progressbars.LoadingIndicator
import com.paystack.androiddesignsystem.PaystackTheme

@Composable
internal fun LoadingScreen(
    modifier: Modifier = Modifier,
    message: String = ""
) {
    Column(
        modifier = modifier
            .fillMaxWidth()
            .padding(vertical = PaystackTheme.dimensions.spacing.single),
        horizontalAlignment = Alignment.CenterHorizontally
    ) {
        Text(text = message, style = PaystackTheme.typography.body.body16M)
        Spacer(modifier = Modifier.height(PaystackTheme.dimensions.spacing.triple))

        LoadingIndicator(
            color = PaystackTheme.colors.neutralColors.gray01,
            modifier = Modifier.size(PaystackTheme.dimensions.spacing.triple)
        )
    }
}
