package com.paystack.android_sdk.ui.paymentchannels.card.auth.phone

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.input.KeyboardType
import androidx.lifecycle.viewmodel.compose.viewModel
import com.paystack.android_sdk.ui.R
import com.paystack.android_sdk.ui.components.buttons.PrimaryButton
import com.paystack.android_sdk.ui.components.views.inputs.PrimaryTextInputField
import com.paystack.android_sdk.ui.components.views.text.PaymentTitleText
import com.paystack.android_sdk.ui.models.Charge
import com.paystack.android_sdk.ui.paymentchannels.card.CardViewModelsProviderFactory
import com.paystack.androiddesignsystem.PaystackTheme

@Composable
internal fun PhoneNumberAuthForm(
    viewModelProviderFactory: CardViewModelsProviderFactory,
    onResult: (Result<Charge>) -> Unit,
    modifier: Modifier = Modifier,
    viewModel: PhoneNumberAuthViewModel = viewModel(factory = viewModelProviderFactory)
) {
    val state by viewModel.state.collectAsState()
    val result by viewModel.result.collectAsState()

    LaunchedEffect(result) {
        result?.let(onResult)
    }

    Column(
        modifier = modifier,
        horizontalAlignment = Alignment.CenterHorizontally
    ) {
        Image(painterResource(R.drawable.ic_phone_number), contentDescription = null)

        Spacer(modifier = Modifier.height(PaystackTheme.dimensions.spacing.triple))

        PaymentTitleText(
            titleText = stringResource(R.string.phone_number_auth_form_instruction),
            modifier = Modifier.padding(horizontal = PaystackTheme.dimensions.spacing.triple)
        )

        Spacer(modifier = Modifier.height(PaystackTheme.dimensions.spacing.double))

        PrimaryTextInputField(
            modifier = Modifier.fillMaxWidth(),
            label = stringResource(R.string.phone_number_label),
            placeholder = stringResource(R.string.phone_number_input_placeholder),
            keyboardType = KeyboardType.Phone,
            text = state.phoneNumber,
            onTextChanged = viewModel::onPhoneNumberChanged
        )

        Spacer(modifier = Modifier.height(PaystackTheme.dimensions.spacing.double))

        PrimaryButton(
            buttonText = stringResource(R.string.send_otp),
            onClick = viewModel::submit,
            isLoading = state.isSubmitting,
            isEnabled = state.isValid
        )
    }
}
