package com.paystack.android_sdk.ui.components.views.inputs.textfield

import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.text.selection.LocalTextSelectionColors
import androidx.compose.foundation.text.selection.TextSelectionColors
import androidx.compose.material3.LocalContentColor
import androidx.compose.runtime.Composable
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.Shape
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import com.paystack.android_sdk.ui.theme.shapes
import com.paystack.androiddesignsystem.PaystackTheme

internal object StackTextFieldDefaults {
    val shape: Shape
        @Composable get() = PaystackTheme.shapes.textField

    /**
     * The default min width applied to an [StackTextField].
     * Note that you can override it by applying Modifier.heightIn directly on a text field.
     */
    val MinHeight = 56.dp

    /**
     * The default thickness of the border in [StackTextField].
     */
    val BorderThickness = 1.dp

    /**
     * Creates a [StackTextFieldColors] that represents the default input text, container, and content
     * colors (including label, placeholder, icons, etc.) used in a [StackTextField].
     *
     * @param focusedTextColor the color used for the input text of this text field when focused
     * @param unfocusedTextColor the color used for the input text of this text field when not
     * focused
     * @param disabledTextColor the color used for the input text of this text field when disabled
     * @param errorTextColor the color used for the input text of this text field when in error
     * state
     * @param cursorColor the cursor color for this text field
     * @param errorCursorColor the cursor color for this text field when in error state
     * @param selectionColors the colors used when the input text of this text field is selected
     * @param focusedIndicatorColor the indicator color for this text field when focused
     * @param unfocusedIndicatorColor the indicator color for this text field when not focused
     * @param disabledIndicatorColor the indicator color for this text field when disabled
     * @param errorIndicatorColor the indicator color for this text field when in error state
     * @param leadingIconColor the leading icon color for this text field when focused
     * @param trailingIconColor the trailing icon color for this text field when focused
     * @param focusedLabelColor the label color for this text field when focused
     * @param unfocusedLabelColor the label color for this text field when not focused
     * @param disabledLabelColor the label color for this text field when disabled
     * @param errorLabelColor the label color for this text field when in error state
     * @param placeholderColor the placeholder color for this text field when focused
     * @param supportingTextColor the supporting text color for this text field when focused
     * @param errorSupportingTextColor the supporting text color for this text field when in error
     * state
     * */
    @Composable
    fun colors(
        focusedTextColor: Color = LocalContentColor.current,
        unfocusedTextColor: Color = LocalContentColor.current,
        disabledTextColor: Color = LocalContentColor.current,
        errorTextColor: Color = LocalContentColor.current,
        containerColor: Color = Color.Transparent,
        cursorColor: Color = PaystackTheme.colors.secondaryColors.stackGreen,
        errorCursorColor: Color = PaystackTheme.colors.feedbackColors.error02,
        selectionColors: TextSelectionColors = LocalTextSelectionColors.current,
        focusedIndicatorColor: Color = PaystackTheme.colors.secondaryColors.stackGreen,
        unfocusedIndicatorColor: Color = PaystackTheme.colors.primaryColors.navy05,
        disabledIndicatorColor: Color = PaystackTheme.colors.primaryColors.navy05,
        errorIndicatorColor: Color = PaystackTheme.colors.feedbackColors.error02,
        leadingIconColor: Color = LocalContentColor.current,
        trailingIconColor: Color = LocalContentColor.current,
        focusedLabelColor: Color = PaystackTheme.colors.secondaryColors.stackGreen,
        unfocusedLabelColor: Color = PaystackTheme.colors.primaryColors.navy02,
        disabledLabelColor: Color = PaystackTheme.colors.primaryColors.navy02,
        errorLabelColor: Color = PaystackTheme.colors.feedbackColors.error02,
        placeholderColor: Color = PaystackTheme.colors.primaryColors.navy04,
        supportingTextColor: Color = PaystackTheme.colors.primaryColors.navy02,
        errorSupportingTextColor: Color = PaystackTheme.colors.feedbackColors.error02,
    ): StackTextFieldColors =
        StackTextFieldColors(
            focusedTextColor = focusedTextColor,
            unfocusedTextColor = unfocusedTextColor,
            disabledTextColor = disabledTextColor,
            errorTextColor = errorTextColor,
            containerColor = containerColor,
            cursorColor = cursorColor,
            errorCursorColor = errorCursorColor,
            textSelectionColors = selectionColors,
            focusedIndicatorColor = focusedIndicatorColor,
            unfocusedIndicatorColor = unfocusedIndicatorColor,
            disabledIndicatorColor = disabledIndicatorColor,
            errorIndicatorColor = errorIndicatorColor,
            leadingIconColor = leadingIconColor,
            trailingIconColor = trailingIconColor,
            focusedLabelColor = focusedLabelColor,
            unfocusedLabelColor = unfocusedLabelColor,
            disabledLabelColor = disabledLabelColor,
            errorLabelColor = errorLabelColor,
            placeholderColor = placeholderColor,
            supportingTextColor = supportingTextColor,
            errorSupportingTextColor = errorSupportingTextColor,
        )

    internal fun supportingTextPadding(
        start: Dp = TextFieldPadding,
        top: Dp = SupportingTopPadding,
        end: Dp = TextFieldPadding,
        bottom: Dp = 0.dp,
    ): PaddingValues = PaddingValues(start, top, end, bottom)

    /**
     * Default content padding applied to [StackTextField].
     * See [PaddingValues] for more details.
     */
    fun contentPadding(
        start: Dp = TextFieldPadding,
        top: Dp = TextFieldPadding,
        end: Dp = TextFieldPadding,
        bottom: Dp = TextFieldPadding
    ): PaddingValues = PaddingValues(start, top, end, bottom)
}
