package com.paystack.androiddesignsystem.colors

import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.compose.ui.graphics.Color

class PrimaryColors(
    stackBlue: Color,
    navy01: Color,
    navy02: Color,
    navy03: Color,
    navy04: Color,
    navy05: Color,
    navy06: Color,

    ceruleanBlue: Color,
    blue01: Color,
    blue02: Color,
    blue03: Color,
    blue04: Color,
    blue05: Color,
    blue06: Color
) {
    var stackBlue by mutableStateOf(stackBlue)
        private set
    var navy01 by mutableStateOf(navy01)
        private set
    var navy02 by mutableStateOf(navy02)
        private set
    var navy03 by mutableStateOf(navy03)
        private set
    var navy04 by mutableStateOf(navy04)
        private set
    var navy05 by mutableStateOf(navy05)
        private set
    var navy06 by mutableStateOf(navy06)
        private set

    //CeruleanBlue
    var ceruleanBlue by mutableStateOf(ceruleanBlue)
        private set
    var blue01 by mutableStateOf(blue01)
        private set
    var blue02 by mutableStateOf(blue02)
        private set
    var blue03 by mutableStateOf(blue03)
        private set
    var blue04 by mutableStateOf(blue04)
        private set
    var blue05 by mutableStateOf(blue05)
        private set
    var blue06 by mutableStateOf(blue06)
        private set

    fun copy(
        stackBlue: Color = this.stackBlue,
        navy01: Color = this.navy01,
        navy02: Color = this.navy02,
        navy03: Color = this.navy03,
        navy04: Color = this.navy04,
        navy05: Color = this.navy05,
        navy06: Color = this.navy06,

        ceruleanBlue: Color = this.ceruleanBlue,
        blue01: Color = this.blue01,
        blue02: Color = this.blue02,
        blue03: Color = this.blue03,
        blue04: Color = this.blue04,
        blue05: Color = this.blue05,
        blue06: Color = this.blue06


    ): PrimaryColors = PrimaryColors(
        stackBlue,
        navy01,
        navy02,
        navy03,
        navy04,
        navy05,
        navy06,

        ceruleanBlue,
        blue01,
        blue02,
        blue03,
        blue04,
        blue05,
        blue06
    )

    fun updateColorsFrom(other: PrimaryColors) {
        stackBlue = other.stackBlue
        navy01 = other.navy01
        navy02 = other.navy02
        navy03 = other.navy03
        navy04 = other.navy04
        navy05 = other.navy05
        navy06 = other.navy06

        ceruleanBlue = other.ceruleanBlue
        blue01 = other.blue01
        blue02 = other.blue02
        blue03 = other.blue03
        blue04 = other.blue04
        blue05 = other.blue05
        blue06 = other.blue06
    }
}

private val stackBlueDefault = Color(0xFF011B33)
private val Navy01 = Color(0xFF394956)
private val Navy02 = Color(0xFF596A7A)
private val Navy03 = Color(0xFF98A6AD)
private val Navy04 = Color(0xFFCCD1D6)
private val Navy05 = Color(0xFFE6E8EB)
private val Navy06 = Color(0xFFF5F6F7)

private val CeruleanBlue = Color(0xFF09A5DB)
private val Blue01 = Color(0xFF096A8B)
private val Blue02 = Color(0xFF61C5E8)
private val Blue03 = Color(0xFF9DDBF1)
private val Blue04 = Color(0xFFC6E8F7)
private val Blue05 = Color(0xFFEAF6FC)
private val Blue06 = Color(0xFFF5FBFE)

fun lightPrimaryColors(
    stackBlue: Color = stackBlueDefault,
    navy01: Color = Navy01,
    navy02: Color = Navy02,
    navy03: Color = Navy03,
    navy04: Color = Navy04,
    navy05: Color = Navy05,
    navy06: Color = Navy06,

    ceruleanBlue: Color = CeruleanBlue,
    blue01: Color = Blue01,
    blue02: Color = Blue02,
    blue03: Color = Blue03,
    blue04: Color = Blue04,
    blue05: Color = Blue05,
    blue06: Color = Blue06
): PrimaryColors = PrimaryColors(
    stackBlue,
    navy01,
    navy02,
    navy03,
    navy04,
    navy05,
    navy06,

    ceruleanBlue,
    blue01,
    blue02,
    blue03,
    blue04,
    blue05,
    blue06
)