/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.BillingAgreementToken;
import com.paypal.api.payments.CreditFinancingOffered;
import com.paypal.api.payments.Error;
import com.paypal.api.payments.Links;
import com.paypal.api.payments.Patch;
import com.paypal.api.payments.Payee;
import com.paypal.api.payments.Payer;
import com.paypal.api.payments.PaymentExecution;
import com.paypal.api.payments.PaymentHistory;
import com.paypal.api.payments.PaymentInstruction;
import com.paypal.api.payments.PotentialPayerInfo;
import com.paypal.api.payments.RedirectUrls;
import com.paypal.api.payments.Transaction;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.JSONFormatter;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import com.paypal.base.sdk.info.SDKVersionImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Payment
extends PayPalResource {
    private String id;
    private String intent;
    private Payer payer;
    private PotentialPayerInfo potentialPayerInfo;
    private Payee payee;
    private String cart;
    private List<Transaction> transactions;
    private List<Error> failedTransactions;
    private List<BillingAgreementToken> billingAgreementTokens;
    private CreditFinancingOffered creditFinancingOffered;
    private PaymentInstruction paymentInstruction;
    private String state;
    private String experienceProfileId;
    private String noteToPayer;
    private RedirectUrls redirectUrls;
    private String failureReason;
    private String createTime;
    private String updateTime;
    private List<Links> links;

    public static String getLastRequest() {
        return PayPalResource.getLastRequest();
    }

    public static String getLastResponse() {
        return PayPalResource.getLastResponse();
    }

    public Payment() {
    }

    public Payment(String intent, Payer payer) {
        this.intent = intent;
        this.payer = payer;
    }

    public Payment setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Payment setIntent(String intent) {
        this.intent = intent;
        return this;
    }

    public String getIntent() {
        return this.intent;
    }

    public Payment setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public Payment setPotentialPayerInfo(PotentialPayerInfo potentialPayerInfo) {
        this.potentialPayerInfo = potentialPayerInfo;
        return this;
    }

    public PotentialPayerInfo getPotentialPayerInfo() {
        return this.potentialPayerInfo;
    }

    public Payment setPayee(Payee payee) {
        this.payee = payee;
        return this;
    }

    public Payee getPayee() {
        return this.payee;
    }

    public Payment setCart(String cart) {
        this.cart = cart;
        return this;
    }

    public String getCart() {
        return this.cart;
    }

    public Payment setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public Payment setFailedTransactions(List<Error> failedTransactions) {
        this.failedTransactions = failedTransactions;
        return this;
    }

    public List<Error> getFailedTransactions() {
        return this.failedTransactions;
    }

    public Payment setBillingAgreementTokens(List<BillingAgreementToken> billingAgreementTokens) {
        this.billingAgreementTokens = billingAgreementTokens;
        return this;
    }

    public List<BillingAgreementToken> getBillingAgreementTokens() {
        return this.billingAgreementTokens;
    }

    public Payment setCreditFinancingOffered(CreditFinancingOffered creditFinancingOffered) {
        this.creditFinancingOffered = creditFinancingOffered;
        return this;
    }

    public CreditFinancingOffered getCreditFinancingOffered() {
        return this.creditFinancingOffered;
    }

    public Payment setPaymentInstruction(PaymentInstruction paymentInstruction) {
        this.paymentInstruction = paymentInstruction;
        return this;
    }

    public PaymentInstruction getPaymentInstruction() {
        return this.paymentInstruction;
    }

    public Payment setState(String state) {
        this.state = state;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public Payment setExperienceProfileId(String experienceProfileId) {
        this.experienceProfileId = experienceProfileId;
        return this;
    }

    public String getExperienceProfileId() {
        return this.experienceProfileId;
    }

    public Payment setNoteToPayer(String noteToPayer) {
        this.noteToPayer = noteToPayer;
        return this;
    }

    public String getNoteToPayer() {
        return this.noteToPayer;
    }

    public Payment setRedirectUrls(RedirectUrls redirectUrls) {
        this.redirectUrls = redirectUrls;
        return this;
    }

    public RedirectUrls getRedirectUrls() {
        return this.redirectUrls;
    }

    public Payment setFailureReason(String failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public Payment setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public Payment setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public Payment setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public Payment create(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext);
    }

    public Payment create(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        String resourcePath = "v1/payments/payment";
        String payLoad = this.toJSON();
        return Payment.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Payment.class);
    }

    public static Payment get(String accessToken, String paymentId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Payment.get(apiContext, paymentId);
    }

    public static Payment get(APIContext apiContext, String paymentId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (paymentId == null) {
            throw new IllegalArgumentException("paymentId cannot be null");
        }
        Object[] parameters = new Object[]{paymentId};
        String pattern = "v1/payments/payment/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Payment.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Payment.class);
    }

    public Payment execute(String accessToken, PaymentExecution paymentExecution) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.execute(apiContext, paymentExecution);
    }

    public Payment execute(APIContext apiContext, PaymentExecution paymentExecution) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (paymentExecution == null) {
            throw new IllegalArgumentException("paymentExecution cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/payment/{0}/execute";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = paymentExecution.toJSON();
        return Payment.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Payment.class);
    }

    public void update(String accessToken, List<Patch> patchRequest) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.update(apiContext, patchRequest);
    }

    public void update(APIContext apiContext, List<Patch> patchRequest) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (patchRequest == null) {
            throw new IllegalArgumentException("patchRequest cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/payment/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = JSONFormatter.toJSON(patchRequest);
        PayPalResource.configureAndExecute(apiContext, HttpMethod.PATCH, resourcePath, payLoad, null);
    }

    public static PaymentHistory list(String accessToken, Map<String, String> containerMap) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Payment.list(apiContext, containerMap);
    }

    public static PaymentHistory list(APIContext apiContext, Map<String, String> containerMap) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (containerMap == null) {
            throw new IllegalArgumentException("containerMap cannot be null");
        }
        Object[] parameters = new Object[]{containerMap};
        String pattern = "v1/payments/payment?count={0}&start_id={1}&start_index={2}&start_time={3}&end_time={4}&payee_id={5}&sort_by={6}&sort_order={7}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        PaymentHistory paymentHistory = Payment.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, PaymentHistory.class);
        return paymentHistory;
    }
}

