/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.http.serializer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;

public class StreamUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStream(InputStream in, String contentEncoding) throws IOException {
        if (in == null) {
            return null;
        }
        if ("gzip".equals(contentEncoding)) {
            in = new GZIPInputStream(in);
        }
        try {
            int count;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) != -1) {
                out.write(buffer, 0, count);
            }
            String string = new String(out.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void writeOutputStream(OutputStream outputStream, String data) throws IOException {
        StreamUtils.writeOutputStream(outputStream, data.getBytes(StandardCharsets.UTF_8));
    }

    public static void writeOutputStream(OutputStream outputStream, byte[] data) throws IOException {
        outputStream.write(data);
    }
}

