/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.http.serializer;

import com.paypal.http.HttpRequest;
import com.paypal.http.annotations.ListOf;
import com.paypal.http.exceptions.JsonParseException;
import com.paypal.http.exceptions.SerializeException;
import com.paypal.http.serializer.ObjectMapper;
import com.paypal.http.serializer.Serializer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Json
implements Serializer {
    private static final char OBJECT_TOKEN_OPEN = '{';
    private static final char OBJECT_TOKEN_CLOSE = '}';
    private static final char LIST_TOKEN_OPEN = '[';
    private static final char LIST_TOKEN_CLOSE = ']';
    private static final char KEY_DELIMITER = ':';
    private static final char PAIR_DELIMITER = ',';
    private static final char KEY_BARRIER = '\"';
    private static final char KEY_ESCAPER = '\\';

    @Override
    public String contentType() {
        return "^application\\/json";
    }

    private boolean hasAncestor(Class descendant, Class ancestor) {
        List<Class<?>> interfaces;
        if (descendant == null) {
            return false;
        }
        if (ancestor.isInterface() && (interfaces = Arrays.asList(descendant.getInterfaces())).contains(ancestor)) {
            return true;
        }
        if (!descendant.equals(Object.class) && descendant.isAssignableFrom(ancestor)) {
            return true;
        }
        return this.hasAncestor(descendant.getSuperclass(), ancestor);
    }

    @Override
    public <T> T decode(String source, Class<T> cls) throws IOException {
        if (this.hasAncestor(cls, List.class) && cls.getAnnotation(ListOf.class) != null) {
            ListOf listOf = cls.getAnnotation(ListOf.class);
            List deserialized = (List)this.deserializeInternal(source);
            try {
                T outlist = cls.newInstance();
                for (Map map : deserialized) {
                    ((List)outlist).add(this.unmap(map, listOf.listClass()));
                }
                return outlist;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new UnsupportedEncodingException("Could not instantiate type " + cls.getSimpleName());
            }
        }
        if (this.hasAncestor(cls, List.class) || this.hasAncestor(cls, Map.class)) {
            return (T)this.deserializeInternal(source);
        }
        Map deserialized = (Map)this.deserializeInternal(source);
        return this.unmap(deserialized, cls);
    }

    private <T> T unmap(Map<String, Object> map, Class<T> destinationClass) throws IOException {
        try {
            return ObjectMapper.unmap(map, destinationClass);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnsupportedEncodingException("Could not instantiate type " + destinationClass.getSimpleName());
        }
        catch (RuntimeException re) {
            throw new JsonParseException("Unable to parse Json " + re.getMessage());
        }
    }

    @Override
    public byte[] encode(HttpRequest request) throws SerializeException {
        return this.serialize(request.requestBody()).getBytes(StandardCharsets.UTF_8);
    }

    public String serialize(Object o) throws SerializeException {
        if (ObjectMapper.isModel(o)) {
            try {
                return this.jsonValueStringFor(ObjectMapper.map(o));
            }
            catch (IllegalAccessException e) {
                throw new SerializeException(e.getMessage());
            }
        }
        return this.jsonValueStringFor(o);
    }

    private String serializeObjectInternal(Map<String, Object> map) throws SerializeException {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        boolean hasContents = false;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw new SerializeException("Map key must be of class String");
            }
            builder.append(String.format("\"%s\":", entry.getKey()));
            builder.append(this.jsonValueStringFor(entry.getValue()));
            builder.append(',');
            hasContents = true;
        }
        if (hasContents) {
            builder.setLength(builder.length() - 1);
        }
        builder.append('}');
        return builder.toString();
    }

    private String jsonValueStringFor(Object obj) throws SerializeException {
        StringBuilder builder = new StringBuilder();
        if (obj == null) {
            builder.append("null");
        } else if (obj instanceof String) {
            builder.append(String.format("\"%s\"", obj.toString()));
        } else if (obj instanceof Number || obj instanceof Boolean) {
            builder.append(obj.toString());
        } else if (obj instanceof Object[] || obj instanceof Collection) {
            builder.append('[');
            boolean hasContents = false;
            if (obj instanceof Object[]) {
                Object[] contents;
                for (Object o : contents = (Object[])obj) {
                    builder.append(this.jsonValueStringFor(o));
                    builder.append(',');
                    hasContents = true;
                }
            } else {
                Collection contents = (Collection)obj;
                for (Object o : contents) {
                    builder.append(this.jsonValueStringFor(o));
                    builder.append(',');
                    hasContents = true;
                }
            }
            if (hasContents) {
                builder.setLength(builder.length() - 1);
            }
            builder.append(']');
        } else if (obj instanceof Map) {
            builder.append(this.serializeObjectInternal((Map)obj));
        } else if (ObjectMapper.isModel(obj)) {
            builder.append(this.serialize(obj));
        } else {
            throw new SerializeException(String.format("Object of class %s could not be serialized as json", obj.getClass()));
        }
        return builder.toString();
    }

    private List<Object> deserializeListInternal(String json) throws JsonParseException {
        ArrayList<Object> values = new ArrayList<Object>();
        if (json.length() == 2) {
            return values;
        }
        List<String> innerValues = this.splitJsonArray(json.trim());
        for (String innerValue : innerValues) {
            char innerDelim = innerValue.charAt(0);
            if (innerDelim == '{' || innerDelim == '[') {
                values.add(this.deserializeInternal(innerValue));
                continue;
            }
            values.add(this.deserializeSimple(innerValue));
        }
        return values;
    }

    private Object deserializeInternal(String json) throws JsonParseException {
        if ((json = json.trim()).length() == 0) {
            throw new JsonParseException("Cannot parse empty string as json");
        }
        char startingToken = json.charAt(0);
        if (this.opposingToken(startingToken) != json.charAt(json.length() - 1)) {
            throw new JsonParseException("Invalid end token " + json.charAt(0));
        }
        if (startingToken == '{') {
            return this.deserializeObjectInternal(json);
        }
        if (startingToken == '[') {
            return this.deserializeListInternal(json);
        }
        throw new JsonParseException("Invalid starting token " + startingToken);
    }

    private Map<String, Object> deserializeObjectInternal(String json) throws JsonParseException {
        HashMap<String, Object> deserialized = new HashMap<String, Object>();
        char[] raw = json.toCharArray();
        int i = 0;
        while (i < raw.length) {
            while (raw[i] != '{' && raw[i] != '\"') {
                ++i;
            }
            if (raw[i] == '{') {
                if (raw[i + 1] == '}') {
                    return deserialized;
                }
                i = this.advanceTo(raw, i, '\"');
            }
            SearchResult keyResult = this.extractKey(raw, i);
            String key = keyResult.token;
            i = keyResult.endIndex;
            switch (raw[i]) {
                case '{': {
                    SearchResult result = this.extractNextToken(raw, i);
                    i = result.endIndex;
                    deserialized.put(key, this.deserializeInternal(result.token));
                    break;
                }
                case '[': {
                    SearchResult result = this.extractNextToken(raw, i);
                    deserialized.put(key, this.deserializeListInternal(result.token));
                    i = result.endIndex;
                    break;
                }
                default: {
                    SearchResult result = this.extractNextToken(raw, i);
                    deserialized.put(key, this.deserializeSimple(result.token));
                    i = result.endIndex;
                    break;
                }
            }
            while (i < raw.length && raw[i] != ',') {
                ++i;
            }
        }
        return deserialized;
    }

    private Object deserializeSimple(String s) throws JsonParseException {
        if ((s = s.trim()).equals("null")) {
            return null;
        }
        if (s.startsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        if (s.contains(".")) {
            return Double.parseDouble(s);
        }
        if (s.equals("true") || s.equals("false")) {
            return Boolean.parseBoolean(s);
        }
        if (Character.isDigit(s.charAt(0))) {
            return Long.parseLong(s);
        }
        throw new JsonParseException("Invalid value " + s);
    }

    private int advanceTo(char[] raw, int i, char search) {
        while (raw[i] != search) {
            ++i;
        }
        return i;
    }

    private int consumeWhitespace(char[] raw, int i) {
        while (Character.isWhitespace(raw[i])) {
            ++i;
        }
        return i;
    }

    private List<String> splitJsonArray(String s) throws JsonParseException {
        ArrayList<String> split = new ArrayList<String>();
        char[] chars = s.toCharArray();
        for (int i = 1; i < chars.length; ++i) {
            i = this.consumeWhitespace(chars, i);
            SearchResult result = this.extractNextToken(chars, i);
            i = result.endIndex;
            split.add(result.token);
            i = this.consumeWhitespace(chars, i);
            if (chars[i] != ']' && chars[i] != ',') {
                throw new JsonParseException("Invalid json array delimiter " + chars[i]);
            }
            if (chars[i] == ']') break;
        }
        return split;
    }

    private SearchResult extractKey(char[] raw, int i) throws JsonParseException {
        if (raw[i = this.consumeWhitespace(raw, i)] == '\"') {
            ++i;
        } else {
            throw new JsonParseException("Malformed json - missing key barrier");
        }
        StringBuilder keyName = new StringBuilder();
        while (raw[i] != '\"') {
            keyName.append(raw[i]);
            ++i;
        }
        if (raw[i] == '\"') {
            ++i;
        } else {
            throw new JsonParseException("Malformed json - missing key barrier");
        }
        i = this.consumeWhitespace(raw, i);
        if (raw[i] != ':') {
            throw new JsonParseException("Malformed json - missing pair delimiter");
        }
        ++i;
        i = this.consumeWhitespace(raw, i);
        return new SearchResult(i, keyName.toString());
    }

    private SearchResult extractNextToken(char[] s, int i) {
        switch (s[i]) {
            case '[': 
            case '{': {
                return this.extractNextObjectToken(s, i);
            }
            case '\"': {
                return this.extractNextStringToken(s, i);
            }
        }
        return this.extractNextValueToken(s, i);
    }

    /*
     * Enabled aggressive block sorting
     */
    private SearchResult extractNextObjectToken(char[] s, int i) {
        int startIndex = i;
        char startToken = s[i];
        char searchToken = this.opposingToken(s[i]);
        int innerCount = 0;
        ++innerCount;
        if (this.matchesOpposing(s[++i], searchToken)) {
            if (this.matchesOpposing(s[i], searchToken)) {
                ++i;
            }
        } else {
            while (++i < s.length) {
                if (this.isBoundaryChar(startToken) && s[i] == startToken) {
                    ++innerCount;
                } else if (this.matchesOpposing(s[i], searchToken) && --innerCount == 0) {
                    ++i;
                    break;
                }
                if (i < s.length) continue;
            }
        }
        String val = new String(s, startIndex, i - startIndex);
        return new SearchResult(i, val);
    }

    private SearchResult extractNextStringToken(char[] s, int i) {
        int startIndex = i;
        if (s[i + 1] == '\"' && !this.isEscaped(s, i + 1)) {
            i += 2;
        } else {
            while (s[++i] != '\"' || this.isEscaped(s, i)) {
            }
            ++i;
        }
        String val = new String(s, startIndex, i - startIndex);
        return new SearchResult(i, val);
    }

    private boolean isEscaped(char[] s, int i) {
        if (i - 1 >= 0) {
            return s[i - 1] == '\\';
        }
        return false;
    }

    private SearchResult extractNextValueToken(char[] s, int i) {
        int startIndex = i;
        while (s[i] != ',' && s[i] != '}' && s[i] != ']') {
            ++i;
        }
        String val = new String(s, startIndex, i - startIndex);
        return new SearchResult(i, val);
    }

    private char opposingToken(char token) {
        switch (token) {
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': {
                return '\"';
            }
        }
        return ',';
    }

    private boolean isBoundaryChar(char token) {
        switch (token) {
            case '\"': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private boolean matchesOpposing(char search, char token) {
        if (search == token) {
            return true;
        }
        if (token == ',') {
            return search == '}' || search == ']' || search == ',';
        }
        return false;
    }

    private static class SearchResult {
        private int endIndex;
        private String token;

        private SearchResult(int endIndex, String token) {
            this.endIndex = endIndex;
            this.token = token;
        }
    }
}

