/*
 * Decompiled with CFR 0.152.
 */
package com.paymennt.crypto.lib;

import com.paymennt.crypto.lib.BitsConverter;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.util.encoders.Hex;

public class Bech32 {
    private static final String BECH32_ALPHABET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
    public static final int BECH32 = 1;
    public static final int BECH32M = 2;
    private static final int BECH32M_CONST = 734539939;

    public static List<Integer> createChecksum(String hrp, List<Integer> data, int spec) {
        ArrayList<Integer> values = new ArrayList<Integer>(Bech32.hrpExpand(hrp));
        values.addAll(data);
        values.addAll(List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0)));
        BigInteger constant = spec == 2 ? BigInteger.valueOf(734539939L) : BigInteger.ONE;
        BigInteger polymod = Bech32.polymod(values).xor(constant);
        ArrayList<Integer> checksum = new ArrayList<Integer>();
        for (int i = 0; i < 6; ++i) {
            checksum.add(polymod.shiftRight(BigInteger.valueOf(5L).multiply(BigInteger.valueOf(5L).subtract(BigInteger.valueOf(i))).intValueExact()).and(BigInteger.valueOf(31L)).intValueExact());
        }
        return checksum;
    }

    public static List<Integer> hrpExpand(String hrp) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (char c : hrp.toCharArray()) {
            list.add(c >> 5);
        }
        list.add(0);
        for (char c : hrp.toCharArray()) {
            list.add(c & 0x1F);
        }
        return list;
    }

    public static BigInteger polymod(List<Integer> values) {
        BigInteger[] generator = new BigInteger[]{new BigInteger(1, Hex.decode((String)"3b6a57b2")), new BigInteger(1, Hex.decode((String)"26508e6d")), new BigInteger(1, Hex.decode((String)"1ea119fa")), new BigInteger(1, Hex.decode((String)"3d4233dd")), new BigInteger(1, Hex.decode((String)"2a1462b3"))};
        BigInteger checksum = BigInteger.ONE;
        for (Integer value : values) {
            BigInteger top = checksum.shiftRight(25);
            checksum = checksum.and(new BigInteger(1, Hex.decode((String)"01ffffff"))).shiftLeft(5).xor(BigInteger.valueOf(value.intValue()));
            for (int i = 0; i < 5; ++i) {
                checksum = !top.shiftRight(i).and(BigInteger.ONE).equals(BigInteger.ZERO) ? checksum.xor(generator[i]) : checksum.xor(BigInteger.ZERO);
            }
        }
        return checksum;
    }

    public static String encode(String hrp, int witnessVersion, byte[] witnessProgram) {
        int spec = witnessVersion == 0 ? 1 : 2;
        ArrayList<Integer> combinedProgram = new ArrayList<Integer>();
        combinedProgram.add(witnessVersion);
        combinedProgram.addAll(BitsConverter.convertBits(witnessProgram, 8, 5, true));
        String result = Bech32.bech32Encode(hrp, combinedProgram, spec);
        String[] decoded = Bech32.decode(hrp, result);
        if (Objects.isNull(decoded[0]) || Objects.isNull(decoded[1])) {
            return null;
        }
        return result;
    }

    private static String bech32Encode(String hrp, ArrayList<Integer> combinedProgram, int spec) {
        ArrayList<Integer> combined = new ArrayList<Integer>(combinedProgram);
        combined.addAll(Bech32.createChecksum(hrp, combinedProgram, spec));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(hrp);
        stringBuilder.append("1");
        for (Integer i : combined) {
            stringBuilder.append(BECH32_ALPHABET.charAt(i));
        }
        return stringBuilder.toString();
    }

    public static String[] decode(String hrp, String address) {
        Object[] hrpAddress = Bech32.bech32Decode(address);
        String hrpGot = (String)hrpAddress[0];
        List data = (List)hrpAddress[1];
        BigInteger spec = (BigInteger)hrpAddress[2];
        if (!hrpGot.equals(hrp)) {
            return new String[]{null, null};
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        data.subList(1, data.size()).forEach(byteArrayOutputStream::write);
        List<Integer> decoded = BitsConverter.convertBits(byteArrayOutputStream.toByteArray(), 5, 8, false);
        if (Objects.isNull(decoded) || decoded.size() < 2 || decoded.size() > 40) {
            return new String[]{null, null};
        }
        if ((Integer)data.get(0) > 16) {
            return new String[]{null, null};
        }
        if ((Integer)data.get(0) == 0 && decoded.size() != 20 && decoded.size() != 32) {
            return new String[]{null, null};
        }
        if ((Integer)data.get(0) == 0 && !spec.equals(BigInteger.valueOf(1L)) || (Integer)data.get(0) != 0 && !spec.equals(BigInteger.valueOf(2L))) {
            return new String[]{null, null};
        }
        ByteArrayOutputStream decodedBytes = new ByteArrayOutputStream();
        decoded.forEach(decodedBytes::write);
        return new String[]{String.valueOf(data.get(0)), Hex.toHexString((byte[])decodedBytes.toByteArray())};
    }

    private static Object[] bech32Decode(String address) {
        int position = address.lastIndexOf("1");
        if (!Bech32.isValidAddress(address, position)) {
            return new Object[]{null, null};
        }
        address = address.toLowerCase();
        String hrp = address.substring(0, position);
        ArrayList<Integer> data = new ArrayList<Integer>();
        for (char c : address.substring(position + 1).toCharArray()) {
            data.add(BECH32_ALPHABET.indexOf(c));
        }
        BigInteger spec = Bech32.verifyChecksum(hrp, data);
        if (Objects.isNull(spec)) {
            return new Object[]{null, null};
        }
        return new Object[]{hrp, data.subList(0, data.size() - 6), spec};
    }

    private static boolean isValidAddress(String address, int position) {
        for (char c : address.toCharArray()) {
            if (c >= '!' && c <= '~') continue;
            return false;
        }
        if (position < 1 || position + 7 > address.length() || address.length() > 90) {
            return false;
        }
        return !Bech32.isMixedCase(address);
    }

    private static BigInteger verifyChecksum(String hrp, List<Integer> data) {
        ArrayList<Integer> combined = new ArrayList<Integer>(Bech32.hrpExpand(hrp));
        combined.addAll(data);
        BigInteger constant = Bech32.polymod(combined);
        if (constant.equals(BigInteger.ONE)) {
            return BigInteger.valueOf(1L);
        }
        if (constant.equals(BigInteger.valueOf(734539939L))) {
            return BigInteger.valueOf(2L);
        }
        return null;
    }

    private static boolean isMixedCase(String address) {
        return !address.toLowerCase().equals(address) && !address.toUpperCase().equals(address);
    }
}

