/*
 * Decompiled with CFR 0.152.
 */
package com.paymennt.crypto.bip32.extern;

import com.paymennt.crypto.bip32.exception.CryptoException;

public class Hex {
    public static final String PREF = "0x";
    private static final char[] intToHex = "0123456789abcdef".toCharArray();
    private static final int[] hexToInt = new int[128];

    private Hex() {
    }

    public static String encode(byte[] raw) {
        char[] hex = new char[raw.length * 2];
        for (int i = 0; i < raw.length; ++i) {
            hex[i * 2] = intToHex[(raw[i] & 0xF0) >> 4];
            hex[i * 2 + 1] = intToHex[raw[i] & 0xF];
        }
        return new String(hex);
    }

    public static String encode0x(byte[] raw) {
        return PREF + Hex.encode(raw);
    }

    public static byte[] decode(String hex) throws CryptoException {
        if (hex == null || !hex.matches("([0-9a-fA-F]{2})*")) {
            throw new CryptoException("Invalid hex string");
        }
        byte[] raw = new byte[hex.length() / 2];
        char[] chars = hex.toCharArray();
        for (int i = 0; i < chars.length; i += 2) {
            raw[i / 2] = (byte)((hexToInt[chars[i]] << 4) + hexToInt[chars[i + 1]]);
        }
        return raw;
    }

    public static byte[] decode0x(String hex) throws CryptoException {
        if (hex != null && hex.startsWith(PREF)) {
            return Hex.decode(hex.substring(2));
        }
        return Hex.decode(hex);
    }

    static {
        for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
            if (i < 10) {
                Hex.hexToInt[48 + i] = i;
                continue;
            }
            Hex.hexToInt[97 + i - 10] = i;
            Hex.hexToInt[65 + i - 10] = i;
        }
    }
}

