/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import com.parse.GCMService;
import com.parse.GcmRegistrar;
import com.parse.ManifestInfo;
import com.parse.PLog;
import com.parse.PPNSUtil;
import com.parse.ParseInstallation;
import com.parse.ParsePlugins;
import com.parse.ProxyService;
import com.parse.PushType;
import com.parse.ServiceUtils;
import java.util.ArrayList;
import java.util.List;

public final class PushService
extends Service {
    private static final String TAG = "com.parse.PushService";
    static final String ACTION_START_IF_REQUIRED = "com.parse.PushService.startIfRequired";
    private static boolean loggedStartError = false;
    private static List<ServiceLifecycleCallbacks> serviceLifecycleCallbacks = null;
    private ProxyService proxy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerServiceLifecycleCallbacks(ServiceLifecycleCallbacks callbacks) {
        Class<PushService> clazz = PushService.class;
        synchronized (PushService.class) {
            if (serviceLifecycleCallbacks == null) {
                serviceLifecycleCallbacks = new ArrayList<ServiceLifecycleCallbacks>();
            }
            serviceLifecycleCallbacks.add(callbacks);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterServiceLifecycleCallbacks(ServiceLifecycleCallbacks callbacks) {
        Class<PushService> clazz = PushService.class;
        synchronized (PushService.class) {
            serviceLifecycleCallbacks.remove(callbacks);
            if (serviceLifecycleCallbacks.size() <= 0) {
                serviceLifecycleCallbacks = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void dispatchOnServiceCreated(Service service) {
        Object[] callbacks = PushService.collectServiceLifecycleCallbacks();
        if (callbacks != null) {
            for (Object callback : callbacks) {
                ((ServiceLifecycleCallbacks)callback).onServiceCreated(service);
            }
        }
    }

    private static void dispatchOnServiceDestroyed(Service service) {
        Object[] callbacks = PushService.collectServiceLifecycleCallbacks();
        if (callbacks != null) {
            for (Object callback : callbacks) {
                ((ServiceLifecycleCallbacks)callback).onServiceDestroyed(service);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] collectServiceLifecycleCallbacks() {
        Object[] callbacks = null;
        Class<PushService> clazz = PushService.class;
        synchronized (PushService.class) {
            if (serviceLifecycleCallbacks == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            if (serviceLifecycleCallbacks.size() > 0) {
                callbacks = serviceLifecycleCallbacks.toArray();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return callbacks;
        }
    }

    static void startServiceIfRequired(Context context) {
        switch (ManifestInfo.getPushType()) {
            case PPNS: {
                ParseInstallation installation = ParseInstallation.getCurrentInstallation();
                if (installation.getPushType() == PushType.GCM) {
                    PLog.w(TAG, "Detected a client that used to use GCM and is now using PPNS.");
                    installation.removePushType();
                    installation.removeDeviceToken();
                    installation.saveEventually();
                }
                ServiceUtils.runIntentInService(context, new Intent(ACTION_START_IF_REQUIRED), PushService.class);
                break;
            }
            case GCM: {
                GcmRegistrar.getInstance().registerAsync();
                break;
            }
            default: {
                if (loggedStartError) break;
                PLog.e(TAG, "Tried to use push, but this app is not configured for push due to: " + ManifestInfo.getNonePushTypeLogMessage());
                loggedStartError = true;
            }
        }
    }

    static void stopServiceIfRequired(Context context) {
        switch (ManifestInfo.getPushType()) {
            case PPNS: {
                context.stopService(new Intent(context, PushService.class));
            }
        }
    }

    public void onCreate() {
        super.onCreate();
        if (ParsePlugins.Android.get().applicationContext() == null) {
            PLog.e(TAG, "The Parse push service cannot start because Parse.initialize has not yet been called. If you call Parse.initialize from an Activity's onCreate, that call should instead be in the Application.onCreate. Be sure your Application class is registered in your AndroidManifest.xml with the android:name property of your <application> tag.");
            this.stopSelf();
            return;
        }
        switch (ManifestInfo.getPushType()) {
            case PPNS: {
                this.proxy = PPNSUtil.newPPNSService(this);
                break;
            }
            case GCM: {
                this.proxy = new GCMService(this);
                break;
            }
            default: {
                PLog.e(TAG, "PushService somehow started even though this device doesn't support push.");
            }
        }
        if (this.proxy != null) {
            this.proxy.onCreate();
        }
        PushService.dispatchOnServiceCreated(this);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        switch (ManifestInfo.getPushType()) {
            case PPNS: 
            case GCM: {
                return this.proxy.onStartCommand(intent, flags, startId);
            }
        }
        PLog.e(TAG, "Started push service even though no push service is enabled: " + intent);
        ServiceUtils.completeWakefulIntent(intent);
        return 2;
    }

    public IBinder onBind(Intent intent) {
        throw new IllegalArgumentException("You cannot bind directly to the PushService. Use PushService.subscribe instead.");
    }

    public void onDestroy() {
        if (this.proxy != null) {
            this.proxy.onDestroy();
        }
        PushService.dispatchOnServiceDestroyed(this);
        super.onDestroy();
    }

    static interface ServiceLifecycleCallbacks {
        public void onServiceCreated(Service var1);

        public void onServiceDestroyed(Service var1);
    }
}

