/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.os.Parcel;
import android.os.Parcelable;
import com.parse.ParseDecoder;
import com.parse.ParseEncoder;
import com.parse.ParseObject;
import com.parse.ParseObjectParcelDecoder;
import com.parse.ParseObjectParcelEncoder;
import com.parse.ParseParcelDecoder;
import com.parse.ParseParcelEncoder;
import com.parse.ParseQuery;
import com.parse.ParseRelationOperation;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseRelation<T extends ParseObject>
implements Parcelable {
    private final Object mutex = new Object();
    private WeakReference<ParseObject> parent;
    private String parentObjectId;
    private String parentClassName;
    private String key;
    private String targetClass;
    private Set<ParseObject> knownObjects = new HashSet<ParseObject>();
    public static final Parcelable.Creator<ParseRelation> CREATOR = new Parcelable.Creator<ParseRelation>(){

        public ParseRelation createFromParcel(Parcel source) {
            return new ParseRelation(source, new ParseObjectParcelDecoder());
        }

        public ParseRelation[] newArray(int size) {
            return new ParseRelation[size];
        }
    };

    ParseRelation(ParseObject parent, String key) {
        this.parent = new WeakReference<ParseObject>(parent);
        this.parentObjectId = parent.getObjectId();
        this.parentClassName = parent.getClassName();
        this.key = key;
        this.targetClass = null;
    }

    ParseRelation(String targetClass) {
        this.parent = null;
        this.parentObjectId = null;
        this.parentClassName = null;
        this.key = null;
        this.targetClass = targetClass;
    }

    ParseRelation(JSONObject jsonObject, ParseDecoder decoder) {
        this.parent = null;
        this.parentObjectId = null;
        this.parentClassName = null;
        this.key = null;
        this.targetClass = jsonObject.optString("className", null);
        JSONArray objectsArray = jsonObject.optJSONArray("objects");
        if (objectsArray != null) {
            for (int i = 0; i < objectsArray.length(); ++i) {
                this.knownObjects.add((ParseObject)decoder.decode(objectsArray.optJSONObject(i)));
            }
        }
    }

    ParseRelation(Parcel source, ParseParcelDecoder decoder) {
        if (source.readByte() == 1) {
            this.key = source.readString();
        }
        if (source.readByte() == 1) {
            this.targetClass = source.readString();
        }
        if (source.readByte() == 1) {
            this.parentClassName = source.readString();
        }
        if (source.readByte() == 1) {
            this.parentObjectId = source.readString();
        }
        if (source.readByte() == 1) {
            this.parent = new WeakReference<ParseObject>((ParseObject)decoder.decode(source));
        }
        int size = source.readInt();
        for (int i = 0; i < size; ++i) {
            this.knownObjects.add((ParseObject)decoder.decode(source));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureParentAndKey(ParseObject someParent, String someKey) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.parent == null) {
                this.parent = new WeakReference<ParseObject>(someParent);
                this.parentObjectId = someParent.getObjectId();
                this.parentClassName = someParent.getClassName();
            }
            if (this.key == null) {
                this.key = someKey;
            }
            if (this.parent.get() != someParent) {
                throw new IllegalStateException("Internal error. One ParseRelation retrieved from two different ParseObjects.");
            }
            if (!this.key.equals(someKey)) {
                throw new IllegalStateException("Internal error. One ParseRelation retrieved from two different keys.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            ParseRelationOperation<T> operation = new ParseRelationOperation<T>(Collections.singleton(object), null);
            this.targetClass = operation.getTargetClass();
            this.getParent().performOperation(this.key, operation);
            this.knownObjects.add((ParseObject)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            ParseRelationOperation<T> operation = new ParseRelationOperation<T>(null, Collections.singleton(object));
            this.targetClass = operation.getTargetClass();
            this.getParent().performOperation(this.key, operation);
            this.knownObjects.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParseQuery<T> getQuery() {
        Object object = this.mutex;
        synchronized (object) {
            ParseQuery.State.Builder builder = this.targetClass == null ? new ParseQuery.State.Builder(this.parentClassName).redirectClassNameForKey(this.key) : new ParseQuery.State.Builder(this.targetClass);
            builder.whereRelatedTo(this.getParent(), this.key);
            return new ParseQuery(builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONObject encodeToJSON(ParseEncoder objectEncoder) throws JSONException {
        Object object = this.mutex;
        synchronized (object) {
            JSONObject relation = new JSONObject();
            relation.put("__type", (Object)"Relation");
            relation.put("className", (Object)this.targetClass);
            JSONArray knownObjectsArray = new JSONArray();
            for (ParseObject knownObject : this.knownObjects) {
                try {
                    knownObjectsArray.put((Object)objectEncoder.encodeRelatedObject(knownObject));
                }
                catch (Exception e) {}
            }
            relation.put("objects", (Object)knownObjectsArray);
            return relation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getTargetClass() {
        Object object = this.mutex;
        synchronized (object) {
            return this.targetClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTargetClass(String className) {
        Object object = this.mutex;
        synchronized (object) {
            this.targetClass = className;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addKnownObject(ParseObject object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            this.knownObjects.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeKnownObject(ParseObject object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            this.knownObjects.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasKnownObject(ParseObject object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            return this.knownObjects.contains(object);
        }
    }

    ParseObject getParent() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.get() == null) {
            return ParseObject.createWithoutData(this.parentClassName, this.parentObjectId);
        }
        return (ParseObject)this.parent.get();
    }

    String getKey() {
        return this.key;
    }

    Set<ParseObject> getKnownObjects() {
        return this.knownObjects;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        this.writeToParcel(dest, new ParseObjectParcelEncoder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToParcel(Parcel dest, ParseParcelEncoder encoder) {
        Object object = this.mutex;
        synchronized (object) {
            dest.writeByte(this.key != null ? (byte)1 : 0);
            if (this.key != null) {
                dest.writeString(this.key);
            }
            dest.writeByte(this.targetClass != null ? (byte)1 : 0);
            if (this.targetClass != null) {
                dest.writeString(this.targetClass);
            }
            dest.writeByte(this.parentClassName != null ? (byte)1 : 0);
            if (this.parentClassName != null) {
                dest.writeString(this.parentClassName);
            }
            dest.writeByte(this.parentObjectId != null ? (byte)1 : 0);
            if (this.parentObjectId != null) {
                dest.writeString(this.parentObjectId);
            }
            boolean has = this.parent != null && this.parent.get() != null;
            dest.writeByte(has ? (byte)1 : 0);
            if (has) {
                encoder.encode(this.parent.get(), dest);
            }
            dest.writeInt(this.knownObjects.size());
            for (ParseObject obj : this.knownObjects) {
                encoder.encode(obj, dest);
            }
        }
    }
}

