/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.ParseRESTCommand;
import com.parse.ParseTextUtils;
import com.parse.PointerEncoder;
import com.parse.http.ParseHttpRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

class ParseRESTQueryCommand
extends ParseRESTCommand {
    static final String KEY_ORDER = "order";
    static final String KEY_WHERE = "where";
    static final String KEY_KEYS = "keys";
    static final String KEY_INCLUDE = "include";
    static final String KEY_LIMIT = "limit";
    static final String KEY_COUNT = "count";
    static final String KEY_SKIP = "skip";
    static final String KEY_TRACE = "trace";

    public static <T extends ParseObject> ParseRESTQueryCommand findCommand(ParseQuery.State<T> state, String sessionToken) {
        String httpPath = String.format("classes/%s", state.className());
        Map<String, String> parameters = ParseRESTQueryCommand.encode(state, false);
        return new ParseRESTQueryCommand(httpPath, ParseHttpRequest.Method.GET, parameters, sessionToken);
    }

    public static <T extends ParseObject> ParseRESTQueryCommand countCommand(ParseQuery.State<T> state, String sessionToken) {
        String httpPath = String.format("classes/%s", state.className());
        Map<String, String> parameters = ParseRESTQueryCommand.encode(state, true);
        return new ParseRESTQueryCommand(httpPath, ParseHttpRequest.Method.GET, parameters, sessionToken);
    }

    static <T extends ParseObject> Map<String, String> encode(ParseQuery.State<T> state, boolean count) {
        int limit;
        Set<String> includeds;
        Set<String> selectedKeys;
        ParseQuery.QueryConstraints conditions;
        PointerEncoder encoder = PointerEncoder.get();
        HashMap<String, String> parameters = new HashMap<String, String>();
        List<String> order = state.order();
        if (!order.isEmpty()) {
            parameters.put(KEY_ORDER, ParseTextUtils.join(",", order));
        }
        if (!(conditions = state.constraints()).isEmpty()) {
            JSONObject encodedConditions = (JSONObject)encoder.encode(conditions);
            parameters.put(KEY_WHERE, encodedConditions.toString());
        }
        if ((selectedKeys = state.selectedKeys()) != null) {
            parameters.put(KEY_KEYS, ParseTextUtils.join(",", selectedKeys));
        }
        if (!(includeds = state.includes()).isEmpty()) {
            parameters.put(KEY_INCLUDE, ParseTextUtils.join(",", includeds));
        }
        if ((limit = state.limit()) >= 0) {
            parameters.put(KEY_LIMIT, Integer.toString(limit));
        }
        if (count) {
            parameters.put(KEY_COUNT, Integer.toString(1));
        } else {
            int skip = state.skip();
            if (skip > 0) {
                parameters.put(KEY_SKIP, Integer.toString(skip));
            }
        }
        Map<String, Object> extraOptions = state.extraOptions();
        for (Map.Entry<String, Object> entry : extraOptions.entrySet()) {
            Object encodedExtraOptions = encoder.encode(entry.getValue());
            parameters.put(entry.getKey(), encodedExtraOptions.toString());
        }
        if (state.isTracingEnabled()) {
            parameters.put(KEY_TRACE, Integer.toString(1));
        }
        return parameters;
    }

    private ParseRESTQueryCommand(String httpPath, ParseHttpRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }
}

