/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.os.Parcel;
import com.parse.ParseACL;
import com.parse.ParseDateFormat;
import com.parse.ParseEncoder;
import com.parse.ParseFieldOperation;
import com.parse.ParseFile;
import com.parse.ParseGeoPoint;
import com.parse.ParseObject;
import com.parse.ParseRelation;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.json.JSONObject;

class ParseParcelEncoder {
    private static final ParseParcelEncoder INSTANCE = new ParseParcelEncoder();
    static final String TYPE_OBJECT = "Object";
    static final String TYPE_POINTER = "Pointer";
    static final String TYPE_DATE = "Date";
    static final String TYPE_BYTES = "Bytes";
    static final String TYPE_ACL = "Acl";
    static final String TYPE_RELATION = "Relation";
    static final String TYPE_MAP = "Map";
    static final String TYPE_COLLECTION = "Collection";
    static final String TYPE_JSON_NULL = "JsonNull";
    static final String TYPE_NULL = "Null";
    static final String TYPE_NATIVE = "Native";
    static final String TYPE_OP = "Operation";
    static final String TYPE_FILE = "File";
    static final String TYPE_GEOPOINT = "GeoPoint";

    ParseParcelEncoder() {
    }

    public static ParseParcelEncoder get() {
        return INSTANCE;
    }

    private static boolean isValidType(Object value) {
        return ParseEncoder.isValidType(value);
    }

    public void encode(Object object, Parcel dest) {
        block17: {
            try {
                if (object instanceof ParseObject) {
                    this.encodeParseObject((ParseObject)object, dest);
                    break block17;
                }
                if (object instanceof Date) {
                    dest.writeString(TYPE_DATE);
                    dest.writeString(ParseDateFormat.getInstance().format((Date)object));
                    break block17;
                }
                if (object instanceof byte[]) {
                    dest.writeString(TYPE_BYTES);
                    byte[] bytes = (byte[])object;
                    dest.writeInt(bytes.length);
                    dest.writeByteArray(bytes);
                    break block17;
                }
                if (object instanceof ParseFieldOperation) {
                    dest.writeString(TYPE_OP);
                    ((ParseFieldOperation)object).encode(dest, this);
                    break block17;
                }
                if (object instanceof ParseFile) {
                    dest.writeString(TYPE_FILE);
                    ((ParseFile)object).writeToParcel(dest, this);
                    break block17;
                }
                if (object instanceof ParseGeoPoint) {
                    dest.writeString(TYPE_GEOPOINT);
                    ((ParseGeoPoint)object).writeToParcel(dest, this);
                    break block17;
                }
                if (object instanceof ParseACL) {
                    dest.writeString(TYPE_ACL);
                    ((ParseACL)object).writeToParcel(dest, this);
                    break block17;
                }
                if (object instanceof ParseRelation) {
                    dest.writeString(TYPE_RELATION);
                    ((ParseRelation)object).writeToParcel(dest, this);
                    break block17;
                }
                if (object instanceof Map) {
                    dest.writeString(TYPE_MAP);
                    Map map = (Map)object;
                    dest.writeInt(map.size());
                    for (Map.Entry pair : map.entrySet()) {
                        dest.writeString((String)pair.getKey());
                        this.encode(pair.getValue(), dest);
                    }
                    break block17;
                }
                if (object instanceof Collection) {
                    dest.writeString(TYPE_COLLECTION);
                    Collection collection = (Collection)object;
                    dest.writeInt(collection.size());
                    for (Object item : collection) {
                        this.encode(item, dest);
                    }
                    break block17;
                }
                if (object == JSONObject.NULL) {
                    dest.writeString(TYPE_JSON_NULL);
                    break block17;
                }
                if (object == null) {
                    dest.writeString(TYPE_NULL);
                    break block17;
                }
                if (ParseParcelEncoder.isValidType(object)) {
                    dest.writeString(TYPE_NATIVE);
                    dest.writeValue(object);
                    break block17;
                }
                throw new IllegalArgumentException("Could not encode this object into Parcel. " + object.getClass().toString());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not encode this object into Parcel. " + object.getClass().toString());
            }
        }
    }

    protected void encodeParseObject(ParseObject object, Parcel dest) {
        dest.writeString(TYPE_OBJECT);
        object.writeToParcel(dest, this);
    }

    protected void encodePointer(String className, String objectId, Parcel dest) {
        dest.writeString(TYPE_POINTER);
        dest.writeString(className);
        dest.writeString(objectId);
    }
}

