/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.os.Parcel;
import com.parse.ParseACL;
import com.parse.ParseDecoder;
import com.parse.ParseEncoder;
import com.parse.ParseFieldOperation;
import com.parse.ParseParcelDecoder;
import com.parse.ParseParcelEncoder;
import com.parse.ParseSetOperation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

class ParseOperationSet
extends HashMap<String, ParseFieldOperation> {
    private static final long serialVersionUID = 1L;
    private static final String REST_KEY_IS_SAVE_EVENTUALLY = "__isSaveEventually";
    private static final String REST_KEY_UUID = "__uuid";
    private final String uuid;
    private boolean isSaveEventually = false;

    public ParseOperationSet() {
        this(UUID.randomUUID().toString());
    }

    public ParseOperationSet(ParseOperationSet operations) {
        super(operations);
        this.uuid = operations.getUUID();
        this.isSaveEventually = operations.isSaveEventually;
    }

    private ParseOperationSet(String uuid) {
        this.uuid = uuid;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setIsSaveEventually(boolean value) {
        this.isSaveEventually = value;
    }

    public boolean isSaveEventually() {
        return this.isSaveEventually;
    }

    public void mergeFrom(ParseOperationSet other) {
        for (String key : other.keySet()) {
            ParseFieldOperation operation1 = (ParseFieldOperation)other.get(key);
            ParseFieldOperation operation2 = (ParseFieldOperation)this.get(key);
            operation2 = operation2 != null ? operation2.mergeWithPrevious(operation1) : operation1;
            this.put(key, operation2);
        }
    }

    public JSONObject toRest(ParseEncoder objectEncoder) throws JSONException {
        JSONObject operationSetJSON = new JSONObject();
        for (String key : this.keySet()) {
            ParseFieldOperation op = (ParseFieldOperation)this.get(key);
            operationSetJSON.put(key, op.encode(objectEncoder));
        }
        operationSetJSON.put(REST_KEY_UUID, (Object)this.uuid);
        if (this.isSaveEventually) {
            operationSetJSON.put(REST_KEY_IS_SAVE_EVENTUALLY, true);
        }
        return operationSetJSON;
    }

    public static ParseOperationSet fromRest(JSONObject json, ParseDecoder decoder) throws JSONException {
        Iterator keysIter = json.keys();
        String[] keys = new String[json.length()];
        int index = 0;
        while (keysIter.hasNext()) {
            String key = (String)keysIter.next();
            keys[index++] = key;
        }
        JSONObject jsonCopy = new JSONObject(json, keys);
        String uuid = (String)jsonCopy.remove(REST_KEY_UUID);
        ParseOperationSet operationSet = uuid == null ? new ParseOperationSet() : new ParseOperationSet(uuid);
        boolean isSaveEventually = jsonCopy.optBoolean(REST_KEY_IS_SAVE_EVENTUALLY);
        jsonCopy.remove(REST_KEY_IS_SAVE_EVENTUALLY);
        operationSet.setIsSaveEventually(isSaveEventually);
        Iterator opKeys = jsonCopy.keys();
        while (opKeys.hasNext()) {
            String opKey = (String)opKeys.next();
            Object value = decoder.decode(jsonCopy.get(opKey));
            if (opKey.equals("ACL")) {
                value = ParseACL.createACLFromJSONObject(jsonCopy.getJSONObject(opKey), decoder);
            }
            ParseFieldOperation fieldOp = value instanceof ParseFieldOperation ? (ParseFieldOperation)value : new ParseSetOperation(value);
            operationSet.put(opKey, fieldOp);
        }
        return operationSet;
    }

    void toParcel(Parcel dest, ParseParcelEncoder encoder) {
        dest.writeString(this.uuid);
        dest.writeByte(this.isSaveEventually ? (byte)1 : 0);
        dest.writeInt(this.size());
        for (String key : this.keySet()) {
            dest.writeString(key);
            encoder.encode(this.get(key), dest);
        }
    }

    static ParseOperationSet fromParcel(Parcel source, ParseParcelDecoder decoder) {
        ParseOperationSet set = new ParseOperationSet(source.readString());
        set.setIsSaveEventually(source.readByte() == 1);
        int size = source.readInt();
        for (int i = 0; i < size; ++i) {
            String key = source.readString();
            ParseFieldOperation op = (ParseFieldOperation)decoder.decode(source);
            set.put(key, op);
        }
        return set;
    }
}

