/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.os.Parcel;
import com.parse.ParseObject;
import com.parse.ParseParcelEncoder;
import java.util.HashSet;
import java.util.Set;

class ParseObjectParcelEncoder
extends ParseParcelEncoder {
    private Set<String> ids = new HashSet<String>();

    public ParseObjectParcelEncoder() {
    }

    public ParseObjectParcelEncoder(ParseObject root) {
        this.ids.add(this.getObjectOrLocalId(root));
    }

    @Override
    protected void encodeParseObject(ParseObject object, Parcel dest) {
        String id = this.getObjectOrLocalId(object);
        if (this.ids.contains(id)) {
            this.encodePointer(object.getClassName(), id, dest);
        } else {
            this.ids.add(id);
            super.encodeParseObject(object, dest);
        }
    }

    private String getObjectOrLocalId(ParseObject object) {
        return object.getObjectId() != null ? object.getObjectId() : object.getOrCreateLocalId();
    }
}

