/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.os.Parcel;
import com.parse.Numbers;
import com.parse.ParseDeleteOperation;
import com.parse.ParseEncoder;
import com.parse.ParseFieldOperation;
import com.parse.ParseParcelEncoder;
import com.parse.ParseSetOperation;
import org.json.JSONException;
import org.json.JSONObject;

class ParseIncrementOperation
implements ParseFieldOperation {
    static final String OP_NAME = "Increment";
    private final Number amount;

    public ParseIncrementOperation(Number amount) {
        this.amount = amount;
    }

    public JSONObject encode(ParseEncoder objectEncoder) throws JSONException {
        JSONObject output = new JSONObject();
        output.put("__op", (Object)OP_NAME);
        output.put("amount", (Object)this.amount);
        return output;
    }

    @Override
    public void encode(Parcel dest, ParseParcelEncoder parcelableEncoder) {
        dest.writeString(OP_NAME);
        parcelableEncoder.encode(this.amount, dest);
    }

    @Override
    public ParseFieldOperation mergeWithPrevious(ParseFieldOperation previous) {
        if (previous == null) {
            return this;
        }
        if (previous instanceof ParseDeleteOperation) {
            return new ParseSetOperation(this.amount);
        }
        if (previous instanceof ParseSetOperation) {
            Object oldValue = ((ParseSetOperation)previous).getValue();
            if (oldValue instanceof Number) {
                return new ParseSetOperation(Numbers.add((Number)oldValue, this.amount));
            }
            throw new IllegalArgumentException("You cannot increment a non-number.");
        }
        if (previous instanceof ParseIncrementOperation) {
            Number oldAmount = ((ParseIncrementOperation)previous).amount;
            return new ParseIncrementOperation(Numbers.add(oldAmount, this.amount));
        }
        throw new IllegalArgumentException("Operation is invalid after previous operation.");
    }

    @Override
    public Object apply(Object oldValue, String key) {
        if (oldValue == null) {
            return this.amount;
        }
        if (oldValue instanceof Number) {
            return Numbers.add((Number)oldValue, this.amount);
        }
        throw new IllegalArgumentException("You cannot increment a non-number.");
    }
}

