/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import bolts.Task;
import com.parse.ParseException;
import com.parse.ParseExecutors;
import com.parse.ParseFileUtils;
import com.parse.ParseIOUtils;
import com.parse.ParseRequest;
import com.parse.ProgressCallback;
import com.parse.http.ParseHttpRequest;
import com.parse.http.ParseHttpResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

class ParseFileRequest
extends ParseRequest<Void> {
    private final File tempFile;

    public ParseFileRequest(ParseHttpRequest.Method method, String url, File tempFile) {
        super(method, url);
        this.tempFile = tempFile;
    }

    @Override
    protected Task<Void> onResponseAsync(final ParseHttpResponse response, final ProgressCallback downloadProgressCallback) {
        int statusCode = response.getStatusCode();
        if ((statusCode < 200 || statusCode >= 300) && statusCode != 304) {
            String action = this.method == ParseHttpRequest.Method.GET ? "Download from" : "Upload to";
            return Task.forError((Exception)new ParseException(100, String.format("%s file server failed. %s", action, response.getReasonPhrase())));
        }
        if (this.method != ParseHttpRequest.Method.GET) {
            return null;
        }
        return Task.call((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                Void void_;
                long totalSize = response.getTotalSize();
                long downloadedSize = 0L;
                InputStream responseStream = null;
                FileOutputStream tempFileStream = null;
                try {
                    int nRead;
                    responseStream = response.getContent();
                    tempFileStream = ParseFileUtils.openOutputStream(ParseFileRequest.this.tempFile);
                    byte[] data = new byte[32768];
                    while ((nRead = responseStream.read(data, 0, data.length)) != -1) {
                        tempFileStream.write(data, 0, nRead);
                        downloadedSize += (long)nRead;
                        if (downloadProgressCallback == null || totalSize == -1L) continue;
                        int progressToReport = Math.round((float)downloadedSize / (float)totalSize * 100.0f);
                        downloadProgressCallback.done(progressToReport);
                    }
                    void_ = null;
                }
                catch (Throwable throwable) {
                    ParseIOUtils.closeQuietly(responseStream);
                    ParseIOUtils.closeQuietly(tempFileStream);
                    throw throwable;
                }
                ParseIOUtils.closeQuietly(responseStream);
                ParseIOUtils.closeQuietly(tempFileStream);
                return void_;
            }
        }, (Executor)ParseExecutors.io());
    }
}

