/*
 * Decompiled with CFR 0.152.
 */
package bolts;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.util.SparseArray;
import bolts.AppLink;
import bolts.AppLinkResolver;
import bolts.Continuation;
import bolts.MeasurementEvent;
import bolts.Task;
import bolts.WebViewAppLinkResolver;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppLinkNavigation {
    private static final String KEY_NAME_USER_AGENT = "user_agent";
    private static final String KEY_NAME_VERSION = "version";
    private static final String KEY_NAME_REFERER_APP_LINK = "referer_app_link";
    private static final String KEY_NAME_REFERER_APP_LINK_APP_NAME = "app_name";
    private static final String KEY_NAME_REFERER_APP_LINK_PACKAGE = "package";
    private static final String VERSION = "1.0";
    private static AppLinkResolver defaultResolver;
    private final AppLink appLink;
    private final Bundle extras;
    private final Bundle appLinkData;

    public AppLinkNavigation(AppLink appLink, Bundle extras, Bundle appLinkData) {
        if (appLink == null) {
            throw new IllegalArgumentException("appLink must not be null.");
        }
        if (extras == null) {
            extras = new Bundle();
        }
        if (appLinkData == null) {
            appLinkData = new Bundle();
        }
        this.appLink = appLink;
        this.extras = extras;
        this.appLinkData = appLinkData;
    }

    public AppLink getAppLink() {
        return this.appLink;
    }

    public Bundle getAppLinkData() {
        return this.appLinkData;
    }

    public Bundle getExtras() {
        return this.extras;
    }

    private Bundle buildAppLinkDataForNavigation(Context context) {
        Bundle data = new Bundle();
        Bundle refererAppLinkData = new Bundle();
        if (context != null) {
            String refererAppName;
            ApplicationInfo appInfo;
            String refererAppPackage = context.getPackageName();
            if (refererAppPackage != null) {
                refererAppLinkData.putString(KEY_NAME_REFERER_APP_LINK_PACKAGE, refererAppPackage);
            }
            if ((appInfo = context.getApplicationInfo()) != null && (refererAppName = context.getString(appInfo.labelRes)) != null) {
                refererAppLinkData.putString(KEY_NAME_REFERER_APP_LINK_APP_NAME, refererAppName);
            }
        }
        data.putAll(this.getAppLinkData());
        data.putString("target_url", this.getAppLink().getSourceUrl().toString());
        data.putString(KEY_NAME_VERSION, VERSION);
        data.putString(KEY_NAME_USER_AGENT, "Bolts Android 1.2.1");
        data.putBundle(KEY_NAME_REFERER_APP_LINK, refererAppLinkData);
        data.putBundle("extras", this.getExtras());
        return data;
    }

    private Object getJSONValue(Object value) throws JSONException {
        if (value instanceof Bundle) {
            return this.getJSONForBundle((Bundle)value);
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof List) {
            JSONArray array = new JSONArray();
            for (Object listValue : (List)value) {
                array.put(this.getJSONValue(listValue));
            }
            return array;
        }
        if (value instanceof SparseArray) {
            JSONArray array = new JSONArray();
            SparseArray sparseValue = (SparseArray)value;
            for (int i = 0; i < sparseValue.size(); ++i) {
                array.put(sparseValue.keyAt(i), this.getJSONValue(sparseValue.valueAt(i)));
            }
            return array;
        }
        if (value instanceof Character) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Number) {
            if (value instanceof Double || value instanceof Float) {
                return ((Number)value).doubleValue();
            }
            return ((Number)value).longValue();
        }
        if (value instanceof boolean[]) {
            JSONArray array = new JSONArray();
            for (boolean arrValue : (boolean[])value) {
                array.put(this.getJSONValue(arrValue));
            }
            return array;
        }
        if (value instanceof char[]) {
            JSONArray array = new JSONArray();
            for (char arrValue : (char[])value) {
                array.put(this.getJSONValue(Character.valueOf(arrValue)));
            }
            return array;
        }
        if (value instanceof CharSequence[]) {
            JSONArray array = new JSONArray();
            for (CharSequence arrValue : (CharSequence[])value) {
                array.put(this.getJSONValue(arrValue));
            }
            return array;
        }
        if (value instanceof double[]) {
            JSONArray array = new JSONArray();
            for (double arrValue : (double[])value) {
                array.put(this.getJSONValue(arrValue));
            }
            return array;
        }
        if (value instanceof float[]) {
            JSONArray array = new JSONArray();
            for (float arrValue : (float[])value) {
                array.put(this.getJSONValue(Float.valueOf(arrValue)));
            }
            return array;
        }
        if (value instanceof int[]) {
            JSONArray array = new JSONArray();
            for (int arrValue : (int[])value) {
                array.put(this.getJSONValue(arrValue));
            }
            return array;
        }
        if (value instanceof long[]) {
            JSONArray array = new JSONArray();
            for (long arrValue : (long[])value) {
                array.put(this.getJSONValue(arrValue));
            }
            return array;
        }
        if (value instanceof short[]) {
            JSONArray array = new JSONArray();
            for (short arrValue : (short[])value) {
                array.put(this.getJSONValue(arrValue));
            }
            return array;
        }
        if (value instanceof String[]) {
            JSONArray array = new JSONArray();
            for (String arrValue : (String[])value) {
                array.put(this.getJSONValue(arrValue));
            }
            return array;
        }
        return null;
    }

    private JSONObject getJSONForBundle(Bundle bundle) throws JSONException {
        JSONObject root = new JSONObject();
        for (String key : bundle.keySet()) {
            root.put(key, this.getJSONValue(bundle.get(key)));
        }
        return root;
    }

    public NavigationResult navigate(Context context) {
        PackageManager pm = context.getPackageManager();
        Bundle finalAppLinkData = this.buildAppLinkDataForNavigation(context);
        Intent eligibleTargetIntent = null;
        for (AppLink.Target target : this.getAppLink().getTargets()) {
            Intent targetIntent = new Intent("android.intent.action.VIEW");
            if (target.getUrl() != null) {
                targetIntent.setData(target.getUrl());
            } else {
                targetIntent.setData(this.appLink.getSourceUrl());
            }
            targetIntent.setPackage(target.getPackageName());
            if (target.getClassName() != null) {
                targetIntent.setClassName(target.getPackageName(), target.getClassName());
            }
            targetIntent.putExtra("al_applink_data", finalAppLinkData);
            ResolveInfo resolved = pm.resolveActivity(targetIntent, 65536);
            if (resolved == null) continue;
            eligibleTargetIntent = targetIntent;
            break;
        }
        Intent outIntent = null;
        NavigationResult result = NavigationResult.FAILED;
        if (eligibleTargetIntent != null) {
            outIntent = eligibleTargetIntent;
            result = NavigationResult.APP;
        } else {
            Uri webUrl = this.getAppLink().getWebUrl();
            if (webUrl != null) {
                JSONObject appLinkDataJson;
                try {
                    appLinkDataJson = this.getJSONForBundle(finalAppLinkData);
                }
                catch (JSONException e) {
                    this.sendAppLinkNavigateEventBroadcast(context, eligibleTargetIntent, NavigationResult.FAILED, e);
                    throw new RuntimeException(e);
                }
                webUrl = webUrl.buildUpon().appendQueryParameter("al_applink_data", appLinkDataJson.toString()).build();
                outIntent = new Intent("android.intent.action.VIEW", webUrl);
                result = NavigationResult.WEB;
            }
        }
        this.sendAppLinkNavigateEventBroadcast(context, outIntent, result, null);
        if (outIntent != null) {
            context.startActivity(outIntent);
        }
        return result;
    }

    private void sendAppLinkNavigateEventBroadcast(Context context, Intent intent, NavigationResult type, JSONException e) {
        HashMap<String, String> extraLoggingData = new HashMap<String, String>();
        if (e != null) {
            extraLoggingData.put("error", e.getLocalizedMessage());
        }
        extraLoggingData.put("success", type.isSucceeded() ? "1" : "0");
        extraLoggingData.put("type", type.getCode());
        MeasurementEvent.sendBroadcastEvent(context, "al_nav_out", intent, extraLoggingData);
    }

    public static void setDefaultResolver(AppLinkResolver resolver) {
        defaultResolver = resolver;
    }

    public static AppLinkResolver getDefaultResolver() {
        return defaultResolver;
    }

    private static AppLinkResolver getResolver(Context context) {
        if (AppLinkNavigation.getDefaultResolver() != null) {
            return AppLinkNavigation.getDefaultResolver();
        }
        return new WebViewAppLinkResolver(context);
    }

    public static NavigationResult navigate(Context context, AppLink appLink) {
        return new AppLinkNavigation(appLink, null, null).navigate(context);
    }

    public static Task<NavigationResult> navigateInBackground(final Context context, Uri destination, AppLinkResolver resolver) {
        return resolver.getAppLinkFromUrlInBackground(destination).onSuccess(new Continuation<AppLink, NavigationResult>(){

            @Override
            public NavigationResult then(Task<AppLink> task) throws Exception {
                return AppLinkNavigation.navigate(context, task.getResult());
            }
        }, Task.UI_THREAD_EXECUTOR);
    }

    public static Task<NavigationResult> navigateInBackground(Context context, URL destination, AppLinkResolver resolver) {
        return AppLinkNavigation.navigateInBackground(context, Uri.parse((String)destination.toString()), resolver);
    }

    public static Task<NavigationResult> navigateInBackground(Context context, String destinationUrl, AppLinkResolver resolver) {
        return AppLinkNavigation.navigateInBackground(context, Uri.parse((String)destinationUrl), resolver);
    }

    public static Task<NavigationResult> navigateInBackground(Context context, Uri destination) {
        return AppLinkNavigation.navigateInBackground(context, destination, AppLinkNavigation.getResolver(context));
    }

    public static Task<NavigationResult> navigateInBackground(Context context, URL destination) {
        return AppLinkNavigation.navigateInBackground(context, destination, AppLinkNavigation.getResolver(context));
    }

    public static Task<NavigationResult> navigateInBackground(Context context, String destinationUrl) {
        return AppLinkNavigation.navigateInBackground(context, destinationUrl, AppLinkNavigation.getResolver(context));
    }

    public static enum NavigationResult {
        FAILED("failed", false),
        WEB("web", true),
        APP("app", true);

        private String code;
        private boolean succeeded;

        public String getCode() {
            return this.code;
        }

        public boolean isSucceeded() {
            return this.succeeded;
        }

        private NavigationResult(String code, boolean success) {
            this.code = code;
            this.succeeded = success;
        }
    }
}

