/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.environmentmanager.jenkins;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class ReportSettingsInjector
extends InputStream {
    private static final String RESULTS_SESSION = "ResultsSession";
    private static final String PROJECT = "project";
    private static final String BUILD_ID = "buildId";
    private static final String TAG = "tag";
    private static final String EXEC_ENV = "execEnv";
    private boolean captureAttributeName;
    private boolean captureElementName;
    private boolean insideAttributeValue;
    private boolean insideQuotes;
    private boolean replaceAttributeValue;
    private boolean finishedInjecting;
    private StringBuilder attributeName;
    private StringBuilder elementName;
    private final InputStream projectBuffer;
    private final InputStream buildIdBuffer;
    private final InputStream tagBuffer;
    private final InputStream wrapped;
    private final InputStream execEnvBuffer;
    private InputStream appendBuffer;
    private final String execEnv;

    private static InputStream makeBuffer(String text) {
        if (text != null && !text.isEmpty()) {
            return new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    public ReportSettingsInjector(String project, String buildId, String tag, String execEnv, InputStream in) {
        this.projectBuffer = ReportSettingsInjector.makeBuffer(project);
        this.buildIdBuffer = ReportSettingsInjector.makeBuffer(buildId);
        this.tagBuffer = ReportSettingsInjector.makeBuffer(tag);
        this.execEnvBuffer = ReportSettingsInjector.makeBuffer(execEnv);
        this.execEnv = execEnv;
        this.appendBuffer = null;
        this.captureAttributeName = false;
        this.insideAttributeValue = false;
        this.captureElementName = false;
        this.insideQuotes = false;
        this.replaceAttributeValue = false;
        this.attributeName = new StringBuilder();
        this.elementName = new StringBuilder();
        this.finishedInjecting = false;
        this.wrapped = in;
    }

    private int nextReplacementChar() throws IOException {
        int next = -1;
        if (PROJECT.equals(this.attributeName.toString())) {
            next = this.projectBuffer.read();
        }
        if (BUILD_ID.equals(this.attributeName.toString())) {
            next = this.buildIdBuffer.read();
        }
        if (TAG.equals(this.attributeName.toString())) {
            next = this.tagBuffer.read();
        }
        if (next == -1) {
            next = 34;
            this.replaceAttributeValue = false;
            this.insideAttributeValue = false;
            this.insideQuotes = false;
        }
        return next;
    }

    @Override
    public int read() throws IOException {
        if (this.replaceAttributeValue) {
            return this.nextReplacementChar();
        }
        if (this.appendBuffer != null && this.appendBuffer.available() > 0) {
            return this.appendBuffer.read();
        }
        int next = this.wrapped.read();
        if (this.finishedInjecting) {
            return next;
        }
        if (!(this.insideQuotes || next != 47 && next != 62)) {
            this.captureElementName = false;
            if (RESULTS_SESSION.equals(this.elementName.toString())) {
                if (this.execEnvBuffer != null && this.execEnvBuffer.available() > 0) {
                    this.appendBuffer = ReportSettingsInjector.makeBuffer("execEnv=\"" + this.execEnv + '\"' + (char)next);
                    return 32;
                }
                this.finishedInjecting = true;
            }
            return next;
        }
        if (RESULTS_SESSION.equals(this.elementName.toString())) {
            if (this.insideAttributeValue) {
                if (next != 34) {
                    return next;
                }
                boolean bl = this.insideQuotes = !this.insideQuotes;
                if (!this.insideQuotes) {
                    this.insideAttributeValue = false;
                } else if (this.projectBuffer != null && PROJECT.equals(this.attributeName.toString())) {
                    this.replaceAttributeValue = true;
                    while (this.wrapped.read() != 34) {
                    }
                } else if (this.buildIdBuffer != null && BUILD_ID.equals(this.attributeName.toString())) {
                    this.replaceAttributeValue = true;
                    while (this.wrapped.read() != 34) {
                    }
                } else if (this.tagBuffer != null && TAG.equals(this.attributeName.toString())) {
                    this.replaceAttributeValue = true;
                    while (this.wrapped.read() != 34) {
                    }
                } else if (this.execEnvBuffer != null && EXEC_ENV.equals(this.attributeName.toString())) {
                    this.replaceAttributeValue = true;
                    while (this.wrapped.read() != 34) {
                    }
                }
            } else if (this.captureAttributeName) {
                if (next == 61) {
                    this.captureAttributeName = false;
                    this.insideAttributeValue = true;
                } else if (Character.isWhitespace(next)) {
                    this.captureAttributeName = false;
                } else {
                    this.attributeName.append((char)next);
                }
            } else if (!Character.isWhitespace(next)) {
                this.captureAttributeName = true;
                this.attributeName.setLength(0);
                this.attributeName.append((char)next);
            }
        }
        if (this.captureElementName) {
            if (Character.isWhitespace(next)) {
                this.captureElementName = false;
            } else {
                this.elementName.append((char)next);
            }
        } else if (next == 60) {
            this.captureElementName = true;
            this.elementName.setLength(0);
        }
        return next;
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }
}

