/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.environmentmanager.jenkins;

import com.parasoft.dtp.client.impl.ProjectsImpl;
import com.parasoft.dtp.client.impl.ServicesImpl;
import com.parasoft.em.client.api.EventMonitor;
import com.parasoft.em.client.impl.JobsImpl;
import com.parasoft.environmentmanager.jenkins.EnvironmentManagerPlugin;
import com.parasoft.environmentmanager.jenkins.ProvisioningEventAction;
import com.parasoft.environmentmanager.jenkins.ReportScanner;
import com.parasoft.environmentmanager.jenkins.ReportSettingsInjector;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ExecuteJobBuilder
extends Builder {
    private static final String JOB_BY_ID = "jobById";
    private static final String JOB_BY_NAME = "jobByName";
    private long jobId;
    private String jobName;
    private String jobType;
    private boolean abortOnFailure;
    private boolean publish;
    private long projectId;
    private String buildId;
    private String sessionTag;
    private boolean appendEnv;

    @DataBoundConstructor
    public ExecuteJobBuilder(long jobId, String jobName, String jobType, boolean abortOnFailure, boolean publish, long projectId, String buildId, String sessionTag, boolean appendEnv) {
        this.jobId = jobId;
        this.jobName = jobName;
        this.jobType = jobType;
        this.abortOnFailure = abortOnFailure;
        this.publish = publish;
        this.projectId = projectId;
        this.buildId = buildId;
        this.sessionTag = sessionTag;
        this.appendEnv = appendEnv;
    }

    public long getJobId() {
        return this.jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public boolean isJobType(String type) {
        if (this.jobId == 0L) {
            return JOB_BY_NAME.equals(type);
        }
        if (this.jobType == null) {
            return JOB_BY_ID.equals(type);
        }
        return this.jobType.equals(type);
    }

    public boolean getAbortOnFailure() {
        return this.abortOnFailure;
    }

    public boolean getPublish() {
        return this.publish;
    }

    public long getProjectId() {
        return this.projectId;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getSessionTag() {
        return this.sessionTag;
    }

    public boolean getAppendEnv() {
        return this.appendEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, final BuildListener listener) throws InterruptedException, IOException {
        EnvironmentManagerPlugin.EnvironmentManagerPluginDescriptor pluginDescriptor = EnvironmentManagerPlugin.getEnvironmentManagerPluginDescriptor();
        String emUrl = pluginDescriptor.getEmUrl();
        String username = pluginDescriptor.getUsername();
        Secret password = pluginDescriptor.getPassword();
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        JobsImpl jobs = new JobsImpl(emUrl, username, password.getPlainText());
        boolean result = true;
        ArrayList<JSONObject> jobsToExecute = new ArrayList<JSONObject>();
        if (JOB_BY_NAME.equals(this.jobType)) {
            String expandedJobName = envVars.expand(this.jobName);
            JSONObject jobsJSON = jobs.getJobsByName(expandedJobName);
            if (jobsJSON.has("jobs")) {
                JSONArray jobsArray = jobsJSON.getJSONArray("jobs");
                for (Object o : jobsArray) {
                    JSONObject jobJSON = (JSONObject)o;
                    if (!expandedJobName.equals(jobJSON.getString("name"))) continue;
                    jobsToExecute.add(jobJSON);
                }
            }
            if (jobsToExecute.isEmpty()) {
                listener.getLogger().println("ERROR: No test scenario job found on " + emUrl + " matching name \"" + expandedJobName + "\"");
                result = false;
            }
        } else {
            JSONObject jobJSON = jobs.getJob(this.jobId);
            jobsToExecute.add(jobJSON);
        }
        boolean allTestsPassed = true;
        for (JSONObject jobJSON : jobsToExecute) {
            JSONArray reportIds;
            listener.getLogger().println("Executing \"" + jobJSON.getString("name") + "\" on " + emUrl);
            JSONObject history = jobs.executeJob(jobJSON.getLong("id"));
            allTestsPassed &= jobs.monitorExecution(history, new EventMonitor(){

                @Override
                public void logMessage(String message) {
                    listener.getLogger().println(message);
                }
            });
            String baseUrl = emUrl;
            if (!baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
            }
            if ((reportIds = (history = jobs.getHistory(this.jobId, history.getLong("id"))).optJSONArray("reportIds")) == null) continue;
            List<String> execEnvs = this.extractEnvironmentNames(jobJSON);
            for (int i = 0; i < reportIds.size(); ++i) {
                String name = jobJSON.getString("name");
                String reportUrl = baseUrl + "testreport/" + reportIds.getLong(i) + "/report.html";
                int tests = 1;
                int failures = result ? 0 : 1;
                FilePath workspace = build.getWorkspace();
                if (workspace == null) {
                    build.addAction((Action)new ProvisioningEventAction(build, name, reportUrl, tests, failures));
                    continue;
                }
                ReportScanner reportScanner = null;
                InputStream reportInputStream = null;
                try {
                    String expandedSessionTag;
                    String expandedBuildId;
                    String projectName;
                    boolean connectToDTP;
                    block34: {
                        String dtpUrl;
                        connectToDTP = true;
                        reportInputStream = jobs.download("testreport/" + reportIds.getLong(i) + "/report.xml");
                        reportScanner = new ReportScanner(reportInputStream);
                        reportInputStream = reportScanner;
                        projectName = null;
                        expandedBuildId = null;
                        expandedSessionTag = null;
                        String execEnv = null;
                        if (!execEnvs.isEmpty()) {
                            execEnv = execEnvs.remove(0);
                        }
                        name = execEnv != null && !execEnv.isEmpty() ? execEnv : jobJSON.getString("name");
                        if (!this.appendEnv) {
                            execEnv = null;
                        }
                        if ((dtpUrl = pluginDescriptor.getDtpUrl()) != null && !dtpUrl.isEmpty()) {
                            String dtpUsername = pluginDescriptor.getDtpUsername();
                            Secret dtpPassword = pluginDescriptor.getDtpPassword();
                            try {
                                ProjectsImpl projects = new ProjectsImpl(dtpUrl, dtpUsername, dtpPassword.getPlainText());
                                projectName = projects.getProject(this.projectId).getString("name");
                                expandedBuildId = envVars.expand(this.buildId);
                                expandedSessionTag = envVars.expand(this.sessionTag);
                                if (execEnv != null && !execEnv.isEmpty()) {
                                    if (expandedSessionTag == null) {
                                        expandedSessionTag = "";
                                    }
                                    if (!expandedSessionTag.isEmpty()) {
                                        expandedSessionTag = expandedSessionTag + '-';
                                    }
                                    expandedSessionTag = expandedSessionTag + execEnv;
                                } else if (expandedSessionTag != null && !expandedSessionTag.isEmpty() && i > 0) {
                                    expandedSessionTag = expandedSessionTag + "-" + (i + 1);
                                }
                                reportInputStream = new ReportSettingsInjector(projectName, expandedBuildId, expandedSessionTag, execEnv, reportInputStream);
                            }
                            catch (IOException e) {
                                connectToDTP = false;
                                if (!this.publish) break block34;
                                listener.getLogger().println("Cannot connect to DTP: " + e.getLocalizedMessage());
                            }
                        }
                    }
                    FilePath reportDir = new FilePath(workspace, "target/parasoft/soatest/" + reportIds.getLong(i));
                    reportDir.mkdirs();
                    FilePath reportXmlFile = new FilePath(reportDir, "report.xml");
                    reportXmlFile.copyFrom(reportInputStream);
                    if (this.publish) {
                        if (connectToDTP) {
                            listener.getLogger().println("Publishing Report to DTP...");
                            listener.getLogger().println("Project: " + (projectName == null || projectName.isEmpty() ? "Not Specified" : projectName));
                            listener.getLogger().println("Build ID: " + (expandedBuildId == null || expandedBuildId.isEmpty() ? "Not Specified" : expandedBuildId));
                            listener.getLogger().println("Session Tag: " + (expandedSessionTag == null || expandedSessionTag.isEmpty() ? "Not Specified" : expandedSessionTag));
                            result = this.publishReport(reportXmlFile, listener.getLogger()) && result;
                        } else {
                            result = false;
                        }
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    if (reportInputStream != null) {
                        reportInputStream.close();
                    }
                }
                if (reportScanner != null) {
                    if (reportScanner.getFailureCount() > 0) {
                        failures = reportScanner.getFailureCount();
                    }
                    if (reportScanner.getTotalCount() > 0) {
                        tests = reportScanner.getTotalCount();
                    }
                }
                build.addAction((Action)new ProvisioningEventAction(build, name, reportUrl, tests, failures));
            }
        }
        if (!allTestsPassed) {
            if (this.abortOnFailure) {
                build.setResult(Result.FAILURE);
                result = false;
            } else {
                build.setResult(Result.UNSTABLE);
            }
        }
        return result;
    }

    private List<String> extractEnvironmentNames(JSONObject jobJSON) {
        boolean separate = jobJSON.getBoolean("fork");
        JSONArray tests = jobJSON.getJSONArray("testScenarioInstances");
        Long lastTestId = null;
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < tests.size(); ++i) {
            JSONObject test = tests.getJSONObject(i);
            Long testId = test.getLong("testScenarioId");
            String variableset = test.optString("variableSet");
            if (separate || lastTestId == null || lastTestId.equals(testId)) {
                results.add(variableset);
            }
            lastTestId = testId;
        }
        return results;
    }

    private boolean publishReport(FilePath reportFile, PrintStream logger) {
        boolean result = true;
        EnvironmentManagerPlugin.EnvironmentManagerPluginDescriptor pluginDescriptor = EnvironmentManagerPlugin.getEnvironmentManagerPluginDescriptor();
        String dtp = pluginDescriptor.getDtpUrl();
        String username = pluginDescriptor.getDtpUsername();
        Secret password = pluginDescriptor.getDtpPassword();
        ServicesImpl services = new ServicesImpl(dtp, username, password.getPlainText());
        String dataCollector = null;
        try {
            dataCollector = services.getDataCollectorV2();
            result = this.postToDataCollector(reportFile, dataCollector, username, password.getPlainText(), logger);
        }
        catch (IOException e) {
            result = false;
            e.printStackTrace();
        }
        if (result) {
            logger.println("Successfully published report to DTP.");
        } else {
            logger.println("ERROR: Unable to publish report to DTP.");
        }
        return result;
    }

    private boolean postToDataCollector(FilePath reportFile, String dataCollector, String username, String password, PrintStream logger) {
        boolean result = true;
        try {
            result = Boolean.valueOf((String)reportFile.act((FilePath.FileCallable)new DataCollectorUploadable(dataCollector, username, password)));
        }
        catch (IOException e) {
            result = false;
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Execute a test scenario job";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindJSON((Object)this, json);
            this.save();
            return super.configure(req, json);
        }

        public ListBoxModel doFillJobIdItems() {
            ListBoxModel m;
            block8: {
                m = new ListBoxModel();
                try {
                    EnvironmentManagerPlugin.EnvironmentManagerPluginDescriptor pluginDescriptor = EnvironmentManagerPlugin.getEnvironmentManagerPluginDescriptor();
                    String emUrl = pluginDescriptor.getEmUrl();
                    String username = pluginDescriptor.getUsername();
                    Secret password = pluginDescriptor.getPassword();
                    if (emUrl != null && !emUrl.isEmpty()) {
                        JobsImpl jobs = new JobsImpl(emUrl, username, password.getPlainText());
                        JSONObject envs = jobs.getJobs();
                        if (envs.has("jobs")) {
                            JSONArray envArray = envs.getJSONArray("jobs");
                            for (Object o : envArray) {
                                JSONObject job = (JSONObject)o;
                                String name = job.getString("name");
                                m.add(name, job.getString("id"));
                            }
                        }
                        if (m.isEmpty()) {
                            m.add("-- No jobs defined --", "0");
                        } else {
                            m.add(0, (Object)new ListBoxModel.Option("-- Select a job --", "0"));
                        }
                    } else {
                        m.add("-- Global settings not configured --", "0");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (!m.isEmpty()) break block8;
                    m.add("-- Cannot connect to CTP --", "0");
                }
            }
            return m;
        }

        public ListBoxModel doFillProjectIdItems() {
            ListBoxModel m;
            block7: {
                m = new ListBoxModel();
                try {
                    EnvironmentManagerPlugin.EnvironmentManagerPluginDescriptor pluginDescriptor = EnvironmentManagerPlugin.getEnvironmentManagerPluginDescriptor();
                    String dtpUrl = pluginDescriptor.getDtpUrl();
                    String dtpUsername = pluginDescriptor.getDtpUsername();
                    Secret dtpPassword = pluginDescriptor.getDtpPassword();
                    if (dtpUrl != null && !dtpUrl.isEmpty()) {
                        ProjectsImpl projects = new ProjectsImpl(dtpUrl, dtpUsername, dtpPassword.getPlainText());
                        for (JSONObject proj : projects.getProjects()) {
                            String name = proj.getString("name");
                            m.add(name, proj.getString("id"));
                        }
                        if (m.isEmpty()) {
                            m.add("-- No projects defined --", "0");
                        } else {
                            m.add(0, (Object)new ListBoxModel.Option("-- Select a project --", "0"));
                        }
                    } else {
                        m.add("-- Global settings not configured --", "0");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (!m.isEmpty()) break block7;
                    m.add("-- Cannot connect to DTP --", "0");
                }
            }
            return m;
        }
    }

    private static class DataCollectorUploadable
    implements FilePath.FileCallable<String> {
        private static final long serialVersionUID = 1L;
        private String url;
        private String username;
        private String password;

        public DataCollectorUploadable(String url, String username, String password) {
            this.url = url;
            this.username = username;
            this.password = password;
        }

        public String invoke(File file, VirtualChannel channel) throws IOException, InterruptedException {
            HttpEntity entity = MultipartEntityBuilder.create().setContentType(ContentType.MULTIPART_FORM_DATA).addPart("file", (ContentBody)new FileBody(file)).build();
            HttpPost request = new HttpPost(this.url);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            request.setEntity(entity);
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            try {
                sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)new NoopHostnameVerifier());
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            CloseableHttpClient client = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            HttpResponse response = client.execute((HttpUriRequest)request);
            return Boolean.toString(response.getStatusLine().getStatusCode() == 200);
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }
}

