/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.em.client.impl;

import com.parasoft.em.client.api.EnvironmentCopy;
import com.parasoft.em.client.api.EventMonitor;
import com.parasoft.em.client.impl.EnvironmentsImpl;
import com.parasoft.em.client.impl.JSONClient;
import java.io.IOException;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class EnvironmentCopyImpl
extends JSONClient
implements EnvironmentCopy {
    public EnvironmentCopyImpl(String emUrl, String username, String password) {
        super(emUrl, username, password);
    }

    @Override
    public JSONObject createEnvironmentCopy(int environmentId, int serverId, String newEnvironmentName, boolean copyDataRepo, JSONObject dataRepoSettings) throws IOException {
        JSONObject payload = new JSONObject();
        try {
            payload.put((Object)"originalEnvId", (Object)environmentId);
            payload.put((Object)"serverId", (Object)serverId);
            if (newEnvironmentName != null && !newEnvironmentName.trim().isEmpty()) {
                payload.put((Object)"newEnvironmentName", (Object)newEnvironmentName);
            }
            payload.put((Object)"copyDataRepo", (Object)copyDataRepo);
            if (dataRepoSettings != null) {
                payload.put((Object)"dataRepoSettings", (Object)dataRepoSettings);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this.doPost("api/v2/environments/copy", payload);
    }

    @Override
    public JSONObject getCopyStatus(int id) throws IOException {
        return this.doGet("api/v2/environments/copy/" + id);
    }

    @Override
    public JSONObject removeCopyStatus(int id) throws IOException {
        return this.doDelete("api/v2/environments/copy/" + id);
    }

    @Override
    public boolean monitorEvent(JSONObject event, EventMonitor monitor) throws IOException {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        EnvironmentsImpl environments = new EnvironmentsImpl(this.baseUrl, this.username, this.password);
        int eventId = event.getInt("id");
        JSONObject response = this.getCopyStatus(eventId);
        int originalEnvId = response.getInt("originalEnvId");
        JSONObject environment = environments.getEnvironment(originalEnvId);
        monitor.logMessage("Copying environment: " + environment.getString("name"));
        JSONObject copiedCount = response.getJSONObject("copiedCount");
        long copiedActionCount = 0L;
        long copiedAssetCount = 0L;
        long copiedMessageProxyCount = 0L;
        long totalActionCount = copiedCount.getLong("totalActionCount");
        long totalAssetCount = copiedCount.getLong("totalAssetCount");
        long totalMessageProxyCount = copiedCount.getLong("totalMessageProxyCount");
        response.put((Object)"status", (Object)"COPYING");
        while ("COPYING".equals(response.getString("status"))) {
            long newCopiedActionCount = copiedCount.getLong("copiedActionCount");
            long newCopiedAssetCount = copiedCount.getLong("copiedAssetCount");
            long newCopiedMessageProxyCount = copiedCount.getLong("copiedMessageProxyCount");
            if (newCopiedActionCount > copiedActionCount) {
                monitor.logMessage("    copied " + newCopiedActionCount + " of " + totalActionCount + " provisioning actions...");
                copiedActionCount = newCopiedActionCount;
            }
            if (newCopiedAssetCount > copiedAssetCount) {
                monitor.logMessage("    copied " + newCopiedAssetCount + " of " + totalAssetCount + " virtual assets...");
                copiedAssetCount = newCopiedAssetCount;
            }
            if (newCopiedMessageProxyCount > copiedMessageProxyCount) {
                monitor.logMessage("    copied " + newCopiedMessageProxyCount + " of " + totalMessageProxyCount + " message proxies...");
                copiedMessageProxyCount = newCopiedMessageProxyCount;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            response = this.getCopyStatus(eventId);
            copiedCount = response.getJSONObject("copiedCount");
        }
        if ("COMPLETE".equals(response.getString("status"))) {
            int newEnvironmentId = response.getInt("environmentId");
            JSONObject newEnvironment = environments.getEnvironment(newEnvironmentId);
            monitor.logMessage("Successfully copied to environment: " + newEnvironment.getString("name"));
            return true;
        }
        if ("FAILURE".equals(response.getString("status"))) {
            monitor.logMessage("Failed to copy environment.");
            if (response.has("deployFailures")) {
                JSONArray deployFailures = response.getJSONArray("deployFailures");
                for (int i = 0; i < deployFailures.size(); ++i) {
                    monitor.logMessage("    " + deployFailures.getString(i));
                }
            }
            if (response.has("message")) {
                monitor.logMessage(response.getString("message"));
            }
        }
        return false;
    }
}

