/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.dtp.client.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.codec.binary.Base64;

public class DTPClient {
    protected String baseUrl;
    protected String username;
    protected String password;
    protected SSLSocketFactory trustAllSslSocketFactory;

    public DTPClient(String baseUrl, String username, String password) {
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        if (!baseUrl.endsWith("grs/")) {
            baseUrl = baseUrl + "grs/";
        }
        this.baseUrl = baseUrl;
        this.username = username;
        this.password = password;
        if (this.password != null && this.password.length() == 0) {
            this.password = null;
        }
        this.trustAllSslSocketFactory = null;
    }

    private HttpURLConnection getConnection(String restPath) throws IOException {
        URL url = new URL(this.baseUrl + restPath);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (connection instanceof HttpsURLConnection) {
            HostnameVerifier hostnameVerifier = null;
            try {
                if (this.trustAllSslSocketFactory == null) {
                    this.trustAllSslSocketFactory = DTPClient.makeTrustAllSslSocketFactory();
                }
                hostnameVerifier = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                ((HttpsURLConnection)connection).setSSLSocketFactory(this.trustAllSslSocketFactory);
                ((HttpsURLConnection)connection).setHostnameVerifier(hostnameVerifier);
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
        }
        connection.setDoOutput(true);
        connection.setRequestProperty("Accept", "application/json");
        if (this.username != null) {
            String encoding = this.username + ":" + this.password;
            encoding = Base64.encodeBase64String((byte[])encoding.getBytes("UTF-8"));
            connection.setRequestProperty("Authorization", "Basic " + encoding);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSON getResponseJSON(InputStream stream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        try {
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
            JSON jSON = JSONSerializer.toJSON((Object)result.toString());
            return jSON;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            in.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponseString(InputStream stream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        try {
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
            String string = result.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    protected JSONObject doGet(String restPath) throws IOException {
        HttpURLConnection connection = this.getConnection(restPath);
        connection.setRequestMethod("GET");
        return (JSONObject)this.handleResponse(restPath, connection);
    }

    protected JSONArray doGetArray(String restPath) throws IOException {
        HttpURLConnection connection = this.getConnection(restPath);
        connection.setRequestMethod("GET");
        return (JSONArray)this.handleResponse(restPath, connection);
    }

    private JSON handleResponse(String restPath, HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode / 100 == 2) {
            return this.getResponseJSON(connection.getInputStream());
        }
        String errorMessage = this.getResponseString(connection.getErrorStream());
        try {
            JSONObject errorJSON = (JSONObject)JSONSerializer.toJSON((Object)errorMessage);
            if (errorJSON.has("message")) {
                errorMessage = errorJSON.getString("message");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        throw new IOException(restPath + ' ' + responseCode + '\n' + errorMessage);
    }

    private static SSLSocketFactory makeTrustAllSslSocketFactory() throws GeneralSecurityException, IOException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, trustAllCerts, new SecureRandom());
        return context.getSocketFactory();
    }
}

