/*
 * Decompiled with CFR 0.152.
 */
package papyrus.util;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import papyrus.util.Res;

public class Animations {
    private static final int DEFAULT_DURATION = 250;
    private static int screenWidth = Resources.getSystem().getDisplayMetrics().widthPixels;
    private static int screenHeight = Resources.getSystem().getDisplayMetrics().heightPixels;

    public static void fadeOut(View view) {
        Animations.fadeOut(view, null);
    }

    public static void fadeOut(final View view, final Runnable completion) {
        view.animate().alpha(0.0f).withEndAction(new Runnable(){

            @Override
            public void run() {
                view.setVisibility(4);
                if (completion != null) {
                    completion.run();
                }
            }
        }).start();
    }

    public static void fadeIn(View view) {
        Animations.fadeIn(view, null);
    }

    public static void fadeIn(final View view, final Runnable completion) {
        view.animate().alpha(1.0f).withStartAction(new Runnable(){

            @Override
            public void run() {
                view.setAlpha(0.0f);
                view.setVisibility(0);
            }
        }).withEndAction(new Runnable(){

            @Override
            public void run() {
                if (completion != null) {
                    completion.run();
                }
            }
        }).start();
    }

    public static void slideOffLeft(final View view) {
        view.animate().translationX((float)(-screenWidth)).withEndAction(new Runnable(){

            @Override
            public void run() {
                view.setVisibility(8);
            }
        }).start();
    }

    public static void slideOffRight(final View view) {
        view.animate().translationX((float)screenWidth).withEndAction(new Runnable(){

            @Override
            public void run() {
                view.setVisibility(8);
            }
        }).start();
    }

    public static void slideOnLeft(final View view) {
        view.setTranslationX((float)(-screenWidth));
        view.animate().translationX(0.0f).withStartAction(new Runnable(){

            @Override
            public void run() {
                view.setVisibility(0);
            }
        }).start();
    }

    public static void slideOnRight(final View view) {
        view.setTranslationX((float)screenWidth);
        view.animate().translationX(0.0f).withStartAction(new Runnable(){

            @Override
            public void run() {
                view.setVisibility(0);
            }
        }).start();
    }

    public static void growAndShrink(final View view) {
        view.animate().scaleX(1.5f).scaleY(1.5f).withEndAction(new Runnable(){

            @Override
            public void run() {
                view.animate().scaleX(1.0f).scaleY(1.0f).start();
            }
        }).start();
    }

    public static void slideInBottom(View view) {
        Animations.slideInBottom(view, null);
    }

    public static void slideInBottom(final View view, final Runnable completion) {
        view.setTranslationY((float)screenHeight);
        view.animate().translationY(0.0f).withStartAction(new Runnable(){

            @Override
            public void run() {
                view.setVisibility(0);
                if (completion != null) {
                    completion.run();
                }
            }
        }).start();
    }

    public static void slideOffBottom(View view) {
        Animations.slideOffBottom(view, null);
    }

    public static void slideOffBottom(final View view, final Runnable completion) {
        view.animate().translationY((float)screenHeight).withEndAction(new Runnable(){

            @Override
            public void run() {
                view.setVisibility(8);
                if (completion != null) {
                    completion.run();
                }
            }
        }).start();
    }

    public static void slideInTop(View view) {
        Animations.slideInTop(view, null);
    }

    public static void slideInTop(final View view, final Runnable completion) {
        view.setTranslationY((float)(-screenHeight));
        view.animate().translationY(0.0f).withStartAction(new Runnable(){

            @Override
            public void run() {
                view.setVisibility(0);
            }
        }).withEndAction(new Runnable(){

            @Override
            public void run() {
                if (completion != null) {
                    completion.run();
                }
            }
        }).start();
    }

    public static void slideVerticalFrom(int start, View view) {
        Animations.slideVerticalFrom(start, view, null);
    }

    public static void slideVerticalFrom(int start, final View view, final Runnable completion) {
        view.setTranslationY((float)start);
        view.animate().translationY(0.0f).withStartAction(new Runnable(){

            @Override
            public void run() {
                view.setVisibility(0);
            }
        }).withEndAction(new Runnable(){

            @Override
            public void run() {
                if (completion != null) {
                    completion.run();
                }
            }
        }).start();
    }

    public static void slideOffTop(View view) {
        Animations.slideOffTop(view, null);
    }

    public static void slideOffTop(final View view, final Runnable completion) {
        view.animate().translationY((float)(-screenHeight)).withStartAction(new Runnable(){

            @Override
            public void run() {
                view.setVisibility(0);
            }
        }).withEndAction(new Runnable(){

            @Override
            public void run() {
                if (completion != null) {
                    completion.run();
                }
            }
        }).start();
    }

    private static int resolveViewHeight(View view) {
        ViewGroup parent = (ViewGroup)view.getParent();
        int width = parent.getWidth();
        width -= parent.getPaddingLeft() + parent.getPaddingRight();
        ViewGroup.LayoutParams params = view.getLayoutParams();
        int heightMargins = 0;
        if (params instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams margins = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            width -= margins.leftMargin + margins.rightMargin;
            heightMargins = margins.topMargin + margins.bottomMargin;
        }
        view.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), -2);
        return view.getMeasuredHeight() + view.getPaddingTop() + view.getPaddingBottom() + heightMargins + Res.dpi(8);
    }

    public static void grow(View view) {
        Animations.grow(view, Animations.resolveViewHeight(view));
    }

    public static void grow(final View view, int targetHeight) {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{view.getHeight(), targetHeight});
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                layoutParams.height = (Integer)valueAnimator.getAnimatedValue();
                view.setLayoutParams(layoutParams);
            }
        });
        anim.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                view.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                view.requestLayout();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        anim.setDuration(250L);
        anim.start();
    }

    public static void shrink(final View view) {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{view.getHeight(), 0});
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                layoutParams.height = (Integer)valueAnimator.getAnimatedValue();
                view.setLayoutParams(layoutParams);
            }
        });
        anim.setDuration(250L);
        anim.start();
    }
}

