/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.palantir.javaformat.gradle.FormatDiff;
import com.palantir.javaformat.gradle.JavaFormatExtension;
import com.palantir.javaformat.gradle.PalantirJavaFormatIdeaPlugin;
import com.palantir.javaformat.gradle.PalantirJavaFormatProviderPlugin;
import com.palantir.javaformat.gradle.PalantirJavaFormatSpotlessPlugin;
import com.palantir.javaformat.java.FormatterService;
import java.io.IOException;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;

public final class PalantirJavaFormatPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getRootProject().getPlugins().apply(PalantirJavaFormatProviderPlugin.class);
        project.getRootProject().getPlugins().apply(PalantirJavaFormatIdeaPlugin.class);
        project.getPlugins().apply(PalantirJavaFormatSpotlessPlugin.class);
        project.getPlugins().withId("java", p -> project.getTasks().register("formatDiff", FormatDiffTask.class));
    }

    public static class FormatDiffTask
    extends DefaultTask {
        public FormatDiffTask() {
            this.setDescription("Format only chunks of files that appear in git diff");
            this.setGroup("Formatting");
        }

        @TaskAction
        public final void formatDiff() throws IOException, InterruptedException {
            JavaFormatExtension extension = (JavaFormatExtension)this.getProject().getRootProject().getExtensions().getByType(JavaFormatExtension.class);
            FormatterService formatterService = extension.serviceLoad();
            FormatDiff.formatDiff(this.getProject().getProjectDir().toPath(), formatterService);
        }
    }
}

