/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.platform;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

final class UiNames {
    public static String uiName(Enum<?> enumValue) {
        return enumValue.name().toLowerCase(Locale.ROOT).replace('_', '-');
    }

    public static <T extends Enum<?>> Optional<T> fromString(T[] enumValues, String uiName) {
        return Arrays.stream(enumValues).filter(jdkDistributionName -> UiNames.uiName(jdkDistributionName).equals(uiName)).findFirst();
    }

    @JsonCreator
    public static <T extends Enum<?>> T fromStringThrowing(Class<T> clazz, T[] enumValues, String uiName) {
        return (T)((Enum)UiNames.fromString(enumValues, (String)uiName).orElseThrow(() -> new IllegalArgumentException(String.format("Cannot convert %s into a %s. Options are: %s.", uiName, clazz.getSimpleName(), Arrays.stream(enumValues).map(UiNames::uiName).collect(Collectors.toList())))));
    }

    private UiNames() {
    }
}

