/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.platform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.palantir.platform.UiNames;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OperatingSystem {
    MACOS,
    LINUX_GLIBC,
    LINUX_MUSL,
    WINDOWS;


    public String toString() {
        return this.uiName();
    }

    @JsonValue
    public final String uiName() {
        return UiNames.uiName(this);
    }

    public Optional<String> glibcOrMuslDistribution() {
        switch (this) {
            case LINUX_MUSL: {
                return Optional.of("musl");
            }
            case LINUX_GLIBC: {
                return Optional.of("glibc");
            }
            case MACOS: 
            case WINDOWS: {
                return Optional.empty();
            }
        }
        throw new IllegalStateException("Unsupported OS: " + String.valueOf((Object)this));
    }

    public static Optional<OperatingSystem> fromString(String osUiName) {
        return UiNames.fromString((Enum[])OperatingSystem.values(), (String)osUiName);
    }

    @JsonCreator
    public static OperatingSystem fromStringThrowing(String osUiName) {
        return (OperatingSystem)UiNames.fromStringThrowing(OperatingSystem.class, (Enum[])OperatingSystem.values(), (String)osUiName);
    }

    public static OperatingSystem get() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (osName.startsWith("mac")) {
            return MACOS;
        }
        if (osName.startsWith("windows")) {
            return WINDOWS;
        }
        if (osName.startsWith("linux")) {
            return OperatingSystem.linuxLibcFromLdd();
        }
        throw new UnsupportedOperationException("Cannot get platform for operating system " + osName);
    }

    private static OperatingSystem linuxLibcFromLdd() {
        return OperatingSystem.linuxLibcFromLdd(UnaryOperator.identity());
    }

    private static OperatingSystem linuxLibcFromLdd(UnaryOperator<List<String>> argTransformer) {
        try {
            Process process = new ProcessBuilder(new String[0]).command((List)argTransformer.apply(List.of("ldd", "--version"))).start();
            String lowercaseOutput = (OperatingSystem.readAllInput(process.getInputStream()) + "\n" + OperatingSystem.readAllInput(process.getErrorStream())).toLowerCase(Locale.ROOT);
            int secondsToWait = 5;
            if (!process.waitFor(secondsToWait, TimeUnit.SECONDS)) {
                throw new RuntimeException("ldd failed to run within " + secondsToWait + " seconds. Output: " + lowercaseOutput);
            }
            if (lowercaseOutput.contains("glibc") || lowercaseOutput.contains("gnu libc")) {
                return LINUX_GLIBC;
            }
            if (lowercaseOutput.contains("musl")) {
                return LINUX_MUSL;
            }
            if (!Set.of(Integer.valueOf(0), Integer.valueOf(1)).contains(process.exitValue())) {
                throw new RuntimeException(String.format("Failed to run ldd - exited with exit code %d. Output: %s.", process.exitValue(), lowercaseOutput));
            }
            throw new UnsupportedOperationException("Cannot work out libc used by this OS. ldd output was: " + lowercaseOutput);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static String readAllInput(InputStream inputStream) {
        try (Stream<String> lines = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines();){
            String string = lines.collect(Collectors.joining("\n"));
            return string;
        }
    }
}

