/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.platform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.palantir.platform.UiNames;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public enum Architecture {
    X86,
    X86_64,
    AARCH64;


    public String toString() {
        return this.uiName();
    }

    @JsonValue
    public final String uiName() {
        return UiNames.uiName(this);
    }

    public static Optional<Architecture> fromString(String archUiName) {
        return UiNames.fromString((Enum[])Architecture.values(), (String)archUiName);
    }

    @JsonCreator
    public static Architecture fromStringThrowing(String archUiName) {
        return (Architecture)UiNames.fromStringThrowing(Architecture.class, (Enum[])Architecture.values(), (String)archUiName);
    }

    public static Architecture get() {
        String osArch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        if (Set.of("x86_64", "x64", "amd64").contains(osArch)) {
            return X86_64;
        }
        if (Set.of("arm", "arm64", "aarch64").contains(osArch)) {
            return AARCH64;
        }
        if (Set.of("x86", "i686").contains(osArch)) {
            return X86;
        }
        throw new UnsupportedOperationException("Cannot get architecture for " + osArch);
    }
}

