/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.gitversion;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.palantir.gradle.gitversion.JsonUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

final class Timer {
    private final ConcurrentMap<String, Long> totalTimesTakenMillis = new ConcurrentHashMap<String, Long>();

    Timer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T record(String name, Supplier<T> codeToTime) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            T t = codeToTime.get();
            return t;
        }
        finally {
            stopwatch.stop();
            long timeTakenMillis = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            this.totalTimesTakenMillis.compute(name, (_ignored, previousValue) -> timeTakenMillis + (previousValue == null ? 0L : previousValue));
        }
    }

    public String toJson() {
        ImmutableMap withTotal = ImmutableMap.builder().putAll(this.totalTimesTakenMillis).put((Object)"total", (Object)this.totalMillis()).build();
        return JsonUtils.mapToJson(withTotal);
    }

    public long totalMillis() {
        return this.totalTimesTakenMillis.values().stream().mapToLong(time -> time).sum();
    }
}

