/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.gitversion;

import com.palantir.gradle.gitversion.GitVersionArgs;
import com.palantir.gradle.gitversion.GitVersionRootPlugin;
import com.palantir.gradle.gitversion.Timer;
import com.palantir.gradle.gitversion.TimingVersionDetails;
import com.palantir.gradle.gitversion.VersionDetails;
import com.palantir.gradle.gitversion.VersionDetailsImpl;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Repository;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;

public final class GitVersionPlugin
implements Plugin<Project> {
    private final Timer timer = new Timer();

    public void apply(final Project project) {
        project.getRootProject().getPluginManager().apply(GitVersionRootPlugin.class);
        final Git git = this.gitRepo(project);
        project.getExtensions().getExtraProperties().set("gitVersion", (Object)new Closure<String>((Object)this, (Object)this){

            public String doCall(Object args) {
                return TimingVersionDetails.wrap(GitVersionPlugin.this.timer, new VersionDetailsImpl(git, GitVersionArgs.fromGroovyClosure(args))).getVersion();
            }
        });
        project.getExtensions().getExtraProperties().set("versionDetails", (Object)new Closure<VersionDetails>((Object)this, (Object)this){

            public VersionDetails doCall(Object args) {
                return TimingVersionDetails.wrap(GitVersionPlugin.this.timer, new VersionDetailsImpl(git, GitVersionArgs.fromGroovyClosure(args)));
            }
        });
        Task printVersionTask = project.getTasks().create("printVersion");
        printVersionTask.doLast((Action)new Action<Task>(){

            public void execute(Task _task) {
                System.out.println(project.getVersion());
            }
        });
        printVersionTask.setGroup("Versioning");
        printVersionTask.setDescription("Prints the project's configured version to standard out");
    }

    Timer timer() {
        return this.timer;
    }

    private Git gitRepo(Project project) {
        try {
            File gitDir = GitVersionPlugin.getRootGitDir(project.getProjectDir());
            return Git.wrap((Repository)new FileRepository(gitDir));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File getRootGitDir(File currentRoot) {
        File gitDir = GitVersionPlugin.scanForRootGitDir(currentRoot);
        if (!gitDir.exists()) {
            throw new IllegalArgumentException("Cannot find '.git' directory");
        }
        return gitDir;
    }

    private static File scanForRootGitDir(File currentRoot) {
        File gitDir = new File(currentRoot, ".git");
        if (gitDir.exists()) {
            return gitDir;
        }
        if (currentRoot.getParentFile() == null) {
            return gitDir;
        }
        return GitVersionPlugin.scanForRootGitDir(currentRoot.getParentFile());
    }
}

