/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.conjure.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class GeneratorOptions
implements Serializable {
    private static final long serialVersionUID = 5676541916502995769L;
    private static Predicate<String> camelCase = Pattern.compile("[a-z][a-zA-Z0-9]*").asPredicate();
    private final Map<String, Object> storage;

    public GeneratorOptions() {
        this.storage = new LinkedHashMap<String, Object>();
    }

    public GeneratorOptions(GeneratorOptions options) {
        this.storage = new LinkedHashMap<String, Object>(options.getProperties());
    }

    public void setProperty(String name, Object newValue) {
        if (name.equals("properties")) {
            throw new RuntimeException("Can't override the 'properties' property");
        }
        this.set(name, newValue);
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.storage);
    }

    public boolean has(String name) {
        return this.storage.containsKey(name);
    }

    public Object get(String name) {
        if (!this.has(name)) {
            throw new RuntimeException("Unknown property: " + name);
        }
        return this.storage.get(name);
    }

    private void set(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        if (!camelCase.test(key)) {
            throw new IllegalArgumentException("Key must be camelCase: " + key);
        }
        if (value == null) {
            throw new NullPointerException(String.format("Property '%s': value cannot be null", key));
        }
        this.storage.put(key, value);
    }

    public GeneratorOptions addFlag(String flag) {
        if (this.has(flag)) {
            throw new IllegalArgumentException(String.format("This GeneratorOptions already has flag '%s' set", flag));
        }
        this.setProperty(flag, true);
        return this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GeneratorOptions that = (GeneratorOptions)other;
        return this.storage.equals(that.storage);
    }

    public int hashCode() {
        return this.storage.hashCode();
    }

    public String toString() {
        return "GeneratorOptions{" + this.storage + "}";
    }
}

